##############################################################################
#
# Jarl - Login Tk Interface Code
#
#   Perl code to handle showing the Jarl Login GUI and interfacing with the
# profiles and settings.
#
##############################################################################

##############################################################################
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
#
#  Jabber
#  Copyright (C) 1998-1999 The Jabber Team http://jabber.org/
#
##############################################################################


##############################################################################
#
# jarlLoginIF_GUI - creates the Login GUI.
#
##############################################################################
sub jarlLoginIF_GUI {

  $GUI{Login}->{vars}->{server} = "";
  $GUI{Login}->{vars}->{port} = "";
  $GUI{Login}->{vars}->{connectiontype} = "";
  $GUI{Login}->{vars}->{ssl} = "";
  $GUI{Login}->{vars}->{username} = "";
  $GUI{Login}->{vars}->{password} = "";
  $GUI{Login}->{vars}->{resource} = "";
  $GUI{Login}->{vars}->{priority} = 0;
  $GUI{Login}->{vars}->{loaded} = 0;

  my $logoStatusTop =
    $GUI{Login}->{top}->
      Frame(-background=>$GUI{color}->{jarl}->{config}->{bg}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark}
	   )->pack(-side=>"top",
		   -pady=>5);

  my $infoTop =
    $GUI{Login}->{top}->
      Frame(-background=>$GUI{color}->{jarl}->{config}->{bg}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark}
	   )->pack(-side=>"top",
		   -fill=>"both");

  my $logoTop =
    $logoStatusTop->
      Frame(-background=>$GUI{color}->{jarl}->{config}->{bg}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark}
	   )->pack(-side=>"top");

  my $bitmap =
    $GUI{Login}->{top}->Pixmap(-file=>"$Bitmaps/logo_small.xpm");

  $logoTop->
    Label(-image=>$bitmap,
	  -background=>$GUI{color}->{jarl}->{config}->{bg}->{normal},
	  -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark},
	  -relief=>"sunken",
	  -borderwidth=>2
	   )->pack(-side=>"top",
		   -pady=>0,
		   -padx=>0);

  $GUI{Login}->{Status} =
    $logoTop->
      Canvas(-height=>10,
	     -takefocus=>0,
	     -width=>156,
	     -background=>"white",
	     -relief=>"sunken",
	     -borderwidth=>2
	   )->pack(-side=>"bottom",
		   -pady=>0,
		   -padx=>5);

  my $profilePullDownTop =
    $infoTop->
      Frame(-background=>$GUI{color}->{jarl}->{config}->{bg}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark}
	   )->pack(-side=>"top",
		   -fill=>"x",
		   -expand=>1);
  $profilePullDownTop->
    Label(-text=>"Profile:",
	  -background=>$GUI{color}->{jarl}->{config}->{bg}->{normal},
	  -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark},
	  -font=>$GUI{fonts}->{login},
	  -width=>10,
	  -anchor=>"e"
	 )->pack(-side=>'left',
		 -anchor=>'e');
  my $profilePullDownOption =
    $profilePullDownTop->
      Optionmenu(-options=>["Connect w/o Profile" ],
		 -variable=>\$GUI{Login}->{vars}->{profile},
		 -background=>$GUI{color}->{jarl}->{config}->{bg}->{normal},
		 -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark},
		 -font=>$GUI{fonts}->{login},
		 -command=>sub{
		   &jarlLoginIF_ConnectionGUI();
		   &jarlLoginIF_SelectProfile($GUI{Login}->{vars}->{profile});
		 }
		)->pack(-side=>'left',
			-anchor=>'w');

  $GUI{Login}->{Connection}->{top} =
    $infoTop->
      Frame(-background=>$GUI{color}->{jarl}->{config}->{bg}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark}
	   )->pack(-side=>"top",
		   -fill=>"both",
		   -expand=>1);

  my $serverTop =
    $GUI{Login}->{Connection}->{top}->
      Frame(-background=>$GUI{color}->{jarl}->{config}->{bg}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark}
	   )->pack(-side=>"top",
		   -fill=>"x");
  $serverTop->
    Label(-text=>"Server:",
	  -background=>$GUI{color}->{jarl}->{config}->{bg}->{normal},
	  -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark},
	  -font=>$GUI{fonts}->{login},
	  -width=>10,
	  -anchor=>"e"
	 )->pack(-side=>'left',
		 -anchor=>'e');
  $serverTop->
    Entry(-textvariable=>\$GUI{Login}->{vars}->{server},
	  -width=>25,
	  -background=>$GUI{color}->{jarl}->{config}->{bg}->{light},
	  -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark},
	  -font=>$GUI{fonts}->{login},
	  -state=>"normal",
	 )->pack(-side=>'left',
		 -anchor=>'w');

  &jarlLoginIF_ConnectionGUI();

  my $usernameTop =
    $infoTop->
      Frame(-background=>$GUI{color}->{jarl}->{config}->{bg}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark}
	   )->pack(-side=>"top",
		   -fill=>"both",
		   -expand=>1);
  $usernameTop->
    Label(-text=>"Username:",
	  -background=>$GUI{color}->{jarl}->{config}->{bg}->{normal},
	  -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark},
	  -font=>$GUI{fonts}->{login},
	  -width=>10,
	  -anchor=>"e"
	 )->pack(-side=>'left',
		 -anchor=>'e');
  $usernameTop->
    Entry(-textvariable=>\$GUI{Login}->{vars}->{username},
	  -width=>25,
	  -background=>$GUI{color}->{jarl}->{config}->{bg}->{light},
	  -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark},
	  -font=>$GUI{fonts}->{login},
	  -state=>"normal",
	 )->pack(-side=>'left',
		 -anchor=>'w');

  my $passwordTop =
    $infoTop->
      Frame(-background=>$GUI{color}->{jarl}->{config}->{bg}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark}
	   )->pack(-side=>"top",
		   -fill=>"both",
		   -expand=>1);
  $passwordTop->
    Label(-text=>"Password:",
	  -background=>$GUI{color}->{jarl}->{config}->{bg}->{normal},
	  -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark},
	  -font=>$GUI{fonts}->{login},
	  -width=>10,
	  -anchor=>"e"
	 )->pack(-side=>'left',
		 -anchor=>'e');
  $passwordTop->
    Entry(-textvariable=>\$GUI{Login}->{vars}->{password},
	  -show=>"*",
	  -width=>25,
	  -background=>$GUI{color}->{jarl}->{config}->{bg}->{light},
	  -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark},
	  -font=>$GUI{fonts}->{login},
	  -state=>"normal",
	 )->pack(-side=>'left',
		 -anchor=>'w');

  my $resPriTop =
    $infoTop->
      Frame(-background=>$GUI{color}->{jarl}->{config}->{bg}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark}
	   )->pack(-side=>"top",
		   -fill=>"x");

  my $resourceTop =
    $resPriTop->
      Frame(-background=>$GUI{color}->{jarl}->{config}->{bg}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark}
	   )->pack(-side=>"left");
  $resourceTop->
    Label(-text=>"Resource:",
	  -background=>$GUI{color}->{jarl}->{config}->{bg}->{normal},
	  -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark},
	  -font=>$GUI{fonts}->{login},
	  -width=>10,
	  -anchor=>"e"
	 )->pack(-side=>'left',
		 -anchor=>'e');
  $resourceTop->
    Entry(-textvariable=>\$GUI{Login}->{vars}->{resource},
	  -width=>7,
	  -background=>$GUI{color}->{jarl}->{config}->{bg}->{light},
	  -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark},
	  -font=>$GUI{fonts}->{login},
	  -state=>"normal",
	 )->pack(-side=>'left',
		 -anchor=>'w');

  my $priorityTop =
    $resPriTop->
      Frame(-background=>$GUI{color}->{jarl}->{config}->{bg}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark}
	   )->pack(-side=>"left");
  $priorityTop->
    Label(-text=>"Priority:",
	  -background=>$GUI{color}->{jarl}->{config}->{bg}->{normal},
	  -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark},
	  -font=>$GUI{fonts}->{login},
	  -width=>7,
	  -anchor=>"e"
	 )->pack(-side=>'left',
		 -anchor=>'e');
  $priorityTop->
    Entry(-textvariable=>\$GUI{Login}->{vars}->{priority},
	  -width=>4,
	  -background=>$GUI{color}->{jarl}->{config}->{bg}->{light},
	  -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark},
	  -font=>$GUI{fonts}->{login},
	 )->pack(-side=>'left',
		 -anchor=>'w');

  $buttonsTop =
    $infoTop->
      Frame(-background=>$GUI{color}->{jarl}->{config}->{bg}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark}
	   )->pack(-side=>"top",
		   -fill=>"both",
		   -expand=>1,
		   -pady=>2);

  $GUI{Login}->{Connect} =
    $buttonsTop->
      Button(-text=>"Connect",
	     -background=>$GUI{color}->{jarl}->{config}->{bg}->{normal},
	     -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark},
	     -disabledforeground=>$GUI{color}->{jarl}->{config}->{fg}->{light},
	     -font=>$GUI{fonts}->{login},
	     -state=>"disabled",
	     -command=>sub{
	       $GUI{Login}->{Connect}->configure(state=>"disabled");

	       $activeProfile = $GUI{Login}->{vars}->{profile};
	       &jarlSettings_SetConfig();
	       $TabBar->RaiseTab("login");

	       if (defined(&jarlConnect(server=>$GUI{Login}->{vars}->{server},
					port=>$GUI{Login}->{vars}->{port},
					connectiontype=>$GUI{Login}->{vars}->{connectiontype},
					ssl=>$GUI{Login}->{vars}->{ssl},
					username=>$GUI{Login}->{vars}->{username},
					password=>$GUI{Login}->{vars}->{password},
					resource=>$GUI{Login}->{vars}->{resource},
					priority=>$GUI{Login}->{vars}->{priority}))) {

		 $TabBar->RaiseTab("roster");

		 &jarlLoginIF_CloseCB();
	       } else {
		 $GUI{Login}->{Connect}->configure(state=>"normal");
	       }
	     }
	    )->pack(-side=>"right",
		    -padx=>10);

  my @newProfiles = ("Connect w/o Profile");
  my $prof;
  foreach $prof (sort {$a cmp $b} keys(%profiles)) {
    next if ($prof eq "Connect w/o Profile");
    push(@newProfiles,$prof);
  }
  $profilePullDownOption->configure(-options=>\@newProfiles);
}


##############################################################################
#
# jarlLoginIF_ConnectionGUI - draw the appropriate Connection GUI
#
##############################################################################
sub jarlLoginIF_ConnectionGUI {

  return unless Exists($GUI{Login}->{Connection}->{top});

  $GUI{Login}->{Connection}->{Bottom}->{top}->packForget()
    if (Exists($GUI{Login}->{Connection}->{Bottom}->{top}));

  $GUI{Login}->{ConnectionProfile}->{top}->packForget()
    if (Exists($GUI{Login}->{ConnectionProfile}->{top}));


  if ($GUI{Login}->{vars}->{profile} eq "Connect w/o Profile") {

    $GUI{Login}->{Connection}->{Bottom}->{top} =
      $GUI{Login}->{Connection}->{top}->
	Frame(-background=>$GUI{color}->{jarl}->{config}->{bg}->{normal},
	      -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark}
	     )->pack(-side=>"top",
		     -fill=>"both",
		     -expand=>1);

    my $portTop =
      $GUI{Login}->{Connection}->{Bottom}->{top}->
	Frame(-background=>$GUI{color}->{jarl}->{config}->{bg}->{normal},
	      -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark}
	     )->pack(-side=>"left");
    $portTop->
      Entry(-textvariable=>\$GUI{Login}->{vars}->{port},
	    -width=>5,
	    -background=>$GUI{color}->{jarl}->{config}->{bg}->{light},
	    -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark},
	    -font=>$GUI{fonts}->{login},
	   )->pack(-side=>'right',
		   -anchor=>'w');
    $portTop->
      Label(-text=>"Port:",
	    -background=>$GUI{color}->{jarl}->{config}->{bg}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark},
	    -font=>$GUI{fonts}->{login},
	    -width=>10,
	    -anchor=>"e"
	   )->pack(-side=>'right',
		   -anchor=>'e');

    my $typeTop =
      $GUI{Login}->{Connection}->{Bottom}->{top}->
	Frame(-background=>$GUI{color}->{jarl}->{config}->{bg}->{normal},
	      -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark}
	     )->pack(-side=>"right",
		     -fill=>"both",
		     -expand=>1);
    $typeTop->
      Label(-text=>"Type:",
	    -background=>$GUI{color}->{jarl}->{config}->{bg}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark},
	    -font=>$GUI{fonts}->{login},
	    -width=>5,
	    -anchor=>"e"
	   )->pack(-side=>'left',
		   -anchor=>'e');

    $GUI{Login}->{vars}->{type} = "TCP/IP";
    $typeTop->
      Optionmenu(-options=>[sort( {$a cmp $b} keys(%connectiontypes))],
		 -variable=>\$GUI{Login}->{vars}->{type},
		 -background=>$GUI{color}->{jarl}->{config}->{bg}->{normal},
		 -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark},
		 -font=>$GUI{fonts}->{login},
		 -command=>sub{
		   $GUI{Login}->{vars}->{connectiontype} =
		     $connectiontypes{$GUI{Login}->{vars}->{type}}->[0];
		   $GUI{Login}->{vars}->{port} =
		     $connectiontypes{$GUI{Login}->{vars}->{type}}->[1];
		   $GUI{Login}->{vars}->{ssl} =
		     $connectiontypes{$GUI{Login}->{vars}->{type}}->[2];
		 }
		)->pack(-side=>'left',
			-anchor=>'w');

  } else {

    $GUI{Login}->{ConnectionProfile}->{top} =
      $GUI{Login}->{Connection}->{top}->
	Frame(-background=>$GUI{color}->{jarl}->{config}->{bg}->{normal},
	      -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark}
	     )->pack(-side=>"right",
		     -fill=>"both",
		     -expand=>1);
    $GUI{Login}->{ConnectionProfile}->{top}->
      Label(-text=>"Connection:",
	    -background=>$GUI{color}->{jarl}->{config}->{bg}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark},
	    -font=>$GUI{fonts}->{login},
	    -width=>10,
	    -anchor=>"e"
	   )->pack(-side=>'left',
		   -anchor=>'e');

    $GUI{Login}->{vars}->{connectionprofile} =
      $profiles{$GUI{Login}->{vars}->{profile}}->{connectionprofile};

    $GUI{Login}->{ConnectionProfile}->{top}->
      Optionmenu(-options=>[ sort( {$a cmp $b} $profiles{$GUI{Login}->{vars}->{profile}}->ConnectionObj()) ],
		 -variable=>\$GUI{Login}->{vars}->{connectionprofile},
		 -background=>$GUI{color}->{jarl}->{config}->{bg}->{normal},
		 -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark},
		 -font=>$GUI{fonts}->{login},
		 -command=>sub{
		   my $connection = $profiles{$GUI{Login}->{vars}->{profile}}->ConnectionObj($GUI{Login}->{vars}->{connectionprofile});

		   $GUI{Login}->{vars}->{port} = $connection->Port();
		   $GUI{Login}->{vars}->{connectiontype} = $connectiontypes{$connection->Type()}->[0];
		   $GUI{Login}->{vars}->{ssl} = $connectiontypes{$connection->Type()}->[2];
		 }
		)->pack(-side=>'left',
			-anchor=>'w');
  }
}


##############################################################################
#
# jarlLoginIF_SetStatus - update the Status Bar
#
##############################################################################
sub jarlLoginIF_SetStatus {
  my ($percent) = @_;

  my $width = (156 * ($percent / 100)) + 1;

  $GUI{Login}->{Status}->delete("all");
  $GUI{Login}->{Status}->createRectangle(-1,-1,
					 $width,11,
					 -fill=>($percent == 100) ? "green" : "red",
					 -outline=>($percent == 100) ? "green" : "red",);
  $GUI{Login}->{Status}->update();
}


##############################################################################
#
# jarlLoginIF_CloseCB - close the Login GUI
#
##############################################################################
sub jarlLoginIF_CloseCB {
  $TabBar->HideTab("login");
  $GUI{Login}->{Connect}->configure(state=>"normal");
  $GUI{Login}->{vars}->{profile} = "Connect w/o Profile";
  &jarlLoginIF_ConnectionGUI();
  &jarlLoginIF_SelectProfile($GUI{Login}->{vars}->{profile});
}


##############################################################################
#
# jarlLoginIF_SelectProfile - powers the pulldown menu when you select a
#                            profile
#
##############################################################################
sub jarlLoginIF_SelectProfile {
  my ($profile) = @_;

  if ($profile ne "Connect w/o Profile") {
    $GUI{Login}->{vars}->{username} = $profiles{$profile}->Username();
    $GUI{Login}->{vars}->{resource} = $profiles{$profile}->Resource();
    $GUI{Login}->{vars}->{password} = $profiles{$profile}->Password();
    $GUI{Login}->{vars}->{priority} = 0;
    $GUI{Login}->{vars}->{server} = $profiles{$profile}->Server();

    my $connection = $profiles{$profile}->ConnectionObj($profiles{$profile}->ConnectionProfile());
    $GUI{Login}->{vars}->{port} = $connection->Port();
    $GUI{Login}->{vars}->{type} = $connection->Type();
  } else {
    $GUI{Login}->{vars}->{username} = "";
    $GUI{Login}->{vars}->{resource} = "";
    $GUI{Login}->{vars}->{password} = "";
    $GUI{Login}->{vars}->{priority} = 0;
    $GUI{Login}->{vars}->{server} = "";
    $GUI{Login}->{vars}->{port} = "5222";
    $GUI{Login}->{vars}->{type} = "TCP/IP";
  }	

  if ($GUI{Login}->{vars}->{loaded} == 1) {
#    $GUI{Login}->{Server}->{Entry}->
#      configure(-state=>($profile eq "Connect w/o Profile") ? "normal" : "disabled",
#		-background=>($profile eq "Connect w/o Profile") ? $GUI{color}->{jarl}->{config}->{bg}->{light} : $GUI{color}->{jarl}->{config}->{bg}->{normal},
#	       );

#    $GUI{Login}->{Username}->{Entry}->
#      configure(-state=>($profile eq "Connect w/o Profile") ? "normal" : "disabled",
#		-background=>($profile eq "Connect w/o Profile") ? $GUI{color}->{jarl}->{config}->{bg}->{light} : $GUI{color}->{jarl}->{config}->{bg}->{normal},
#	       );
#    $GUI{Login}->{Password}->{Entry}->
#      configure(-state=>($profile eq "Connect w/o Profile") ? "normal" : "disabled",
#		-background=>($profile eq "Connect w/o Profile") ? $GUI{color}->{jarl}->{config}->{bg}->{light} : $GUI{color}->{jarl}->{config}->{bg}->{normal},
#	       );
#    $GUI{Login}->{Resource}->{Entry}->
#      configure(-state=>($profile eq "Connect w/o Profile") ? "normal" : "disabled",
#		-background=>($profile eq "Connect w/o Profile") ? $GUI{color}->{jarl}->{config}->{bg}->{light} : $GUI{color}->{jarl}->{config}->{bg}->{normal},
#	       );
  } else {
    $GUI{Login}->{vars}->{loaded} = 1;
  }
}


1;
