##############################################################################
#
# Jarl - Presence Tk Interface Code
#
#   Perl code to handle presence requests and other presence GUI functions.
#
##############################################################################

##############################################################################
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
#
#  Jabber
#  Copyright (C) 1998-1999 The Jabber Team http://jabber.org/
#
##############################################################################

##############################################################################
#
# jarlPresenceIF_SubscriptionAsk - prompts the user for what they want to do
#                                with the incoming subscription
#
##############################################################################
sub jarlPresenceIF_SubscriptionAsk {
  my ($subscription) = @_;
  my $jid = $subscription->GetFrom("jid")->GetJID();

  if (Exists($GUI{Subscription}->{$jid}->{window}) && $GUI{Subscription}->{$jid}->{window}->ismapped()) {
    $GUI{Subscription}->{$jid}->{window}->raise();
    return;
  }

  $GUI{Subscription}->{$jid}->{window} = $GUI{top}->Toplevel();
  $GUI{Subscription}->{$jid}->{window}->title("Subscription Query");
  $GUI{Subscription}->{$jid}->{window}->resizable(0,0);

  $GUI{Subscription}->{$jid}->{top} = 
    $GUI{Subscription}->{$jid}->{window}->
      Frame(-background=>$GUI{color}->{jarl}->{main}->{bg}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{main}->{fg}->{dark},
	   )->pack(-side=>"top",
		   -fill=>"y",
		   -padx=>$GUI{width}->{jarl}->{rosteritem}->{pad},
		   -pady=>$GUI{height}->{jarl}->{rosteritem}->{pad},
		   -expand=>1);
  
  $GUI{Subscription}->{$jid}->{Text}->{top} =
    $GUI{Subscription}->{$jid}->{top}->
      Frame(-background=>$GUI{color}->{jarl}->{rosteritem}->{bg}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{rosteritem}->{fg}->{dark},
	   )->pack(-side=>"top",
		   -fill=>"both",
		   -expand=>1);
  $GUI{Subscription}->{$jid}->{Text}->{Label} =
    $GUI{Subscription}->{$jid}->{Text}->{top}->
      Label(-text=>"The user $jid has requested a subscription to you.",
	    -anchor=>"w",
	    -font=>$GUI{fonts}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{rosteritem}->{fg}->{dark},
	    -background=>$GUI{color}->{jarl}->{rosteritem}->{bg}->{normal}
	   )->pack(-side=>"left",
		   -fill=>"y",
		   -anchor=>"w");

  &jarlPresenceIF_SubscriptionGUI($GUI{Subscription}->{$jid}->{top},$jid)
    if (($config{subscriptions} eq "prompt") ||
	($config{subscriptions} eq "roster"));
  
  &jarlPresenceIF_SubscribeGUI($GUI{Subscription}->{$jid}->{top},$jid)
    if ($config{subscribe} == 0);

  $GUI{Subscription}->{$jid}->{Buttons}->{top} = 
    $GUI{Subscription}->{$jid}->{top}->
      Frame(-background=>$GUI{color}->{jarl}->{rosteritem}->{bg}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{rosteritem}->{fg}->{dark},
	   )->pack(-side=>"top",
		   -fill=>"both",
		   -expand=>1);
  $GUI{Subscription}->{$jid}->{Buttons}->{Ok} =
    $GUI{Subscription}->{$jid}->{Buttons}->{top}->
      Button(-text=>"Ok",
	     -width=>$GUI{width}->{jarl}->{rosteritem}->{button},
	     -background=>$GUI{color}->{jarl}->{rosteritem}->{bg}->{normal},
	     -foreground=>$GUI{color}->{jarl}->{rosteritem}->{fg}->{dark},
	     -disabledforeground=>$GUI{color}->{jarl}->{rosteritem}->{fg}->{light},
	     -font=>$GUI{fonts}->{normal},
	     -command=>sub{
	       if (($config{subscriptions} eq "prompt") ||
		   ($config{subscriptions} eq "roster")) {
		 my $reply =
		   $subscription->
		     Reply(template=>"client",
			   type=>(($GUI{Subscription}->{$jid}->{vars}->{subscription} == 1) ? "subscribed" : "unsubscribed"),
			   (($GUI{Subscription}->{$jid}->{vars}->{subscription} == 0) ?
			    (status=>$config{subscriptiondenymessage}) :
			    ()
			   )
			  );
		 $jabber{client}->Send($reply);
	       }
	       if ($config{subscribe} == 0) {
		 if ($GUI{Subscription}->{$jid}->{vars}->{subscribe} == 1) {
		   my $reply =
		     $subscription->
		       Reply(template=>"client",
			     type=>"subscribe");
		   $jabber{client}->Send($reply);
		 }
	       } else {
		 if ($GUI{Subscription}->{$jid}->{vars}->{subscription} == 1) {
		   my $reply =
		     $subscription->
		       Reply(template=>"client",
			     type=>"subscribe");
		   $jabber{client}->Send($reply);
		 }
	       }

	       &jarlPresenceIF_SubscriptionCloseCB($jid);
	     }
	    )->pack(-side=>"right",
		    -pady=>$GUI{height}->{jarl}->{rosteritem}->{pad},
		    -padx=>$GUI{width}->{jarl}->{rosteritem}->{pad});
}


##############################################################################
#
# jarlPresenceIF_SubscriptionGUI - defines the GUI widgets for the 
#                                SubscriptionAsk function.
#
##############################################################################
sub jarlPresenceIF_SubscriptionGUI {
  my ($widget,$jid) = @_;

  $GUI{Subscription}->{$jid}->{vars}->{subscription} = 1;

  $GUI{Subscription}->{$jid}->{Subscription}->{Text}->{top} =
    $widget->
      Frame(-background=>$GUI{color}->{jarl}->{rosteritem}->{bg}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{rosteritem}->{fg}->{dark},
	   )->pack(-side=>"top",
		   -fill=>"both",
		   -expand=>1);
  $GUI{Subscription}->{$jid}->{Subscription}->{Text}->{Label} =
    $GUI{Subscription}->{$jid}->{Subscription}->{Text}->{top}->
      Label(-text=>"Do you want to allow them to see your presence?",
	    -anchor=>"w",
	    -font=>$GUI{fonts}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{rosteritem}->{fg}->{dark},
	    -background=>$GUI{color}->{jarl}->{rosteritem}->{bg}->{normal}
	   )->pack(-side=>"left",
		   -fill=>"y",
		   -anchor=>"w");

  $GUI{Subscription}->{$jid}->{Subscription}->{Ask}->{top} =
    $widget->
      Frame(-background=>$GUI{color}->{bg}->{normal},
	    -foreground=>$GUI{color}->{fg}->{dark},
	   )->pack(-side=>'top',
		   -fill=>'x');
  $GUI{Subscription}->{$jid}->{Subscription}->{Ask}->{Yes}->{top} =
    $GUI{Subscription}->{$jid}->{Subscription}->{Ask}->{top}->
      Frame(-background=>$GUI{color}->{bg}->{normal},
	    -foreground=>$GUI{color}->{fg}->{dark},
	   )->pack(-side=>'top',
		   -fill=>'x');
  $GUI{Subscription}->{$jid}->{Subscription}->{Ask}->{Yes}->{Radio} =
    $GUI{Subscription}->{$jid}->{Subscription}->{Ask}->{Yes}->{top}->
      Radiobutton(-value=>1,
		  -variable=>\$GUI{Subscription}->{$jid}->{vars}->{subscription},
		  -activebackground=>$GUI{color}->{bg}->{normal},
		  -background=>$GUI{color}->{bg}->{normal},
		  -foreground=>$GUI{color}->{fg}->{dark},
		  -font=>$GUI{fonts}->{normal},
		  -selectimage=>$GUI{Icons}->{RadioOn},
		  -image=>$GUI{Icons}->{RadioOff},
		  -indicatoron=>0,
		  -borderwidth=>0,
		  -selectcolor=>$GUI{color}->{bg}->{normal},
		  -command=>sub {
		    if ($config{subscribe} == 0) {
		      $GUI{Subscription}->{$jid}->{Subscribe}->{Ask}->{Yes}->{Radio}->configure(-state=>"normal");
		      $GUI{Subscription}->{$jid}->{Subscribe}->{Ask}->{No}->{Radio}->configure(-state=>"normal");
		    }
		  }
		 )->pack(-side=>'left',
			 -anchor=>'w');
  &jarlMainIF_RegisterIcon($GUI{Subscription}->{$jid}->{Subscription}->{Ask}->{Yes}->{Radio},"RadioOff");
  $GUI{Subscription}->{$jid}->{Subscription}->{Ask}->{Yes}->{Label} =
    $GUI{Subscription}->{$jid}->{Subscription}->{Ask}->{Yes}->{top}->
      Label(-text=>"Yes",
	    -background=>$GUI{color}->{bg}->{normal},
	    -foreground=>$GUI{color}->{fg}->{dark},
	    -font=>$GUI{fonts}->{normal},
	   )->pack(-side=>'left',
		   -anchor=>'w',
		   -fill=>'x');
  $GUI{Subscription}->{$jid}->{Subscription}->{Ask}->{Yes}->{Label}->
    bind("<Button-1>",sub{ $GUI{Subscription}->{$jid}->{Subscription}->{Ask}->{Yes}->{Radio}->invoke(); });
  
  $GUI{Subscription}->{$jid}->{Subscription}->{Ask}->{No}->{top} =
    $GUI{Subscription}->{$jid}->{Subscription}->{Ask}->{top}->
      Frame(-background=>$GUI{color}->{bg}->{normal},
	    -foreground=>$GUI{color}->{fg}->{dark},
	   )->pack(-side=>'top',
		   -fill=>'x');
  $GUI{Subscription}->{$jid}->{Subscription}->{Ask}->{No}->{Radio} =
    $GUI{Subscription}->{$jid}->{Subscription}->{Ask}->{No}->{top}->
      Radiobutton(-value=>0,
		  -variable=>\$GUI{Subscription}->{$jid}->{vars}->{subscription},
		  -activebackground=>$GUI{color}->{bg}->{normal},
		  -background=>$GUI{color}->{bg}->{normal},
		  -foreground=>$GUI{color}->{fg}->{dark},
		  -font=>$GUI{fonts}->{normal},
		  -selectimage=>$GUI{Icons}->{RadioOn},
		  -image=>$GUI{Icons}->{RadioOff},
		  -indicatoron=>0,
		  -borderwidth=>0,
		  -selectcolor=>$GUI{color}->{bg}->{normal},
		  -command=>sub {
		    if ($config{subscribe} == 0) {
		      $GUI{Subscription}->{$jid}->{Subscribe}->{Ask}->{Yes}->{Radio}->configure(-state=>"disabled");
		      $GUI{Subscription}->{$jid}->{Subscribe}->{Ask}->{No}->{Radio}->configure(-state=>"disabled");
		    }
		  }
		 )->pack(-side=>'left',
			 -anchor=>'w');
  &jarlMainIF_RegisterIcon($GUI{Subscription}->{$jid}->{Subscription}->{Ask}->{No}->{Radio},"RadioOff");
  $GUI{Subscription}->{$jid}->{Subscription}->{Ask}->{No}->{Label} =
    $GUI{Subscription}->{$jid}->{Subscription}->{Ask}->{No}->{top}->
      Label(-text=>"No",
	    -background=>$GUI{color}->{bg}->{normal},
	    -foreground=>$GUI{color}->{fg}->{dark},
	    -font=>$GUI{fonts}->{normal},
	   )->pack(-side=>'left',
		   -anchor=>'w',
		   -fill=>'x');
  $GUI{Subscription}->{$jid}->{Subscription}->{Ask}->{No}->{Label}->
    bind("<Button-1>",sub{ $GUI{Subscription}->{$jid}->{Subscription}->{Ask}->{No}->{Radio}->invoke(); });
}


##############################################################################
#
# jarlPresenceIF_SubscribeGUI - GUI code to prompt the user if they want to 
#                             subscribe to the user who sent a "subscribe" 
#                             presence.
#
##############################################################################
sub jarlPresenceIF_SubscribeGUI {
  my ($widget,$jid) = @_;
  
  $GUI{Subscription}->{$jid}->{vars}->{subscribe} = 1;
  
  $GUI{Subscription}->{$jid}->{Subscribe}->{Text}->{top} =
    $widget->
      Frame(-background=>$GUI{color}->{jarl}->{rosteritem}->{bg}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{rosteritem}->{fg}->{dark},
	   )->pack(-side=>"top",
		   -fill=>"both",
		   -expand=>1);
  $GUI{Subscription}->{$jid}->{Subscribe}->{Text}->{Label} =
    $GUI{Subscription}->{$jid}->{Subscribe}->{Text}->{top}->
      Label(-text=>"Do you want to subscribe to them?",
	    -anchor=>"w",
	    -font=>$GUI{fonts}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{rosteritem}->{fg}->{dark},
	    -background=>$GUI{color}->{jarl}->{rosteritem}->{bg}->{normal}
	   )->pack(-side=>"left",
		   -fill=>"y",
		   -anchor=>"w");

  $GUI{Subscription}->{$jid}->{Subscribe}->{Ask}->{top} =
    $widget->
      Frame(-background=>$GUI{color}->{bg}->{normal},
	    -foreground=>$GUI{color}->{fg}->{dark},
	   )->pack(-side=>'top',
		   -fill=>'x');
  $GUI{Subscription}->{$jid}->{Subscribe}->{Ask}->{Yes}->{top} =
    $GUI{Subscription}->{$jid}->{Subscribe}->{Ask}->{top}->
      Frame(-background=>$GUI{color}->{bg}->{normal},
	    -foreground=>$GUI{color}->{fg}->{dark},
	   )->pack(-side=>'top',
		   -fill=>'x');
  $GUI{Subscription}->{$jid}->{Subscribe}->{Ask}->{Yes}->{Radio} =
    $GUI{Subscription}->{$jid}->{Subscribe}->{Ask}->{Yes}->{top}->
      Radiobutton(-value=>1,
		  -variable=>\$GUI{Subscription}->{$jid}->{vars}->{subscribe},
		  -activebackground=>$GUI{color}->{bg}->{normal},
		  -background=>$GUI{color}->{bg}->{normal},
		  -foreground=>$GUI{color}->{fg}->{dark},
		  -font=>$GUI{fonts}->{normal},
		  -selectimage=>$GUI{Icons}->{RadioOn},
		  -image=>$GUI{Icons}->{RadioOff},
		  -indicatoron=>0,
		  -borderwidth=>0,
		  -selectcolor=>$GUI{color}->{bg}->{normal},
		 )->pack(-side=>'left',
			 -anchor=>'w');
  &jarlMainIF_RegisterIcon($GUI{Subscription}->{$jid}->{Subscribe}->{Ask}->{Yes}->{Radio},"RadioOff");
  $GUI{Subscription}->{$jid}->{Subscribe}->{Ask}->{Yes}->{Label} =
    $GUI{Subscription}->{$jid}->{Subscribe}->{Ask}->{Yes}->{top}->
      Label(-text=>"Yes",
	    -background=>$GUI{color}->{bg}->{normal},
	    -foreground=>$GUI{color}->{fg}->{dark},
	    -font=>$GUI{fonts}->{normal},
	   )->pack(-side=>'left',
		   -anchor=>'w',
		   -fill=>'x');
  $GUI{Subscription}->{$jid}->{Subscribe}->{Ask}->{Yes}->{Label}->
    bind("<Button-1>",sub{ $GUI{Subscription}->{$jid}->{Subscribe}->{Ask}->{Yes}->{Radio}->invoke(); });

  $GUI{Subscription}->{$jid}->{Subscribe}->{Ask}->{No}->{top} =
    $GUI{Subscription}->{$jid}->{Subscribe}->{Ask}->{top}->
      Frame(-background=>$GUI{color}->{bg}->{normal},
	    -foreground=>$GUI{color}->{fg}->{dark},
	   )->pack(-side=>'top',
		   -fill=>'x');
  $GUI{Subscription}->{$jid}->{Subscribe}->{Ask}->{No}->{Radio} =
    $GUI{Subscription}->{$jid}->{Subscribe}->{Ask}->{No}->{top}->
      Radiobutton(-value=>0,
		  -variable=>\$GUI{Subscription}->{$jid}->{vars}->{subscribe},
		  -activebackground=>$GUI{color}->{bg}->{normal},
		  -background=>$GUI{color}->{bg}->{normal},
		  -foreground=>$GUI{color}->{fg}->{dark},
		  -font=>$GUI{fonts}->{normal},
		  -selectimage=>$GUI{Icons}->{RadioOn},
		  -image=>$GUI{Icons}->{RadioOff},
		  -indicatoron=>0,
		  -borderwidth=>0,
		  -selectcolor=>$GUI{color}->{bg}->{normal},
		 )->pack(-side=>'left',
			 -anchor=>'w');
  &jarlMainIF_RegisterIcon($GUI{Subscription}->{$jid}->{Subscribe}->{Ask}->{No}->{Radio},"RadioOff");
  $GUI{Subscription}->{$jid}->{Subscribe}->{Ask}->{No}->{Label} =
    $GUI{Subscription}->{$jid}->{Subscribe}->{Ask}->{No}->{top}->
      Label(-text=>"No",
	    -background=>$GUI{color}->{bg}->{normal},
	    -foreground=>$GUI{color}->{fg}->{dark},
	    -font=>$GUI{fonts}->{normal},
	   )->pack(-side=>'left',
		   -anchor=>'w',
		   -fill=>'x');
  $GUI{Subscription}->{$jid}->{Subscribe}->{Ask}->{No}->{Label}->
    bind("<Button-1>",sub{ $GUI{Subscription}->{$jid}->{Subscribe}->{Ask}->{No}->{Radio}->invoke(); });
}


##############################################################################
#
# jarlPresenceIF_SubscriptionCloseCB - closes the subscription GUI.
#
##############################################################################
sub jarlPresenceIF_SubscriptionCloseCB {
  my ($jid) = @_;

  $GUI{Subscription}->{$jid}->{window}->destroy;
  delete($GUI{Subscription}->{$jid});
}


##############################################################################
#
# jarlPresenceIF_CustomGUI - open the custom presence GUI
#
##############################################################################
sub jarlPresenceIF_CustomGUI {

  $GUI{CustomPresence}->{vars}->{type} = "available";
  $GUI{CustomPresence}->{vars}->{show} = "";
  $GUI{CustomPresence}->{vars}->{status} = "";
  $GUI{CustomPresence}->{vars}->{priority} = $jabber{presence}->Priority;

  $GUI{CustomPresence}->{window} = $GUI{top}->Toplevel();
  $GUI{CustomPresence}->{window}->title("Custom Presence...");
  $GUI{CustomPresence}->{window}->resizable(0,0);

  $GUI{CustomPresence}->{top} = 
    $GUI{CustomPresence}->{window}->
      Frame(-background=>$GUI{color}->{jarl}->{main}->{bg}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{main}->{fg}->{dark},
	   )->pack(-side=>"top",
		   -fill=>"y",
		   -padx=>$GUI{width}->{jarl}->{rosteritem}->{pad},
		   -pady=>$GUI{height}->{jarl}->{rosteritem}->{pad},
		   -expand=>1);

  $GUI{CustomPresence}->{left} = 
    $GUI{CustomPresence}->{top}->
      Frame(-background=>$GUI{color}->{jarl}->{main}->{bg}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{main}->{fg}->{dark},
	   )->pack(-side=>"left",
		   -fill=>"y",
		   -expand=>1);

  $GUI{CustomPresence}->{right} = 
    $GUI{CustomPresence}->{top}->
      Frame(-background=>$GUI{color}->{jarl}->{main}->{bg}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{main}->{fg}->{dark},
	   )->pack(-side=>"right",
		   -fill=>"y",
		   -expand=>1);

  $GUI{CustomPresence}->{Show}->{top} = 
    $GUI{CustomPresence}->{left}->
      Frame(-background=>$GUI{color}->{jarl}->{main}->{bg}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{main}->{fg}->{dark},
	   )->pack(-side=>"top",
		   -fill=>"x",
		   -expand=>1);
  $GUI{CustomPresence}->{Show}->{Label} =
    $GUI{CustomPresence}->{Show}->{top}->
      Label(-text=>"Show:",
	    -anchor=>"w",
	    -width=>10,
	    -font=>$GUI{fonts}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{rosteritem}->{fg}->{dark},
	    -background=>$GUI{color}->{jarl}->{rosteritem}->{bg}->{normal}
	   )->pack(-side=>"top",
		   -fill=>"y",
		   -anchor=>"w");

  $GUI{CustomPresence}->{Show}->{Choices}->{Chat}->{top} =
    $GUI{CustomPresence}->{Show}->{top}->
      Frame(-background=>$GUI{color}->{bg}->{normal},
            -foreground=>$GUI{color}->{fg}->{dark},
           )->pack(-side=>'top',
                   -fill=>'x',
		   -padx=>5);
  $GUI{CustomPresence}->{Show}->{Choices}->{Chat}->{Radio} =
    $GUI{CustomPresence}->{Show}->{Choices}->{Chat}->{top}->
      Radiobutton(-value=>"chat",
                  -variable=>\$GUI{CustomPresence}->{vars}->{show},
                  -activebackground=>$GUI{color}->{bg}->{normal},
                  -background=>$GUI{color}->{bg}->{normal},
                  -foreground=>$GUI{color}->{fg}->{dark},
                  -font=>$GUI{fonts}->{normal},
                  -selectimage=>$GUI{Icons}->{RadioOn},
                  -image=>$GUI{Icons}->{RadioOff},
                  -indicatoron=>0,
                  -borderwidth=>0,
                  -selectcolor=>$GUI{color}->{bg}->{normal},
                 )->pack(-side=>'left',
                         -anchor=>'w');
  &jarlMainIF_RegisterIcon($GUI{CustomPresence}->{Show}->{Choices}->{Chat}->{Radio},"RadioOff");
  $GUI{CustomPresence}->{Show}->{Choices}->{Chat}->{Label} =
    $GUI{CustomPresence}->{Show}->{Choices}->{Chat}->{top}->
      Label(-text=>"Chat",
            -background=>$GUI{color}->{bg}->{normal},
            -foreground=>$GUI{color}->{fg}->{dark},
            -font=>$GUI{fonts}->{normal},
           )->pack(-side=>'left',
                   -anchor=>'w');
  $GUI{CustomPresence}->{Show}->{Choices}->{Chat}->{Label}->
    bind("<Button-1>",sub{ $GUI{CustomPresence}->{vars}->{show} = "chat"; });

  $GUI{CustomPresence}->{Show}->{Choices}->{Dnd}->{top} =
    $GUI{CustomPresence}->{Show}->{top}->
      Frame(-background=>$GUI{color}->{bg}->{normal},
            -foreground=>$GUI{color}->{fg}->{dark},
           )->pack(-side=>'top',
                   -fill=>'x',
		   -padx=>5);
  $GUI{CustomPresence}->{Show}->{Choices}->{Dnd}->{Radio} =
    $GUI{CustomPresence}->{Show}->{Choices}->{Dnd}->{top}->
      Radiobutton(-value=>"dnd",
                  -variable=>\$GUI{CustomPresence}->{vars}->{show},
                  -activebackground=>$GUI{color}->{bg}->{normal},
                  -background=>$GUI{color}->{bg}->{normal},
                  -foreground=>$GUI{color}->{fg}->{dark},
                  -font=>$GUI{fonts}->{normal},
                  -selectimage=>$GUI{Icons}->{RadioOn},
                  -image=>$GUI{Icons}->{RadioOff},
                  -indicatoron=>0,
                  -borderwidth=>0,
                  -selectcolor=>$GUI{color}->{bg}->{normal},
                 )->pack(-side=>'left',
                         -anchor=>'w');
  &jarlMainIF_RegisterIcon($GUI{CustomPresence}->{Show}->{Choices}->{Dnd}->{Radio},"RadioOff");
  $GUI{CustomPresence}->{Show}->{Choices}->{Dnd}->{Label} =
    $GUI{CustomPresence}->{Show}->{Choices}->{Dnd}->{top}->
      Label(-text=>"Do Not Disturb",
            -background=>$GUI{color}->{bg}->{normal},
            -foreground=>$GUI{color}->{fg}->{dark},
            -font=>$GUI{fonts}->{normal},
           )->pack(-side=>'left',
                   -anchor=>'w');
  $GUI{CustomPresence}->{Show}->{Choices}->{Dnd}->{Label}->
    bind("<Button-1>",sub{ $GUI{CustomPresence}->{vars}->{show} = "dnd"; });

  $GUI{CustomPresence}->{Show}->{Choices}->{Away}->{top} =
    $GUI{CustomPresence}->{Show}->{top}->
      Frame(-background=>$GUI{color}->{bg}->{normal},
            -foreground=>$GUI{color}->{fg}->{dark},
           )->pack(-side=>'top',
                   -fill=>'x',
		   -padx=>5);
  $GUI{CustomPresence}->{Show}->{Choices}->{Away}->{Radio} =
    $GUI{CustomPresence}->{Show}->{Choices}->{Away}->{top}->
      Radiobutton(-value=>"away",
                  -variable=>\$GUI{CustomPresence}->{vars}->{show},
                  -activebackground=>$GUI{color}->{bg}->{normal},
                  -background=>$GUI{color}->{bg}->{normal},
                  -foreground=>$GUI{color}->{fg}->{dark},
                  -font=>$GUI{fonts}->{normal},
                  -selectimage=>$GUI{Icons}->{RadioOn},
                  -image=>$GUI{Icons}->{RadioOff},
                  -indicatoron=>0,
                  -borderwidth=>0,
                  -selectcolor=>$GUI{color}->{bg}->{normal},
                 )->pack(-side=>'left',
                         -anchor=>'w');
  &jarlMainIF_RegisterIcon($GUI{CustomPresence}->{Show}->{Choices}->{Away}->{Radio},"RadioOff");
  $GUI{CustomPresence}->{Show}->{Choices}->{Away}->{Label} =
    $GUI{CustomPresence}->{Show}->{Choices}->{Away}->{top}->
      Label(-text=>"Away",
            -background=>$GUI{color}->{bg}->{normal},
            -foreground=>$GUI{color}->{fg}->{dark},
            -font=>$GUI{fonts}->{normal},
           )->pack(-side=>'left',
                   -anchor=>'w');
  $GUI{CustomPresence}->{Show}->{Choices}->{Away}->{Label}->
    bind("<Button-1>",sub{ $GUI{CustomPresence}->{vars}->{show} = "away"; });

  $GUI{CustomPresence}->{Show}->{Choices}->{Xa}->{top} =
    $GUI{CustomPresence}->{Show}->{top}->
      Frame(-background=>$GUI{color}->{bg}->{normal},
            -foreground=>$GUI{color}->{fg}->{dark},
           )->pack(-side=>'top',
                   -fill=>'x',
		   -padx=>5);
  $GUI{CustomPresence}->{Show}->{Choices}->{Xa}->{Radio} =
    $GUI{CustomPresence}->{Show}->{Choices}->{Xa}->{top}->
      Radiobutton(-value=>"xa",
                  -variable=>\$GUI{CustomPresence}->{vars}->{show},
                  -activebackground=>$GUI{color}->{bg}->{normal},
                  -background=>$GUI{color}->{bg}->{normal},
                  -foreground=>$GUI{color}->{fg}->{dark},
                  -font=>$GUI{fonts}->{normal},
                  -selectimage=>$GUI{Icons}->{RadioOn},
                  -image=>$GUI{Icons}->{RadioOff},
                  -indicatoron=>0,
                  -borderwidth=>0,
                  -selectcolor=>$GUI{color}->{bg}->{normal},
                 )->pack(-side=>'left',
                         -anchor=>'w');
  &jarlMainIF_RegisterIcon($GUI{CustomPresence}->{Show}->{Choices}->{Xa}->{Radio},"RadioOff");
  $GUI{CustomPresence}->{Show}->{Choices}->{Xa}->{Label} =
    $GUI{CustomPresence}->{Show}->{Choices}->{Xa}->{top}->
      Label(-text=>"Extended Away",
            -background=>$GUI{color}->{bg}->{normal},
            -foreground=>$GUI{color}->{fg}->{dark},
            -font=>$GUI{fonts}->{normal},
           )->pack(-side=>'left',
                   -anchor=>'w');
  $GUI{CustomPresence}->{Show}->{Choices}->{Xa}->{Label}->
    bind("<Button-1>",sub{ $GUI{CustomPresence}->{vars}->{show} = "xa"; });

  $GUI{CustomPresence}->{Status}->{top} =
    $GUI{CustomPresence}->{right}->
      Frame(-background=>$GUI{color}->{jarl}->{rosteritem}->{bg}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{rosteritem}->{fg}->{dark},
	   )->pack(-side=>"top",
		   -fill=>"x");
  $GUI{CustomPresence}->{Status}->{Label} =
    $GUI{CustomPresence}->{Status}->{top}->
      Label(-text=>"Status:",
	    -anchor=>"w",
	    -width=>10,
	    -font=>$GUI{fonts}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{rosteritem}->{fg}->{dark},
	    -background=>$GUI{color}->{jarl}->{rosteritem}->{bg}->{normal}
	   )->pack(-side=>"left",
		   -fill=>"y",
		   -anchor=>"w");
  $GUI{CustomPresence}->{Status}->{Entry} =
    $GUI{CustomPresence}->{Status}->{top}->
      Entry(-textvariable=>\$GUI{CustomPresence}->{vars}->{status},
	    -width=>25,
	    -font=>$GUI{fonts}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{rosteritem}->{fg}->{dark},
	    -background=>$GUI{color}->{jarl}->{rosteritem}->{bg}->{light}
	   )->pack(-side=>"left",
		   -fill=>"both",
		   -anchor=>"w");
  
  $GUI{CustomPresence}->{Priority}->{top} =
    $GUI{CustomPresence}->{right}->
      Frame(-background=>$GUI{color}->{jarl}->{rosteritem}->{bg}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{rosteritem}->{fg}->{dark},
	   )->pack(-side=>"top",
		   -fill=>"x");
  $GUI{CustomPresence}->{Priority}->{Label} =
    $GUI{CustomPresence}->{Priority}->{top}->
      Label(-text=>"Priority:",
	    -anchor=>"w",
	    -width=>10,
	    -font=>$GUI{fonts}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{rosteritem}->{fg}->{dark},
	    -background=>$GUI{color}->{jarl}->{rosteritem}->{bg}->{normal}
	   )->pack(-side=>"left",
		   -fill=>"y",
		   -anchor=>"w");
  $GUI{CustomPresence}->{Priority}->{Entry} =
    $GUI{CustomPresence}->{Priority}->{top}->
      Entry(-textvariable=>\$GUI{CustomPresence}->{vars}->{priority},
	    -width=>25,
	    -font=>$GUI{fonts}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{rosteritem}->{fg}->{dark},
	    -background=>$GUI{color}->{jarl}->{rosteritem}->{bg}->{light}
	   )->pack(-side=>"left",
		   -fill=>"both",
		   -anchor=>"w");
  
  $GUI{CustomPresence}->{Buttons}->{top} = 
    $GUI{CustomPresence}->{right}->
      Frame(-background=>$GUI{color}->{jarl}->{rosteritem}->{bg}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{rosteritem}->{fg}->{dark},
	   )->pack(-side=>"bottom",
		   -fill=>"both",
		   -expand=>1);
  $GUI{CustomPresence}->{Buttons}->{Cancel} =
    $GUI{CustomPresence}->{Buttons}->{top}->
      Button(-text=>"Cancel",
	     -width=>$GUI{width}->{jarl}->{rosteritem}->{button},
	     -background=>$GUI{color}->{jarl}->{rosteritem}->{bg}->{normal},
	     -foreground=>$GUI{color}->{jarl}->{rosteritem}->{fg}->{dark},
	     -disabledforeground=>$GUI{color}->{jarl}->{rosteritem}->{fg}->{light},
	     -font=>$GUI{fonts}->{normal},
	     -command=>sub{
	       &jarlPresenceIF_CustomCloseCB();
	     }
	    )->pack(-side=>"right",
		    -pady=>$GUI{height}->{jarl}->{rosteritem}->{pad},
		    -padx=>$GUI{width}->{jarl}->{rosteritem}->{pad});
  $GUI{CustomPresence}->{Buttons}->{Save} =
    $GUI{CustomPresence}->{Buttons}->{top}->
      Button(-text=>"Send",
	     -width=>$GUI{width}->{jarl}->{rosteritem}->{button},
	     -background=>$GUI{color}->{jarl}->{rosteritem}->{bg}->{normal},
	     -foreground=>$GUI{color}->{jarl}->{rosteritem}->{fg}->{dark},
	     -disabledforeground=>$GUI{color}->{jarl}->{rosteritem}->{fg}->{light},
	     -font=>$GUI{fonts}->{normal},
	     -command=>sub{
	       $jabber{presence}->
		 Set(type=>$GUI{CustomPresence}->{vars}->{type},
		     show=>$GUI{CustomPresence}->{vars}->{show},
		     status=>$GUI{CustomPresence}->{vars}->{status},
		     priority=>$GUI{CustomPresence}->{vars}->{priority});
	       &jarlPresenceIF_CustomCloseCB();
	     }
	    )->pack(-side=>"right",
		    -pady=>$GUI{height}->{jarl}->{rosteritem}->{pad},
		    -padx=>$GUI{width}->{jarl}->{rosteritem}->{pad});

}


##############################################################################
#
# jarlPresenceIF_CustomCloseCB - close the custom presence GUI
#
##############################################################################
sub jarlPresenceIF_CustomCloseCB {
  $GUI{CustomPresence}->{window}->destroy;
  delete($GUI{CustomPresence});
}


1;
