##############################################################################
#
# Jarl - Debug Code
#
#   Perl code to handle displaying and sending info form the Debug Tab.
#
##############################################################################

##############################################################################
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
#
#  Jabber
#  Copyright (C) 1998-1999 The Jabber Team http://jabber.org/
#
##############################################################################


##############################################################################
#
# jarlDebug_AddSendXML - wrapper function for Net::Jabber support.
#
##############################################################################
sub jarlDebug_AddSendXML {
  my ($sid,$xml) = @_;

  &jarlDebugIF_AddXML("SENT",$xml);
}


##############################################################################
#
# jarlDebug_AddReceivceXML - wrapper function for Net::Jabber support.
#
##############################################################################
sub jarlDebug_AddReceiveXML {
  my ($sid,$xml) = @_;

  &jarlDebugIF_AddXML("RCVD",$xml);
}


##############################################################################
#
# jarlDebug_HistoryUp -  function to provide the interfaces with a
#                        consistent way of supporting scrolling up
#                        through the history.
#
##############################################################################
sub jarlDebug_HistoryUp {
  my $current = &jarlDebugIF_CurrentSay();

  return $current if ($#{$debug{history}} < 0);
  return $current if ($debug{historyPtr} == $#{$debug{history}});

  $debug{historySaved} = $current if ($debug{historyPtr} == -1);

  $debug{historyPtr}++;

  return $debug{history}->[$debug{historyPtr}];
}


##############################################################################
#
# jarlDebug_HistoryDown - function to provide the interfaces with a
#                         consistent way of supporting scrolling down
#                         through the history.
#
##############################################################################
sub jarlDebug_HistoryDown {
  my $current = &jarlDebugIF_CurrentSay();

  return $current if ($#{$debug{history}} < 0);
  return $current if ($debug{historyPtr} == -1);

  $debug{historyPtr}--;

  return $debug{historySaved} if ($debug{historyPtr} == -1 );

  return $debug{history}->[$debug{historyPtr}];
}


##############################################################################
#
# jarlDebug_AddHistory - function to add a line to the chat history and reset
#                       the pointer.
#
##############################################################################
sub jarlDebug_AddHistory {
  my ($text) = @_;

  unshift(@{$debug{history}},$text);
  $debug{historyPtr} = -1;
}


1;
