##############################################################################
#
# Jarl - GroupChat Tk Interface Code
#
#   Perl code to handle showing the Jarl GroupChat GUI and interfacing with
# it.
#
##############################################################################

##############################################################################
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
#
#  Jabber
#  Copyright (C) 1998-1999 The Jabber Team http://jabber.org/
#
##############################################################################

##############################################################################
#
# jarlGroupChatIF_GUI - window to ask which groupchat the user would like to
#                    join based on server, channel, and nick.
#
##############################################################################
sub jarlGroupChatIF_GUI {
  $GUI{GroupChatJoin}->{window} = $GUI{top}->Toplevel();
  $GUI{GroupChatJoin}->{window}->title("GroupChat");
  $GUI{GroupChatJoin}->{window}->resizable(0,0);

  my $top =
    $GUI{GroupChatJoin}->{window}->
      Frame(-background=>$GUI{color}->{bg}->{normal},
	    -foreground=>$GUI{color}->{fg}->{dark}
	   )->pack(-side=>"top",
		   -fill=>"both",
		   -expand=>1);

  my $channelFrame =
    $top->
      Frame(-background=>$GUI{color}->{bg}->{normal},
	    -foreground=>$GUI{color}->{fg}->{dark},
	   )->pack(-side=>'top',
		   -fill=>'both',
		   -expand=>1);
  $channelFrame->
    Label(-text=>"Channel:",
	  -width=>$GUI{width}->{jarl}->{profileeditor}->{label},
	  -background=>$GUI{color}->{bg}->{normal},
	  -foreground=>$GUI{color}->{fg}->{dark},
	  -font=>$GUI{fonts}->{normal},
	  -anchor=>'e'
	 )->pack(-side=>'left',
		 -anchor=>'e');
  $channelFrame->
    Entry(-textvariable=>\$GUI{GroupChatJoin}->{vars}->{channel},
	  -width=>$GUI{width}->{jarl}->{profileeditor}->{entry},
	  -background=>$GUI{color}->{bg}->{light},
	  -foreground=>$GUI{color}->{fg}->{dark},
	  -font=>$GUI{fonts}->{normal},
	  -state=>"normal"
	 )->pack(-side=>'left',
		 -fill=>"x",
		 -expand=>1,
		 -anchor=>'w');

  my $JIDPullDownFrame =
    $top->
      Frame(-background=>$GUI{color}->{bg}->{normal},
	    -foreground=>$GUI{color}->{fg}->{dark}
	   )->pack(-side=>"top",
		   -fill=>"both",
		   -expand=>1);
  $JIDPullDownFrame->
    Label(-text=>"Server:",
	  -background=>$GUI{color}->{bg}->{normal},
	  -foreground=>$GUI{color}->{fg}->{dark},
	  -font=>$GUI{fonts}->{normal},
	  -width=>$GUI{width}->{jarl}->{config}->{label},
	  -anchor=>"e"
	 )->pack(-side=>'left',
		 -anchor=>'e');
  $serverList =
    $JIDPullDownFrame->
      EntryPullDown(-textvariable=>\$GUI{GroupChatJoin}->{vars}->{server},
		    -width=>$GUI{width}->{jarl}->{profileeditor}->{entry},
		    -background=>$GUI{color}->{bg}->{normal},
		    -foreground=>$GUI{color}->{fg}->{dark},
		    -entrybackground=>$GUI{color}->{bg}->{light},
		    -entryforeground=>$GUI{color}->{fg}->{dark},
		    -font=>$GUI{fonts}->{normal},
		    -buttonborderwidth=>1,
		    -elements=>[keys(%groupchatJIDs)],
		   )->pack(-side=>'left',
			   -anchor=>'w');

  my $nickFrame =
    $top->
      Frame(-background=>$GUI{color}->{bg}->{normal},
	    -foreground=>$GUI{color}->{fg}->{dark},
	   )->pack(-side=>'top',
		   -fill=>'both',
		   -expand=>1);
  $nickFrame->
    Label(-text=>"Nick:",
	  -width=>$GUI{width}->{jarl}->{profileeditor}->{label},
	  -background=>$GUI{color}->{bg}->{normal},
	  -foreground=>$GUI{color}->{fg}->{dark},
	  -font=>$GUI{fonts}->{normal},
	  -anchor=>'e'
	 )->pack(-side=>'left',
		 -anchor=>'e');
  $nickFrame->
    Entry(-textvariable=>\$GUI{GroupChatJoin}->{vars}->{nick},
	  -width=>$GUI{width}->{jarl}->{profileeditor}->{entry},
	  -background=>$GUI{color}->{bg}->{light},
	  -foreground=>$GUI{color}->{fg}->{dark},
	  -font=>$GUI{fonts}->{normal},
	  -state=>"normal"
	 )->pack(-side=>'left',
		 -fill=>"x",
		 -expand=>1,
		 -anchor=>'w');

  my $buttonsFrame =
    $top->
      Frame(-background=>$GUI{color}->{bg}->{normal},
	    -foreground=>$GUI{color}->{fg}->{dark},
	   )->pack(-side=>"bottom",
		   -fill=>"both",
		   -expand=>1);
  $buttonsFrame->
    Button(-text=>"Close",
	   -background=>$GUI{color}->{bg}->{normal},
	   -foreground=>$GUI{color}->{fg}->{dark},
	   -disabledforeground=>$GUI{color}->{jarl}->{rosteritem}->{fg}->{light},
	   -font=>$GUI{fonts}->{normal},
	   -command=>sub{
	     &jarlGroupChatIF_CloseCB();
	   }
	  )->pack(-side=>"right",
		  -pady=>$GUI{height}->{jarl}->{rosteritem}->{pad},
		  -padx=>$GUI{width}->{jarl}->{rosteritem}->{pad});

  $buttonsFrame->
    Button(-text=>"Join",
	   -background=>$GUI{color}->{bg}->{normal},
	   -foreground=>$GUI{color}->{fg}->{dark},
	   -disabledforeground=>$GUI{color}->{fg}->{light},
	   -font=>$GUI{fonts}->{normal},
	   -command=>sub{

	     $serverList->SaveElement();
	     foreach my $server ($serverList->GetElements()) {
	       $groupchatJIDs{$server} = 1;
	     }

	     &jarlGroupChat_Join($GUI{GroupChatJoin}->{vars}->{channel}."\@".$GUI{GroupChatJoin}->{vars}->{server},$GUI{GroupChatJoin}->{vars}->{nick});
	   }
	  )->pack(-side=>"right",
		  -pady=>$GUI{height}->{jarl}->{rosteritem}->{pad},
		  -padx=>$GUI{width}->{jarl}->{rosteritem}->{pad});
}


##############################################################################
#
# jarlGroupChatIF_CloseCB - function to close the current groupchat window.
#
##############################################################################
sub jarlGroupChatIF_CloseCB {
  $GUI{GroupChatJoin}->{window}->destroy;
  delete($GUI{GroupChatJoin});
}


##############################################################################
#
# jarlGroupChatIF_AddMessage - takes a <message/> and adds it to the proper
#                           channel based on the from JID.
#
##############################################################################
sub jarlGroupChatIF_AddMessage {
  my ($tag,$type,$timestamp,$history,$currentID,@message) = @_;

  $Debug->Log1("jarlGroupChatIF_AddMessage: tag($tag) type($type) timestamp($timestamp)");
  $Debug->Log1("jarlGroupChatIF_AddMessage: history($history) currentID($currentID)");
  $Debug->Log1("jarlGroupChatIF_AddMessage: message(\"".join("\",\"",@message)."\")");

  my $priority = "low";

  $GUI{GroupChat}->{$tag}->{GroupChatText}->{Text}->
    configure(-state=>"normal");

  $GUI{GroupChat}->{$tag}->{GroupChatText}->{Text}->
    insert("end","\n")
      if ($GUI{GroupChat}->{$tag}->{vars}->{neednewline} == 1);
  $GUI{GroupChat}->{$tag}->{vars}->{neednewline} = 1;

  my $timestampString = "[".$timestamp."]";
  $timestampString .= "\@" if ($history == 1);
  $GUI{GroupChat}->{$tag}->{GroupChatText}->{Text}->
    insert("end","$timestampString ",[ "timestamp" , "lastinserted" ]);

  my (undef,undef,$lmargin,undef) = 
    $GUI{GroupChat}->{$tag}->{GroupChatText}->{Text}->
      dlineinfo("lastinserted.first");

  $GUI{GroupChat}->{$tag}->{GroupChatText}->{Text}->
    tagDelete("lastinserted");

  $GUI{GroupChat}->{$tag}->{GroupChatText}->{Text}->
    tagConfigure($type."$currentID",
		 -lmargin1=>$lmargin,
		 -lmargin2=>$lmargin);

  while ($#message > -1) {
    my $pieceType = shift(@message);
    my $piece = shift(@message);

    my @tagList = ( $pieceType, $type, $type."$currentID");
    if ($pieceType eq "link") {
      push(@tagList, "link-$piece");
      $GUI{GroupChat}->{$tag}->{GroupChatText}->{Text}->
	tagBind("link-$piece",
		"<Button-1>",
		sub{
		  &jarlFetchURL($piece);
		});
    }

    $GUI{GroupChat}->{$tag}->{GroupChatText}->{Text}->
      insert("end", $piece, \@tagList);

    $priority = "medium" if ($pieceType eq "highlight");
  }

  $GUI{GroupChat}->{$tag}->{GroupChatText}->{Text}->
    yview("moveto",100) 
      if ($GUI{GroupChat}->{$tag}->{vars}->{ScrollLock} == 1);
  $GUI{GroupChat}->{$tag}->{GroupChatText}->{Text}->
    configure(-state=>"disabled");

  $TabBar->HighlightTab($tag,$priority);
}


##############################################################################
#
# jarlGroupChatIF_ShowTopic - take a parsed topic and display it.
#
##############################################################################
sub jarlGroupChatIF_ShowTopic {
  my ($tag,@topic) = @_;

  $Debug->Log1("jarlGroupChatIF_ShowTopic: tag($tag) topic(\"",join("\",\"",@topic),"\")");

  $GUI{GroupChat}->{$tag}->{Topic}->{top}->
    pack(-side=>"top",
	 -fill=>"x",
	 -padx=>5,
	 -pady=>5)
      unless ($GUI{GroupChat}->{$tag}->{vars}->{topic} == 1);

  $GUI{GroupChat}->{$tag}->{vars}->{topic} = 1;

  $GUI{GroupChat}->{$tag}->{Topic}->{Text}->
    configure(-state=>"normal");
  $GUI{GroupChat}->{$tag}->{Topic}->{Text}->
    delete("1.0","end");
  $GUI{GroupChat}->{$tag}->{Topic}->{Text}->
    insert("end","Topic:  ",["topic"]);
  while ($#topic > -1) {
    my $pieceType = shift(@topic);
    my $piece = shift(@topic);

    my @tagList = ( $pieceType );
    if ($pieceType eq "link") {
      push(@tagList, "link-$piece");
      $GUI{GroupChat}->{$tag}->{Topic}->{Text}->
	tagBind("link-$piece",
		"<Button-1>",
		sub{
		  &jarlFetchURL($piece);
		});
    }

    $GUI{GroupChat}->{$tag}->{Topic}->{Text}->
      insert("end", $piece, \@tagList);
  }
  $GUI{GroupChat}->{$tag}->{Topic}->{Text}->
    configure(-state=>"disabled");
}


##############################################################################
#
# jarlGroupChatIF_GroupChatExists - returns 1 if the GUI for the groupchat 
#                                   exists, 0 if not.
#
##############################################################################
sub jarlGroupChatIF_GroupChatExists {
  my ($tag) = @_;
  return exists($GUI{GroupChat}->{$tag});
}


##############################################################################
#
# jarlGroupChatIF_NewGroupChat - function to do all GUI calls needed to create #                                a new groupchat.
#
##############################################################################
sub jarlGroupChatIF_NewGroupChat {
  my ($tag) = @_;

  $Debug->Log3("jarlGroupChatIF_NewGroupChat: tag($tag)");

  $GUI{GroupChat}->{$tag}->{top} =
    $TabBar->AddTab(-type=>"docked",
		    -tag=>$tag,
		    -text=>"GroupChat - ".&jarlGroupChat_ChannelName($tag));
  &jarlGroupChatIF_NewGUI($tag);
  &jarlGroupChatIF_RaiseGroupChat($tag);
}


##############################################################################
#
# jarlGroupChatIF_RaiseGroupChat - function to bring the specified groupchat 
#                                  to the top of the window list.
#
##############################################################################
sub jarlGroupChatIF_RaiseGroupChat {
  my ($tag) = @_;
  $TabBar->RaiseTab($tag);
}


##############################################################################
#
# jarlGroupChatIF_NewGUI - populates the new tab with a groupchat GUI.
#
##############################################################################
sub jarlGroupChatIF_NewGUI {
  my ($tag) = @_;

  $Debug->Log3("jarlGroupChatIF_NewGUI: tag($tag)");

  $GUI{GroupChat}->{$tag}->{vars}->{ScrollLock} = 1;
  $GUI{GroupChat}->{$tag}->{vars}->{topic} = 0;
  $GUI{GroupChat}->{$tag}->{vars}->{neednewline} = 0;

  #---------------------------------------------------------------------------
  # Groupchat Window
  #---------------------------------------------------------------------------
  my $frame =
    $GUI{GroupChat}->{$tag}->{top}->
      Frame(-background=>$GUI{color}->{jarl}->{main}->{bg}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{main}->{fg}->{dark},
	   )->pack(-side=>"top",
		   -fill=>"x");

  my $bottomFrame =
    $GUI{GroupChat}->{$tag}->{top}->
      Frame(-background=>$GUI{color}->{jarl}->{main}->{bg}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{main}->{fg}->{dark},
	   )->pack(-side=>"bottom",
		   -fill=>"x");
  my $leftFrame =
    $GUI{GroupChat}->{$tag}->{top}->
      Frame(-background=>$GUI{color}->{jarl}->{main}->{bg}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{main}->{fg}->{dark},
	   )->pack(-side=>"left",
		   -fill=>"both",
		   -expand=>1);
  $GUI{GroupChat}->{$tag}->{Right}->{top} =
    $GUI{GroupChat}->{$tag}->{top}->
      Frame(-background=>$GUI{color}->{jarl}->{main}->{bg}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{main}->{fg}->{dark},
	   )->pack(-side=>"right",
		   -fill=>"y");

  $GUI{GroupChat}->{$tag}->{Topic}->{top} =
    $frame->
      Frame(-background=>$GUI{color}->{jarl}->{main}->{bg}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{main}->{fg}->{dark},
	    -borderwidth=>"2",
	    -relief=>"sunken",
	   );
  my $scrolledText =
    $GUI{GroupChat}->{$tag}->{Topic}->{top}->
      Scrolled("Text",
	       -scrollbars=>"oe",
	       -background=>$GUI{color}->{jarl}->{config}->{bg}->{normal},
	       -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark},
	       -font=>$GUI{fonts}->{normal},
	       -height=>2,
	       -width=>0,
	       -borderwidth=>0,
	       -highlightthickness=>0,
	       -selectborderwidth=>0,
	       -exportselection=>1,
	       -takefocus=>0,
	       -wrap=>"word",
	       -state=>"disabled",
	      )->pack(-side=>'left',
		      -fill=>'x',
		      -expand=>1);

  $scrolledText->Subwidget("yscrollbar")->
    configure(-width=>10,
	      -borderwidth=>1,
	      -highlightthickness=>0,
	      -relief=>"flat"
	     );

  $GUI{GroupChat}->{$tag}->{Topic}->{Text} =
    $scrolledText->Subwidget("text");
  $GUI{GroupChat}->{$tag}->{Topic}->{Text}->
    tagConfigure("topic",
		 -font=>$GUI{fonts}->{header});
  $GUI{GroupChat}->{$tag}->{Topic}->{Text}->
    tagConfigure("highlight",
		 -foreground=>"red");
  $GUI{GroupChat}->{$tag}->{Topic}->{Text}->
    tagConfigure("link",
		 -foreground=>"blue",
		 -font=>$GUI{fonts}->{link});

  $GUI{GroupChat}->{$tag}->{Topic}->{Text}->
    tagBind("link",
	    "<Enter>",
	    sub{
	      $GUI{GroupChat}->{$tag}->{Topic}->{Text}->
		configure(-cursor=>"hand2");
	    });
  $GUI{GroupChat}->{$tag}->{Topic}->{Text}->
    tagBind("link",
	    "<Leave>",
	    sub{
	      $GUI{GroupChat}->{$tag}->{Topic}->{Text}->
		configure(-cursor=>"xterm");
	    });

  $GUI{GroupChat}->{$tag}->{Topic}->{Text}->
    bind("<Button-4>",
	 sub{
	   $GUI{GroupChat}->{$tag}->{Topic}->{Text}->
	     yviewScroll(-1,"units");
	 });
  $GUI{GroupChat}->{$tag}->{Topic}->{Text}->
    bind("<Button-5>",
	 sub{
	   $GUI{GroupChat}->{$tag}->{Topic}->{Text}->
	     yviewScroll(1,"units");
	 });

  my $textFrame =
    $leftFrame->
      Frame(-background=>$GUI{color}->{bg}->{normal},
	    -foreground=>$GUI{color}->{fg}->{dark},
	    -relief=>"sunken",
	    -borderwidth=>2
	   )->pack(-side=>"top",
		   -fill=>"both",
		   -expand=>1,
		   -padx=>5,
		   -pady=>5);

  $scrolledText =
    $textFrame->
      Scrolled("Text",
	       -scrollbars=>"oe",
	       -background=>$GUI{color}->{bg}->{light},
	       -foreground=>$GUI{color}->{fg}->{dark},
	       -font=>$GUI{fonts}->{normal},
	       -height=>0,
	       -width=>0,
	       -cursor=>"xterm",
	       -borderwidth=>0,
	       -highlightthickness=>0,
	       -selectborderwidth=>0,
	       -exportselection=>1,
	       -takefocus=>0,
	       -wrap=>"word",
	       -state=>"disabled",
	      )->pack(-side=>"left",
		      -fill=>"both",
		      -expand=>1,
		      -padx=>0,
		      -pady=>0);

  my $textScrollbar = $scrolledText->Subwidget("yscrollbar");
  $textScrollbar->
    configure(-width=>10,
	      -borderwidth=>1,
	      -highlightthickness=>0,
	      -relief=>"flat",
	      -command=>sub{
		my ($high,$low) = $textScrollbar->get();
		$GUI{GroupChat}->{$tag}->{vars}->{ScrollLock} =
		  ($low == 1);
		$GUI{GroupChat}->{$tag}->{GroupChatText}->{Text}->
		  yview(@_);
	      });
  $GUI{GroupChat}->{$tag}->{GroupChatText}->{Text} =
    $scrolledText->Subwidget("text");

  $GUI{GroupChat}->{$tag}->{GroupChatText}->{Text}->
    bind("<Button-4>",
	 sub{
	   $GUI{GroupChat}->{$tag}->{GroupChatText}->{Text}->
	     yviewScroll(-1,"units");
	 });
  $GUI{GroupChat}->{$tag}->{GroupChatText}->{Text}->
    bind("<Button-5>",
	 sub{
	   $GUI{GroupChat}->{$tag}->{GroupChatText}->{Text}->
	     yviewScroll(1,"units");
	 });

  $GUI{GroupChat}->{$tag}->{GroupChatText}->{Text}->
    bind("<Configure>",
	 sub {
	   $GUI{GroupChat}->{$tag}->{GroupChatText}->{Text}->
	     see("end");
	 }
	);

  $GUI{GroupChat}->{$tag}->{GroupChatText}->{Text}->
    tagConfigure("server",
		 -foreground=>"green4");
  $GUI{GroupChat}->{$tag}->{GroupChatText}->{Text}->
    tagConfigure("me",
		 -foreground=>"red");
  $GUI{GroupChat}->{$tag}->{GroupChatText}->{Text}->
    tagConfigure("notme",
		 -foreground=>"blue");
  $GUI{GroupChat}->{$tag}->{GroupChatText}->{Text}->
    tagConfigure("highlight",
		 -foreground=>"red");
  $GUI{GroupChat}->{$tag}->{GroupChatText}->{Text}->
    tagConfigure("timestamp",
		 -foreground=>"gray30");
  $GUI{GroupChat}->{$tag}->{GroupChatText}->{Text}->
    tagConfigure("action",
		 -foreground=>"purple");
  $GUI{GroupChat}->{$tag}->{GroupChatText}->{Text}->
    tagConfigure("link",
		 -foreground=>"blue",
		 -font=>$GUI{fonts}->{link});

  $GUI{GroupChat}->{$tag}->{GroupChatText}->{Text}->
    tagBind("link",
	    "<Enter>",
	    sub{
	      $GUI{GroupChat}->{$tag}->{GroupChatText}->{Text}->
		configure(-cursor=>"hand2");
	    });
  $GUI{GroupChat}->{$tag}->{GroupChatText}->{Text}->
    tagBind("link",
	    "<Leave>",
	    sub{
	      $GUI{GroupChat}->{$tag}->{GroupChatText}->{Text}->
		configure(-cursor=>"xterm");
	    });

  my $userListFrame = 
    $GUI{GroupChat}->{$tag}->{Right}->{top}->
      Frame(-background=>$GUI{color}->{jarl}->{main}->{bg}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{main}->{fg}->{dark},
	    -relief=>"sunken",
	    -borderwidth=>2
	   )->pack(-side=>"bottom",
		   -fill=>"y",
		   -expand=>1,
		   -padx=>5,
		   -pady=>5);
  $groupchatRosters{$tag} =
    $userListFrame->
      Roster(-width=>125,
	     -background=>$GUI{color}->{bg}->{normal},
	     -groupbackground=>"gray70",
	     -groupforeground=>"black",
	     -jidbackground=>"gray80",
	     -jidforeground=>"black",
	       -selectbackground=>"light blue",
	     -resourcebackground=>"grey90",
	       -resourceforeground=>"black",
	     -balloon=>$GUI{ToolBar}->{Balloon},
	     -font=>$GUI{fonts}->{normal},
	     -updatemode=>"presence",
	     -jidleftcommand=>sub{
	       my ($jid,$resource) = @_;
	       my $toJID = new Net::Jabber::JID();
	       $toJID->SetJID($jid);
	       &jarlChat_AddMessage($toJID,"");
	     },
	    )->pack(-side=>"left",
		    -fill=>"y",
		    -expand=>1,
		    -padx=>0,
		    -pady=>0);

  my $sayFrame =
    $bottomFrame->
      Frame(-background=>$GUI{color}->{jarl}->{newmessage}->{bg}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{newmessage}->{fg}->{dark},
	   )->pack(-side=>"top",
		   -fill=>"x",
		   -padx=>5);
  $sayFrame->
    Label(-text=>"Say:",
	  -anchor=>"e",
	  -font=>$GUI{fonts}->{normal},
	  -foreground=>$GUI{color}->{jarl}->{newmessage}->{fg}->{dark},
	  -background=>$GUI{color}->{jarl}->{newmessage}->{bg}->{normal}
	 )->pack(-side=>"left",
		 -fill=>"y",
		 -anchor=>"e");
  $GUI{GroupChat}->{$tag}->{Say}->{Entry} =
    $sayFrame->
      Entry(-textvariable=>\$GUI{GroupChat}->{$tag}->{vars}->{body},
	    -background=>$GUI{color}->{jarl}->{newmessage}->{bg}->{light},
	    -foreground=>$GUI{color}->{jarl}->{newmessage}->{fg}->{dark},
	    -font=>$GUI{fonts}->{normal},
	   )->pack(-side=>'left',
		   -fill=>"x",
		   -expand=>1,
		   -anchor=>'w');

  $GUI{GroupChat}->{$tag}->{Say}->{Entry}->
    bind("<Key>", sub{ &jarlGroupChat_TabRotate($tag,0); });

  $GUI{GroupChat}->{$tag}->{Say}->{Entry}->
    bind("<Key-Up>", sub{
	   &jarlGroupChat_TabRotate($tag,0);
	   &jarlGroupChatIF_CurrentSay($tag,&jarlGroupChat_HistoryUp($tag));
	 });

  $GUI{GroupChat}->{$tag}->{Say}->{Entry}->
    bind("<Key-Down>", sub{
	   &jarlGroupChat_TabRotate($tag,0);
	   &jarlGroupChatIF_CurrentSay($tag,&jarlGroupChat_HistoryDown($tag));
	 });

  $GUI{GroupChat}->{$tag}->{Say}->{Entry}->
    bind("<Return>",sub{
	   &jarlGroupChat_TabRotate($tag,0);
	   &jarlGroupChat_SendSay($tag);
	 }
	);

  $GUI{GroupChat}->{$tag}->{Say}->{Entry}->
    bind("<Map>",sub{
	   $GUI{GroupChat}->{$tag}->{Say}->{Entry}->focus();
	   $GUI{GroupChat}->{$tag}->{GroupChatText}->{Text}->
	     see("end");
	 });

  $GUI{GroupChat}->{$tag}->{Say}->{Entry}->
    bind("<Tab>",sub{
	   $GUI{GroupChat}->{$tag}->{vars}->{tab} = 1;
	   &jarlGroupChat_CompleteNick($tag);
	 }
	);
  $GUI{GroupChat}->{$tag}->{Say}->{Entry}->
    bind("<FocusOut>",sub{
	   $GUI{GroupChat}->{$tag}->{vars}->{tab} = 0
	     unless exists($GUI{GroupChat}->{$tag}->{vars}->{tab});
	   if ($GUI{GroupChat}->{$tag}->{vars}->{tab} == 1) {
	     $GUI{GroupChat}->{$tag}->{vars}->{tab} = 0;
	     $GUI{GroupChat}->{$tag}->{Say}->{Entry}->focus();
	   }
	 }
	);

  my $leaveButton =
    $sayFrame->
      Button(-image=>$GUI{Icons}->{Leave},
	     -background=>$GUI{color}->{jarl}->{newmessage}->{bg}->{normal},
	     -foreground=>$GUI{color}->{jarl}->{newmessage}->{fg}->{dark},
	     -disabledforeground=>$GUI{color}->{jarl}->{newmessage}->{fg}->{light},
	     -font=>$GUI{fonts}->{normal},
	     -command=>sub{
	       &jarlGroupChat_Leave($tag);
	       $TabBar->DeleteTab($tag);
	       delete($GUI{GroupChat}->{$tag});
	     }
	    )->pack(-side=>"right");
  &jarlMainIF_RegisterIcon($leaveButton,"Leave");
  $GUI{ToolBar}->{Balloon}->attach($leaveButton,
				   -balloonmsg=>"Leave the Room ");

  $GUI{GroupChat}->{$tag}->{Say}->{ListState} =
    $sayFrame->
      Button(-image=>$GUI{Icons}->{UserListShow},
	     -background=>$GUI{color}->{jarl}->{newmessage}->{bg}->{normal},
	     -foreground=>$GUI{color}->{jarl}->{newmessage}->{fg}->{dark},
	     -disabledforeground=>$GUI{color}->{jarl}->{newmessage}->{fg}->{light},
	     -font=>$GUI{fonts}->{normal},
	     -command=>sub{
	       if ($GUI{GroupChat}->{$tag}->{Right}->{top}->ismapped()) {
		 $GUI{GroupChat}->{$tag}->{Right}->{top}->
		   packForget();	
		 &jarlMainIF_ChangeIcon($GUI{GroupChat}->{$tag}->{Say}->{ListState},
					"UserListHide",
					"UserListShow");
	       } else {
		 $GUI{GroupChat}->{$tag}->{Right}->{top}->
		   pack(-side=>"right",
			-fill=>"y");
		 &jarlMainIF_ChangeIcon($GUI{GroupChat}->{$tag}->{Say}->{ListState},
					"UserListShow",
					"UserListHide");
	       }
	     }
	    )->pack(-side=>"right");
  &jarlMainIF_RegisterIcon($GUI{GroupChat}->{$tag}->{Say}->{ListState},
			   "UserListShow");
  $GUI{ToolBar}->{Balloon}->
    attach($GUI{GroupChat}->{$tag}->{Say}->{ListState},
	   -balloonmsg=>"Show/Hide the User List ");

  my $clearButton =
    $sayFrame->
      Button(-image=>$GUI{Icons}->{Clear},
	     -background=>$GUI{color}->{jarl}->{newmessage}->{bg}->{normal},
	     -foreground=>$GUI{color}->{jarl}->{newmessage}->{fg}->{dark},
	     -disabledforeground=>$GUI{color}->{jarl}->{newmessage}->{fg}->{light},
	     -font=>$GUI{fonts}->{normal},
	     -command=>sub{
	       $GUI{GroupChat}->{$tag}->{GroupChatText}->{Text}->
		 configure(state=>"normal");
	       $GUI{GroupChat}->{$tag}->{GroupChatText}->{Text}->
		 delete("1.0","end");
	       $GUI{GroupChat}->{$tag}->{GroupChatText}->{Text}->
		 configure(state=>"disabled");
	       $GUI{GroupChat}->{$tag}->{vars}->{neednewline} = 0;
	     }
	    )->pack(-side=>"right");
  &jarlMainIF_RegisterIcon($clearButton,"Clear");
  $GUI{ToolBar}->{Balloon}->attach($clearButton,
				   -balloonmsg=>"Clear the Channel ");

#  $topicButton =
#    $sayFrame->
#      Button(-image=>$GUI{Icons}->{TopicChange},
#	     -background=>$GUI{color}->{jarl}->{newmessage}->{bg}->{normal},
#	     -foreground=>$GUI{color}->{jarl}->{newmessage}->{fg}->{dark},
#	     -disabledforeground=>$GUI{color}->{jarl}->{newmessage}->{fg}->{light},
#	     -font=>$GUI{fonts}->{normal},
#	     -command=>sub{
#	     }
#	    )->pack(-side=>"right");
#  &jarlMainIF_RegisterIcon($topicButton,"TopicChange");
#  $GUI{ToolBar}->{Balloon}->attach($topicButton,
#	                            -balloonmsg=>"Edit Topic ");
}


##############################################################################
#
# jarlGroupChatIF_CurrentSay - if $value is defined then the Entry contents 
#                              are set to $value, otherwise the contents of 
#                              the Entry are returned.
#
##############################################################################
sub jarlGroupChatIF_CurrentSay {
  my ($tag,$value) =  @_;
  $Debug->Log3("jarlGroupChatIF_CurrentSay: tag($tag) value($value)");
  if (defined($value)) {
    $Debug->Log3("jarlGroupChatIF_CurrentSay: set the entry to value($value)");
    $GUI{GroupChat}->{$tag}->{Say}->{Entry}->delete(0,"end");
    $GUI{GroupChat}->{$tag}->{Say}->{Entry}->insert(0,$value);
    $GUI{GroupChat}->{$tag}->{Say}->{Entry}->icursor("end");
    $GUI{GroupChat}->{$tag}->{Say}->{Entry}->xview(0);
    return;
  }
  $Debug->Log3("jarlGroupChatIF_CurrentSay: return(".$GUI{GroupChat}->{$tag}->{Say}->{Entry}->get().")");
  return $GUI{GroupChat}->{$tag}->{Say}->{Entry}->get();
}


1;
