##############################################################################
#
# Jarl - Presence CLI Interface Code
#
#   Perl code to handle presence requests and other presence GUI functions.
#
##############################################################################

##############################################################################
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
#
#  Jabber
#  Copyright (C) 1998-1999 The Jabber Team http://jabber.org/
#
##############################################################################

##############################################################################
#
# jarlPresenceIF_SubscriptionAsk - prompts the user for what they want to do
#                                  with the incoming subscription
#
##############################################################################
sub jarlPresenceIF_SubscriptionAsk {
  my ($subscription) = @_;
  my $jid = $subscription->GetFrom("jid")->GetJID();

  $TabBar->Print("__jarl__:tabbar:transient","The user $jid has requested a subscription to you.\n");

  my $subscriptionAnswer = 0;
  $subscriptionAnswer =
    &jarlMainIF_Prompt(prompt=>"Do you want to allow them to see your presence?",
		       transient=>1,
		       options=>["y","n"],
		       default=>"y")
      if (($config{subscriptions} eq "prompt") ||
	  ($config{subscriptions} eq "roster"));

  my $subscribeAnswer = 0;
  $subscribeAnswer =
    &jarlMainIF_Prompt(prompt=>"Do you want to subscribe to them?",
		       transient=>1,
		       options=>["y","n"],
		       default=>"y")
      if ($config{subscribe} == 0);

  if (($config{subscriptions} eq "prompt") ||
      ($config{subscriptions} eq "roster")) {
    my $reply =
      $subscription->
	Reply(template=>"client",
	      type=>(($subscriptionAnswer eq "y") ?
		     "subscribed" :
		     "unsubscribed"),
	      (($subscriptionAnswer eq "n") ?
	       (status=>$config{subscriptiondenymessage}) :
	       ()
	      )
	     );
    $jabber{client}->Send($reply);
  }
  if ($config{subscribe} == 0) {
    if ($subscribeAnswer eq "y") {
      my $reply =
	$subscription->
	  Reply(template=>"client",
		type=>"subscribe");
      $jabber{client}->Send($reply);
    }
  } else {
    if ($subscriptionAnswer eq "y") {
      my $reply =
	$subscription->
	  Reply(template=>"client",
		type=>"subscribe");
      $jabber{client}->Send($reply);
    }
  }

}


##############################################################################
#
# jarlPresenceIF_CustomGUI - open the custom presence GUI
#
##############################################################################
sub jarlPresenceIF_CustomGUI {

  $TabBar->Print("__jarl__:tabbar:transient","Choose a show:\n");
  $TabBar->Print("__jarl__:tabbar:transient","  a) Away\n");
  $TabBar->Print("__jarl__:tabbar:transient","  c) Chat\n");
  $TabBar->Print("__jarl__:tabbar:transient","  d) Do Not Disturb\n");
  $TabBar->Print("__jarl__:tabbar:transient","  x) Extended Away\n");
  $TabBar->Print("__jarl__:tabbar:transient","  n) None\n");

  my %shows = (c=>"chat",
	       d=>"dnd",
	       a=>"away",
	       x=>"xa",
	       n=>"");

  my $type = "available";
  my $show = &jarlMainIF_Prompt(prompt=>"Show",
				transient=>1,
				options=>["a","c","d","x","n"],
				default=>"n");
  $show = $shows{$show};

  my $status = &jarlMainIF_Prompt(prompt=>"Status",
				  transient=>1);
  my $priority = &jarlMainIF_Prompt(prompt=>"Priority",
				    transient=>1,
				    default=>$jabber{presence}->Priority);
  $jabber{presence}->
    Set(type=>$type,
	show=>$show,
	status=>$status,
	priority=>$priority);
}


1;
