##############################################################################
#
# Jarl - SXPM Tk Interface Code
#
#   Perl code to handle showing the Jarl SXPM GUI and interfacing with it.
#
##############################################################################

##############################################################################
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
#
#  Jabber
#  Copyright (C) 1998-1999 The Jabber Team http://jabber.org/
#
##############################################################################


##############################################################################
#
# jarlSXPMIF_AddMessage - takes a <message/> and adds it to the proper
#                           channel based on the from JID.
#
##############################################################################
sub jarlSXPMIF_AddXPM {
  my ($tag,$xpm) = @_;
  
  $Debug->Log1("jarlSXPMIF_AddMessage: tag($tag) x($x) y($y) xpm($xpm)");

#
# erasing....
#

  my $priority = "low";
  
  $GUI{Jabber}->{SXPM}->{$tag}->{Board}->{Canvas}->delete("xpm");

  $GUI{Jabber}->{SXPM}->{$tag}->{Board}->{Canvas}->
    createImage(0,0,
		image=>$GUI{Jabber}->{SXPM}->{$tag}->{Board}->{Canvas}->Pixmap(-data=>$xpm),
		anchor=>"nw",
	        tag=>[ "xpm" ]);

  $TabBar->HighlightTab($tag,$priority);
}


##############################################################################
#
# jarlSXPMIF_SXPMExists - returns 1 if the GUI for the groupchat 
#                                   exists, 0 if not.
#
##############################################################################
sub jarlSXPMIF_SXPMExists {
  my ($tag) = @_;
  return exists($GUI{Jabber}->{SXPM}->{$tag});
}

##############################################################################
#
# jarlSXPMIF_NewSXPM - function to do all GUI calls needed to create
#                      a new groupchat.
#
##############################################################################
sub jarlSXPMIF_NewSXPM {
  my ($tag) = @_;
  
  $Debug->Log3("jarlSXPMIF_NewSXPM: tag($tag)");

  $GUI{Jabber}->{SXPM}->{$tag}->{top} = 
    $TabBar->AddTab(-type=>"docked",
				 -tag=>$tag,
				 -text=>"SXPM - ".&jarlSXPM_BoardName($tag));
  &jarlSXPMIF_NewGUI($tag);
  &jarlSXPMIF_RaiseSXPM($tag);
}


##############################################################################
#
# jarlSXPMIF_RaiseSXPM - function to bring the specified groupchat 
#                                  to the top of the window list.
#
##############################################################################
sub jarlSXPMIF_RaiseSXPM {
  my ($tag) = @_;
  $TabBar->RaiseTab($tag);
}


##############################################################################
#
# jarlSXPMIF_NewGUI - populates the new tab with a groupchat GUI.
#
##############################################################################
sub jarlSXPMIF_NewGUI {
  my ($tag) = @_;

  $Debug->Log3("jarlSXPMIF_NewGUI: tag($tag)");

  #---------------------------------------------------------------------------
  # Groupchat Window
  #---------------------------------------------------------------------------
  $GUI{Jabber}->{SXPM}->{$tag}->{Top}->{top}=
    $GUI{Jabber}->{SXPM}->{$tag}->{top}->
      Frame(-background=>$GUI{color}->{jarl}->{main}->{bg}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{main}->{fg}->{dark},
	   )->pack(-side=>"top",
		   -fill=>"x");
  $GUI{Jabber}->{SXPM}->{$tag}->{Bottom}->{top}=
    $GUI{Jabber}->{SXPM}->{$tag}->{top}->
      Frame(-background=>$GUI{color}->{jarl}->{main}->{bg}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{main}->{fg}->{dark},
	   )->pack(-side=>"bottom",
		   -fill=>"x");
  $GUI{Jabber}->{SXPM}->{$tag}->{Left}->{top}=
    $GUI{Jabber}->{SXPM}->{$tag}->{top}->
      Frame(-background=>$GUI{color}->{jarl}->{main}->{bg}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{main}->{fg}->{dark},
	   )->pack(-side=>"left",
		   -fill=>"both",
		   -expand=>1);
  $GUI{Jabber}->{SXPM}->{$tag}->{Right}->{top}=
    $GUI{Jabber}->{SXPM}->{$tag}->{top}->
      Frame(-background=>$GUI{color}->{jarl}->{main}->{bg}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{main}->{fg}->{dark},
	   )->pack(-side=>"right",
		   -fill=>"y");

  $GUI{Jabber}->{SXPM}->{$tag}->{Board}->{top}=
    $GUI{Jabber}->{SXPM}->{$tag}->{Left}->{top}->
      Frame(-background=>$GUI{color}->{jarl}->{main}->{bg}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{main}->{fg}->{dark},
	    -relief=>"sunken",
	    -borderwidth=>2
	   )->pack(-side=>"top",
		   -fill=>"both",
		   -expand=>1,
		   -padx=>5,
		   -pady=>5);

  $GUI{Jabber}->{SXPM}->{$tag}->{Board}->{Scrolled} =
    $GUI{Jabber}->{SXPM}->{$tag}->{Board}->{top}->
      Scrolled("Canvas",
	       -scrollbars=>"osoe",
	       -background=>$GUI{color}->{jarl}->{main}->{bg}->{normal},
	       -scrollregion=>[ 0,0,&jarlSXPM_BoardWidth($tag),&jarlSXPM_BoardHeight($tag)],
	       -cursor=>"crosshair"
	      )->pack(-side=>"left",
		      -fill=>"both",
		      -expand=>1,
		      -padx=>0,
		      -pady=>0);

  $GUI{Jabber}->{SXPM}->{$tag}->{Board}->{YScrollbar} = 
    $GUI{Jabber}->{SXPM}->{$tag}->{Board}->{Scrolled}->
      Subwidget("yscrollbar");
  $GUI{Jabber}->{SXPM}->{$tag}->{Board}->{YScrollbar}->
    configure(-width=>10,
	      -borderwidth=>1,
	      -highlightthickness=>0,
	      -relief=>"flat",
	     );
  $GUI{Jabber}->{SXPM}->{$tag}->{Board}->{XScrollbar} = 
    $GUI{Jabber}->{SXPM}->{$tag}->{Board}->{Scrolled}->
      Subwidget("xscrollbar");
  $GUI{Jabber}->{SXPM}->{$tag}->{Board}->{XScrollbar}->
    configure(-width=>10,
	      -borderwidth=>1,
	      -highlightthickness=>0,
	      -relief=>"flat",
	     );
  $GUI{Jabber}->{SXPM}->{$tag}->{Board}->{Canvas} = 
    $GUI{Jabber}->{SXPM}->{$tag}->{Board}->{Scrolled}->
      Subwidget("canvas");

  $GUI{Jabber}->{SXPM}->{$tag}->{Board}->{Canvas}->
    createRectangle(0,0,&jarlSXPM_BoardWidth($tag),&jarlSXPM_BoardHeight($tag),
		    -outline=>undef,
		    -fill=>$GUI{color}->{jarl}->{main}->{bg}->{light},
		    -tag=>[ "board" ]);
  

  $GUI{Jabber}->{SXPM}->{$tag}->{Board}->{Canvas}->
    Tk::bind("<Button-4>",
	     sub{
	       $GUI{Jabber}->{SXPM}->{$tag}->{Board}->{Canvas}->
		 yviewScroll(-1,"units");
	     });
  $GUI{Jabber}->{SXPM}->{$tag}->{Board}->{Canvas}->
    Tk::bind("<Button-5>",
	     sub{
	       $GUI{Jabber}->{SXPM}->{$tag}->{Board}->{Canvas}->
		 yviewScroll(1,"units");
	     });

  $GUI{Jabber}->{SXPM}->{$tag}->{ControlPanel}->{top}=
    $GUI{Jabber}->{SXPM}->{$tag}->{Right}->{top}->
      Frame(-background=>$GUI{color}->{jarl}->{main}->{bg}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{main}->{fg}->{dark},
	   )->pack(-side=>"bottom",
		   -fill=>"y",
		   -expand=>1,
		   -padx=>5,
		   -pady=>5);
  
  $GUI{Jabber}->{SXPM}->{$tag}->{vars}->{drawitem} = "rect";

  $GUI{Jabber}->{SXPM}->{$tag}->{ControlPanel}->{top}->
    Radiobutton(-variable=>\$GUI{Jabber}->{SXPM}->{$tag}->{vars}->{drawitem},
                -text=>"Rectangle",
                -value=>"rect",
                -command=>sub {
		  &jarlSXPMIF_BindStart($tag);
		}
	       )->pack(-side=>"top",
		       -anchor => 'w');

  $GUI{Jabber}->{SXPM}->{$tag}->{ControlPanel}->{top}->
    Radiobutton(-variable=>\$GUI{Jabber}->{SXPM}->{$tag}->{vars}->{drawitem},
                -text=>"Oval",
                -value=>"oval",
                -command=>sub {
		  &jarlSXPMIF_BindStart($tag);
		}
	       )->pack(-side=>"top",
		       -anchor => 'w');

  $GUI{Jabber}->{SXPM}->{$tag}->{ControlPanel}->{top}->
    Radiobutton(-variable=>\$GUI{Jabber}->{SXPM}->{$tag}->{vars}->{drawitem},
                -text=>"Line",
                -value=>"line",
                -command=>sub {
		  &jarlSXPMIF_BindStart($tag);
		}
	       )->pack(-side=>"top",
		       -anchor => 'w');

  $GUI{Jabber}->{SXPM}->{$tag}->{ControlPanel}->{top}->
    Label(-text => "Line Width:"
	 )->pack(-side=>"top",
		 -anchor => 'w');

  $GUI{Jabber}->{SXPM}->{$tag}->{vars}->{thickness} = 1;

  $GUI{Jabber}->{SXPM}->{$tag}->{ControlPanel}->{top}->
    Entry(-textvariable=>\$GUI{Jabber}->{SXPM}->{$tag}->{vars}->{thickness}
	 )->pack(-side=>"top",
		 -anchor=>'w');

  &jarlSXPMIF_BindStart($tag);

  $GUI{Jabber}->{SXPM}->{$tag}->{Say}->{Leave} =
    $GUI{Jabber}->{SXPM}->{$tag}->{Bottom}->{top}->
      Button(-image=>$GUI{Icons}->{Leave},
	     -background=>$GUI{color}->{jarl}->{newmessage}->{bg}->{normal},
	     -foreground=>$GUI{color}->{jarl}->{newmessage}->{fg}->{dark},
	     -disabledforeground=>$GUI{color}->{jarl}->{newmessage}->{fg}->{light},
	     -font=>$GUI{fonts}->{normal},
	     -command=>sub{
	       &jarlSXPM_Leave($tag);
#	       &jarlGroupChat_Leave($tag);
	       $TabBar->DeleteTab($tag);
	       delete($GUI{Jabber}->{SXPM}->{$tag});
	     }
	    )->pack(-side=>"right");
  &jarlMainIF_RegisterIcon($GUI{Jabber}->{SXPM}->{$tag}->{Say}->{Leave},
			 "Leave");
  $GUI{ToolBar}->{Balloon}->
    attach($GUI{Jabber}->{SXPM}->{$tag}->{Say}->{Leave},
	   -balloonmsg=>"Leave the Room ");
}


sub jarlSXPMIF_BindStart {
  my $tag = shift;
  # If there is a "Motion" binding, we need to allow the user
  # to finish drawing the item before rebinding Button-1
  # this fcn gets called when the finish drawing the item again

  $GUI{Jabber}->{SXPM}->{$tag}->{vars}->{bindings} = 
    $GUI{Jabber}->{SXPM}->{$tag}->{Board}->{Canvas}->Tk::bind("<Motion>");

  return if ($#{$GUI{Jabber}->{SXPM}->{$tag}->{vars}->{bindings}} >= 0);

  if ($GUI{Jabber}->{SXPM}->{$tag}->{vars}->{drawitem} eq "rect") {
    $GUI{Jabber}->{SXPM}->{$tag}->{Board}->{Canvas}->
      Tk::bind("<Button-1>", [\&jarlSXPMIF_StartDrawing, $tag, Ev('x'), Ev('y')]);
  } elsif ($GUI{Jabber}->{SXPM}->{$tag}->{vars}->{drawitem} eq "oval") {
    $GUI{Jabber}->{SXPM}->{$tag}->{Board}->{Canvas}->
      Tk::bind("<Button-1>", [\&jarlSXPMIF_StartDrawing, $tag, Ev('x'), Ev('y')]);
  } elsif ($GUI{Jabber}->{SXPM}->{$tag}->{vars}->{drawitem} eq "line") {
    $GUI{Jabber}->{SXPM}->{$tag}->{Board}->{Canvas}->
      Tk::bind("<Button-1>", [\&jarlSXPMIF_StartDrawing, $tag, Ev('x'), Ev('y')]);
  }
}



sub jarlSXPMIF_StartDrawing {
  my ($canvas, $tag, $x, $y) = @_;
  $x = $canvas->canvasx($x);
  $y = $canvas->canvasy($y);

  # Do a little error checking

  return if ($x >= &jarlSXPM_BoardWidth($tag));
  return if ($y >= &jarlSXPM_BoardHeight($tag));

  return if ($GUI{Jabber}->{SXPM}->{$tag}->{vars}->{drawing} ne "");
  
  $GUI{Jabber}->{SXPM}->{$tag}->{vars}->{thickness} = 1 
    if (($GUI{Jabber}->{SXPM}->{$tag}->{vars}->{thickness} !~ /[0-9]+/) ||
	($GUI{Jabber}->{SXPM}->{$tag}->{vars}->{thickness} < 1));

  $GUI{Jabber}->{SXPM}->{$tag}->{vars}->{drawing} =
    $GUI{Jabber}->{SXPM}->{$tag}->{vars}->{drawitem};
  $GUI{Jabber}->{SXPM}->{$tag}->{vars}->{drawingthickness} =
    $GUI{Jabber}->{SXPM}->{$tag}->{vars}->{thickness};

  if ($GUI{Jabber}->{SXPM}->{$tag}->{vars}->{drawitem} eq "rect") {
    $canvas->createRectangle($x, $y, $x, $y, 
			     -width => $GUI{Jabber}->{SXPM}->{$tag}->{vars}->{thickness}, 
			     -tags => "drawmenow");
  } elsif ($GUI{Jabber}->{SXPM}->{$tag}->{vars}->{drawitem} eq "oval") {
    $canvas->createOval($x, $y, $x, $y,
			-width => $GUI{Jabber}->{SXPM}->{$tag}->{vars}->{thickness}, 
			-tags => "drawmenow");
  } elsif ($GUI{Jabber}->{SXPM}->{$tag}->{vars}->{drawitem} eq "line") {
    $canvas->createLine($x, $y, $x, $y, 
			-width => $GUI{Jabber}->{SXPM}->{$tag}->{vars}->{thickness}, 
			-tags => "drawmenow");
  }

  $GUI{Jabber}->{SXPM}->{$tag}->{vars}->{startx} = $x;
  $GUI{Jabber}->{SXPM}->{$tag}->{vars}->{starty} = $y;

  # Map the Button-1 binding to &jarlSXPMIF_EndDrawing instead of start drawing

  $canvas->Tk::bind("<Motion>", [\&jarlSXPMIF_SizeItem, $tag, Ev('x'), Ev('y')]);

  $canvas->Tk::bind("<ButtonRelease-1>", [\&jarlSXPMIF_EndDrawing, $tag, Ev('x'), Ev('y')]);

}



sub jarlSXPMIF_SizeItem {
  my ($canvas, $tag, $x, $y) = @_;
  $x = $canvas->canvasx($x);
  $y = $canvas->canvasy($y);

  return if ($x >= &jarlSXPM_BoardWidth($tag));
  return if ($y >= &jarlSXPM_BoardHeight($tag));

  $canvas->coords("drawmenow", 
		  $GUI{Jabber}->{SXPM}->{$tag}->{vars}->{startx},
		  $GUI{Jabber}->{SXPM}->{$tag}->{vars}->{starty}, 
		  $x, 
		  $y);
}



sub jarlSXPMIF_EndDrawing {
  my ($canvas, $tag, $x, $y) = @_;
  $x = $canvas->canvasx($x);
  $y = $canvas->canvasy($y);

  return if ($x >= &jarlSXPM_BoardWidth($tag));
  return if ($y >= &jarlSXPM_BoardHeight($tag));

  # finalize the size of the item, and remove the tag from the item

  $canvas->coords("drawmenow", 
		  $GUI{Jabber}->{SXPM}->{$tag}->{vars}->{startx},
		  $GUI{Jabber}->{SXPM}->{$tag}->{vars}->{starty}, 
		  $x, 
		  $y);

  # remove motion binding.

  $canvas->Tk::bind("<Motion>", "");

  &jarlSXPMIF_BindStart($tag);

  my $drawing = $GUI{Jabber}->{SXPM}->{$tag}->{vars}->{drawing};
  $GUI{Jabber}->{SXPM}->{$tag}->{vars}->{drawing} = "";

  $canvas->delete("drawmenow");

  if (($x != $GUI{Jabber}->{SXPM}->{$tag}->{vars}->{startx}) ||
      ($y != $GUI{Jabber}->{SXPM}->{$tag}->{vars}->{starty})) {
  
    my ($offsetX,$offsetY,$dataWidth,$data);

    ($offsetX,$offsetY,$dataWidth,$data) =
      &jarlSXPM_Rect($GUI{Jabber}->{SXPM}->{$tag}->{vars}->{startx},
		     $GUI{Jabber}->{SXPM}->{$tag}->{vars}->{starty},
		     $x,
		     $y,
		     $GUI{Jabber}->{SXPM}->{$tag}->{vars}->{drawingthickness},
		     " ",
		     "a",
		     " ")
	if ($drawing eq "rect");

    ($offsetX,$offsetY,$dataWidth,$data) =
      &jarlSXPM_Oval($GUI{Jabber}->{SXPM}->{$tag}->{vars}->{startx},
		     $GUI{Jabber}->{SXPM}->{$tag}->{vars}->{starty},
		     $x,
		     $y,
		     $GUI{Jabber}->{SXPM}->{$tag}->{vars}->{drawingthickness},
		     " ",
		     "a",
		     " ")
	if ($drawing eq "oval");

    ($offsetX,$offsetY,$dataWidth,$data) =
      &jarlSXPM_Line($GUI{Jabber}->{SXPM}->{$tag}->{vars}->{startx},
		     $GUI{Jabber}->{SXPM}->{$tag}->{vars}->{starty},
		     $x,
		     $y,
		     $GUI{Jabber}->{SXPM}->{$tag}->{vars}->{drawingthickness},
		     " ",
		     "a",
		     " ")
	if ($drawing eq "line");

    my $message = $jabber{client}->SXPMSend(to=>&jarlSXPM_JID($tag),
					    type=>&jarlSXPM_Type($tag),
					    data=>$data,
					    datawidth=>$dataWidth,
					    datax=>$offsetX,
					    datay=>$offsetY);
    
    &jarlSXPM_AddMessage(&jarlSXPM_JID($tag),$message);
  }
}




sub jarlSXPMIF_ResizeBoard {
  my $tag = shift;
  
  $GUI{Jabber}->{SXPM}->{$tag}->{Board}->{Canvas}->
    delete("board");
  $GUI{Jabber}->{SXPM}->{$tag}->{Board}->{Canvas}->
    createRectangle(0,0,&jarlSXPM_BoardWidth($tag),&jarlSXPM_BoardHeight($tag),
		    -outline=>undef,
		    -fill=>$GUI{color}->{jarl}->{main}->{bg}->{light},
		    -tag=>[ "board" ]);

  $GUI{Jabber}->{SXPM}->{$tag}->{Board}->{Canvas}->
    configure(-scrollregion=>[ 0,0,&jarlSXPM_BoardWidth($tag),&jarlSXPM_BoardHeight($tag)],
	     );
}



##############################################################################
#
# jarlSXPMIF_CurrentSay - if $value is defined then the Entry contents 
#                              are set to $value, otherwise the contents of 
#                              the Entry are returned.
#
##############################################################################
sub jarlSXPMIF_CurrentSay {
  my ($tag,$value) =  @_;
  $Debug->Log3("jarlSXPMIF_CurrentSay: tag($tag) value($value)");
  if (defined($value)) {
    $Debug->Log3("jarlSXPMIF_CurrentSay: set the entry to value($value)");
    $GUI{Jabber}->{SXPM}->{$tag}->{Say}->{Entry}->delete(0,"end");
    $GUI{Jabber}->{SXPM}->{$tag}->{Say}->{Entry}->insert(0,$value);
    $GUI{Jabber}->{SXPM}->{$tag}->{Say}->{Entry}->icursor("end");
    $GUI{Jabber}->{SXPM}->{$tag}->{Say}->{Entry}->xview(0);
    return;
  }
  $Debug->Log3("jarlSXPMIF_CurrentSay: return(".$GUI{Jabber}->{SXPM}->{$tag}->{Say}->{Entry}->get().")");
  return $GUI{Jabber}->{SXPM}->{$tag}->{Say}->{Entry}->get();
}


1;
