// -*- c++ -*-
//
// $Id: op.h,v 1.3 2001/12/15 02:42:42 jsquyres Exp $
//
// $COPYRIGHT$
//

class Op {
public:

  // construction
  Op();
  Op(const MPI_Op &i);
  Op(const Op& op);
#if _MPIPP_PROFILING_
  Op(const PMPI::Op& op) : pmpi_op(op) { }
#endif
  // destruction
  virtual ~Op();
  // assignment
  Op& operator=(const Op& op);
  Op& operator= (const MPI_Op &i);
  // comparison
  inline MPI2CPP_BOOL_T operator== (const Op &a);
  inline MPI2CPP_BOOL_T operator!= (const Op &a);
  // conversion functions for inter-language operability
  inline operator MPI_Op () const;
  //  inline operator MPI_Op* (); //JGS const
#if _MPIPP_PROFILING_
  inline operator const PMPI::Op&() const { return pmpi_op; }
#endif
  // Collective Communication
  //JGS took const out
  virtual void Init(User_function *func, MPI2CPP_BOOL_T commute);
  virtual void Free();
 
#if ! _MPIPP_PROFILING_
  User_function *op_user_function; //JGS move to private
protected:
  MPI_Op mpi_op;
#endif

#if _MPIPP_PROFILING_
private:
  PMPI::Op pmpi_op;
#endif

};

