// -*- c++ -*-
//
// $Id: errhandler_inln.h,v 1.3 2001/12/15 02:42:42 jsquyres Exp $
//
// $COPYRIGHT$
//

#if _MPIPP_PROFILING_

inline PMPI::Errhandler::Errhandler(const PMPI::Errhandler& e)
  : mpi_errhandler(e.mpi_errhandler), handler_fn(e.handler_fn) { }

inline PMPI::Errhandler&
PMPI::Errhandler::operator=(const PMPI::Errhandler& e)
{
  handler_fn = e.handler_fn;
  mpi_errhandler = e.mpi_errhandler;
  return *this;
}

inline MPI2CPP_BOOL_T
PMPI::Errhandler::operator==(const PMPI::Errhandler &a)
{
  return (MPI2CPP_BOOL_T)(mpi_errhandler == a.mpi_errhandler);
}

#endif

inline void
_REAL_MPI_::Errhandler::Free()
{
  (void)MPI_Errhandler_free(&mpi_errhandler);
}




