#ifndef LIBCAPSI_NETWORK_LISTENER_H
#define LIBCAPSI_NETWORK_LISTENER_H

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <sys/time.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <unistd.h>
#include <netinet/in.h>
#include <netdb.h>
#include <fcntl.h>

#include "socket.h"

#define	LISTENQ	1024

class ListenPort
{
	public:
		ListenPort(int);
		virtual ~ListenPort();
		int tcp_bind();
		int tcp_listen();
		int unblock();

		int port;
		int fd;
		ListenPort *next;
};

class Listener
{
	public:
		Listener(int);
		virtual ~Listener();
		void do_select();

		void set_socket(int); // public for softbooting
		int my_fd; // public for softbooting
		
	private:
		void set_timeval();

		int make_selectlist(Socket *);
		void tcp_read();
		void new_socket(int); // maybe remove int and move to LP?

		struct timeval my_tv;
		int my_listenfd, my_highest, my_retval;
		Socket *my_newsock;
//		fd_set my_rfds;

		int my_port;

};

extern void socket_handler(Socket *, char *);
extern fd_set listener_rfds;

// extern Listener *lis;

#endif // LIBCAPSI_NETWORK_LISTENER_H
