#ifndef LIBCAPSI_NETWORK_SOCKET_H
#define LIBCAPSI_NETWORK_SOCKET_H

/* Most of this code was originally written by Erik van Zijst
 * <icehawk@prutser.cx> and taken from the KMonop development team with
 * permission. Rob Kaper <cap@capsi.com> then ported it from C to C++ and
 * turned it into a library for the RealFC project.
 */
     
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/time.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <unistd.h>  
#include <netinet/in.h>
#include <netdb.h>
#include <fcntl.h>
#include <arpa/inet.h>

#define	SOCKET_NEW	1
#define	SOCKET_OK	0
#define SOCKET_BYE	-1
#define	SOCKET_GONE	-2
/*
 * Class to handle incoming sockets. Can/will be used to store fd
 * information, etc etc.
 */

class Socket
{
	public:
		Socket(int);
		virtual ~Socket();
		int io_write(char *);
		int io_accept();
		int io_data();
		void io_close(fd_set *);
		char *fqdn();

		int fd;
		int status;
		int port; // whether we are a listenport socket

		// You probably will write a class which contains more info than
		// socket, such as User or Client. As a generic lib, we don't want
		// to know what you write though, ever. To avoid your socket handler
		// having to locate which of your objects matches the appropriate
		// socket, this variable allows you to directly access it from an
		// array or STL vector, for example.
		unsigned int pos;

//		struct sockaddr_in my_cliaddr;
		char my_ip[16], my_fqdn[255];
		char buf[1024]; // for nonlinemode input
		Socket *next;
};

extern Socket *s1;
extern Socket *sN;

#endif // LIBCAPSI_NETWORK_SOCKET_H
