#!/bin/sh
# Start/stop the nrpe daemon.
#
# Contributed by Andrew Ryder 06-22-02
# Slight mods by Ethan Galstad 07-09-02

NrpeBin=/usr/local/bin/nrpe
NrpeCfg=/usr/local/etc/nrpe.cfg

case "$1" in
start)
	$NrpeBin -c $NrpeCfg -d
	echo -n ' nrpe'
	;;
stop)
		killall -TERM nrpe
		echo -n ' nrpe'
	;;
restart)
		killall -HUP nrpe
		echo 'nrpe restarted'
	;;
*)
	echo "Usage: ${0##*/}: { start | stop | restart }" 2>&1
	exit 65
	;;
esac

