# NOTE: Derived from blib/lib/Net/SOCKS.pm.
# Changes made here will be lost when autosplit again.
# See AutoSplit.pm.
package Net::SOCKS;

#line 375 "blib/lib/Net/SOCKS.pm (autosplit into blib/lib/auto/Net/SOCKS/_request5.al)"
sub _request5 {

  my $self    = shift;
  my $req_num = shift;
  my $rc;

  $self->_import_args(@_);
  $rc=$self->_validate();

  if ($rc != SOCKS_OKAY) { return ${*self}{status_num} = $rc }

  # connect to the SOCKS server
  ${*self}{status_num}=$self->_connect();

  if  (${*self}{status_num} != SOCKS_OKAY) {return ${*self}{status_num}}

  # send method request
  $self->_method_request5();
  if  (${*self}{status_num} != SOCKS_OKAY) {return ${*self}{status_num}}

  # get server method response
  $self->_method_response5();
  if  (${*self}{status_num} != SOCKS_OKAY) {return ${*self}{status_num}}

  
  if ( ${*self}{returned_method} == 2) { # username/password needed
    $self->_user_request5();
    if  (${*self}{status_num} != SOCKS_OKAY) {return ${*self}{status_num}}
    $self->_user_response5();
    if  (${*self}{status_num} != SOCKS_OKAY) {return ${*self}{status_num}}
  }

  my $addr_type;
  my $dest_addr;

  if (${*self}{peer_addr} =~ /[a-z][A-Z]/) {    # FQDN?
    $addr_type=3;
    $dest_addr = length(${*self}{peer_addr}) . ${*self}{peer_addr};
  } else {                                      # nope.  Must be dotted-dec.
    $addr_type = 1;
    $dest_addr = inet_aton(${*self}{peer_addr});
  }

  print  { ${*self}{fh} } pack ('CCCC', 5, $req_num, 0, $addr_type);
  print  { ${*self}{fh} } $dest_addr . pack('n', ${*self}{peer_port});

  $self->_get_resp5();
  return ${*self}{status_num};
}

# end of Net::SOCKS::_request5
1;
