# NOTE: Derived from blib/lib/Net/SOCKS.pm.
# Changes made here will be lost when autosplit again.
# See AutoSplit.pm.
package Net::SOCKS;

#line 261 "blib/lib/Net/SOCKS.pm (autosplit into blib/lib/auto/Net/SOCKS/accept.al)"
# Upon success, return a reference to a socket.  Otherwise, return undef.

sub accept {
  my ($self) = @_;

  if (${*self}{protocol_version}==4) {
    if ($self->_get_response() == SOCKS_OKAY ) {  return ${*self}{fh} }
  } elsif (${*self}{protocol_version}==5) {
    $self->_get_resp5();
    if (${*self}{status_num} != SOCKS_OKAY) {return undef}

    if (${*self}{addr_type}==4) {                             # IPv6?
      ${*self}{status_num} = SOCKS_UNSUPPORTED_ADDRESS_TYPE;
      return undef;
    }

    if (${*self}{addr_type}==3) {                             # FQDN?
      my $addr = gethostbyname(${*self}{listen_addr});        # -> 32 bit IPv4
      ${*self}{listen_hostname} = ${*self}{listen_addr};
      if (! defined $addr) {
        ${*self}{status_num}=SOCKS_HOSTNAME_LOOKUP_FAILURE;
	return undef;
      }
      ${*self}{listen_addr}=$addr;              # we expect IPv4 to live there
    }

    return ${*self}{fh}
  } else {
    ${*self}{status_num} = SOCKS_UNSUPPORTED_PROTOCOL_VERSION;
  }

  return undef;
}

# end of Net::SOCKS::accept
1;
