# NOTE: Derived from blib/lib/Net/SOCKS.pm.
# Changes made here will be lost when autosplit again.
# See AutoSplit.pm.
package Net::SOCKS;

#line 210 "blib/lib/Net/SOCKS.pm (autosplit into blib/lib/auto/Net/SOCKS/bind.al)"
# bind() opens a socket through _request() and sends a command
# code of 2 to the SOCKS server.  Upon success, it returns
# an array of (32 bit IP address, IP address as dotted decimal,
# port number) where the SOCKS server is listening on the
# client's behalf.  Upon failure, return undef.

sub bind {
  my $self = shift;

  if (${*self}{protocol_version}==4) {
    $self->_request(2, @_);
  } elsif (${*self}{protocol_version}==5) {
    $self->_request5(2, @_);
  } else {
    ${*self}{status_num} = SOCKS_UNSUPPORTED_PROTOCOL_VERSION;
  }

  if  (${*self}{status_num} != SOCKS_OKAY) {
    return undef;
  }

  # if we're working with an IPv4 address
  if (${*self}{protocol_version}==4 || (${*self}{protocol_version}==5
	&& defined ${*self}{addr_type} && ${*self}{addr_type}==1)) {

    # if the listen address is zero, assume it is the same as the socks host
    if (defined ${*self}{listen_addr} && ${*self}{listen_addr} == 0) {
      ${*self}{listen_addr} = ${*self}{socks_addr};
    }

    my $dotted_dec = inet_ntoa( pack ("N", ${*self}{listen_addr} ) );
    if (${*self}{status_num}==SOCKS_OKAY) {
      return (${*self}{listen_addr}, $dotted_dec, ${*self}{listen_port})
    } 
  } else {  # not a 32 bit IPv4 address.  FQDN or IPv6 then.
    if (${*self}{addr_type}==4) {                             # IPv6?
      ${*self}{status_num} = SOCKS_UNSUPPORTED_ADDRESS_TYPE;
      return undef;
    }
    if (${*self}{addr_type}==3) {                             # FQDN?
      my $addr = gethostbyname(${*self}{listen_addr});        # -> 32 bit IPv4
      ${*self}{listen_hostname} = ${*self}{listen_addr};
      if (! defined $addr) {
        ${*self}{status_num}=SOCKS_HOSTNAME_LOOKUP_FAILURE;
	return undef;
      }
	
      my $dotted_dec = inet_ntoa( pack ("N", $addr ) );
      return ($addr, $dotted_dec, ${*self}{listen_port})
    }
  }

  return undef;
}

# end of Net::SOCKS::bind
1;
