# NOTE: Derived from blib/lib/Net/SOCKS.pm.
# Changes made here will be lost when autosplit again.
# See AutoSplit.pm.
package Net::SOCKS;

#line 427 "blib/lib/Net/SOCKS.pm (autosplit into blib/lib/auto/Net/SOCKS/_get_resp5.al)"
# reads response from server, returns status_code, sets object values

sub _get_resp5 {
  my ($self) = @_;
  my $received = '';

  while ( read(${*self}{fh}, $received, 4) && (length($received) < 4) ) {}

  ( ${*self}{vn},  ${*self}{cd},  ${*self}{socks_flag}, ${*self}{addr_type})=
  unpack('CCCC', $received);


  if ( ${*self}{addr_type} == 3) {                    # FQDN

    $received = '';
    # get length of hostname (pascal style string)
    while ( read(${*self}{fh}, $received, 1) && (length($received) < 1) ) {}
    my $length = unpack('C', $received);

    $received = '';
    while ( read(${*self}{fh}, $received, $length) && (length($received) <
	    $length) ) {}
    ${*self}{listen_addr} = $received;

  } elsif ( ${*self}{addr_type} == 1) {               # IPv4 32 bit

    $received = '';
    while ( read(${*self}{fh}, $received, 4) && (length($received) < 4) ) {}
     ${*self}{listen_addr}=unpack('N', $received);

  } else {                                            # IPv6, others
    ${*self}{status_num} = SOCKS_UNSUPPORTED_ADDRESS_TYPE;
  }

  $received = '';
  while ( read(${*self}{fh}, $received, 2) && (length($received) < 2) ) {}
  ${*self}{listen_port} = unpack('n', $received);

  if (${*self}{cd} == 0) {
    # convert SOCKS5 success status code into the one SOCKS4 uses
    ${*self}{cd} = SOCKS_OKAY;
  }

  return ${*self}{status_num} = ${*self}{cd};
}

# end of Net::SOCKS::_get_resp5
1;
