/*
 * Decompiled with CFR 0.152.
 */
package com.bitzi.bitprint;

public class Base32 {
    private static final int base32LookupMax = 32;
    private static final String base32Chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZ234567";
    private static final int[] base32Lookup = new int[]{255, 255, 26, 27, 28, 29, 30, 31, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25};

    public static String encode(byte[] byArray) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        while (n < byArray.length) {
            int n4 = byArray[n];
            if (n4 < 0) {
                n4 += 256;
            }
            if (n2 > 3) {
                int n5;
                if (n < byArray.length - 1) {
                    n5 = byArray[n + 1];
                    if (n5 < 0) {
                        n5 += 256;
                    }
                } else {
                    n5 = 0;
                }
                n3 = n4 & 255 >> n2;
                n2 = (n2 + 5) % 8;
                n3 <<= n2;
                n3 |= n5 >> 8 - n2;
                ++n;
            } else {
                n3 = n4 >> 8 - (n2 + 5) & 0x1F;
                if ((n2 = (n2 + 5) % 8) == 0) {
                    ++n;
                }
            }
            stringBuffer.append(base32Chars.charAt(n3));
        }
        return stringBuffer.toString();
    }

    public static byte[] decodeBase32(String string) {
        byte[] byArray = new byte[(int)Math.ceil(string.length() * 5 / 8)];
        int n = string.length();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n2 < n) {
            int n5;
            int n6 = string.charAt(n2) - 48;
            if (n6 >= 0 && n6 < base32Lookup.length && (n5 = base32Lookup[n6]) != 255) {
                if (n3 <= 3) {
                    if ((n3 = (n3 + 5) % 8) == 0) {
                        int n7 = n4++;
                        byArray[n7] = (byte)(byArray[n7] | n5);
                        if (n4 >= byArray.length) {
                            break;
                        }
                    } else {
                        int n8 = n4;
                        byArray[n8] = (byte)(byArray[n8] | n5 << 8 - n3);
                    }
                } else {
                    n3 = (n3 + 5) % 8;
                    int n9 = n4++;
                    byArray[n9] = (byte)(byArray[n9] | n5 >> n3);
                    if (n4 >= byArray.length) break;
                    int n10 = n4;
                    byArray[n10] = (byte)(byArray[n10] | n5 << 8 - n3);
                }
            }
            ++n2;
        }
        return byArray;
    }

    public static void main(String[] stringArray) {
        String string = stringArray.length == 0 ? "PLSTHIPQGSSZTS5FJUPAKUZWUGYQYPFB" : stringArray[0];
        System.out.println("Test String: '" + string + "'");
        byte[] byArray = Base32.decodeBase32(string);
        System.out.println("...decoded...");
        int n = 0;
        while (n < byArray.length) {
            int n2 = byArray[n];
            if (n2 < 0) {
                n2 += 256;
            }
            System.out.print(Integer.toHexString(n2));
            ++n;
        }
        System.out.println();
        String string2 = Base32.encode(byArray);
        System.out.println("...encoded...");
        System.out.println("Result String: '" + string2 + "'");
    }
}

