/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.gui.plaf.skin;

import com.l2fprod.gui.plaf.skin.Skin;
import com.l2fprod.gui.plaf.skin.SkinArrowButton;
import com.l2fprod.gui.plaf.skin.SkinComboBoxRenderer;
import com.l2fprod.gui.plaf.skin.SkinLookAndFeel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicComboBoxUI;

public class SkinComboBoxUI
extends BasicComboBoxUI {
    protected PropertyChangeListener editableChangeListener;
    private Skin skin = SkinLookAndFeel.getSkin();

    public Dimension getPreferredSize(JComponent jComponent) {
        Dimension dimension = super.getMinimumSize(jComponent);
        Dimension dimension2 = this.skin.getPersonality().getComboBoxPreferredSize(this.comboBox);
        dimension.width = Math.max(dimension.width, dimension2.width);
        dimension.height = Math.max(dimension.height, dimension2.height);
        return dimension;
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        this.hasFocus = this.comboBox.hasFocus();
        if (!this.comboBox.isEditable()) {
            Rectangle rectangle = this.rectangleForCurrentValue();
            this.skin.getPersonality().paintComboBox(graphics, this.comboBox, rectangle, this.hasFocus);
            this.paintCurrentValue(graphics, rectangle, false);
        } else {
            graphics.setColor(Color.black);
            graphics.drawRect(0, 0, this.comboBox.getWidth(), this.comboBox.getHeight());
        }
    }

    protected Insets getInsets() {
        return this.skin.getPersonality().getComboBoxInsets();
    }

    protected JButton createArrowButton() {
        return new SkinArrowButton(5);
    }

    protected void installComponents() {
        super.installComponents();
        this.arrowButton.setVisible(this.comboBox.isEditable());
    }

    protected void installListeners() {
        super.installListeners();
        this.editableChangeListener = this.createEditableChangeListener();
        if (this.editableChangeListener != null) {
            this.comboBox.addPropertyChangeListener(this.editableChangeListener);
        }
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        this.comboBox.removePropertyChangeListener(this.editableChangeListener);
        this.editableChangeListener = null;
    }

    protected Rectangle rectangleForCurrentValue() {
        int n = this.comboBox.getWidth();
        int n2 = this.comboBox.getHeight();
        Insets insets = this.getInsets();
        int n3 = 0;
        if (this.arrowButton != null && this.arrowButton.isVisible()) {
            n3 = this.arrowButton.getWidth();
        }
        return new Rectangle(insets.left, insets.top, n - (insets.left + insets.right + n3), n2 - (insets.top + insets.bottom));
    }

    protected LayoutManager createLayoutManager() {
        return new SkinComboBoxLayoutManager();
    }

    protected ListCellRenderer createRenderer() {
        return new SkinComboBoxRenderer();
    }

    protected PropertyChangeListener createEditableChangeListener() {
        return new EditableChangeHandler();
    }

    protected JButton arrowButton() {
        return this.arrowButton;
    }

    protected void installKeyboardActions() {
        super.installKeyboardActions();
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (SkinComboBoxUI.this.comboBox.isEnabled()) {
                    if (SkinComboBoxUI.this.isPopupVisible()) {
                        SkinComboBoxUI.super.selectNextPossibleValue();
                    } else {
                        SkinComboBoxUI.this.setPopupVisible(SkinComboBoxUI.this.comboBox, true);
                    }
                }
            }
        };
        this.comboBox.registerKeyboardAction(actionListener, KeyStroke.getKeyStroke(40, 0), 1);
        this.comboBox.registerKeyboardAction(actionListener, KeyStroke.getKeyStroke("KP_DOWN"), 1);
        ActionListener actionListener2 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (SkinComboBoxUI.this.comboBox.isEnabled() && SkinComboBoxUI.this.isPopupVisible()) {
                    SkinComboBoxUI.this.togglePopup();
                }
            }
        };
        this.comboBox.registerKeyboardAction(actionListener2, KeyStroke.getKeyStroke(40, 8), 1);
        this.comboBox.registerKeyboardAction(actionListener2, KeyStroke.getKeyStroke("alt KP_DOWN"), 1);
        this.comboBox.registerKeyboardAction(actionListener2, KeyStroke.getKeyStroke(38, 8), 1);
        this.comboBox.registerKeyboardAction(actionListener2, KeyStroke.getKeyStroke("alt KP_UP"), 1);
        ActionListener actionListener3 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (SkinComboBoxUI.this.comboBox.isEnabled() && SkinComboBoxUI.this.isPopupVisible()) {
                    SkinComboBoxUI.super.selectPreviousPossibleValue();
                }
            }
        };
        this.comboBox.registerKeyboardAction(actionListener3, KeyStroke.getKeyStroke(38, 0), 1);
        this.comboBox.registerKeyboardAction(actionListener3, KeyStroke.getKeyStroke("KP_UP"), 1);
    }

    protected void uninstallKeyboardActions() {
        super.uninstallKeyboardActions();
        this.comboBox.unregisterKeyboardAction(KeyStroke.getKeyStroke(40, 0));
        this.comboBox.unregisterKeyboardAction(KeyStroke.getKeyStroke("KP_DOWN"));
        this.comboBox.unregisterKeyboardAction(KeyStroke.getKeyStroke(40, 8));
        this.comboBox.unregisterKeyboardAction(KeyStroke.getKeyStroke("alt KP_DOWN"));
        this.comboBox.unregisterKeyboardAction(KeyStroke.getKeyStroke(38, 0));
        this.comboBox.unregisterKeyboardAction(KeyStroke.getKeyStroke("KP_UP"));
        this.comboBox.unregisterKeyboardAction(KeyStroke.getKeyStroke(38, 8));
        this.comboBox.unregisterKeyboardAction(KeyStroke.getKeyStroke("alt KP_UP"));
    }

    protected Component editor() {
        return this.editor;
    }

    boolean isPopupVisible() {
        return super.isPopupVisible(this.comboBox);
    }

    void togglePopup() {
        this.toggleOpenClose();
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new SkinComboBoxUI();
    }

    public class SkinComboBoxLayoutManager
    implements LayoutManager {
        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public Dimension preferredLayoutSize(Container container) {
            JComboBox jComboBox = (JComboBox)container;
            return container.getPreferredSize();
        }

        public Dimension minimumLayoutSize(Container container) {
            JComboBox jComboBox = (JComboBox)container;
            return container.getMinimumSize();
        }

        public void layoutContainer(Container container) {
            JComboBox jComboBox = (JComboBox)container;
            int n = jComboBox.getWidth();
            int n2 = jComboBox.getHeight();
            Insets insets = jComboBox.getInsets();
            int n3 = n2 - (insets.top + insets.bottom);
            if (SkinComboBoxUI.this.arrowButton() != null && SkinComboBoxUI.this.arrowButton().isVisible()) {
                SkinComboBoxUI.this.arrowButton().setBounds(n - (insets.right + n3), insets.top, n3, n3);
            }
            if (SkinComboBoxUI.this.editor() != null) {
                Rectangle rectangle = SkinComboBoxUI.this.rectangleForCurrentValue();
                SkinComboBoxUI.this.editor().setBounds(rectangle);
            }
        }
    }

    public class EditableChangeHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("renderer")) {
                SkinComboBoxUI.this.arrowButton().setVisible(SkinComboBoxUI.this.comboBox.isEditable());
            } else if (string.equals("editable")) {
                SkinComboBoxUI.this.arrowButton().setVisible((Boolean)propertyChangeEvent.getNewValue());
                SkinComboBoxUI.this.comboBox.revalidate();
                SkinComboBoxUI.this.comboBox.repaint();
            }
        }
    }
}

