/*
 * Decompiled with CFR 0.152.
 */
package phex;

import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import phex.utils.IOUtil;
import phex.utils.Logger;

public class HttpRequest {
    protected String mRequestLine;
    protected String mMethod;
    protected String mUri;
    protected String mVersion;
    protected Hashtable mHeader = new Hashtable();

    protected HttpRequest() {
    }

    public String getMethod() {
        return this.mMethod;
    }

    public void setMethod(String string) {
        this.mMethod = string;
    }

    public String getUri() {
        return this.mUri;
    }

    public void setUri(String string) {
        this.mUri = string;
    }

    public String getVersion() {
        return this.mVersion;
    }

    public void setVersion(String string) {
        this.mVersion = string;
    }

    public void putHeader(String string, String string2) {
        this.mHeader.put(string, string2);
    }

    public String getHeader(String string) {
        return (String)this.mHeader.get(string);
    }

    public boolean readHeaders(InputStream inputStream) {
        boolean bl = true;
        try {
            byte[] byArray = new byte[1024];
            int n = IOUtil.readToCRLF(inputStream, byArray, 1024, 0);
            while (n > 0) {
                String string = new String(byArray, 0, n).trim();
                int n2 = string.indexOf(":");
                if (n2 != -1) {
                    String string2 = string.substring(0, n2);
                    String string3 = string.substring(n2 + 1);
                    Logger.logMessage(Logger.FINER, (short)16, "Read Header: " + string2 + ":" + string3);
                    this.putHeader(string2.toUpperCase().trim(), string3.trim());
                }
                n = IOUtil.readToCRLF(inputStream, byArray, 1024, 0);
            }
        }
        catch (IOException iOException) {
            Logger.logMessage(Logger.FINE, (short)16, iOException);
            bl = false;
        }
        return bl;
    }

    public String toString() {
        return this.mMethod + " " + this.mUri + " " + this.mVersion + "\r\n";
    }
}

