/*
 * Decompiled with CFR 0.152.
 */
package phex;

import phex.MainFrame;
import phex.NetworkManager;
import phex.ServiceManager;
import phex.common.TransferRateService;
import phex.gui.common.GUIRegistry;
import phex.host.HostManager;
import phex.msg.MsgManager;
import phex.query.QueryManager;
import phex.share.ShareManager;
import phex.utils.Logger;
import phex.utils.StatisticTracker;

public class JobsRunner
implements Runnable {
    private boolean mRequestToDie = false;
    private boolean mRunning = false;
    private boolean mShutdownCompleted = false;
    private HostManager mHostMgr = ServiceManager.getHostManager();
    private NetworkManager mNetworkMgr = ServiceManager.getNetworkManager();
    private MsgManager mMsgManager = ServiceManager.getMsgManager();
    private ShareManager mShareMgr = ServiceManager.getShareManager();
    private StatisticTracker statisticTracker = ServiceManager.getStatisticTracker();
    private TransferRateService transferRateService = ServiceManager.getTransferRateService();
    private boolean mInitScan = false;

    JobsRunner() {
    }

    public synchronized void startup() {
        if (this.mRunning) {
            return;
        }
        Logger.logMessage(Logger.FINE, (short)255, "Background jobs runner starting...");
        this.mRequestToDie = false;
        this.mRunning = true;
        Thread thread = new Thread((Runnable)this, "JobsRunner-" + Integer.toHexString(this.hashCode()));
        thread.setDaemon(true);
        thread.start();
    }

    public boolean getRunning() {
        return this.mRunning;
    }

    public synchronized void shutdown(boolean bl) {
        if (this.mRequestToDie) {
            return;
        }
        Logger.logMessage(Logger.FINE, (short)255, "Background jobs runner shutting down...");
        this.mShutdownCompleted = false;
        this.mRequestToDie = true;
        if (bl) {
            while (!this.mShutdownCompleted) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
            }
        }
    }

    public void run() {
        Logger.logMessage(Logger.FINE, (short)255, "Background jobs runner started.");
        MainFrame mainFrame = GUIRegistry.getInstance().getMainFrame();
        int n = 1000;
        int n2 = 0;
        QueryManager queryManager = ServiceManager.getQueryManager();
        GUIRegistry gUIRegistry = GUIRegistry.getInstance();
        block4: while (true) {
            try {
                while (true) {
                    try {
                        Thread.sleep(n);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (this.mRequestToDie) break block4;
                    this.mMsgManager.pingNeighbors();
                    this.mHostMgr.periodicallyCheckHosts();
                    gUIRegistry.getLazyEventQueue().fireLazyEvents();
                    if (n2 % 2 == 0) {
                        this.mHostMgr.cleanupConnectedHosts();
                        this.mHostMgr.cleanupNetworkHosts();
                        int n3 = this.mHostMgr.getConnectedHostCount();
                        if (n3 < ServiceManager.sCfg.mNetMinConn && this.mNetworkMgr.isNetworkJoined()) {
                            int n4;
                            int n5 = n4 = ServiceManager.sCfg.mNetMaxConnection - this.mHostMgr.getNetworkHostCount();
                            while (n5 > 0) {
                                this.mHostMgr.autoConnectToNextCaughtHost();
                                --n5;
                            }
                        }
                        gUIRegistry.getTableUpdateService().updateTables();
                    }
                    if (n2 % 5 == 0) {
                        if (ServiceManager.sCfg.mUploadAutoRemoveCompleted) {
                            this.mShareMgr.getUploadFileContainer().cleanUploadFileList();
                        }
                        queryManager.stopExpiredSearches();
                        queryManager.getResearchService().startResearchSequence();
                    }
                    if (n2 % 10 == 0) {
                        this.statisticTracker.newRateSamplePeriod();
                        this.transferRateService.setTransferRateTimestamp();
                    }
                    if (n2 % 60 == 0) {
                        this.mHostMgr.saveHostsContainer();
                        if (n2 > 1) {
                            this.mShareMgr.getFileAdministration().rescan(false);
                        }
                    }
                    if (!this.mInitScan) {
                        this.mShareMgr.getFileAdministration().rescan(true);
                        this.mInitScan = true;
                    }
                    ++n2;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                continue;
            }
            break;
        }
        this.shutdownCompleted();
    }

    private synchronized void shutdownCompleted() {
        this.mRunning = false;
        Logger.logMessage(Logger.FINE, (short)255, "Background jobs runner stopped.");
        this.mShutdownCompleted = true;
        this.notifyAll();
    }
}

