/*
 * Decompiled with CFR 0.152.
 */
package phex;

import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import phex.ReadWorker;
import phex.ServiceManager;
import phex.common.ThreadPool;
import phex.host.Host;
import phex.host.HostAddress;
import phex.interfaces.IHostChanged;
import phex.utils.IPUtils;
import phex.utils.Logger;

public class Listener
implements Runnable {
    private ServerSocket mListeningSocket;
    private boolean mRequestToDie = false;
    private boolean mRunning = false;
    private boolean mShutdownCompleted = false;
    private IHostChanged mHostChangedListener = null;
    private boolean hasConnectedIncomming = false;
    private HostAddress forcedAddress;
    private HostAddress localAddress;

    public synchronized void startup() throws IOException {
        boolean bl;
        if (this.mRunning) {
            return;
        }
        ServiceManager.getShareManager();
        Logger.logMessage(Logger.FINER, (short)255, "Starting Listener");
        int n = ServiceManager.sCfg.mListeningPort;
        int n2 = 0;
        do {
            bl = false;
            try {
                this.mListeningSocket = new ServerSocket(n, 50);
            }
            catch (BindException bindException) {
                if (n2 > 10) {
                    throw bindException;
                }
                bl = true;
                ++n;
                ++n2;
            }
        } while (bl);
        this.mRequestToDie = false;
        this.mRunning = true;
        if (ServiceManager.sCfg.mMyIP.length() > 0) {
            this.setForcedHostIP(HostAddress.parseIP(ServiceManager.sCfg.mMyIP));
        } else {
            byte[] byArray = this.resolveLocalHostIP();
            n = this.mListeningSocket.getLocalPort();
            this.updateLocalAddress(byArray, n);
        }
        ThreadPool.getInstance().addJob(this);
    }

    public synchronized void shutdown(boolean bl) {
        if (!this.mRunning || this.mRequestToDie) {
            return;
        }
        Logger.logMessage(Logger.FINER, (short)255, "Shutting down Listener");
        this.mShutdownCompleted = false;
        this.mRequestToDie = true;
        try {
            Socket socket = new Socket(HostAddress.LOCAL_HOST_NAME, this.mListeningSocket.getLocalPort());
            socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (bl) {
            while (!this.mShutdownCompleted) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
            }
        }
    }

    protected boolean getRequestToDie() {
        return this.mRequestToDie;
    }

    public boolean getRunning() {
        return this.mRunning;
    }

    public HostAddress getLocalAddress() {
        if (this.forcedAddress != null) {
            return this.forcedAddress;
        }
        return this.localAddress;
    }

    public boolean hasConnectedIncoming() {
        return this.hasConnectedIncomming;
    }

    public void setHostChangedListener(IHostChanged iHostChanged) {
        this.mHostChangedListener = iHostChanged;
    }

    public void updateLocalAddress(byte[] byArray) {
        if (this.forcedAddress != null) {
            return;
        }
        this.updateLocalAddress(byArray, this.mListeningSocket.getLocalPort());
    }

    public void updateLocalAddress(byte[] byArray, int n) {
        if (this.forcedAddress != null) {
            return;
        }
        if (this.localAddress == null) {
            this.localAddress = new HostAddress(byArray, n);
        } else {
            this.localAddress.updateAddress(byArray, n);
        }
        if (this.mHostChangedListener != null) {
            this.mHostChangedListener.updateMyIP();
        }
    }

    public void setForcedHostIP(byte[] byArray) {
        if (byArray == null) {
            this.forcedAddress = null;
            ServiceManager.sCfg.mMyIP = "";
            byte[] byArray2 = this.resolveLocalHostIP();
            int n = this.mListeningSocket.getLocalPort();
            this.updateLocalAddress(byArray2, n);
            return;
        }
        if (byArray.length != 4) {
            throw new IllegalArgumentException("Wrong arguement length for IP " + byArray.length);
        }
        ServiceManager.sCfg.mMyIP = IPUtils.ip2string(byArray);
        if (this.forcedAddress == null) {
            this.forcedAddress = new HostAddress(byArray, this.mListeningSocket.getLocalPort());
        } else {
            this.forcedAddress.updateAddress(byArray, this.mListeningSocket.getLocalPort());
        }
        if (this.mHostChangedListener != null) {
            this.mHostChangedListener.updateMyIP();
        }
    }

    public void run() {
        Logger.logMessage(Logger.FINER, (short)255, "Listener started. Listening on: " + this.mListeningSocket.getInetAddress().getHostAddress() + ':' + this.mListeningSocket.getLocalPort());
        while (true) {
            Socket socket;
            try {
                socket = this.mListeningSocket.accept();
                socket.setSoTimeout(ServiceManager.sCfg.mSocketTimeout);
                this.hasConnectedIncomming = true;
            }
            catch (IOException iOException) {
                Logger.logError(iOException);
                break;
            }
            if (this.getRequestToDie()) break;
            try {
                HostAddress hostAddress = new HostAddress(socket.getInetAddress().getHostAddress(), socket.getPort());
                Host host = new Host(hostAddress);
                host.setType(2);
                host.setSock(socket);
                host.setOs(socket.getOutputStream());
                host.setIs(socket.getInputStream());
                host.setStatus(3, "");
                new ReadWorker(host);
            }
            catch (Exception exception) {
                Logger.logError(exception);
            }
        }
        try {
            this.mListeningSocket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.shutdownCompleted();
    }

    private byte[] resolveLocalHostIP() {
        byte[] byArray = null;
        InetAddress inetAddress = this.mListeningSocket.getInetAddress();
        byArray = inetAddress.getAddress();
        if (byArray[0] == 0 && byArray[1] == 0 && byArray[2] == 0 && byArray[3] == 0) {
            byArray = HostAddress.LOCAL_HOST_IP;
        }
        return byArray;
    }

    private synchronized void shutdownCompleted() {
        this.mRunning = false;
        Logger.logMessage(Logger.FINER, (short)255, "Listener stopped.");
        this.mShutdownCompleted = true;
        this.updateLocalAddress(HostAddress.LOCAL_HOST_IP, 6346);
        this.notifyAll();
    }
}

