/*
 * Decompiled with CFR 0.152.
 */
package phex;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.AbstractTableModel;
import org.apache.crimson.tree.XmlDocument;
import org.w3c.dom.Document;
import phex.BaseFrame;
import phex.NetworkManager;
import phex.Res;
import phex.ServiceManager;
import phex.SplashWindow;
import phex.download.RemoteFile;
import phex.download.swarming.SwarmingManager;
import phex.event.UpdateNotificationListener;
import phex.gui.actions.CloseGUIAction;
import phex.gui.common.DesktopIndicator;
import phex.gui.common.DesktopIndicatorListener;
import phex.gui.common.GUIRegistry;
import phex.gui.common.IconFactory;
import phex.gui.common.SkinLookAndFeelLoader;
import phex.gui.common.StatusBar;
import phex.gui.dialogs.UpdateNotificationDialog;
import phex.gui.tabs.FWTab;
import phex.gui.tabs.MonitorTab;
import phex.gui.tabs.NetworkTab;
import phex.gui.tabs.SWDownloadTab;
import phex.gui.tabs.SearchTab;
import phex.gui.tabs.ShareTab;
import phex.host.HostManager;
import phex.msg.MsgManager;
import phex.share.UploadFileContainer;
import phex.update.UpdateChecker;
import phex.utils.BrowserLauncher;
import phex.utils.Localizer;
import phex.utils.Logger;
import phex.utils.StatisticTracker;
import phex.utils.StrUtil;
import phex.xml.XMLBuilder;
import phex.xml.XMLGUISettings;
import phex.xml.XMLGUITableList;
import phex.xml.XMLPhex;
import phex.xml.XMLPhexXMLCodec;

public class MainFrame
extends BaseFrame {
    public static final int NETWORK_TAB = 0;
    public static final int SEARCH_TAB = 1;
    public static final int MONITOR_TAB = 2;
    public static final int DOWNLOAD_TAB = 3;
    public static final int SHARE_TAB = 4;
    private MsgManager mMsgManager = ServiceManager.getMsgManager();
    private StatisticTracker statTracker = ServiceManager.getStatisticTracker();
    private HostManager mHostMgr;
    private NetworkManager mNetworkMgr;
    private SwarmingManager swarmingMgr;
    private JTabbedPane mTabs;
    private JPanel mUpload;
    private Timer mRefresher;
    private boolean mInRefreshHandler = false;
    private UploadFileContainer uploadContainer;
    private NetworkTab networkTab;
    private SearchTab searchTab;
    private MonitorTab monitorTab;
    private ShareTab shareTab;
    private SWDownloadTab swDownloadTab;

    private MainFrame() {
    }

    public MainFrame(SplashWindow splashWindow) {
        super("Main");
        this.mHostMgr = ServiceManager.getHostManager();
        this.mNetworkMgr = ServiceManager.getNetworkManager();
        this.uploadContainer = ServiceManager.getShareManager().getUploadFileContainer();
        this.swarmingMgr = ServiceManager.getSwarmingManager();
        ServiceManager.sCfg.save();
        SkinLookAndFeelLoader.tryLoadingSkinLookAndFeel();
        XMLGUISettings xMLGUISettings = this.loadGUISettings();
        this.setFonts();
        this.resetLookAndFeel();
        this.setupComponents(xMLGUISettings);
        ServiceManager.getListener().setHostChangedListener(this.networkTab);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowHandler());
        DesktopIndicator desktopIndicator = GUIRegistry.getInstance().getDesktopIndicator();
        if (desktopIndicator != null) {
            desktopIndicator.addDesktopIndicatorListener(new DesktopIndicatorHandler());
        }
        this.pack();
        BaseFrame.centerAndSizeWindow(this, 7, 8);
        this.refreshAllActions();
        this.setTitle();
        splashWindow.dispose();
        ((Component)this).setVisible(true);
        try {
            ServiceManager.getListener().startup();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        ServiceManager.getNetworkManager().init();
        ServiceManager.getSwarmingManager().loadDownloadList();
        this.mRefresher = new Timer(1000, new RefreshHandler());
        this.mRefresher.start();
        this.checkForUpdates();
    }

    private void setupComponents(XMLGUISettings xMLGUISettings) {
        this.mTabs = new JTabbedPane();
        this.mTabs.setMinimumSize(new Dimension(50, 50));
        this.mTabs.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                Component component = MainFrame.this.mTabs.getSelectedComponent();
                if (component instanceof FWTab) {
                    ((FWTab)component).tabSelectedNotify();
                }
            }
        });
        IconFactory iconFactory = GUIRegistry.getInstance().getIconFactory();
        this.networkTab = new NetworkTab(this);
        this.networkTab.initComponent(xMLGUISettings);
        this.mTabs.addTab(Localizer.getString("GnutellaNet"), iconFactory.getIcon("Network"), this.networkTab);
        this.searchTab = new SearchTab(this);
        this.searchTab.initComponent(xMLGUISettings);
        this.mTabs.addTab(Localizer.getString("Search"), iconFactory.getIcon("Search"), this.searchTab);
        this.monitorTab = new MonitorTab(this);
        this.monitorTab.initComponent(xMLGUISettings);
        this.mTabs.addTab(Localizer.getString("MonitorSearch"), iconFactory.getIcon("Monitor"), this.monitorTab);
        this.swDownloadTab = new SWDownloadTab(this);
        this.swDownloadTab.initComponent(xMLGUISettings);
        this.mTabs.addTab(Localizer.getString("Download"), iconFactory.getIcon("Download"), this.swDownloadTab);
        this.shareTab = new ShareTab(this);
        this.shareTab.initComponent(xMLGUISettings);
        this.mTabs.addTab(Localizer.getString("Share"), iconFactory.getIcon("Upload"), this.shareTab);
        this.getContentPane().add("Center", this.mTabs);
        StatusBar statusBar = new StatusBar();
        this.getContentPane().add("South", statusBar);
        BaseFrame.updateComponentsUI();
    }

    public void setTitle() {
        StringBuffer stringBuffer = new StringBuffer(StrUtil.getAppNameVersion());
        if (this.mNetworkMgr.isNetworkJoined()) {
            stringBuffer.append(" - ");
            stringBuffer.append(ServiceManager.sCfg.mCurrentNetwork);
        }
        if (ServiceManager.sCfg.mProxyUse) {
            stringBuffer.append("  (via Proxy Server)");
        }
        super.setTitle(stringBuffer.toString());
    }

    public boolean isNetTabSelected() {
        return this.mTabs != null && this.mTabs.getSelectedComponent() == this.networkTab;
    }

    public boolean isSearchTabSelected() {
        return this.mTabs != null && this.mTabs.getSelectedComponent() == this.searchTab;
    }

    public boolean isMonitorTabSelected() {
        return this.mTabs != null && this.mTabs.getSelectedComponent() == this.monitorTab;
    }

    public boolean isUploadTabSelected() {
        return this.mTabs != null && this.mTabs.getSelectedComponent() == this.shareTab;
    }

    public void setSelectedTab(int n) {
        switch (n) {
            case 0: {
                this.mTabs.setSelectedComponent(this.networkTab);
                break;
            }
            case 1: {
                this.mTabs.setSelectedComponent(this.searchTab);
                break;
            }
            case 2: {
                this.mTabs.setSelectedComponent(this.monitorTab);
                break;
            }
            case 3: {
                this.mTabs.setSelectedComponent(this.swDownloadTab);
                break;
            }
            case 4: {
                this.mTabs.setSelectedComponent(this.shareTab);
            }
        }
    }

    public void launchBrowserOnHost() {
        RemoteFile remoteFile;
        if (this.isSearchTabSelected()) {
            remoteFile = this.searchTab.getSelectedRemoteFile();
        } else if (this.isMonitorTabSelected()) {
            remoteFile = this.monitorTab.getSelectedRemoteFile();
        } else {
            return;
        }
        String string = StrUtil.parseURLHostPort(remoteFile.getURL());
        if (string == null) {
            return;
        }
        try {
            BrowserLauncher.openURL(string);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, "Failed to launch browser  " + exception.getMessage(), "Can't Launch Browser", 0);
        }
    }

    public void launchBrowserOnURL() {
        RemoteFile remoteFile;
        if (this.isSearchTabSelected()) {
            remoteFile = this.searchTab.getSelectedRemoteFile();
        } else if (this.isMonitorTabSelected()) {
            remoteFile = this.monitorTab.getSelectedRemoteFile();
        } else {
            return;
        }
        String string = URLEncoder.encode(remoteFile.getURL());
        try {
            BrowserLauncher.openURL(string);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, "Failed to launch browser  " + exception.getMessage(), "Can't Launch Browser", 0);
        }
    }

    public ShareTab getShareTab() {
        return this.shareTab;
    }

    public NetworkTab getNetworkTab() {
        return this.networkTab;
    }

    public SearchTab getSearchTab() {
        return this.searchTab;
    }

    public MonitorTab getMonitorTab() {
        return this.monitorTab;
    }

    public SWDownloadTab getSwarmingTab() {
        return this.swDownloadTab;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void saveGUISettings() {
        OutputStreamWriter outputStreamWriter = null;
        FileOutputStream fileOutputStream = new FileOutputStream(ServiceManager.getXMLGUISettingsFilename());
        outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF8");
        XMLGUISettings xMLGUISettings = new XMLGUISettings();
        XMLGUITableList xMLGUITableList = new XMLGUITableList();
        xMLGUISettings.setTableList(xMLGUITableList);
        this.networkTab.appendXMLGUISettings(xMLGUISettings);
        this.searchTab.appendXMLGUISettings(xMLGUISettings);
        this.monitorTab.appendXMLGUISettings(xMLGUISettings);
        this.swDownloadTab.appendXMLGUISettings(xMLGUISettings);
        this.shareTab.appendXMLGUISettings(xMLGUISettings);
        XMLPhex xMLPhex = new XMLPhex();
        xMLPhex.setPhexVersion(Res.getStr("Program.Version"));
        xMLPhex.setGuiSettings(xMLGUISettings);
        XmlDocument xmlDocument = XMLPhexXMLCodec.encodeXML(xMLPhex);
        xmlDocument.write(outputStreamWriter, "UTF-8");
        Object var8_10 = null;
        if (outputStreamWriter == null) return;
        try {
            outputStreamWriter.close();
            return;
        }
        catch (IOException iOException) {}
        return;
        {
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Logger.logError(unsupportedEncodingException);
                Object var8_11 = null;
                if (outputStreamWriter == null) return;
                try {
                    outputStreamWriter.close();
                    return;
                }
                catch (IOException iOException) {}
                return;
            }
            catch (FileNotFoundException fileNotFoundException) {
                Logger.logError(fileNotFoundException);
                Object var8_12 = null;
                if (outputStreamWriter == null) return;
                try {
                    outputStreamWriter.close();
                    return;
                }
                catch (IOException iOException) {}
                return;
            }
            catch (IOException iOException) {
                Logger.logError(iOException);
                Object var8_13 = null;
                if (outputStreamWriter == null) return;
                try {
                    outputStreamWriter.close();
                    return;
                }
                catch (IOException iOException2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var8_14 = null;
            if (outputStreamWriter == null) throw throwable;
            try {
                outputStreamWriter.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
    }

    private void checkForUpdates() {
        UpdateChecker updateChecker = new UpdateChecker(new UpdateNotificationListener(){

            public void updateNotification(UpdateChecker updateChecker) {
                UpdateNotificationDialog updateNotificationDialog = new UpdateNotificationDialog(updateChecker);
                updateNotificationDialog.show();
            }
        });
        updateChecker.checkForUpdate();
    }

    private XMLGUISettings loadGUISettings() {
        File file = new File(ServiceManager.getXMLGUISettingsFilename());
        if (!file.exists()) {
            Logger.logMessage(Logger.FINE, (short)255, "No gui settings configuration file found.");
            return null;
        }
        Logger.logMessage(Logger.FINE, (short)255, "Load gui settings file.");
        Document document = XMLBuilder.loadFromFile(file);
        if (document != null) {
            XMLPhex xMLPhex = XMLPhexXMLCodec.decodeXML(document.getDocumentElement());
            return xMLPhex.getGuiSettings();
        }
        Logger.logMessage(Logger.FINE, (short)255, "Load gui settings file failed.");
        return null;
    }

    private void fireTableChanged(JTable jTable, AbstractTableModel abstractTableModel) {
        int n = jTable.getSelectedRowCount();
        int[] nArray = jTable.getSelectedRows();
        abstractTableModel.fireTableDataChanged();
        if (n > 0) {
            int n2 = 0;
            while (n2 < nArray.length) {
                if (nArray[n2] < jTable.getRowCount()) {
                    jTable.addRowSelectionInterval(nArray[n2], nArray[n2]);
                }
                ++n2;
            }
        }
    }

    private class RefreshHandler
    implements ActionListener {
        private RefreshHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MainFrame.this.mInRefreshHandler = true;
            MainFrame.this.networkTab.refresh(false);
            MainFrame.this.mInRefreshHandler = false;
        }
    }

    private class ChangeHandler
    implements ChangeListener {
        private ChangeHandler() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            MainFrame.this.refreshAllActions();
        }
    }

    private class DesktopIndicatorHandler
    implements DesktopIndicatorListener {
        private DesktopIndicatorHandler() {
        }

        public void onDesktopIndicatorClicked(DesktopIndicator desktopIndicator) {
            MainFrame.this.show();
            desktopIndicator.hideIndicator();
            if (MainFrame.this.getState() != 0) {
                MainFrame.this.setState(0);
            }
            MainFrame.this.requestFocus();
        }
    }

    private class WindowHandler
    extends WindowAdapter {
        private WindowHandler() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            CloseGUIAction.performCloseGUIAction();
        }
    }
}

