/*
 * Decompiled with CFR 0.152.
 */
package phex;

import phex.MainFrame;
import phex.ServiceManager;
import phex.gui.common.GUIRegistry;
import phex.host.HostManager;

public class NetworkManager {
    private static final String sRequestSignature = "GNUTELLA CONNECT";
    private ServiceManager mManager = ServiceManager.getManager();
    private boolean mJoined;

    NetworkManager() {
        this.mJoined = ServiceManager.sCfg.mAutoJoin;
    }

    public void init() {
        if (this.mJoined) {
            HostManager hostManager = ServiceManager.getHostManager();
            hostManager.initializeCaughtHosts();
        }
    }

    public synchronized void joinNetwork() {
        HostManager hostManager = ServiceManager.getHostManager();
        hostManager.initializeCaughtHosts();
        MainFrame mainFrame = GUIRegistry.getInstance().getMainFrame();
        mainFrame.getNetworkTab().updateStat();
        this.mJoined = true;
        mainFrame.setTitle();
        mainFrame.refreshAllActions();
    }

    public synchronized void leaveNetwork() {
        if (this.mJoined) {
            this.mJoined = false;
            MainFrame mainFrame = GUIRegistry.getInstance().getMainFrame();
            mainFrame.setTitle();
            mainFrame.refreshAllActions();
            ServiceManager.getHostManager().removeAllNetworkHosts();
            ServiceManager.getQueryManager().getSearchContainer().stopAllSearches();
            ServiceManager.getHostManager().saveHostsContainer();
        }
    }

    public boolean isNetworkJoined() {
        return this.mJoined;
    }

    public String getGreeting() {
        if (ServiceManager.sCfg.mCurrentNetwork.equals("<General Gnutella Network>")) {
            return sRequestSignature;
        }
        return "GNUTELLA PCONNECT " + ServiceManager.sCfg.mCurrentNetwork;
    }
}

