/*
 * Decompiled with CFR 0.152.
 */
package phex;

import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.StringTokenizer;
import phex.FlexBuf;
import phex.GUID;
import phex.Listener;
import phex.PushWorker;
import phex.SendManager;
import phex.ServiceManager;
import phex.common.ThreadPool;
import phex.connection.ConnectionManager;
import phex.connection.ConnectionRequest;
import phex.connection.ProtocolNotSupportedException;
import phex.download.PushHandler;
import phex.host.CaughtHostsContainer;
import phex.host.Host;
import phex.host.HostAddress;
import phex.host.HostManager;
import phex.msg.MsgHeader;
import phex.msg.MsgInit;
import phex.msg.MsgInitResponse;
import phex.msg.MsgManager;
import phex.msg.MsgPushRequest;
import phex.msg.MsgQuery;
import phex.msg.MsgQueryResponse;
import phex.msg.MsgResRecord;
import phex.query.QueryHistoryMonitor;
import phex.share.FileAdministration;
import phex.share.ShareFile;
import phex.share.ShareManager;
import phex.utils.HexConverter;
import phex.utils.IPUtils;
import phex.utils.Logger;
import phex.utils.StatisticTracker;

public class ReadWorker
implements Runnable {
    private static final String sRequestSignature = "GNUTELLA CONNECT/0.4";
    private static final String sReplySignature = "GNUTELLA OK";
    private static final String sPasswordChallege = "GNUTELLA AUTHENTICATION CHALLENGE";
    private static final String sPasswordReply = "GNUTELLA AUTHENTICATION RESPONSE";
    private static final String sAuthFailed = "GNUTELLA AUTHENTICATION FAILED";
    private Host mRemoteHost;
    private byte[] mHeaderBuf;
    private FlexBuf mBuf1;
    private FlexBuf mBuf2;
    private FlexBuf mBodyBuf;
    private ServiceManager mManager = ServiceManager.getManager();
    private ConnectionManager mConnMgr = ServiceManager.getConnectionManager();
    private HostManager mHostMgr = ServiceManager.getHostManager();
    private SendManager mSendMgr = ServiceManager.getSendManager();
    private ShareManager mShareMgr = ServiceManager.getShareManager();
    private QueryHistoryMonitor queryHistory;
    private FileAdministration fileAdministration;
    private StatisticTracker statTracker = ServiceManager.getStatisticTracker();
    private MsgManager mMsgMgr = ServiceManager.getMsgManager();

    private ReadWorker() {
    }

    public ReadWorker(Host host) {
        this.mRemoteHost = host;
        this.mHeaderBuf = new byte[23];
        this.mBuf1 = new FlexBuf();
        this.mBuf2 = new FlexBuf();
        this.mBodyBuf = new FlexBuf();
        this.fileAdministration = this.mShareMgr.getFileAdministration();
        this.queryHistory = ServiceManager.getQueryManager().getQueryHistoryMonitor();
        ThreadPool.getInstance().addJob(this);
    }

    public void run() {
        if (!this.mRemoteHost.acquireByWorker()) {
            return;
        }
        try {
            try {
                if (this.mRemoteHost.getType() == 1) {
                    this.connectAndHandShakeOutgoing();
                    this.mRemoteHost.setStatus(4);
                    this.mHostMgr.addConnectedHost(this.mRemoteHost);
                    this.mSendMgr.queueMsgToSend(this.mRemoteHost, this.mMsgMgr.getMyMsgInit(), false);
                    this.processIncomingData();
                } else if (this.mRemoteHost.getType() == 2) {
                    Logger.logMessage(Logger.INFO, (short)16, "ReadWorker Incoming connection detected.");
                    this.handleIncomingConnection();
                } else {
                    throw new Exception("Invalid host type");
                }
                Object var6_1 = null;
                if (this.mRemoteHost != null) {
                    this.mRemoteHost.releaseFromWorker();
                    this.mRemoteHost.disconnect();
                }
            }
            catch (SocketException socketException) {
                this.mRemoteHost.setStatus(1, socketException.getMessage());
                Logger.logMessage(Logger.FINEST, (short)16, socketException);
                Object var6_2 = null;
                if (this.mRemoteHost != null) {
                    this.mRemoteHost.releaseFromWorker();
                    this.mRemoteHost.disconnect();
                }
            }
            catch (ProtocolNotSupportedException protocolNotSupportedException) {
                Logger.logMessage(Logger.FINE, (short)16, protocolNotSupportedException);
                this.mRemoteHost.setStatus(1, protocolNotSupportedException.getMessage());
                Object var6_3 = null;
                if (this.mRemoteHost != null) {
                    this.mRemoteHost.releaseFromWorker();
                    this.mRemoteHost.disconnect();
                }
            }
            catch (IOException iOException) {
                Logger.logMessage(Logger.INFO, (short)16, iOException);
                this.mRemoteHost.setStatus(1, iOException.getMessage());
                Object var6_4 = null;
                if (this.mRemoteHost != null) {
                    this.mRemoteHost.releaseFromWorker();
                    this.mRemoteHost.disconnect();
                }
            }
            catch (Exception exception) {
                this.mRemoteHost.setStatus(1, exception.getMessage());
                Logger.logWarning(exception);
                Object var6_5 = null;
                if (this.mRemoteHost != null) {
                    this.mRemoteHost.releaseFromWorker();
                    this.mRemoteHost.disconnect();
                }
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (this.mRemoteHost != null) {
                this.mRemoteHost.releaseFromWorker();
                this.mRemoteHost.disconnect();
            }
            throw throwable;
        }
    }

    private void handleIncomingConnection() throws Exception {
        ConnectionRequest connectionRequest = this.negotiateHandShakeAsServer();
        if (connectionRequest.getMethod().equals("GNUTELLA CONNECT")) {
            this.mHostMgr.addIncomingHost(this.mRemoteHost);
            this.mSendMgr.queueMsgToSend(this.mRemoteHost, this.mMsgMgr.getMyMsgInit(), false);
            this.processIncomingData();
        } else if (connectionRequest.getMethod().equals("GET")) {
            this.mShareMgr.httpRequestHandler(connectionRequest, this.mRemoteHost);
        } else if (connectionRequest.getMethod().equals("GIV")) {
            Socket socket = this.mRemoteHost.getSock();
            GUID gUID = GUID.createFromHexString(connectionRequest.getHeader("ClientGUID"));
            long l = Long.parseLong(connectionRequest.getHeader("FileIndex"));
            String string = connectionRequest.getHeader("Filename");
            PushHandler.handleIncommingGIV(socket, gUID, l, string);
            this.mRemoteHost = null;
        } else {
            throw new Exception("Unknown incoming request type.");
        }
    }

    private void connectToRemoteHost() throws IOException {
        this.mRemoteHost.setStatus(2, "");
        try {
            Socket socket = this.mConnMgr.connect(this.mRemoteHost.getHostAddress(), ServiceManager.sCfg.mNetConnectionTimeout);
            this.mRemoteHost.setSock(socket);
            this.mRemoteHost.setOs(socket.getOutputStream());
            this.mRemoteHost.setIs(socket.getInputStream());
        }
        catch (UnknownHostException unknownHostException) {
            throw new IOException("Unknown host.");
        }
    }

    private ConnectionRequest connectAndHandShakeOutgoing() throws Exception {
        this.connectToRemoteHost();
        byte[] byArray = this.mRemoteHost.getSock().getLocalAddress().getAddress();
        ServiceManager.getListener().updateLocalAddress(byArray);
        ConnectionRequest connectionRequest = new ConnectionRequest(this.mRemoteHost);
        try {
            try {
                connectionRequest.initializeOutgoingWith06();
            }
            catch (ProtocolNotSupportedException protocolNotSupportedException) {
                Logger.logMessage(Logger.FINE, (short)16, protocolNotSupportedException);
                this.mRemoteHost.disconnect();
                this.connectToRemoteHost();
                connectionRequest.initializeOutgoingWith04();
                Object var5_4 = null;
                this.handleConnectionHeader(connectionRequest);
            }
            Object var5_3 = null;
            this.handleConnectionHeader(connectionRequest);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.handleConnectionHeader(connectionRequest);
            throw throwable;
        }
        return connectionRequest;
    }

    private ConnectionRequest negotiateHandShakeAsServer() throws Exception {
        if (!ServiceManager.getNetworkManager().isNetworkJoined()) {
            throw new Exception("Network not joined.");
        }
        if (IPUtils.isHostInUserIgnoreList(this.mRemoteHost.getHostAddress().getHostName())) {
            throw new IOException("Host is ignored.");
        }
        ConnectionRequest connectionRequest = new ConnectionRequest(this.mRemoteHost);
        try {
            connectionRequest.initializeIncomming();
            Object var3_2 = null;
            this.handleConnectionHeader(connectionRequest);
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.handleConnectionHeader(connectionRequest);
            throw throwable;
        }
        return connectionRequest;
    }

    private void processIncomingData() throws Exception {
        block12: {
            this.mRemoteHost.setStatus(4);
            try {
                block10: while (true) {
                    MsgHeader msgHeader = this.readHeader();
                    byte[] byArray = this.readBody(msgHeader, msgHeader.getDataLen());
                    this.mRemoteHost.incReceivedCount();
                    this.statTracker.incStatMsgCount(1);
                    this.statTracker.incStatTakenCount(msgHeader.getHopsTaken());
                    switch (msgHeader.getFunction()) {
                        case 0: {
                            this.handleInit(msgHeader, byArray);
                            continue block10;
                        }
                        case 1: {
                            this.handleInitResponse(msgHeader, byArray);
                            continue block10;
                        }
                        case 64: {
                            this.handlePushRequest(msgHeader, byArray);
                            continue block10;
                        }
                        case 128: {
                            this.handleQuery(msgHeader, byArray);
                            continue block10;
                        }
                        case 129: {
                            this.handleQueryResponse(msgHeader, byArray);
                            continue block10;
                        }
                    }
                    this.handleUnknown(msgHeader, byArray);
                }
            }
            catch (IOException iOException) {
                Logger.logMessage(Logger.FINEST, (short)16, iOException);
                if (this.mRemoteHost.getSock() != null) {
                    this.mRemoteHost.setStatus(1, iOException.getMessage());
                }
            }
            catch (Exception exception) {
                Logger.logMessage(Logger.WARNING, (short)16, exception);
                if (this.mRemoteHost.getSock() == null) break block12;
                this.mRemoteHost.setStatus(1, exception.getMessage());
            }
        }
    }

    private MsgHeader readHeader() throws Exception {
        InputStream inputStream = this.mRemoteHost.getIs();
        if (inputStream == null) {
            throw new IOException("Connection closed by remote host");
        }
        int n = 0;
        while (n < 23) {
            int n2 = inputStream.read(this.mHeaderBuf, n, 23 - n);
            if (n2 == 0 || n2 == -1) {
                this.mRemoteHost.log(Logger.FINE, "Disconnected from remote host during reading header");
                throw new IOException("Connection closed by remote host");
            }
            n += n2;
        }
        this.statTracker.incBytesCount(n);
        this.mHostMgr.throttleControl(n);
        MsgHeader msgHeader = new MsgHeader(new GUID(true));
        msgHeader.deserialize(this.mHeaderBuf, 0);
        msgHeader.setArrivalTime(System.currentTimeMillis());
        msgHeader.setFromHost(this.mRemoteHost);
        if (msgHeader.getDataLen() > ServiceManager.sCfg.maxTotalBandwidth) {
            if (Logger.isLevelLogged(Logger.WARNING)) {
                byte[] byArray = this.readBody(msgHeader, 262144);
                String string = HexConverter.toHexString(byArray);
                this.mRemoteHost.log(Logger.WARNING, "Body too big. Header: " + msgHeader + "\nBody(256KB): " + string);
            }
            throw new IOException("Packet too big.  Disconnecting the remote host.");
        }
        return msgHeader;
    }

    private byte[] readBody(MsgHeader msgHeader, int n) throws Exception {
        InputStream inputStream = this.mRemoteHost.getIs();
        if (inputStream == null) {
            throw new IOException("Connection closed by remote host");
        }
        int n2 = 0;
        byte[] byArray = this.mBodyBuf.getBuf(n);
        Arrays.fill(byArray, (byte)0);
        while (n2 < n) {
            int n3;
            int n4 = n - n2;
            if (n4 > 1024) {
                n4 = 1024;
            }
            if ((n3 = inputStream.read(byArray, n2, n4)) == 0 || n3 == -1) {
                throw new IOException("Connection closed by remote host");
            }
            n2 += n3;
            this.statTracker.incBytesCount(n3);
            this.mHostMgr.throttleControl(n3);
        }
        return byArray;
    }

    private void handleInit(MsgHeader msgHeader, byte[] byArray) throws Exception {
        if (this.mMsgMgr.checkAndAddMsgSeen(msgHeader)) {
            this.mRemoteHost.log(Logger.FINEST, "Dropping already seen ping");
            this.mRemoteHost.incDropCount();
            this.statTracker.incStatDropCount(1);
            return;
        }
        MsgInit msgInit = new MsgInit(msgHeader);
        msgInit.deserialize(byArray, 0);
        this.mMsgMgr.addToRoutingTable(msgInit.getHeader().getMsgID(), this.mRemoteHost);
        this.mMsgMgr.forwardMsg(msgInit, this.mRemoteHost);
        Listener listener = ServiceManager.getListener();
        int n = msgInit.getHeader().getTTL();
        int n2 = msgInit.getHeader().getHopsTaken();
        if (n + n2 > 2 && !this.mHostMgr.hasIncommingSlotsAvailable()) {
            return;
        }
        MsgHeader msgHeader2 = new MsgHeader(msgHeader.getMsgID());
        MsgInitResponse msgInitResponse = new MsgInitResponse(msgHeader2);
        msgHeader2.setTTL(msgHeader.getHopsTaken() + 1);
        msgInitResponse.setPort((short)listener.getLocalAddress().getPort());
        msgInitResponse.setIP(listener.getLocalAddress().getHostIP());
        msgInitResponse.setFileCount(this.fileAdministration.getFileCount());
        msgInitResponse.setTotalSize(this.fileAdministration.getTotalFileSizeInKb());
        this.mSendMgr.queueMsgToSend(this.mRemoteHost, msgInitResponse, false);
    }

    private void handleInitResponse(MsgHeader msgHeader, byte[] byArray) throws Exception {
        Object object;
        MsgInitResponse msgInitResponse = new MsgInitResponse(msgHeader);
        msgInitResponse.deserialize(byArray, 0);
        if (msgInitResponse.getPort() < 0) {
            if (Logger.isLevelLogged(Logger.WARNING)) {
                object = HexConverter.toHexString(byArray);
                this.mRemoteHost.log(Logger.WARNING, "Pong with negative Port. Port: " + msgInitResponse.getPort() + "\nBody: " + (String)object);
            }
        } else {
            object = new HostAddress(msgInitResponse.getIP(), (int)msgInitResponse.getPort());
            if (!IPUtils.isHostInUserInvalidList((HostAddress)object)) {
                this.mHostMgr.addCaughtHost((HostAddress)object, (short)1);
            }
        }
        object = this.mMsgMgr.getMyMsgInit();
        if (msgInitResponse.getHeader().getMsgID().equals(((MsgInit)object).getHeader().getMsgID())) {
            this.statTracker.incStatHosts(1);
            this.statTracker.incStatFiles(msgInitResponse.getFileCount());
            this.statTracker.incStatSize(msgInitResponse.getTotalSize());
            return;
        }
        if (this.mRemoteHost.checkPingResponse(msgInitResponse)) {
            return;
        }
        Host host = this.mMsgMgr.getRouting(msgInitResponse.getHeader().getMsgID());
        if (host == null) {
            return;
        }
        if (this.mMsgMgr.decTTL(msgInitResponse)) {
            return;
        }
        this.mSendMgr.queueMsgToSend(host, msgInitResponse, false);
    }

    private void handleQuery(MsgHeader msgHeader, byte[] byArray) throws UnknownHostException {
        if (this.mMsgMgr.checkAndAddMsgSeen(msgHeader)) {
            this.mRemoteHost.log(Logger.FINEST, "Dropping already seen query");
            this.mRemoteHost.incDropCount();
            this.statTracker.incStatDropCount(1);
            return;
        }
        int n = msgHeader.getDataLen();
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        MsgQuery msgQuery = new MsgQuery(msgHeader, byArray2);
        this.mMsgMgr.addToRoutingTable(msgQuery.getHeader().getMsgID(), this.mRemoteHost);
        this.queryHistory.addSearchQuery(msgQuery);
        this.mMsgMgr.forwardMsg(msgQuery, this.mRemoteHost);
        ShareFile[] shareFileArray = this.mShareMgr.handleQuery(msgQuery);
        if (shareFileArray.length == 0) {
            return;
        }
        this.replyToQuery(msgHeader, shareFileArray);
    }

    private void replyToQuery(MsgHeader msgHeader, ShareFile[] shareFileArray) throws UnknownHostException {
        MsgHeader msgHeader2 = new MsgHeader(msgHeader.getMsgID());
        msgHeader2.setTTL(Math.min(10, msgHeader.getHopsTaken() + 5));
        int n = shareFileArray.length;
        if (n > 255) {
            n = 255;
        }
        ShareFile shareFile = null;
        MsgResRecord[] msgResRecordArray = new MsgResRecord[n];
        int n2 = 0;
        while (n2 < n) {
            MsgResRecord msgResRecord;
            shareFile = shareFileArray[n2];
            msgResRecordArray[n2] = msgResRecord = new MsgResRecord(shareFile.getFileIndex(), shareFile.getURN(), (int)shareFile.getFileSize(), shareFile.getEffectiveName());
            ++n2;
        }
        Listener listener = ServiceManager.getListener();
        HostAddress hostAddress = listener.getLocalAddress();
        MsgQueryResponse msgQueryResponse = new MsgQueryResponse(msgHeader2, this.mManager.getClientID(), hostAddress, Math.round((long)ServiceManager.sCfg.mUploadMaxBandwidth / 1024L), msgResRecordArray);
        this.mSendMgr.queueMsgToSend(this.mRemoteHost, msgQueryResponse, false);
    }

    private void handleQueryResponse(MsgHeader msgHeader, byte[] byArray) throws Exception {
        int n = msgHeader.getDataLen();
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        MsgQueryResponse msgQueryResponse = new MsgQueryResponse(msgHeader, byArray2);
        this.mMsgMgr.addToPushRoutingTable(msgQueryResponse.getRemoteClientID(), this.mRemoteHost);
        this.mMsgMgr.processQueryResponse(this.mRemoteHost, msgQueryResponse);
        Host host = this.mMsgMgr.getRouting(msgQueryResponse.getHeader().getMsgID());
        if (host == null) {
            return;
        }
        if (this.mMsgMgr.decTTL(msgQueryResponse)) {
            return;
        }
        this.mSendMgr.queueMsgToSend(host, msgQueryResponse, false);
    }

    private void handlePushRequest(MsgHeader msgHeader, byte[] byArray) throws Exception {
        MsgPushRequest msgPushRequest = new MsgPushRequest(msgHeader);
        msgPushRequest.deserialize(byArray, 0);
        if (this.mManager.getClientID().equals(msgPushRequest.getClientGUID())) {
            new PushWorker(msgPushRequest);
            return;
        }
        Host host = this.mMsgMgr.getPushRouting(msgPushRequest.getClientGUID());
        if (host == null) {
            return;
        }
        if (this.mMsgMgr.decTTL(msgPushRequest)) {
            return;
        }
        this.mSendMgr.queueMsgToSend(host, msgPushRequest, false);
    }

    private void handleUnknown(MsgHeader msgHeader, byte[] byArray) throws Exception {
        this.mRemoteHost.log(Logger.FINER, "Dropping unknown message.");
        this.mRemoteHost.log(Logger.FINEST, "Header: " + msgHeader + " Body: " + new String(byArray) + " (" + HexConverter.toHexString(byArray) + ").");
        this.mRemoteHost.incDropCount();
        this.statTracker.incStatDropCount(1);
    }

    private void handleConnectionHeader(ConnectionRequest connectionRequest) {
        String string = connectionRequest.getHeader("X-TRY");
        this.handleXTryHosts(string, true);
        string = connectionRequest.getHeader("X-TRY-ULTRAPEERS");
        this.handleXTryHosts(string, false);
    }

    private void handleXTryHosts(String string, boolean bl) {
        if (string == null) {
            return;
        }
        short s = bl ? (short)0 : 1;
        CaughtHostsContainer caughtHostsContainer = ServiceManager.getHostManager().getCaughtHostsContainer();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            HostAddress hostAddress;
            String string2 = stringTokenizer.nextToken().trim();
            byte[] byArray = HostAddress.parseIP(string2);
            if (byArray == null || IPUtils.isHostInUserInvalidList(hostAddress = new HostAddress(byArray, HostAddress.parsePort(string2)))) continue;
            Logger.logMessage(Logger.FINEST, (short)16, "Adding X-Try address: " + string2);
            caughtHostsContainer.addCaughtHost(hostAddress, s);
        }
    }
}

