/*
 * Decompiled with CFR 0.152.
 */
package phex.common;

public class URN {
    public static final String SHA1 = "sha1";
    public static final String URN_PREFIX = "urn:";
    private int hashCode = -1;
    private String urnString;
    private String urnNID;
    private String urnNSS;

    public URN(String string) {
        if (!string.regionMatches(true, 0, URN_PREFIX, 0, URN_PREFIX.length())) {
            throw new IllegalArgumentException("URN not valid: " + string);
        }
        int n = string.indexOf(58, 4);
        if (n == -1) {
            throw new IllegalArgumentException("URN not valid: " + string);
        }
        this.urnNID = string.substring(4, n);
        if (!URN.isValidNamespaceIdentifier(this.urnNID)) {
            throw new IllegalArgumentException("URN not valid (NID): " + string);
        }
        this.urnNSS = string.substring(n + 1, string.length());
        if (!URN.isValidNamespaceSpecificString(this.urnNSS)) {
            throw new IllegalArgumentException("URN not valid (NSS): " + string);
        }
        this.urnString = string;
    }

    public boolean isSha1Nid() {
        return SHA1.equalsIgnoreCase(this.urnNID);
    }

    public String getNamespaceSpecificString() {
        return this.urnNSS;
    }

    public String getAsString() {
        return this.urnString;
    }

    public boolean equals(Object object) {
        if (object instanceof URN) {
            return this.equals((URN)object);
        }
        return false;
    }

    public boolean equals(URN uRN) {
        return uRN.urnString.equalsIgnoreCase(this.urnString);
    }

    public int hashCode() {
        if (this.hashCode == -1) {
            this.hashCode = 3 * (this.urnString.hashCode() + this.getClass().hashCode());
        }
        return this.hashCode;
    }

    public static boolean isValidURN(String string) {
        if (!string.regionMatches(true, 0, URN_PREFIX, 0, URN_PREFIX.length())) {
            return false;
        }
        int n = string.indexOf(58, 4);
        if (n == -1) {
            return false;
        }
        String string2 = string.substring(4, n);
        if (!URN.isValidNamespaceIdentifier(string2)) {
            return false;
        }
        String string3 = string.substring(n + 1, string.length());
        return URN.isValidNamespaceSpecificString(string3);
    }

    public static boolean isValidNamespaceSpecificString(String string) {
        int n = string.length();
        return n == 32;
    }

    public static boolean isValidNamespaceIdentifier(String string) {
        return string.equalsIgnoreCase(SHA1);
    }

    public static void main(String[] stringArray) {
        System.out.println("valid");
        System.out.println(URN.isValidURN("urn:sha1:PLSTHIPQGSSZTS5FJUPAKUZWUGYQYPFB"));
        System.out.println(URN.isValidURN("urn:SHA1:PLSTHIPQGSSZTS5FJUPAKUZWUGYQYPFB"));
        System.out.println("invalid");
        System.out.println(URN.isValidURN("urn:blub:PLSTHIPQGSSZTS5FJUPAKUZWUGYQYPFB"));
        System.out.println(URN.isValidURN("urt:sha1:PLSTHIPQGSSZTS5FJUPAKUZWUGYQYPFB"));
        System.out.println(URN.isValidURN("urn:sha1:PLSTHIPQGSSZTS5FUPAKUZWUGYQYPFB"));
        System.out.println(URN.isValidURN("urn:sha1PLSTHIPQGSSZTS5FJUPAKUZWUGYQYPFB"));
    }
}

