/*
 * Decompiled with CFR 0.152.
 */
package phex.config;

import java.awt.Font;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.UIManager;
import phex.GUID;
import phex.Res;
import phex.ServiceManager;
import phex.utils.FileUtils;
import phex.utils.IPUtils;
import phex.utils.Logger;
import phex.utils.StrUtil;
import phex.utils.VersionUtils;

public class Cfg {
    public static final int DEFAULT_SOCKS5_PORT = 1080;
    public static final int DEFAULT_HTTP_PORT = 80;
    public static final int DEFAULT_MAX_MESSAGE_LENGTH = 65536;
    public static final short DEFAULT_LOGGER_VERBOSE_LEVEL = 6;
    public static final boolean DEFAULT_ENABLE_HIT_SNOOPING = false;
    public static final int UNLIMITED_BANDWIDTH = Integer.MAX_VALUE;
    public static int MIN_SEARCH_TERM_LENGTH = 2;
    public static final String sGeneralNetwork = "<General Gnutella Network>";
    public GUID mProgramClientID = new GUID();
    public String mMyIP = "";
    public int mListeningPort = -1;
    public int mMaxDownload = 4;
    public int mMaxDownloadPerIP = 1;
    public int mMaxUpload = 4;
    public int mMaxUploadPerIP = 1;
    public int mUploadMaxBandwidth = 102400;
    public int mNetTTL = 5;
    public int mNetMaxTTL = 7;
    public int mNetMaxHostToCatch = 5000;
    public int mNetMaxSendQueue = 500;
    public int mPingFrequency = 15000;
    public int mPingTimeout = 60000;
    public int mSearchMaxSearch = 2000;
    public int mSearchMaxConcurrent = 10;
    public String mSearchFilter = "";
    public int mNetMaxConnection = 6;
    public int mNetMaxRate = 50000;
    public int mDownloadMaxBandwidth = 102400;
    public boolean mDownloadAutoRemoveCompleted = false;
    public String mDownloadDir = ".";
    public int mDownloadMaxRetry = 999;
    public int mDownloadRetryWait = 30000;
    public String mDownloadSaveFile = "";
    public String gWebCacheFilename = "";
    public String autoConnectHostsFilename = "";
    public String mXMLDownloadSaveFile = "";
    public String xmlResearchServiceFilename = "";
    public String xmlGUISettingsFilename = "";
    public boolean mAutoConnect = true;
    public int mNetMinConn = 4;
    public boolean mAutoCleanup = true;
    public int mUploadMaxSearch = 100;
    public boolean mShareBrowseDir = true;
    public int mPushTransferTimeout = 30000;
    public ArrayList mNetIgnoredHosts;
    public Vector mNetInvalidHosts = new Vector();
    public Vector mFilteredSearchHosts = new Vector();
    public boolean mApplyFilterdHosts = false;
    public String mCurrentNetwork = "<General Gnutella Network>";
    public Vector mNetNetworkHistory = new Vector();
    public boolean mAutoJoin = true;
    public boolean mDisconnectApplyPolicy = true;
    public int mDisconnectDropRatio = 70;
    public int mDisconnectLatency = 60000;
    public boolean mProxyUse = false;
    public String mProxyHost = "";
    public int mProxyPort = 1080;
    public boolean useProxyAuthentication = false;
    public String mProxyUserName = "";
    public String mProxyPassword = "";
    public Font mFontMenu = new Font("Dialog", 0, 11);
    public Font mFontLabel = new Font("Dialog", 0, 11);
    public Font mFontTable = new Font("Dialog", 0, 11);
    public String mFindText = "";
    public boolean mFindMatchCase = false;
    public boolean mFindDown = true;
    public boolean mUIDisplayTooltip = true;
    public String mLFClassName;
    public String mUserName = "(noname)";
    public String mUploadDir = "";
    public String mUploadFileExclusions = "";
    public String mUploadFileInclusions = "*";
    public boolean mUploadScanRecursively = true;
    public boolean mUploadAutoRemoveCompleted = false;
    public String mHostFile = "";
    public String mLogFile = "";
    public String mSearchLastSearch = "";
    public int mSearchMinSpeed = 0;
    public boolean mPhexPingResponse = true;
    public boolean monitorSearchHistory = false;
    public int searchHistoryLength = 10;
    public long mMinimumFileSize = 0L;
    public long mMaximumFileSize = Long.MAX_VALUE;
    public boolean connectedToLAN = true;
    public long minimumFileSizeMultiplier = 1024L;
    public boolean minimizeToBackground = true;
    public boolean showCloseOptionsDialog = true;
    public String incompleteDir = ".";
    public ArrayList filteredCatcherPorts = new ArrayList();
    public short maxWorkerPerDownload = (short)3;
    public short maxTotalDownloadWorker = (short)6;
    public short maxFailedConnectionsInARow = (short)10;
    public int networkSpeedKbps = 256;
    public int maxTotalBandwidth = 16384;
    public String runningPhexVersion = "";
    public boolean isBehindFirewall = false;
    public boolean isHttpProxyUsed = false;
    public String httpProxyHost = "";
    public int httpProxyPort = 80;
    public String lastUpdateCheckVersion = "0";
    public long lastUpdateCheckTime = 0L;
    public boolean showUpdateNotification = true;
    public int mSocketTimeout = 120000;
    public int privateSocketTimeout = 2000;
    public int mNetConnectionTimeout = 30000;
    public int searchRetryTimeout = 30000;
    public short loggerVerboseLevel;
    public short logType = 1;
    public boolean logToConsole = false;
    public long maxLogFileLength = 524288L;
    public boolean enableHitSnooping;
    public int maxMessageLength;
    public ArrayList mSearchFilterTokens;
    private String mCfgFilename;
    private Properties mSetting = new Properties();

    private Cfg() {
    }

    public Cfg(String string) {
        this.mCfgFilename = string;
    }

    public String getConfigFilename() {
        return this.mCfgFilename;
    }

    public void load() {
        Object object;
        this.loadDefaultValues();
        try {
            object = new FileInputStream(this.mCfgFilename);
            this.mSetting.load((InputStream)object);
            ((FileInputStream)object).close();
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (Exception exception) {
            Logger.logError(exception);
        }
        this.deserializeSimpleFields();
        this.deserializeComplexFields();
        this.breakSearchFilter();
        this.handlePhexVersionAdjustments();
        if (this.mListeningPort == -1) {
            object = new Random(System.currentTimeMillis());
            this.mListeningPort = ((Random)object).nextInt();
            this.mListeningPort = this.mListeningPort < 0 ? -this.mListeningPort : this.mListeningPort;
            this.mListeningPort %= 8000;
            this.mListeningPort += 2000;
        }
        this.updateHTTPProxySettings();
        if (this.mLFClassName == null) {
            this.mLFClassName = ServiceManager.isMacOSX() ? UIManager.getSystemLookAndFeelClassName() : UIManager.getCrossPlatformLookAndFeelClassName();
        }
        object = new File(this.mDownloadDir);
        ((File)object).mkdirs();
        object = new File(this.incompleteDir);
        ((File)object).mkdirs();
    }

    public void save() {
        ((Hashtable)this.mSetting).clear();
        this.serializeSimpleFields();
        this.serializeComplexField();
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.mCfgFilename);
            this.mSetting.store(fileOutputStream, "PHEX Config Values");
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            Logger.logError(iOException);
        }
    }

    private void loadDefaultValues() {
        this.enableHitSnooping = false;
        this.maxMessageLength = 65536;
        this.loggerVerboseLevel = (short)6;
    }

    private String get(String string) {
        String string2 = (String)((Hashtable)this.mSetting).get(string);
        if (string2 != null) {
            string2 = string2.trim();
        }
        return string2;
    }

    private String get(String string, String string2) {
        String string3 = this.get(string);
        if (string3 == null) {
            return string2;
        }
        return string3;
    }

    private boolean getBool(String string, boolean bl) {
        return this.get(string, bl ? "true" : "false").equals("true");
    }

    private void set(String string, String string2) {
        if (string2 != null) {
            ((Hashtable)this.mSetting).put(string, string2);
        }
    }

    private void set(String string, long l) {
        ((Hashtable)this.mSetting).put(string, String.valueOf(l));
    }

    private void set(String string, boolean bl) {
        ((Hashtable)this.mSetting).put(string, bl ? "true" : "false");
    }

    private void breakSearchFilter() {
        StringTokenizer stringTokenizer = new StringTokenizer(this.mSearchFilter);
        if (!stringTokenizer.hasMoreTokens()) {
            return;
        }
        if (this.mSearchFilterTokens == null) {
            this.mSearchFilterTokens = new ArrayList(stringTokenizer.countTokens());
        } else {
            this.mSearchFilterTokens.clear();
            this.mSearchFilterTokens.ensureCapacity(stringTokenizer.countTokens());
        }
        while (stringTokenizer.hasMoreTokens()) {
            this.mSearchFilterTokens.add(stringTokenizer.nextToken());
        }
        this.mSearchFilterTokens.trimToSize();
    }

    private void serializeSimpleFields() {
        Field[] fieldArray = this.getClass().getDeclaredFields();
        int n = 0;
        while (n < fieldArray.length) {
            String string = fieldArray[n].getName();
            int n2 = fieldArray[n].getModifiers();
            Class<?> clazz = fieldArray[n].getType();
            if (Modifier.isPublic(n2) && !Modifier.isTransient(n2) && !Modifier.isStatic(n2)) {
                try {
                    if (clazz.getName().equals("int")) {
                        this.set(string, fieldArray[n].getInt(this));
                    } else if (clazz.getName().equals("short")) {
                        this.set(string, fieldArray[n].getShort(this));
                    } else if (clazz.getName().equals("long")) {
                        this.set(string, fieldArray[n].getLong(this));
                    } else if (clazz.getName().equals("boolean")) {
                        this.set(string, fieldArray[n].getBoolean(this));
                    } else if (clazz.getName().equals("java.lang.String")) {
                        this.set(string, (String)fieldArray[n].get(this));
                    }
                }
                catch (Exception exception) {
                    Logger.logError(exception, "Error in field: " + string);
                }
            }
            ++n;
        }
    }

    private void serializeComplexField() {
        try {
            this.set("mProgramClientID", this.mProgramClientID.toHexString());
            StringBuffer stringBuffer = new StringBuffer(16 * this.mNetIgnoredHosts.size());
            int n = 0;
            while (n < this.mNetIgnoredHosts.size()) {
                String[] stringArray = (String[])this.mNetIgnoredHosts.get(n);
                stringBuffer.append(stringArray[0]);
                stringBuffer.append('.');
                stringBuffer.append(stringArray[1]);
                stringBuffer.append('.');
                stringBuffer.append(stringArray[2]);
                stringBuffer.append('.');
                stringBuffer.append(stringArray[3]);
                stringBuffer.append(' ');
                ++n;
            }
            this.set("mNetIgnoredHosts", stringBuffer.toString());
            stringBuffer.setLength(0);
            int n2 = 0;
            while (n2 < this.mFilteredSearchHosts.size()) {
                String[] stringArray = (String[])this.mFilteredSearchHosts.elementAt(n2);
                stringBuffer.append(stringArray[0]);
                stringBuffer.append('.');
                stringBuffer.append(stringArray[1]);
                stringBuffer.append('.');
                stringBuffer.append(stringArray[2]);
                stringBuffer.append('.');
                stringBuffer.append(stringArray[3]);
                stringBuffer.append(' ');
                ++n2;
            }
            this.set("mFilteredSearchHosts", stringBuffer.toString());
            stringBuffer.setLength(0);
            int n3 = 0;
            while (n3 < this.mNetInvalidHosts.size()) {
                String[] stringArray = (String[])this.mNetInvalidHosts.elementAt(n3);
                stringBuffer.append(stringArray[0]);
                stringBuffer.append('.');
                stringBuffer.append(stringArray[1]);
                stringBuffer.append('.');
                stringBuffer.append(stringArray[2]);
                stringBuffer.append('.');
                stringBuffer.append(stringArray[3]);
                stringBuffer.append(' ');
                ++n3;
            }
            this.set("mNetInvalidHosts", stringBuffer.toString());
            int n4 = this.filteredCatcherPorts.size();
            stringBuffer.setLength(0);
            int n5 = 0;
            while (n5 < n4) {
                stringBuffer.append((String)this.filteredCatcherPorts.get(n5));
                stringBuffer.append(" ");
                ++n5;
            }
            this.set("filteredCatcherPorts", stringBuffer.toString());
            stringBuffer.setLength(0);
            int n6 = 0;
            while (n6 < this.mNetNetworkHistory.size()) {
                stringBuffer.append(this.mNetNetworkHistory.elementAt(n6));
                stringBuffer.append(" ");
                ++n6;
            }
            this.set("mNetNetworkHistory", stringBuffer.toString());
            this.set("mFontMenu", this.mFontMenu.getName() + ";" + this.mFontMenu.getStyle() + ";" + this.mFontMenu.getSize());
            this.set("mFontLabel", this.mFontLabel.getName() + ";" + this.mFontLabel.getStyle() + ";" + this.mFontLabel.getSize());
            this.set("mFontTable", this.mFontTable.getName() + ";" + this.mFontTable.getStyle() + ";" + this.mFontTable.getSize());
            this.breakSearchFilter();
        }
        catch (Exception exception) {
            Logger.logError(exception);
        }
    }

    private void deserializeSimpleFields() {
        Field[] fieldArray = this.getClass().getDeclaredFields();
        int n = 0;
        while (n < fieldArray.length) {
            String string = fieldArray[n].getName();
            int n2 = fieldArray[n].getModifiers();
            Class<?> clazz = fieldArray[n].getType();
            String string2 = "";
            if (Modifier.isPublic(n2) && !Modifier.isTransient(n2) && !Modifier.isStatic(n2)) {
                try {
                    string2 = this.get(string);
                    if (string2 != null) {
                        if (clazz.getName().equals("int")) {
                            fieldArray[n].setInt(this, Integer.parseInt(string2));
                        } else if (clazz.getName().equals("short")) {
                            fieldArray[n].setShort(this, Short.parseShort(string2));
                        } else if (clazz.getName().equals("long")) {
                            fieldArray[n].setLong(this, Long.parseLong(string2));
                        } else if (clazz.getName().equals("boolean")) {
                            fieldArray[n].setBoolean(this, string2.equals("true"));
                        } else if (clazz.getName().equals("java.lang.String")) {
                            fieldArray[n].set(this, string2);
                        }
                    }
                }
                catch (Exception exception) {
                    Logger.logError(exception, "Error in field: " + string + ", value: " + string2);
                }
            }
            ++n;
        }
    }

    private void deserializeComplexFields() {
        try {
            try {
                this.mProgramClientID.fromHexString(this.get("mProgramClientID"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            String string = this.get("mNetIgnoredHosts", "");
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            if (this.mNetIgnoredHosts == null) {
                this.mNetIgnoredHosts = new ArrayList(stringTokenizer.countTokens());
            } else {
                this.mNetIgnoredHosts.clear();
                this.mNetInvalidHosts.ensureCapacity(stringTokenizer.countTokens());
            }
            while (stringTokenizer.hasMoreTokens()) {
                this.mNetIgnoredHosts.add(IPUtils.splitIP2Parts(stringTokenizer.nextToken()));
            }
            this.mNetInvalidHosts.trimToSize();
            String string2 = this.get("mFilteredSearchHosts", "");
            if (string2 == null) {
                this.mFilteredSearchHosts = Cfg.getDefaultFilteredHosts();
            } else {
                stringTokenizer = new StringTokenizer(string2);
                while (stringTokenizer.hasMoreTokens()) {
                    this.mFilteredSearchHosts.addElement(IPUtils.splitIP2Parts(stringTokenizer.nextToken()));
                }
            }
            String string3 = this.get("mNetInvalidHosts");
            if (string3 == null) {
                this.mNetInvalidHosts = Cfg.getDefaultInvalidHosts();
            } else {
                stringTokenizer = new StringTokenizer(string3);
                while (stringTokenizer.hasMoreTokens()) {
                    this.mNetInvalidHosts.addElement(IPUtils.splitIP2Parts(stringTokenizer.nextToken()));
                }
            }
            String string4 = this.get("filteredCatcherPorts");
            if (string4 != null) {
                stringTokenizer = new StringTokenizer(string4, " ");
                while (stringTokenizer.hasMoreTokens()) {
                    this.filteredCatcherPorts.add(stringTokenizer.nextToken());
                }
            }
            String string5 = this.get("mNetNetworkHistory", "");
            stringTokenizer = new StringTokenizer(string5);
            while (stringTokenizer.hasMoreTokens()) {
                this.mNetNetworkHistory.addElement(stringTokenizer.nextToken());
            }
            String string6 = this.get("mFontMenu");
            if (string6 != null) {
                try {
                    stringTokenizer = new StringTokenizer(string6, ";");
                    this.mFontMenu = new Font(stringTokenizer.nextToken(), Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((string6 = this.get("mFontLabel")) != null) {
                try {
                    stringTokenizer = new StringTokenizer(string6, ";");
                    this.mFontLabel = new Font(stringTokenizer.nextToken(), Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((string6 = this.get("mFontTable")) != null) {
                try {
                    stringTokenizer = new StringTokenizer(string6, ";");
                    this.mFontTable = new Font(stringTokenizer.nextToken(), Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()));
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exception) {
            Logger.logError(exception);
        }
    }

    public static Vector getDefaultInvalidHosts() {
        Vector<String[]> vector = new Vector<String[]>();
        vector.addElement(IPUtils.splitIP2Parts("0.0.0.0"));
        vector.addElement(IPUtils.splitIP2Parts("255.*.*.*"));
        vector.addElement(IPUtils.splitIP2Parts("10.0.0.*"));
        vector.addElement(IPUtils.splitIP2Parts("172.16.*.*"));
        vector.addElement(IPUtils.splitIP2Parts("192.168.*.*"));
        return vector;
    }

    public static Vector getDefaultFilteredHosts() {
        Vector<String[]> vector = new Vector<String[]>();
        vector.addElement(IPUtils.splitIP2Parts("0.0.0.0"));
        vector.addElement(IPUtils.splitIP2Parts("255.*.*.*"));
        vector.addElement(IPUtils.splitIP2Parts("10.0.0.*"));
        vector.addElement(IPUtils.splitIP2Parts("172.16.*.*"));
        vector.addElement(IPUtils.splitIP2Parts("192.168.*.*"));
        return vector;
    }

    public void updateHTTPProxySettings() {
        System.setProperty("http.agent", StrUtil.getAppNameVersion());
        if (this.isHttpProxyUsed) {
            System.setProperty("http.proxyHost", this.httpProxyHost);
            System.setProperty("http.proxyPort", String.valueOf(this.httpProxyPort));
        } else {
            System.setProperty("http.proxyHost", "");
            System.setProperty("http.proxyPort", "");
        }
    }

    private void handlePhexVersionAdjustments() {
        if (this.runningPhexVersion == null || this.runningPhexVersion.length() == 0) {
            if (this.mNetMaxHostToCatch < 5000) {
                this.mNetMaxHostToCatch = 5000;
            }
            this.runningPhexVersion = "0.6";
        }
        if (VersionUtils.compare("0.6.2", this.runningPhexVersion) > 0) {
            this.updatesFor0_6_2();
        }
        if (VersionUtils.compare("0.6.4", this.runningPhexVersion) > 0) {
            this.updatesFor0_6_4();
        }
        if (VersionUtils.compare("0.7", this.runningPhexVersion) > 0) {
            this.updatesFor0_7();
        }
        this.runningPhexVersion = Res.getStr("Program.Version");
        this.save();
    }

    private void updatesFor0_6_2() {
        int n;
        Logger.logMessage(Logger.FINE, (short)255, "Updating to 0.6.2");
        this.useProxyAuthentication = this.mProxyUserName.length() > 0;
        int n2 = Math.max(this.mNetMaxRate, Math.max(this.mUploadMaxBandwidth, this.mDownloadMaxBandwidth));
        this.networkSpeedKbps = n = n2 / 1024 * 8;
        this.maxTotalBandwidth = n2;
        this.runningPhexVersion = "0.6.2";
    }

    private void updatesFor0_6_4() {
        Logger.logMessage(Logger.FINE, (short)255, "Updating to 0.6.4");
        this.incompleteDir = this.mDownloadDir;
        this.runningPhexVersion = "0.6.4";
    }

    private void updatesFor0_7() {
        try {
            File file;
            String string = this.mXMLDownloadSaveFile;
            if (string == null || string.length() == 0) {
                string = ServiceManager.XML_DOWNLOAD_FILE_NAME;
            }
            if ((file = new File(string = ServiceManager.envSubstitution(string))).exists()) {
                FileUtils.copyFile(file, new File(string + ".v0.6.4"));
            }
        }
        catch (IOException iOException) {
            Logger.logError(iOException);
        }
        this.runningPhexVersion = "0.7";
    }
}

