/*
 * Decompiled with CFR 0.152.
 */
package phex.connection;

import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import phex.FlexBuf;
import phex.HttpRequest;
import phex.ServiceManager;
import phex.common.HandshakeHeaders;
import phex.connection.ConnectionRejectedException;
import phex.connection.ProtocolNotSupportedException;
import phex.host.Host;
import phex.utils.IOUtil;
import phex.utils.Logger;
import phex.utils.VersionUtils;

public class ConnectionRequest
extends HttpRequest {
    private static final String PROTOCOL_04 = "0.4";
    private static final String PROTOCOL_06 = "0.6";
    private static final String GNUTELLA_06 = "GNUTELLA/0.6";
    private static final String GNUTELLA_06_200 = "GNUTELLA/0.6 200";
    private static final String GNUTELLA_OK_04 = "GNUTELLA OK";
    private static final String GNUTELLA_OK_06 = "GNUTELLA/0.6 200 OK";
    public static final String sGnutellaConnect = "GNUTELLA CONNECT";
    public static final String GET_REQUEST_PREFIX = "GET ";
    public static final String GET_REQUEST = "GET";
    public static final String GIV_REQUEST_PREFIX = "GIV ";
    public static final String GIV_REQUEST = "GIV";
    private static final String sPasswordChallege = "GNUTELLA AUTHENTICATION CHALLENGE";
    private static final String sPasswordReply = "GNUTELLA AUTHENTICATION RESPONSE";
    private static final String sAuthFailed = "GNUTELLA AUTHENTICATION FAILED";
    private Host remoteHost;
    private FlexBuf flexBuffer;

    public ConnectionRequest(Host host) throws Exception {
        this.remoteHost = host;
        this.flexBuffer = new FlexBuf();
    }

    public void initializeIncomming() throws Exception {
        InputStream inputStream = this.remoteHost.getIs();
        if (inputStream == null) {
            throw new IOException("Disconnected from remote host during initial handshake");
        }
        String string = this.readLineFromHost();
        Logger.logMessage(Logger.FINE, (short)16, "ConnectionRequest " + string);
        String string2 = ServiceManager.getNetworkManager().getGreeting();
        if (!string.startsWith(string2 + "/")) {
            if (string.startsWith(GET_REQUEST_PREFIX)) {
                this.setMethod(GET_REQUEST);
                int n = string.indexOf("/");
                this.setUri(string.substring(n));
                int n2 = string.indexOf("HTTP/") + 5;
                this.setVersion(string.substring(n2, string.length()));
                return;
            }
            if (string.startsWith(GIV_REQUEST_PREFIX)) {
                this.setMethod(GIV_REQUEST);
                String string3 = string.substring(4);
                StringTokenizer stringTokenizer = new StringTokenizer(string3, ":");
                this.putHeader("FileIndex", stringTokenizer.nextToken());
                StringTokenizer stringTokenizer2 = new StringTokenizer(stringTokenizer.nextToken(), "/");
                this.putHeader("ClientGUID", stringTokenizer2.nextToken());
                this.putHeader("Filename", URLDecoder.decode(stringTokenizer2.nextToken()));
                return;
            }
            throw new Exception("Can't handle request: " + string);
        }
        this.handleGnutellaConnect(string);
    }

    public void initializeOutgoingWith06() throws IOException {
        String string;
        int n;
        this.remoteHost.setStatus(2, "Negotiate 0.6 handshake.");
        String string2 = ServiceManager.getNetworkManager().getGreeting();
        String string3 = string2 + '/' + PROTOCOL_06 + "\r\n";
        this.sendStringToHost(string3);
        this.sendHeadersToHost(HandshakeHeaders.OPEN_HEADERS);
        String string4 = null;
        try {
            string4 = this.readLineFromHost();
            if (!string4.startsWith(GNUTELLA_06)) {
                throw new ProtocolNotSupportedException("Bad protocol response on " + string3 + ". Response: " + string4);
            }
        }
        catch (IOException iOException) {
            Logger.logMessage(Logger.FINEST, (short)16, iOException);
            throw new ProtocolNotSupportedException("Can't connect with " + string3 + ". Response: " + string4);
        }
        this.readHeaders(this.remoteHost.getIs());
        this.configureRemoteHost();
        try {
            String string5 = string4.substring(GNUTELLA_06.length()).trim();
            int n2 = string5.indexOf(32);
            n = Integer.parseInt(string5.substring(0, n2));
            string = string5.substring(n2).trim();
        }
        catch (Exception exception) {
            Logger.logWarning((short)16, exception, "Error parsing response: '" + string4 + "' for request: '" + string3 + "'.");
            throw new ConnectionRejectedException("Error parsing response: '" + string4 + "' for request: '" + string3 + "'.");
        }
        if (n != 200) {
            throw new ConnectionRejectedException("Gnutella 0.6 connection rejected. Status: " + n + " - " + string);
        }
        this.sendStringToHost("GNUTELLA/0.6 200 OK\r\n");
        this.sendHeadersToHost(HandshakeHeaders.EMPTY_HEADERS);
    }

    public void initializeOutgoingWith04() throws IOException {
        this.remoteHost.setStatus(2, "Negotiate 0.4 handshake.");
        String string = ServiceManager.getNetworkManager().getGreeting();
        String string2 = string + '/' + PROTOCOL_04 + "\r\n";
        this.sendStringToHost(string2);
        String string3 = null;
        try {
            string3 = this.readLineFromHost();
            if (!string3.equals(GNUTELLA_OK_04) && !string3.startsWith(GNUTELLA_OK_06)) {
                throw new ProtocolNotSupportedException("Bad protocol response on " + string2 + ". Response: " + string3);
            }
        }
        catch (IOException iOException) {
            throw new ProtocolNotSupportedException("Can't connect with " + string2 + ". Response: " + string3);
        }
    }

    private void handleGnutellaConnect(String string) throws Exception {
        if (!ServiceManager.getHostManager().hasIncommingSlotsAvailable()) {
            throw new IOException("No free slots.");
        }
        this.setMethod(sGnutellaConnect);
        int n = string.lastIndexOf(47) + 1;
        String string2 = string.substring(n, string.length());
        this.setVersion(string2);
        if (string2.equals(PROTOCOL_04)) {
            this.sendStringToHost("GNUTELLA OK\n\n");
        } else if (this.is06orHigher(string2)) {
            this.readHeaders(this.remoteHost.getIs());
            this.sendStringToHost("GNUTELLA/0.6 200 OK\r\n");
            this.sendHeadersToHost(HandshakeHeaders.OPEN_HEADERS);
            String string3 = this.readLineFromHost();
            if (!string3.equals(GNUTELLA_OK_06)) {
                throw new IOException("Bad protocol response");
            }
            this.readHeaders(this.remoteHost.getIs());
            this.configureRemoteHost();
        }
    }

    private void configureRemoteHost() {
        this.remoteHost.setVendor(this.getHeader("USER-AGENT"));
    }

    private void sendHeadersToHost(Properties properties) throws IOException {
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string);
            this.sendStringToHost(string + ": " + string2 + "\r\n");
        }
        this.sendStringToHost("\r\n");
    }

    private String readLineFromHost() throws IOException {
        byte[] byArray = this.flexBuffer.getBuf(1024);
        int n = 0;
        n = IOUtil.readToCRLF(this.remoteHost.getIs(), byArray, 1024, 0);
        String string = new String(byArray, 0, n);
        this.remoteHost.log(Logger.FINER, "Read: " + string);
        return string;
    }

    private void sendStringToHost(String string) throws IOException {
        this.remoteHost.log(Logger.FINER, "Send: " + string);
        byte[] byArray = this.flexBuffer.getBuf(string.length());
        int n = IOUtil.serializeString(string, byArray, 0);
        this.remoteHost.getOs().write(byArray, 0, n);
    }

    private boolean is06orHigher(String string) {
        int n = VersionUtils.compare(string, PROTOCOL_06);
        return n >= 0;
    }
}

