/*
 * Decompiled with CFR 0.152.
 */
package phex.cqueue;

import phex.cqueue.CQueueEntry;
import phex.cqueue.CQueueException;

public class CQueue
implements CQueueEntry {
    private CQueueEntry mHeadTail;
    private int mCount;
    private int mMax;
    private boolean mEnforcingMax;
    private CQueueEntry mNext = null;
    private CQueueEntry mPrev = null;
    private CQueue mQueue = null;

    private CQueue() {
    }

    public CQueue(int n, boolean bl) {
        this.mMax = n;
        this.mEnforcingMax = bl;
        this.initQueue();
    }

    private void initQueue() {
        CQueue cQueue = new CQueue();
        cQueue.setNext(cQueue);
        cQueue.setPrev(cQueue);
        cQueue.setCQueue(this);
        this.mHeadTail = cQueue;
        this.mCount = 0;
    }

    public int getCount() {
        return this.mCount;
    }

    public int getMax() {
        return this.mMax;
    }

    public boolean isExceedingMax() {
        return this.mCount > this.mMax;
    }

    public boolean isEmpty() {
        return this.mHeadTail.getNext() == this.mHeadTail;
    }

    public void addToTail(CQueueEntry cQueueEntry) throws CQueueException {
        if (this.mEnforcingMax && this.mCount > this.mMax) {
            this.removeFromHead();
        }
        this.addBefore(this.mHeadTail, cQueueEntry);
    }

    public void addToHead(CQueueEntry cQueueEntry) throws CQueueException {
        if (this.mEnforcingMax && this.mCount > this.mMax) {
            this.removeFromTail();
        }
        this.addAfter(this.mHeadTail, cQueueEntry);
    }

    private void addAfter(CQueueEntry cQueueEntry, CQueueEntry cQueueEntry2) throws CQueueException {
        if (cQueueEntry.getCQueue() != this) {
            throw new CQueueException("The entry to be followed doesn't belong to the same queue.");
        }
        if (cQueueEntry2.getCQueue() != null) {
            throw new CQueueException("The entry to be added already belongs to another queue.");
        }
        cQueueEntry2.setPrev(cQueueEntry);
        cQueueEntry2.setNext(cQueueEntry.getNext());
        cQueueEntry.getNext().setPrev(cQueueEntry2);
        cQueueEntry.setNext(cQueueEntry2);
        cQueueEntry2.setCQueue(this);
        ++this.mCount;
    }

    private void addBefore(CQueueEntry cQueueEntry, CQueueEntry cQueueEntry2) throws CQueueException {
        if (cQueueEntry.getCQueue() != this) {
            throw new CQueueException("The entry to follow doesn't belong to the same queue.");
        }
        if (cQueueEntry2.getCQueue() != null) {
            throw new CQueueException("The entry to be added already belongs to another queue.");
        }
        cQueueEntry2.setNext(cQueueEntry);
        cQueueEntry2.setPrev(cQueueEntry.getPrev());
        cQueueEntry.getPrev().setNext(cQueueEntry2);
        cQueueEntry.setPrev(cQueueEntry2);
        cQueueEntry2.setCQueue(this);
        ++this.mCount;
    }

    public CQueueEntry remove(CQueueEntry cQueueEntry) {
        CQueueEntry cQueueEntry2 = cQueueEntry.getPrev();
        CQueueEntry cQueueEntry3 = cQueueEntry.getNext();
        if (cQueueEntry2 == null || cQueueEntry3 == null) {
            return cQueueEntry;
        }
        cQueueEntry2.setNext(cQueueEntry3);
        cQueueEntry3.setPrev(cQueueEntry2);
        cQueueEntry.setNext(null);
        cQueueEntry.setPrev(null);
        --cQueueEntry.getCQueue().mCount;
        cQueueEntry.setCQueue(null);
        return cQueueEntry;
    }

    public CQueueEntry removeFromHead() {
        if (this.isEmpty()) {
            return null;
        }
        return this.remove(this.mHeadTail.getNext());
    }

    public CQueueEntry removeFromTail() {
        if (this.isEmpty()) {
            return null;
        }
        return this.remove(this.mHeadTail.getPrev());
    }

    public CQueueEntry getPrev() {
        return this.mPrev;
    }

    public void setPrev(CQueueEntry cQueueEntry) {
        this.mPrev = cQueueEntry;
    }

    public CQueueEntry getNext() {
        return this.mNext;
    }

    public void setNext(CQueueEntry cQueueEntry) {
        this.mNext = cQueueEntry;
    }

    public void setCQueue(CQueue cQueue) {
        this.mQueue = cQueue;
    }

    public CQueue getCQueue() {
        return this.mQueue;
    }
}

