/*
 * Decompiled with CFR 0.152.
 */
package phex.dialogues;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import phex.BaseFrame;
import phex.ServiceManager;
import phex.gui.common.TextFieldFix;
import phex.interfaces.IFind;

public class DlgResultFind
extends JDialog
implements KeyListener {
    private TextFieldFix mTextValue;
    private JCheckBox mMatchCase;
    private JRadioButton mFindUp;
    private JRadioButton mFindDown;
    private IFind mSearchCallback;

    public DlgResultFind(BaseFrame baseFrame, IFind iFind) {
        super((Frame)baseFrame, true);
        this.mSearchCallback = iFind;
        this.setTitle("Find");
        String string = "";
        this.setDefaultCloseOperation(1);
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12), BorderFactory.createEtchedBorder()), BorderFactory.createEmptyBorder(10, 16, 10, 16)));
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel(new GridLayout(3, 1, 0, 0));
        JLabel jLabel = new JLabel("Find Text:");
        jPanel2.add(jLabel);
        this.mTextValue = new TextFieldFix(string, 20);
        this.mTextValue.setText(ServiceManager.sCfg.mFindText);
        jLabel.setDisplayedMnemonic('T');
        jLabel.setLabelFor(this.mTextValue);
        jPanel2.add(this.mTextValue);
        JPanel jPanel3 = new JPanel(new GridLayout(1, 3, 0, 8));
        this.mMatchCase = new JCheckBox("Match case      ", ServiceManager.sCfg.mFindMatchCase);
        this.mMatchCase.setMnemonic('C');
        this.mFindUp = new JRadioButton("Find Up", !ServiceManager.sCfg.mFindDown);
        this.mFindUp.setMnemonic('U');
        this.mFindDown = new JRadioButton("Find Down", ServiceManager.sCfg.mFindDown);
        this.mFindDown.setMnemonic('N');
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.mFindUp);
        buttonGroup.add(this.mFindDown);
        jPanel3.add(this.mMatchCase);
        jPanel3.add(this.mFindUp);
        jPanel3.add(this.mFindDown);
        jPanel2.add(jPanel3);
        JPanel jPanel4 = new JPanel(new BorderLayout());
        JPanel jPanel5 = new JPanel(new FlowLayout(4));
        JPanel jPanel6 = new JPanel(new GridLayout(2, 1, 0, 6));
        JButton jButton = new JButton("Find Next");
        JButton jButton2 = new JButton("Done");
        jButton.setMnemonic('F');
        jButton2.setMnemonic('D');
        jPanel6.add(jButton);
        jPanel6.add(jButton2);
        jPanel5.add(jPanel6);
        jPanel4.add("Center", new JLabel("    "));
        jPanel4.add("East", jPanel5);
        jPanel.add("Center", jPanel2);
        jPanel.add("East", jPanel4);
        this.getContentPane().add("Center", jPanel);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getActionCommand().equals("Done")) {
                    DlgResultFind.this.doDone();
                } else if (actionEvent.getActionCommand().equals("Find Next")) {
                    DlgResultFind.this.doFind();
                }
            }
        };
        jButton.addActionListener(actionListener);
        jButton2.addActionListener(actionListener);
        this.addKeyListener(this);
        this.pack();
        BaseFrame.centerWindow(this, new Point(0, 0));
    }

    private void doDone() {
        ((Component)this).setVisible(false);
        this.dispose();
    }

    private void doFind() {
        ServiceManager.sCfg.mFindMatchCase = this.mMatchCase.isSelected();
        ServiceManager.sCfg.mFindDown = this.mFindDown.isSelected();
        ServiceManager.sCfg.mFindText = this.mTextValue.getText();
        this.mSearchCallback.findInResult(this.mMatchCase.isSelected(), this.mFindDown.isSelected(), this.mTextValue.getText());
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 27) {
            this.doDone();
        } else if (keyEvent.getKeyCode() == 10) {
            this.doFind();
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }
}

