/*
 * Decompiled with CFR 0.152.
 */
package phex.download;

import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.net.Socket;
import java.net.SocketException;
import java.util.StringTokenizer;
import phex.ServiceManager;
import phex.common.URN;
import phex.connection.ConnectionFailedException;
import phex.connection.ConnectionManager;
import phex.download.FileNotAvailableException;
import phex.download.HostBusyException;
import phex.download.IDownloadCandidate;
import phex.download.IDownloadFile;
import phex.download.IDownloadSegment;
import phex.download.WrongHTTPHeaderException;
import phex.host.HostAddress;
import phex.host.UnusableHostException;
import phex.utils.GnutellaInputStream;
import phex.utils.Logger;
import phex.utils.StrUtil;

public class DownloadEngine {
    private static final int BUFFER_LENGTH = 1024;
    private IDownloadCandidate candidate;
    private IDownloadSegment segment;
    private IDownloadFile downloadFile;
    private File destFile;
    private RandomAccessFile raFile;
    private Socket socket;
    private GnutellaInputStream inStream;
    private long downloadOffset;
    private long fileOffset;

    public DownloadEngine(IDownloadFile iDownloadFile, IDownloadCandidate iDownloadCandidate, IDownloadSegment iDownloadSegment, File file) {
        this.downloadFile = iDownloadFile;
        this.candidate = iDownloadCandidate;
        this.segment = iDownloadSegment;
        this.downloadOffset = this.segment.getTransferStartPosition();
        this.fileOffset = this.segment.getTransferredDataSize();
        this.destFile = file;
    }

    public DownloadEngine(Socket socket, IDownloadFile iDownloadFile, IDownloadCandidate iDownloadCandidate, IDownloadSegment iDownloadSegment, File file) {
        this(iDownloadFile, iDownloadCandidate, iDownloadSegment, file);
        this.socket = socket;
    }

    public void connect(int n) throws IOException, UnusableHostException {
        if (this.socket == null) {
            ConnectionManager connectionManager = ServiceManager.getConnectionManager();
            HostAddress hostAddress = this.candidate.getHostAddress();
            Logger.logMessage(Logger.FINE, (short)2, "DownloadEngine - Connecting to " + hostAddress.getHostName() + ":" + hostAddress.getPort());
            try {
                this.socket = connectionManager.connect(hostAddress, n);
            }
            catch (SocketException socketException) {
                throw new ConnectionFailedException(socketException.getMessage());
            }
        }
        this.inStream = new GnutellaInputStream(this.socket.getInputStream(), ServiceManager.getManager().getDownloadThrottle());
        this.sendGetRequest();
        this.readHTTPResponseCode();
        Logger.logMessage(Logger.FINE, (short)2, "Download Engine connected successfull.");
    }

    public void startDownload() throws IOException {
        Logger.logMessage(Logger.FINE, (short)2, "Download Engine starts download.");
        this.raFile = new RandomAccessFile(this.destFile, "rw");
        try {
            this.segment.downloadStartNotify();
            this.raFile.seek(this.fileOffset);
            byte[] byArray = new byte[1024];
            long l = this.segment.getTransferDataSize();
            long l2 = this.segment.getTransferredDataSize();
            while (l > l2) {
                long l3 = l - l2;
                int n = this.inStream.read(byArray, 0, (int)Math.min(1024L, l3));
                if (n == -1) break;
                this.raFile.write(byArray, 0, n);
                this.segment.setTransferredDataSize(l2 += (long)n);
                l = this.segment.getTransferDataSize();
            }
            Object var10_6 = null;
            this.stopDownload();
        }
        catch (Throwable throwable) {
            Object var10_7 = null;
            this.stopDownload();
            throw throwable;
        }
    }

    public void stopDownload() {
        this.segment.downloadStopNotify();
        if (this.inStream != null) {
            try {
                this.inStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.raFile != null) {
            try {
                this.raFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void sendGetRequest() throws IOException {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(this.socket.getOutputStream());
        long l = this.candidate.getFileIndex();
        String string = this.candidate.getFileName();
        String string2 = "GET /get/" + l + "/" + string + " HTTP/1.0\r\n" + "User-Agent: " + StrUtil.getAppNameVersion() + "\r\n" + "Range: bytes=" + this.downloadOffset + "-\r\n" + "\r\n";
        Logger.logMessage(Logger.FINE, (short)2, "GET Request: " + string2);
        outputStreamWriter.write(string2);
        outputStreamWriter.flush();
    }

    private void readHTTPResponseCode() throws IOException, UnusableHostException {
        int n;
        String string = this.inStream.readLine();
        Logger.logMessage(Logger.FINE, (short)2, "GET Request Response: " + string);
        if (string == null) {
            throw new WrongHTTPHeaderException("No HTTP header found.");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        if (!stringTokenizer.hasMoreElements()) {
            throw new WrongHTTPHeaderException("No HTTP header found.");
        }
        if (stringTokenizer.nextToken().toUpperCase().indexOf("HTTP") < 0) {
            throw new WrongHTTPHeaderException("Header dosn't start with 'HTTP'.");
        }
        if (!stringTokenizer.hasMoreElements()) {
            throw new WrongHTTPHeaderException("Incomplete HTTP header (HTTP Code missing).");
        }
        String string2 = stringTokenizer.nextToken();
        try {
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new WrongHTTPHeaderException("Second HTTP header token not a parseable integer HTTP code.");
        }
        this.readHTTPHeaders();
        if (n >= 200 && n < 300) {
            return;
        }
        if (n == 503 || n == 408) {
            throw new HostBusyException();
        }
        if (n == 404 || n == 410) {
            throw new FileNotAvailableException();
        }
        throw new IOException("Unknown HTTP code: " + n);
    }

    private void readHTTPHeaders() throws IOException, UnusableHostException {
        String string;
        while ((string = this.inStream.readLine()) != null && string.length() != 0) {
            Logger.logMessage(Logger.FINE, (short)2, "Response Header: " + string);
            string = string.toUpperCase();
            if (string.startsWith("SERVER:")) {
                String string2 = string.substring(7).trim();
                this.candidate.setVendor(string2);
                continue;
            }
            if (string.startsWith("CONTENT-RANGE:")) {
                int n = this.parseStartOffset(string);
                if ((long)n == this.downloadOffset) continue;
                throw new IOException("Invalid 'CONTENT-RANGE' start offset.");
            }
            if (string.startsWith("X-GNUTELLA-CONTENT-URN:")) {
                String string3 = string.substring(23).trim();
                URN uRN = this.downloadFile.getResearchSetting().getSearchURN();
                if (uRN == null) continue;
                if (!URN.isValidURN(string3)) {
                    throw new IOException("Invalid X-GNUTELLA-CONTENT-URN: " + string3);
                }
                URN uRN2 = new URN(string3);
                if (uRN.equals(uRN2)) continue;
                throw new IOException("Required URN and content URN do not match.");
            }
            Logger.logMessage(Logger.INFO, (short)2, "Unknown Header: " + string);
        }
    }

    private int parseStartOffset(String string) throws WrongHTTPHeaderException {
        try {
            int n = string.indexOf("BYTES") + 6;
            String string2 = string.substring(n).trim();
            if (string2.charAt(0) == '*') {
                return 0;
            }
            n = string2.indexOf(45);
            String string3 = string2.substring(0, n);
            int n2 = Integer.parseInt(string3);
            return n2;
        }
        catch (NumberFormatException numberFormatException) {
            Logger.logWarning(numberFormatException);
            throw new WrongHTTPHeaderException("Number error while parsing content range: " + string);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new WrongHTTPHeaderException("Error while parsing content range: " + string);
        }
    }
}

