/*
 * Decompiled with CFR 0.152.
 */
package phex.download;

import java.net.NoRouteToHostException;
import java.net.Socket;
import phex.GUID;
import phex.ServiceManager;
import phex.download.IDownloadCandidate;
import phex.download.PushHandler;

public class PushRequestSleeper {
    private GUID clientGUID;
    private long fileIndex;
    private String fileName;
    private Socket givenSocket;

    public PushRequestSleeper(IDownloadCandidate iDownloadCandidate) {
        this.clientGUID = iDownloadCandidate.getGUID();
        this.fileIndex = iDownloadCandidate.getFileIndex();
        this.fileName = iDownloadCandidate.getFileName();
    }

    public GUID getGUID() {
        return this.clientGUID;
    }

    public long getFileIndex() {
        return this.fileIndex;
    }

    public String getFileName() {
        return this.fileName;
    }

    public synchronized boolean acceptGIVConnection(Socket socket, GUID gUID, long l, String string) {
        if (!this.clientGUID.equals(gUID)) {
            return false;
        }
        if (l != this.fileIndex) {
            return false;
        }
        if (!string.equals(this.fileName)) {
            return false;
        }
        this.givenSocket = socket;
        this.notify();
        return true;
    }

    public synchronized Socket requestSocketViaPush() {
        try {
            ServiceManager.getMsgManager().sendPushRequest(this);
        }
        catch (NoRouteToHostException noRouteToHostException) {
            PushHandler.unregisterPushRequestSleeper(this);
            return null;
        }
        try {
            this.wait(ServiceManager.sCfg.mPushTransferTimeout);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.givenSocket == null) {
            PushHandler.unregisterPushRequestSleeper(this);
            return null;
        }
        PushHandler.unregisterPushRequestSleeper(this);
        return this.givenSocket;
    }
}

