/*
 * Decompiled with CFR 0.152.
 */
package phex.download.swarming;

import phex.GUID;
import phex.ServiceManager;
import phex.download.IDownloadCandidate;
import phex.download.RemoteFile;
import phex.download.swarming.SWDownloadConstants;
import phex.download.swarming.SWDownloadFile;
import phex.download.swarming.SWDownloadSegment;
import phex.download.swarming.SWDownloadWorker;
import phex.host.HostAddress;
import phex.host.MalformedHostAddressException;
import phex.query.QueryHitHost;
import phex.utils.Logger;
import phex.xml.XMLSWDownloadCandidate;

public class SWDownloadCandidate
implements IDownloadCandidate,
SWDownloadConstants {
    private GUID guid;
    private long fileIndex;
    private String fileName;
    private HostAddress hostAddress;
    private short status;
    private short errorStatus;
    private long statusTimeout;
    private int errorStatusRepetition;
    private String vendor;
    private boolean isPushNeeded;
    private short hostRating;
    private SWDownloadFile downloadFile;
    private SWDownloadWorker worker;
    private SWDownloadSegment downloadSegment;

    public SWDownloadCandidate(RemoteFile remoteFile, SWDownloadFile sWDownloadFile) {
        this.downloadFile = sWDownloadFile;
        this.fileIndex = remoteFile.getFileIndex();
        this.fileName = remoteFile.getFilename();
        this.guid = remoteFile.getRemoteClientID();
        QueryHitHost queryHitHost = remoteFile.getQueryHitHost();
        this.vendor = queryHitHost.getVendor();
        this.isPushNeeded = queryHitHost.isPushNeeded();
        this.hostRating = queryHitHost.getHostRating();
        this.hostAddress = remoteFile.getHostAddress();
        this.status = (short)10;
    }

    public SWDownloadCandidate(XMLSWDownloadCandidate xMLSWDownloadCandidate, SWDownloadFile sWDownloadFile) {
        this.downloadFile = sWDownloadFile;
        this.fileIndex = xMLSWDownloadCandidate.getFileIndex();
        this.fileName = xMLSWDownloadCandidate.getFileName();
        try {
            this.guid = GUID.createFromHexString(xMLSWDownloadCandidate.getGuid());
        }
        catch (Exception exception) {
            Logger.logWarning((short)2, exception);
        }
        this.vendor = xMLSWDownloadCandidate.getVendor();
        this.isPushNeeded = xMLSWDownloadCandidate.getIsPushNeeded();
        this.hostRating = xMLSWDownloadCandidate.getRating();
        try {
            this.hostAddress = new HostAddress(xMLSWDownloadCandidate.getRemoteHost());
        }
        catch (MalformedHostAddressException malformedHostAddressException) {
            Logger.logWarning((short)2, malformedHostAddressException);
        }
        this.status = (short)10;
    }

    public HostAddress getHostAddress() {
        return this.hostAddress;
    }

    public String getFileName() {
        return this.fileName;
    }

    public GUID getGUID() {
        return this.guid;
    }

    public long getFileIndex() {
        return this.fileIndex;
    }

    public long getStatusTimeLeft() {
        long l = this.statusTimeout - System.currentTimeMillis();
        if (l < 0L) {
            l = 0L;
        }
        return l;
    }

    public int getStatus() {
        return this.status;
    }

    public String getVendor() {
        return this.vendor;
    }

    public void setVendor(String string) {
        if (this.vendor == null || !this.vendor.equals(string)) {
            this.vendor = string;
            this.downloadFile.fireDownloadCandidateChanged(this);
        }
    }

    public boolean isPushNeeded() {
        return this.isPushNeeded;
    }

    public short getHostRating() {
        return this.hostRating;
    }

    public boolean equals(Object object) {
        if (object instanceof SWDownloadCandidate) {
            return this.equals((SWDownloadCandidate)object);
        }
        return false;
    }

    public boolean equals(SWDownloadCandidate sWDownloadCandidate) {
        return this.hostAddress.equals(sWDownloadCandidate.hostAddress) && this.fileIndex == sWDownloadCandidate.fileIndex;
    }

    public void setStatus(short s) {
        this.status = s;
        this.statusTimeout = System.currentTimeMillis();
        this.log("Set status to " + this.status + " and raise timeout from: " + this.statusTimeout);
        switch (this.status) {
            case 13: 
            case 15: {
                this.statusTimeout += this.determineErrorStatusTimeout(this.status);
                break;
            }
            case 14: {
                this.statusTimeout += (long)ServiceManager.sCfg.mPushTransferTimeout;
                break;
            }
            case 12: {
                this.errorStatus = 0;
            }
        }
        this.log("to time: " + this.statusTimeout);
        this.downloadFile.fireDownloadCandidateChanged(this);
    }

    private long determineErrorStatusTimeout(short s) {
        if (this.errorStatus == s) {
            ++this.errorStatusRepetition;
        } else {
            this.errorStatus = s;
            this.errorStatusRepetition = 0;
        }
        switch (this.errorStatus) {
            case 13: {
                return 60000L;
            }
            case 15: {
                if (this.errorStatusRepetition + 1 >= ServiceManager.sCfg.maxFailedConnectionsInARow) {
                    this.downloadFile.removeDownloadCandidate(this);
                }
                return 120000L * (long)Math.pow(2.0, this.errorStatusRepetition);
            }
        }
        Logger.logWarning((short)2, "Unknown error status: " + this.errorStatus);
        return 0L;
    }

    public void manualConnectionRetry() {
        if (this.status != 13 && this.status != 15) {
            return;
        }
        this.setStatus((short)10);
        --this.errorStatusRepetition;
        ServiceManager.getSwarmingManager().notifyWaitingWorkers();
    }

    public boolean isAbleToBeAllocated() {
        long l = System.currentTimeMillis();
        return this.worker == null && this.statusTimeout <= l;
    }

    public void setAllocatedByWorker(SWDownloadWorker sWDownloadWorker) {
        this.log("Allocated from " + sWDownloadWorker);
        this.worker = sWDownloadWorker;
    }

    public void associateDownloadSegment(SWDownloadSegment sWDownloadSegment) {
        this.downloadSegment = sWDownloadSegment;
        this.downloadSegment.associateDownloadCandidate(this);
    }

    public void releaseDownloadSegment() {
        this.downloadSegment.associateDownloadCandidate(null);
        this.downloadSegment = null;
    }

    public SWDownloadSegment getDownloadSegment() {
        return this.downloadSegment;
    }

    public void stopDownload() {
        if (this.worker != null) {
            this.worker.stopDownload();
        }
    }

    public XMLSWDownloadCandidate createXMLSWDownloadCandidate() {
        XMLSWDownloadCandidate xMLSWDownloadCandidate = new XMLSWDownloadCandidate();
        xMLSWDownloadCandidate.setFileIndex(this.fileIndex);
        xMLSWDownloadCandidate.setFileName(this.fileName);
        xMLSWDownloadCandidate.setGuid(this.guid.toHexString());
        xMLSWDownloadCandidate.setIsPushNeeded(this.isPushNeeded);
        xMLSWDownloadCandidate.setRating(this.hostRating);
        xMLSWDownloadCandidate.setRemoteHost(this.hostAddress.getFullHostName());
        xMLSWDownloadCandidate.setVendor(this.vendor);
        return xMLSWDownloadCandidate;
    }

    public void log(String string) {
        Logger.logMessage(Logger.FINE, (short)2, "Candidate " + this.hostAddress.getHostName() + ":" + this.hostAddress.getPort() + ": " + string);
    }

    public String toString() {
        return "[Candidate: " + this.hostAddress.getFullHostName() + " -> " + super.toString() + "]";
    }
}

