/*
 * Decompiled with CFR 0.152.
 */
package phex.download.swarming;

import java.io.File;
import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventListener;
import java.util.Iterator;
import phex.ServiceManager;
import phex.common.FileHandlingException;
import phex.common.URN;
import phex.download.IDownloadFile;
import phex.download.RemoteFile;
import phex.download.swarming.SWDownloadCandidate;
import phex.download.swarming.SWDownloadConstants;
import phex.download.swarming.SWDownloadSegment;
import phex.download.swarming.SWDownloadWorker;
import phex.event.AsynchronousDispatcher;
import phex.event.DownloadCandidatesChangeListener;
import phex.event.DownloadSegmentsChangeListener;
import phex.event.EventListenerList;
import phex.query.ResearchSetting;
import phex.utils.FileUtils;
import phex.utils.Logger;
import phex.xml.XMLSWDownloadCandidate;
import phex.xml.XMLSWDownloadFile;
import phex.xml.XMLSWDownloadSegment;

public class SWDownloadFile
implements IDownloadFile,
SWDownloadConstants {
    private static Comparator candidatesComparator = new SWDownloadCandidateComparator();
    private ArrayList downloadSegments;
    private ArrayList downloadCandidates;
    private Integer candidateCountObj;
    private long fileSize;
    private int nextSegmentNumber;
    private File destinationFile;
    private short status;
    private long transferRateTimestamp;
    private int transferRateBytes;
    private long sessionTransferRateBytes;
    private int transferRate;
    private long transferStartTime;
    private long transferStopTime;
    private long transferDataSize;
    private long transferredDataSize;
    private long transferDataUpdateTime;
    private Integer currentProgress;
    private short workerCount;
    private ResearchSetting researchSetting;
    private EventListenerList listenerList = new EventListenerList();
    static /* synthetic */ Class class$phex$event$DownloadCandidatesChangeListener;
    static /* synthetic */ Class class$phex$event$DownloadSegmentsChangeListener;

    public SWDownloadFile(String string, String string2, long l, URN uRN) {
        this(string, string2, l, uRN, true);
    }

    private SWDownloadFile(String string, String string2, long l, URN uRN, boolean bl) {
        this.destinationFile = new File(string);
        this.fileSize = l;
        this.downloadCandidates = new ArrayList();
        this.candidateCountObj = new Integer(0);
        this.currentProgress = new Integer(0);
        this.status = 1;
        if (bl) {
            this.createDownloadSegments();
        } else {
            this.downloadSegments = new ArrayList();
        }
        this.researchSetting = new ResearchSetting(this);
        this.researchSetting.setSearchTerm(string2);
        this.researchSetting.setSearchURN(uRN);
        ServiceManager.getTransferRateService().registerTransferDataProvider(this);
    }

    public SWDownloadFile(XMLSWDownloadFile xMLSWDownloadFile) {
        this(ServiceManager.sCfg.mDownloadDir + File.separator + xMLSWDownloadFile.getLocalFilename(), xMLSWDownloadFile.getSearchterm(), xMLSWDownloadFile.getFilesize(), null, false);
        this.status = xMLSWDownloadFile.getStatus();
        if (xMLSWDownloadFile.getFileURN() != null) {
            URN uRN = new URN(xMLSWDownloadFile.getFileURN());
            this.researchSetting.setSearchURN(uRN);
        }
        this.createDownloadCandidates(xMLSWDownloadFile);
        this.createDownloadSegments(xMLSWDownloadFile);
        this.forceCollectionOfTransferData();
        this.transferRateBytes = 0;
        this.sessionTransferRateBytes = 0L;
        this.verifyStatus();
        if (this.status == 3) {
            this.transferDataSize = this.transferredDataSize = this.fileSize;
        }
    }

    public SWDownloadSegment allocateDownloadSegment(SWDownloadWorker sWDownloadWorker) {
        long l = 0L;
        SWDownloadSegment sWDownloadSegment = null;
        ArrayList arrayList = this.downloadSegments;
        synchronized (arrayList) {
            SWDownloadSegment sWDownloadSegment2 = null;
            Iterator iterator = ((AbstractList)this.downloadSegments).iterator();
            while (iterator.hasNext()) {
                sWDownloadSegment2 = (SWDownloadSegment)iterator.next();
                if (sWDownloadSegment2.isAbleToBeAllocated()) {
                    Logger.logMessage(Logger.FINE, (short)2, "Allocating segment: " + sWDownloadSegment2);
                    sWDownloadSegment2.setAllocatedByWorker(sWDownloadWorker);
                    SWDownloadSegment sWDownloadSegment3 = sWDownloadSegment2;
                    return sWDownloadSegment3;
                }
                if (sWDownloadSegment2.getTransferDataSizeLeft() <= l) continue;
                l = sWDownloadSegment2.getTransferDataSizeLeft();
                sWDownloadSegment = sWDownloadSegment2;
            }
            if (sWDownloadSegment == null) {
                SWDownloadSegment sWDownloadSegment4 = null;
                return sWDownloadSegment4;
            }
            Logger.logMessage(Logger.FINE, (short)2, "No free segment found... try to split segment: " + sWDownloadSegment);
            sWDownloadSegment2 = this.splitDownloadSegment(sWDownloadSegment);
            if (sWDownloadSegment2 == null) {
                SWDownloadSegment sWDownloadSegment5 = null;
                return sWDownloadSegment5;
            }
            Logger.logMessage(Logger.FINE, (short)2, "Allocating segment: " + sWDownloadSegment2);
            sWDownloadSegment2.setAllocatedByWorker(sWDownloadWorker);
            SWDownloadSegment sWDownloadSegment6 = sWDownloadSegment2;
            return sWDownloadSegment6;
        }
    }

    public SWDownloadCandidate allocateDownloadCandidate(SWDownloadWorker sWDownloadWorker) {
        SWDownloadCandidate sWDownloadCandidate = null;
        ArrayList arrayList = this.downloadCandidates;
        synchronized (arrayList) {
            Iterator iterator = ((AbstractList)this.downloadCandidates).iterator();
            while (iterator.hasNext()) {
                sWDownloadCandidate = (SWDownloadCandidate)iterator.next();
                if (!sWDownloadCandidate.isAbleToBeAllocated()) continue;
                sWDownloadCandidate.setAllocatedByWorker(sWDownloadWorker);
                SWDownloadCandidate sWDownloadCandidate2 = sWDownloadCandidate;
                return sWDownloadCandidate2;
            }
        }
        return null;
    }

    public boolean addDownloadCandidate(RemoteFile remoteFile) {
        SWDownloadCandidate sWDownloadCandidate = new SWDownloadCandidate(remoteFile, this);
        Logger.logMessage(Logger.FINE, (short)2, "Adding download candidate " + remoteFile);
        ArrayList arrayList = this.downloadCandidates;
        synchronized (arrayList) {
            if (this.downloadCandidates.contains(sWDownloadCandidate)) {
                Logger.logMessage(Logger.FINE, (short)2, "Dublicate download candidate");
                boolean bl = false;
                return bl;
            }
            int n = this.downloadCandidates.size();
            this.downloadCandidates.add(n, sWDownloadCandidate);
            this.fireDownloadCandidateAdded(n);
            Collections.sort(this.downloadCandidates, candidatesComparator);
        }
        if (this.researchSetting.getSearchURN() == null) {
            this.researchSetting.setSearchURN(remoteFile.getURN());
        }
        ServiceManager.getSwarmingManager().notifyWaitingWorkers();
        return true;
    }

    public void removeDownloadCandidate(SWDownloadCandidate sWDownloadCandidate) {
        sWDownloadCandidate.stopDownload();
        ArrayList arrayList = this.downloadCandidates;
        synchronized (arrayList) {
            int n = this.downloadCandidates.indexOf(sWDownloadCandidate);
            if (n >= 0) {
                this.downloadCandidates.remove(n);
                this.fireDownloadCandidateRemoved(n);
            }
        }
        Logger.logMessage(Logger.FINE, (short)2, "Removing Candidate: " + sWDownloadCandidate.getHostAddress());
    }

    public void releaseDownloadSegment(SWDownloadSegment sWDownloadSegment) {
        ArrayList arrayList = this.downloadSegments;
        synchronized (arrayList) {
            sWDownloadSegment.setAllocatedByWorker(null);
        }
    }

    public int getCandidateCount() {
        return this.downloadCandidates.size();
    }

    public Integer getCandidateCountObject() {
        if (this.candidateCountObj.intValue() != this.downloadCandidates.size()) {
            this.candidateCountObj = new Integer(this.downloadCandidates.size());
        }
        return this.candidateCountObj;
    }

    public SWDownloadCandidate getCandidate(int n) {
        if (n >= this.downloadCandidates.size()) {
            return null;
        }
        return (SWDownloadCandidate)this.downloadCandidates.get(n);
    }

    public int getSegmentCount() {
        return this.downloadSegments.size();
    }

    public SWDownloadSegment getSegment(int n) {
        if (n >= this.downloadSegments.size()) {
            return null;
        }
        return (SWDownloadSegment)this.downloadSegments.get(n);
    }

    public void releaseDownloadCandidate(SWDownloadCandidate sWDownloadCandidate) {
        ArrayList arrayList = this.downloadCandidates;
        synchronized (arrayList) {
            sWDownloadCandidate.setAllocatedByWorker(null);
        }
    }

    public ResearchSetting getResearchSetting() {
        return this.researchSetting;
    }

    public void startSearchForCandidates() {
        this.researchSetting.stopSearch();
        this.researchSetting.startSearch(300000L);
    }

    public boolean mergeSegmentWithNext(SWDownloadSegment sWDownloadSegment) {
        ArrayList arrayList = this.downloadSegments;
        synchronized (arrayList) {
            SWDownloadSegment sWDownloadSegment2 = sWDownloadSegment.getNextDownloadSegment();
            Logger.logMessage(Logger.FINE, (short)2, "Segment to merge: " + sWDownloadSegment);
            if (sWDownloadSegment2 == null || !sWDownloadSegment2.isAbleToBeAllocated() || sWDownloadSegment2.getTransferredDataSize() > 0L) {
                boolean bl = false;
                return bl;
            }
            sWDownloadSegment.mergeWithNextSegment();
            int n = this.downloadSegments.indexOf(sWDownloadSegment2);
            if (n >= 0) {
                this.downloadSegments.remove(n);
                this.fireDownloadSegmentRemoved(n);
            }
            this.logDownloadSegments();
            boolean bl = true;
            return bl;
        }
    }

    public void mergeCompletedSegments(SWDownloadWorker sWDownloadWorker) {
        ArrayList arrayList = this.downloadSegments;
        synchronized (arrayList) {
            int n = this.downloadSegments.size() - 1;
            while (n >= 0) {
                SWDownloadSegment sWDownloadSegment = (SWDownloadSegment)this.downloadSegments.get(n);
                Logger.logMessage(Logger.FINE, (short)2, "Trying to merge completed segment: " + sWDownloadSegment);
                SWDownloadSegment sWDownloadSegment2 = sWDownloadSegment.getNextDownloadSegment();
                if (sWDownloadSegment2 != null && sWDownloadSegment.getTransferredDataSize() >= sWDownloadSegment.getTransferDataSize() && sWDownloadSegment2.getTransferredDataSize() != 0L && (sWDownloadSegment2.getAllocatedByWorker() == null || sWDownloadSegment2.getAllocatedByWorker() == sWDownloadWorker)) {
                    try {
                        FileUtils.truncateFile(sWDownloadSegment.getIncompleteFile(), sWDownloadSegment.getTransferDataSize());
                        FileUtils.appendFile(sWDownloadSegment.getIncompleteFile(), sWDownloadSegment2.getIncompleteFile());
                    }
                    catch (IOException iOException) {
                        Logger.logWarning(iOException);
                    }
                    sWDownloadSegment.mergeWithNextSegment();
                    int n2 = this.downloadSegments.indexOf(sWDownloadSegment2);
                    if (n2 >= 0) {
                        this.downloadSegments.remove(n2);
                        this.fireDownloadSegmentRemoved(n2);
                    }
                    Logger.logMessage(Logger.FINE, (short)2, "Merged completed segment: " + sWDownloadSegment);
                }
                --n;
            }
            this.logDownloadSegments();
        }
        ServiceManager.getSwarmingManager().saveDownloadList();
    }

    public void setStatus(short s) {
        if (this.status == s) {
            return;
        }
        Logger.logMessage(Logger.FINE, (short)2, "DownloadFile Status " + s);
        ArrayList arrayList = this.downloadCandidates;
        synchronized (arrayList) {
            switch (s) {
                case 1: 
                case 3: 
                case 4: {
                    this.downloadStopNotify();
                    break;
                }
                case 2: {
                    this.downloadStartNotify();
                }
            }
            this.status = s;
            ServiceManager.getSwarmingManager().fireDownloadFileChanged(this);
        }
    }

    public short getStatus() {
        return this.status;
    }

    public boolean isAbleToBeAllocated() {
        return this.status != 4 && this.status != 3 && this.workerCount <= ServiceManager.sCfg.maxWorkerPerDownload;
    }

    public void incrementWorkerCount() {
        this.workerCount = (short)(this.workerCount + 1);
    }

    public void decrementWorkerCount() {
        this.workerCount = (short)(this.workerCount - 1);
    }

    public void verifyStatus() {
        this.forceCollectionOfTransferData();
        if (this.getTransferDataSize() == this.getTransferredDataSize()) {
            this.setStatus((short)3);
            return;
        }
        ArrayList arrayList = this.downloadCandidates;
        synchronized (arrayList) {
            int n = this.downloadCandidates.size();
            int n2 = n - 1;
            while (n2 >= 0) {
                SWDownloadCandidate sWDownloadCandidate = (SWDownloadCandidate)this.downloadCandidates.get(n2);
                if (sWDownloadCandidate.getStatus() == 12) {
                    this.setStatus((short)2);
                    return;
                }
                --n2;
            }
            if (this.status != 1 && this.status != 4 && this.status != 3) {
                this.setStatus((short)1);
            }
        }
    }

    public boolean isDownloadCompleted() {
        return this.status == 3;
    }

    public boolean isDownloadInProgress() {
        return this.status == 2;
    }

    public boolean isDownloadStopped() {
        return this.status == 4;
    }

    public File getDestinationFile() {
        return this.destinationFile;
    }

    public String getDestinationFileName() {
        return this.destinationFile.getName();
    }

    public void setDestinationFile(File file, boolean bl) throws FileHandlingException {
        if (file.compareTo(this.destinationFile) == 0) {
            return;
        }
        if (bl) {
            if (ServiceManager.getSwarmingManager().isNewLocalFilenameUsed(this, file)) {
                throw new FileHandlingException(1);
            }
            this.renameSegmentsToDestinationRoot(file);
            FileUtils.renameLocalFile(this.destinationFile, file);
        }
        this.destinationFile = file;
    }

    public void moveToDestinationFile() {
        if (this.downloadSegments.size() != 1 && this.status == 3) {
            throw new RuntimeException("There must be exactly one download segment and the download must be completed to move to destination file");
        }
        ArrayList arrayList = this.downloadSegments;
        synchronized (arrayList) {
            SWDownloadSegment sWDownloadSegment = (SWDownloadSegment)this.downloadSegments.get(0);
            File file = sWDownloadSegment.getIncompleteFile();
            File file2 = this.destinationFile;
            if (!file2.isAbsolute()) {
                file2 = new File(ServiceManager.sCfg.mDownloadDir, this.destinationFile.getName());
            }
            int n = 0;
            while (file2.exists()) {
                ++n;
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(this.destinationFile.getParent());
                stringBuffer.append(File.separatorChar);
                stringBuffer.append('(');
                stringBuffer.append(n);
                stringBuffer.append(") ");
                stringBuffer.append(this.destinationFile.getName());
                file2 = new File(stringBuffer.toString());
            }
            Logger.logMessage(Logger.FINE, (short)2, "Renameing final segment from " + file.getAbsolutePath() + " to " + file2.getAbsoluteFile() + ".");
            boolean bl = file.renameTo(file2);
            if (bl) {
                int n2 = this.downloadSegments.indexOf(sWDownloadSegment);
                if (n2 >= 0) {
                    this.downloadSegments.remove(n2);
                    this.fireDownloadSegmentRemoved(n2);
                    this.logDownloadSegments();
                }
            } else {
                Logger.logMessage(Logger.FINE, (short)2, "Renaming from " + file.getAbsolutePath() + " to " + file2.getAbsolutePath() + " failed.");
            }
        }
        if (ServiceManager.sCfg.mDownloadAutoRemoveCompleted) {
            ServiceManager.getSwarmingManager().removeDownloadFile(this);
        } else {
            ServiceManager.getSwarmingManager().saveDownloadList();
        }
    }

    public void setTransferRateTimestamp(long l) {
        this.transferRateTimestamp = l;
        this.transferRateBytes = 0;
    }

    public int getShortTermTransferRate() {
        if (this.status == 3) {
            this.transferRate = 0;
        } else if (this.transferRateTimestamp != 0L) {
            double d = (System.currentTimeMillis() - this.transferRateTimestamp) / 1000L;
            if ((this.transferRateBytes > 0 || d > 1.0) && d != 0.0) {
                this.transferRate = (int)((double)this.transferRateBytes / d);
            }
        }
        return this.transferRate;
    }

    public short getDataTransferStatus() {
        switch (this.status) {
            case 2: {
                return 10;
            }
            case 3: {
                return 12;
            }
        }
        return 11;
    }

    public long getTransferDataSize() {
        this.lazyCollectTransferData();
        return this.transferDataSize;
    }

    public long getTotalDataSize() {
        return this.fileSize;
    }

    public long getTransferredDataSize() {
        this.lazyCollectTransferData();
        return this.transferredDataSize;
    }

    public int getLongTermTransferRate() {
        long l = this.transferStopTime != 0L ? (this.transferStopTime - this.transferStartTime) / 1000L : (System.currentTimeMillis() - this.transferStartTime) / 1000L;
        return (int)(this.sessionTransferRateBytes / (l + 1L));
    }

    public Integer getProgress() {
        int n;
        if (this.status == 3) {
            n = 100;
        } else {
            long l = this.transferDataSize;
            if (l == 0L) {
                l = 1L;
            }
            n = (int)(this.transferredDataSize * 100L / l);
        }
        if (this.currentProgress != n) {
            this.currentProgress = new Integer(n);
        }
        return this.currentProgress;
    }

    public void startDownload() {
        this.setStatus((short)1);
        ServiceManager.getSwarmingManager().notifyWaitingWorkers();
    }

    public void stopDownload() {
        this.setStatus((short)4);
        ArrayList arrayList = this.downloadCandidates;
        synchronized (arrayList) {
            Iterator iterator = ((AbstractList)this.downloadCandidates).iterator();
            while (iterator.hasNext()) {
                SWDownloadCandidate sWDownloadCandidate = (SWDownloadCandidate)iterator.next();
                sWDownloadCandidate.stopDownload();
            }
        }
    }

    public void removeDownloadSegmentFiles() {
        if (this.status != 4) {
            Logger.logMessage(Logger.WARNING, (short)2, "Can't clean temp files of not stopped download file.");
            return;
        }
        ArrayList arrayList = this.downloadSegments;
        synchronized (arrayList) {
            Iterator iterator = ((AbstractList)this.downloadSegments).iterator();
            while (iterator.hasNext()) {
                SWDownloadSegment sWDownloadSegment = (SWDownloadSegment)iterator.next();
                sWDownloadSegment.removeDownloadDestinationFile();
            }
        }
    }

    private void renameSegmentsToDestinationRoot(File file) throws FileHandlingException {
        ArrayList arrayList = this.downloadSegments;
        synchronized (arrayList) {
            Iterator iterator = ((AbstractList)this.downloadSegments).iterator();
            while (iterator.hasNext()) {
                SWDownloadSegment sWDownloadSegment = (SWDownloadSegment)iterator.next();
                sWDownloadSegment.renameToDestinationRoot(file);
            }
        }
    }

    private void downloadStartNotify() {
        this.transferRateTimestamp = this.transferStartTime = System.currentTimeMillis();
        this.transferStopTime = 0L;
        this.sessionTransferRateBytes = 0L;
    }

    private void downloadStopNotify() {
        if (this.transferStopTime == 0L) {
            this.transferStopTime = System.currentTimeMillis();
        }
    }

    public void forceCollectionOfTransferData() {
        long l = 0L;
        long l2 = 0L;
        ArrayList arrayList = this.downloadSegments;
        synchronized (arrayList) {
            Iterator iterator = ((AbstractList)this.downloadSegments).iterator();
            while (iterator.hasNext()) {
                SWDownloadSegment sWDownloadSegment = (SWDownloadSegment)iterator.next();
                l += sWDownloadSegment.getTransferredDataSize();
                l2 += sWDownloadSegment.getTransferDataSize();
            }
        }
        this.transferRateBytes = (int)((long)this.transferRateBytes + (l - this.transferredDataSize));
        this.sessionTransferRateBytes += l - this.transferredDataSize;
        this.transferDataSize = l2;
        this.transferredDataSize = l;
        this.transferDataUpdateTime = System.currentTimeMillis() + 1000L;
    }

    public XMLSWDownloadFile createXMLSWDownloadFile() {
        Object object;
        Object object2;
        Object object3;
        XMLSWDownloadFile xMLSWDownloadFile = new XMLSWDownloadFile();
        xMLSWDownloadFile.setLocalFilename(this.destinationFile.getName());
        xMLSWDownloadFile.setFilesize(this.fileSize);
        xMLSWDownloadFile.setSearchterm(this.researchSetting.getSearchTerm());
        if (this.researchSetting.getSearchURN() != null) {
            xMLSWDownloadFile.setFileURN(this.researchSetting.getSearchURN().getAsString());
        }
        xMLSWDownloadFile.setStatus(this.status);
        ArrayList arrayList = this.downloadCandidates;
        synchronized (arrayList) {
            object3 = ((AbstractList)this.downloadCandidates).iterator();
            while (object3.hasNext()) {
                object2 = (SWDownloadCandidate)object3.next();
                object = ((SWDownloadCandidate)object2).createXMLSWDownloadCandidate();
                xMLSWDownloadFile.addXMLSWDownloadCandidate((XMLSWDownloadCandidate)object);
            }
        }
        object3 = this.downloadSegments;
        synchronized (object3) {
            object2 = ((AbstractList)this.downloadSegments).iterator();
            while (object2.hasNext()) {
                object = (SWDownloadSegment)object2.next();
                XMLSWDownloadSegment xMLSWDownloadSegment = ((SWDownloadSegment)object).createXMLSWDownloadSegment();
                xMLSWDownloadFile.addXMLSWDownloadSegment(xMLSWDownloadSegment);
            }
        }
        return xMLSWDownloadFile;
    }

    private void lazyCollectTransferData() {
        if (this.status == 3 || this.transferDataUpdateTime > System.currentTimeMillis()) {
            return;
        }
        this.forceCollectionOfTransferData();
    }

    private SWDownloadSegment splitDownloadSegment(SWDownloadSegment sWDownloadSegment) {
        long l = sWDownloadSegment.getTransferredDataSize();
        long l2 = sWDownloadSegment.getTransferDataSizeLeft();
        long l3 = sWDownloadSegment.getStartPosition();
        if (l2 < 131072L) {
            return null;
        }
        long l4 = (long)Math.ceil((double)l + (double)l2 / 2.0);
        sWDownloadSegment.setTransferDataSize(l4);
        long l5 = l3 + l4;
        SWDownloadSegment sWDownloadSegment2 = new SWDownloadSegment(this, this.nextSegmentNumber, l5, (long)Math.floor((double)l2 / 2.0));
        ++this.nextSegmentNumber;
        SWDownloadSegment sWDownloadSegment3 = sWDownloadSegment.getNextDownloadSegment();
        sWDownloadSegment2.setNextDownloadSegment(sWDownloadSegment3);
        sWDownloadSegment.setNextDownloadSegment(sWDownloadSegment2);
        int n = this.downloadSegments.size();
        this.downloadSegments.add(n, sWDownloadSegment2);
        this.fireDownloadSegmentAdded(n);
        this.logDownloadSegments();
        Logger.logMessage(Logger.FINE, (short)2, "Splitted segment: " + sWDownloadSegment + " - New Segment: " + sWDownloadSegment2);
        ServiceManager.getSwarmingManager().saveDownloadList();
        return sWDownloadSegment2;
    }

    private void createDownloadSegments() {
        int n = 0x100000;
        int n2 = (int)Math.ceil(this.fileSize / (long)n);
        this.downloadSegments = new ArrayList(n2);
        long l = 0L;
        int n3 = 0;
        this.nextSegmentNumber = 0;
        SWDownloadSegment sWDownloadSegment = null;
        SWDownloadSegment sWDownloadSegment2 = null;
        while (l < this.fileSize) {
            n3 = (int)Math.min((long)n, this.fileSize - l);
            sWDownloadSegment = new SWDownloadSegment(this, this.nextSegmentNumber, l, n3);
            this.downloadSegments.add(sWDownloadSegment);
            if (sWDownloadSegment2 != null) {
                sWDownloadSegment2.setNextDownloadSegment(sWDownloadSegment);
            }
            sWDownloadSegment2 = sWDownloadSegment;
            l += (long)n3;
            ++this.nextSegmentNumber;
        }
        this.logDownloadSegments();
    }

    private void createDownloadSegments(XMLSWDownloadFile xMLSWDownloadFile) {
        this.downloadSegments = new ArrayList();
        SWDownloadSegment sWDownloadSegment = null;
        this.nextSegmentNumber = 0;
        ArrayList arrayList = new ArrayList();
        Iterator iterator = xMLSWDownloadFile.createXMLSWDownloadSegmentIterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        Collections.sort(arrayList, new SWDownloadSegmentComparator());
        iterator = ((AbstractList)arrayList).iterator();
        while (iterator.hasNext()) {
            XMLSWDownloadSegment xMLSWDownloadSegment = (XMLSWDownloadSegment)iterator.next();
            SWDownloadSegment sWDownloadSegment2 = new SWDownloadSegment(this, xMLSWDownloadSegment);
            this.downloadSegments.add(sWDownloadSegment2);
            if (sWDownloadSegment != null) {
                sWDownloadSegment.setNextDownloadSegment(sWDownloadSegment2);
            }
            this.nextSegmentNumber = Math.max(xMLSWDownloadSegment.getSegmentNumber() + 1, this.nextSegmentNumber);
            sWDownloadSegment = sWDownloadSegment2;
        }
        ++this.nextSegmentNumber;
        this.logDownloadSegments();
    }

    private void createDownloadCandidates(XMLSWDownloadFile xMLSWDownloadFile) {
        ArrayList arrayList = this.downloadCandidates;
        synchronized (arrayList) {
            this.downloadCandidates.clear();
            Iterator iterator = xMLSWDownloadFile.createXMLSWDownloadCandidateIterator();
            while (iterator.hasNext()) {
                XMLSWDownloadCandidate xMLSWDownloadCandidate = (XMLSWDownloadCandidate)iterator.next();
                SWDownloadCandidate sWDownloadCandidate = new SWDownloadCandidate(xMLSWDownloadCandidate, this);
                Logger.logMessage(Logger.FINE, (short)2, "Adding download candidate " + sWDownloadCandidate);
                int n = this.downloadCandidates.size();
                this.downloadCandidates.add(n, sWDownloadCandidate);
                this.fireDownloadCandidateAdded(n);
            }
            Collections.sort(this.downloadCandidates, candidatesComparator);
        }
        ServiceManager.getSwarmingManager().notifyWaitingWorkers();
    }

    private void logDownloadSegments() {
    }

    public void addDownloadCandidatesChangeListener(DownloadCandidatesChangeListener downloadCandidatesChangeListener) {
        this.listenerList.add(class$phex$event$DownloadCandidatesChangeListener == null ? (class$phex$event$DownloadCandidatesChangeListener = SWDownloadFile.class$("phex.event.DownloadCandidatesChangeListener")) : class$phex$event$DownloadCandidatesChangeListener, downloadCandidatesChangeListener);
    }

    public void removeDownloadCandidatesChangeListener(DownloadCandidatesChangeListener downloadCandidatesChangeListener) {
        this.listenerList.remove(class$phex$event$DownloadCandidatesChangeListener == null ? (class$phex$event$DownloadCandidatesChangeListener = SWDownloadFile.class$("phex.event.DownloadCandidatesChangeListener")) : class$phex$event$DownloadCandidatesChangeListener, downloadCandidatesChangeListener);
    }

    private void fireDownloadCandidateChanged(final int n) {
        AsynchronousDispatcher.invokeLater(new Runnable(){
            static /* synthetic */ Class class$phex$event$DownloadCandidatesChangeListener;

            public void run() {
                EventListener[] eventListenerArray = SWDownloadFile.this.listenerList.getListeners(class$phex$event$DownloadCandidatesChangeListener == null ? (class$phex$event$DownloadCandidatesChangeListener = 1.class$("phex.event.DownloadCandidatesChangeListener")) : class$phex$event$DownloadCandidatesChangeListener);
                int n2 = eventListenerArray.length - 1;
                while (n2 >= 0) {
                    DownloadCandidatesChangeListener downloadCandidatesChangeListener = (DownloadCandidatesChangeListener)eventListenerArray[n2];
                    downloadCandidatesChangeListener.downloadCandidateChanged(n);
                    --n2;
                }
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        });
    }

    private void fireDownloadCandidateAdded(final int n) {
        AsynchronousDispatcher.invokeLater(new Runnable(){
            static /* synthetic */ Class class$phex$event$DownloadCandidatesChangeListener;

            public void run() {
                EventListener[] eventListenerArray = SWDownloadFile.this.listenerList.getListeners(class$phex$event$DownloadCandidatesChangeListener == null ? (class$phex$event$DownloadCandidatesChangeListener = 2.class$("phex.event.DownloadCandidatesChangeListener")) : class$phex$event$DownloadCandidatesChangeListener);
                int n2 = eventListenerArray.length - 1;
                while (n2 >= 0) {
                    DownloadCandidatesChangeListener downloadCandidatesChangeListener = (DownloadCandidatesChangeListener)eventListenerArray[n2];
                    downloadCandidatesChangeListener.downloadCandidateAdded(n);
                    --n2;
                }
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        });
    }

    private void fireDownloadCandidateRemoved(final int n) {
        AsynchronousDispatcher.invokeLater(new Runnable(){
            static /* synthetic */ Class class$phex$event$DownloadCandidatesChangeListener;

            public void run() {
                EventListener[] eventListenerArray = SWDownloadFile.this.listenerList.getListeners(class$phex$event$DownloadCandidatesChangeListener == null ? (class$phex$event$DownloadCandidatesChangeListener = 3.class$("phex.event.DownloadCandidatesChangeListener")) : class$phex$event$DownloadCandidatesChangeListener);
                int n2 = eventListenerArray.length - 1;
                while (n2 >= 0) {
                    DownloadCandidatesChangeListener downloadCandidatesChangeListener = (DownloadCandidatesChangeListener)eventListenerArray[n2];
                    downloadCandidatesChangeListener.downloadCandidateRemoved(n);
                    --n2;
                }
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        });
    }

    public void fireDownloadCandidateChanged(SWDownloadCandidate sWDownloadCandidate) {
        int n = this.downloadCandidates.indexOf(sWDownloadCandidate);
        if (n >= 0) {
            this.fireDownloadCandidateChanged(n);
        }
    }

    public void addDownloadSegmentChangeListener(DownloadSegmentsChangeListener downloadSegmentsChangeListener) {
        this.listenerList.add(class$phex$event$DownloadSegmentsChangeListener == null ? (class$phex$event$DownloadSegmentsChangeListener = SWDownloadFile.class$("phex.event.DownloadSegmentsChangeListener")) : class$phex$event$DownloadSegmentsChangeListener, downloadSegmentsChangeListener);
    }

    public void removeDownloadSegmentChangeListener(DownloadSegmentsChangeListener downloadSegmentsChangeListener) {
        this.listenerList.remove(class$phex$event$DownloadSegmentsChangeListener == null ? (class$phex$event$DownloadSegmentsChangeListener = SWDownloadFile.class$("phex.event.DownloadSegmentsChangeListener")) : class$phex$event$DownloadSegmentsChangeListener, downloadSegmentsChangeListener);
    }

    private void fireDownloadSegmentChanged(final int n) {
        AsynchronousDispatcher.invokeLater(new Runnable(){
            static /* synthetic */ Class class$phex$event$DownloadSegmentsChangeListener;

            public void run() {
                EventListener[] eventListenerArray = SWDownloadFile.this.listenerList.getListeners(class$phex$event$DownloadSegmentsChangeListener == null ? (class$phex$event$DownloadSegmentsChangeListener = 4.class$("phex.event.DownloadSegmentsChangeListener")) : class$phex$event$DownloadSegmentsChangeListener);
                int n2 = eventListenerArray.length - 1;
                while (n2 >= 0) {
                    DownloadSegmentsChangeListener downloadSegmentsChangeListener = (DownloadSegmentsChangeListener)eventListenerArray[n2];
                    downloadSegmentsChangeListener.downloadSegmentChanged(n);
                    --n2;
                }
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        });
    }

    private void fireDownloadSegmentAdded(final int n) {
        AsynchronousDispatcher.invokeLater(new Runnable(){
            static /* synthetic */ Class class$phex$event$DownloadSegmentsChangeListener;

            public void run() {
                EventListener[] eventListenerArray = SWDownloadFile.this.listenerList.getListeners(class$phex$event$DownloadSegmentsChangeListener == null ? (class$phex$event$DownloadSegmentsChangeListener = 5.class$("phex.event.DownloadSegmentsChangeListener")) : class$phex$event$DownloadSegmentsChangeListener);
                int n2 = eventListenerArray.length - 1;
                while (n2 >= 0) {
                    DownloadSegmentsChangeListener downloadSegmentsChangeListener = (DownloadSegmentsChangeListener)eventListenerArray[n2];
                    downloadSegmentsChangeListener.downloadSegmentAdded(n);
                    --n2;
                }
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        });
    }

    private void fireDownloadSegmentRemoved(final int n) {
        AsynchronousDispatcher.invokeLater(new Runnable(){
            static /* synthetic */ Class class$phex$event$DownloadSegmentsChangeListener;

            public void run() {
                EventListener[] eventListenerArray = SWDownloadFile.this.listenerList.getListeners(class$phex$event$DownloadSegmentsChangeListener == null ? (class$phex$event$DownloadSegmentsChangeListener = 6.class$("phex.event.DownloadSegmentsChangeListener")) : class$phex$event$DownloadSegmentsChangeListener);
                int n2 = eventListenerArray.length - 1;
                while (n2 >= 0) {
                    DownloadSegmentsChangeListener downloadSegmentsChangeListener = (DownloadSegmentsChangeListener)eventListenerArray[n2];
                    downloadSegmentsChangeListener.downloadSegmentRemoved(n);
                    --n2;
                }
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        });
    }

    public void fireDownloadSegmentChanged(SWDownloadSegment sWDownloadSegment) {
        int n = this.downloadSegments.indexOf(sWDownloadSegment);
        if (n >= 0) {
            this.fireDownloadSegmentChanged(n);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class SWDownloadSegmentComparator
    implements Comparator {
        private SWDownloadSegmentComparator() {
        }

        public int compare(Object object, Object object2) {
            XMLSWDownloadSegment xMLSWDownloadSegment = (XMLSWDownloadSegment)object;
            XMLSWDownloadSegment xMLSWDownloadSegment2 = (XMLSWDownloadSegment)object2;
            long l = xMLSWDownloadSegment.getStartPosition() - xMLSWDownloadSegment2.getStartPosition();
            if (l < 0L) {
                return -1;
            }
            if (l > 0L) {
                return 1;
            }
            return 0;
        }
    }

    private static class SWDownloadCandidateComparator
    implements Comparator {
        private SWDownloadCandidateComparator() {
        }

        public int compare(Object object, Object object2) {
            SWDownloadCandidate sWDownloadCandidate = (SWDownloadCandidate)object;
            SWDownloadCandidate sWDownloadCandidate2 = (SWDownloadCandidate)object2;
            return sWDownloadCandidate2.getHostRating() - sWDownloadCandidate.getHostRating();
        }
    }
}

