/*
 * Decompiled with CFR 0.152.
 */
package phex.download.swarming;

import java.io.File;
import java.io.IOException;
import java.net.Socket;
import phex.ServiceManager;
import phex.common.ThreadPool;
import phex.connection.ConnectionFailedException;
import phex.download.DownloadEngine;
import phex.download.HostBusyException;
import phex.download.PushHandler;
import phex.download.swarming.SWDownloadCandidate;
import phex.download.swarming.SWDownloadFile;
import phex.download.swarming.SWDownloadSegment;
import phex.download.swarming.SWDownloadSet;
import phex.download.swarming.SwarmingManager;
import phex.host.UnusableHostException;
import phex.utils.Logger;

public class SWDownloadWorker
implements Runnable {
    private boolean isRunning = true;
    private DownloadEngine downloadEngine;
    private SwarmingManager swarmingMgr = ServiceManager.getSwarmingManager();

    public SWDownloadWorker() {
        ThreadPool.getInstance().addJob(this);
        Logger.logMessage(Logger.FINE, (short)2, "Started SWDownloadWorker");
    }

    public void run() {
        try {
            SwarmingManager swarmingManager = ServiceManager.getSwarmingManager();
            while (this.isRunning) {
                Object var5_4;
                boolean bl = swarmingManager.checkToStopWorker(this);
                if (bl) break;
                Logger.logMessage(Logger.FINE, (short)2, this.toString() + " - SWDownloadWorker Allocating DownloadSet.");
                SWDownloadSet sWDownloadSet = swarmingManager.allocateDownloadSet(this);
                if (sWDownloadSet == null) continue;
                Logger.logMessage(Logger.FINE, (short)2, this.toString() + " - SWDownloadWorker Allocated DownloadSet " + sWDownloadSet.toString());
                try {
                    this.handleDownload(sWDownloadSet.getDownloadFile(), sWDownloadSet.getDownloadCandidate(), sWDownloadSet.getDownloadSegment());
                    var5_4 = null;
                    if (sWDownloadSet == null) continue;
                }
                catch (Throwable throwable) {
                    var5_4 = null;
                    if (sWDownloadSet != null) {
                        Logger.logMessage(Logger.FINE, (short)2, this.toString() + " - Releasing DownloadSet " + sWDownloadSet.toString());
                        swarmingManager.releaseDownloadSet(sWDownloadSet);
                    }
                    throw throwable;
                }
                Logger.logMessage(Logger.FINE, (short)2, this.toString() + " - Releasing DownloadSet " + sWDownloadSet.toString());
                swarmingManager.releaseDownloadSet(sWDownloadSet);
                {
                }
            }
            Object var7_6 = null;
            if (this.isRunning) {
                this.swarmingMgr.notifyWorkerShoutdown(this);
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (this.isRunning) {
                this.swarmingMgr.notifyWorkerShoutdown(this);
            }
            throw throwable;
        }
    }

    public void stopWorker() {
        this.isRunning = false;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public void stopDownload() {
        if (this.downloadEngine != null) {
            this.downloadEngine.stopDownload();
        }
    }

    private void handleDownload(SWDownloadFile sWDownloadFile, SWDownloadCandidate sWDownloadCandidate, SWDownloadSegment sWDownloadSegment) {
        if (sWDownloadCandidate.isPushNeeded()) {
            this.connectDownloadEngineViaPush(sWDownloadFile, sWDownloadCandidate, sWDownloadSegment);
        } else {
            this.connectDownloadEngine(sWDownloadFile, sWDownloadCandidate, sWDownloadSegment);
        }
        if (this.downloadEngine == null) {
            return;
        }
        try {
            try {
                this.startDownload(sWDownloadFile, sWDownloadCandidate);
                sWDownloadCandidate.setStatus((short)10);
            }
            catch (IOException iOException) {
                sWDownloadCandidate.setStatus((short)10);
                Logger.logMessage(Logger.FINE, (short)2, iOException);
                Object var6_5 = null;
                sWDownloadFile.mergeCompletedSegments(this);
                sWDownloadFile.verifyStatus();
                return;
            }
            Object var6_4 = null;
            sWDownloadFile.mergeCompletedSegments(this);
            sWDownloadFile.verifyStatus();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            sWDownloadFile.mergeCompletedSegments(this);
            sWDownloadFile.verifyStatus();
            throw throwable;
        }
        if (sWDownloadFile.isDownloadCompleted()) {
            sWDownloadFile.moveToDestinationFile();
        }
    }

    private void connectDownloadEngine(SWDownloadFile sWDownloadFile, SWDownloadCandidate sWDownloadCandidate, SWDownloadSegment sWDownloadSegment) {
        sWDownloadCandidate.setStatus((short)11);
        this.downloadEngine = null;
        File file = sWDownloadSegment.getIncompleteFile();
        this.downloadEngine = new DownloadEngine(sWDownloadFile, sWDownloadCandidate, sWDownloadSegment, file);
        try {
            this.downloadEngine.connect(0);
        }
        catch (HostBusyException hostBusyException) {
            this.downloadEngine = null;
            sWDownloadCandidate.setStatus((short)13);
            Logger.logMessage(Logger.FINEST, (short)2, hostBusyException);
            return;
        }
        catch (ConnectionFailedException connectionFailedException) {
            Logger.logMessage(Logger.FINEST, (short)2, connectionFailedException);
            this.connectDownloadEngineViaPush(sWDownloadFile, sWDownloadCandidate, sWDownloadSegment);
            return;
        }
        catch (UnusableHostException unusableHostException) {
            this.downloadEngine = null;
            Logger.logMessage(Logger.WARNING, (short)2, unusableHostException);
            sWDownloadFile.removeDownloadCandidate(sWDownloadCandidate);
            return;
        }
        catch (IOException iOException) {
            this.downloadEngine = null;
            this.connectDownloadEngineViaPush(sWDownloadFile, sWDownloadCandidate, sWDownloadSegment);
            Logger.logMessage(Logger.SEVERE, (short)2, iOException, "Error at Host: " + sWDownloadCandidate.getHostAddress().getFullHostName() + " Vender: " + sWDownloadCandidate.getVendor());
            return;
        }
    }

    private void connectDownloadEngineViaPush(SWDownloadFile sWDownloadFile, SWDownloadCandidate sWDownloadCandidate, SWDownloadSegment sWDownloadSegment) {
        this.downloadEngine = null;
        if (ServiceManager.sCfg.isBehindFirewall && !ServiceManager.sCfg.connectedToLAN && sWDownloadCandidate.getHostAddress().isPrivateIP()) {
            Logger.logMessage(Logger.FINER, (short)2, "We are behind a firewall, we are not in LAN, and candidate has private IP, we cant try a PUSH.");
            if (sWDownloadCandidate.isPushNeeded()) {
                sWDownloadFile.removeDownloadCandidate(sWDownloadCandidate);
            } else {
                sWDownloadCandidate.setStatus((short)15);
            }
            return;
        }
        sWDownloadCandidate.setStatus((short)14);
        Socket socket = PushHandler.requestSocketViaPush(sWDownloadCandidate);
        if (socket == null) {
            if (sWDownloadCandidate.isPushNeeded()) {
                sWDownloadFile.removeDownloadCandidate(sWDownloadCandidate);
            } else {
                sWDownloadCandidate.setStatus((short)15);
            }
            Logger.logMessage(Logger.FINE, (short)2, "Push request fails for candidate: " + sWDownloadCandidate);
            return;
        }
        File file = sWDownloadSegment.getIncompleteFile();
        this.downloadEngine = new DownloadEngine(socket, sWDownloadFile, sWDownloadCandidate, sWDownloadSegment, file);
        try {
            this.downloadEngine.connect(0);
        }
        catch (HostBusyException hostBusyException) {
            this.downloadEngine = null;
            sWDownloadCandidate.setStatus((short)13);
            Logger.logMessage(Logger.FINEST, (short)2, hostBusyException);
            return;
        }
        catch (UnusableHostException unusableHostException) {
            this.downloadEngine = null;
            Logger.logMessage(Logger.WARNING, (short)2, unusableHostException);
            sWDownloadFile.removeDownloadCandidate(sWDownloadCandidate);
            return;
        }
        catch (IOException iOException) {
            sWDownloadCandidate.setStatus((short)10);
            Logger.logError(iOException);
            this.downloadEngine = null;
            return;
        }
    }

    private void startDownload(SWDownloadFile sWDownloadFile, SWDownloadCandidate sWDownloadCandidate) throws IOException {
        sWDownloadFile.setStatus((short)2);
        sWDownloadCandidate.setStatus((short)12);
        this.downloadEngine.startDownload();
    }
}

