/*
 * Decompiled with CFR 0.152.
 */
package phex.download.swarming;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.crimson.tree.XmlDocument;
import org.w3c.dom.Document;
import phex.Res;
import phex.ServiceManager;
import phex.common.TransferRateService;
import phex.common.URN;
import phex.download.RemoteFile;
import phex.download.swarming.SWDownloadCandidate;
import phex.download.swarming.SWDownloadFile;
import phex.download.swarming.SWDownloadSegment;
import phex.download.swarming.SWDownloadSet;
import phex.download.swarming.SWDownloadWorker;
import phex.event.AsynchronousDispatcher;
import phex.event.DownloadFilesChangeListener;
import phex.utils.FileUtils;
import phex.utils.Logger;
import phex.xml.XMLBuilder;
import phex.xml.XMLDownloadFile;
import phex.xml.XMLDownloadList;
import phex.xml.XMLPhex;
import phex.xml.XMLPhexXMLCodec;
import phex.xml.XMLRemoteFile;
import phex.xml.XMLSWDownloadCandidate;
import phex.xml.XMLSWDownloadFile;
import phex.xml.XMLSWDownloadList;
import phex.xml.XMLSWDownloadSegment;

public class SwarmingManager {
    private short workerCount = 0;
    private ArrayList downloadList;
    private TransferRateService transferRateService;
    private ArrayList listenerList = new ArrayList(2);

    public SwarmingManager() {
        this.downloadList = new ArrayList(ServiceManager.sCfg.mMaxDownload);
        this.transferRateService = ServiceManager.getTransferRateService();
    }

    public synchronized void addFileToDownload(RemoteFile remoteFile, String string, String string2) {
        int n;
        SWDownloadFile sWDownloadFile = new SWDownloadFile(string, string2, remoteFile.getFileSize(), remoteFile.getURN());
        sWDownloadFile.addDownloadCandidate(remoteFile);
        ArrayList arrayList = this.downloadList;
        synchronized (arrayList) {
            n = this.downloadList.size();
            this.downloadList.add(n, sWDownloadFile);
        }
        this.fireDownloadFileAdded(n);
        sWDownloadFile.setStatus((short)1);
        this.createRequiredWorkers();
        this.saveDownloadList();
    }

    public void removeDownloadFile(SWDownloadFile sWDownloadFile) {
        sWDownloadFile.stopDownload();
        ArrayList arrayList = this.downloadList;
        synchronized (arrayList) {
            int n = this.downloadList.indexOf(sWDownloadFile);
            if (n >= 0) {
                this.downloadList.remove(n);
                this.fireDownloadFileRemoved(n);
            }
        }
        sWDownloadFile.removeDownloadSegmentFiles();
        this.saveDownloadList();
    }

    public void removeDownloadFiles(SWDownloadFile[] sWDownloadFileArray) {
        int n = 0;
        while (n < sWDownloadFileArray.length) {
            sWDownloadFileArray[n].stopDownload();
            ArrayList arrayList = this.downloadList;
            synchronized (arrayList) {
                int n2 = this.downloadList.indexOf(sWDownloadFileArray[n]);
                if (n2 >= 0) {
                    this.downloadList.remove(n2);
                    this.fireDownloadFileRemoved(n2);
                }
            }
            sWDownloadFileArray[n].removeDownloadSegmentFiles();
            ++n;
        }
        this.saveDownloadList();
    }

    public void moveDownloadFile(SWDownloadFile sWDownloadFile, boolean bl) {
        ArrayList arrayList = this.downloadList;
        synchronized (arrayList) {
            int n = this.downloadList.indexOf(sWDownloadFile);
            if (n >= 0) {
                int n2 = n;
                n2 = bl ? --n2 : ++n2;
                if (n2 < 0 || n2 >= this.downloadList.size()) {
                    return;
                }
                this.downloadList.remove(n);
                this.downloadList.add(n2, sWDownloadFile);
                this.fireDownloadFileChanged(n);
                this.fireDownloadFileChanged(n2);
            }
        }
    }

    public synchronized void notifyWaitingWorkers() {
        this.notifyAll();
    }

    public int getDownloadFileCount() {
        return this.downloadList.size();
    }

    public int getDownloadFileCount(int n) {
        int n2 = 0;
        ArrayList arrayList = this.downloadList;
        synchronized (arrayList) {
            Iterator iterator = ((AbstractList)this.downloadList).iterator();
            while (iterator.hasNext()) {
                SWDownloadFile sWDownloadFile = (SWDownloadFile)iterator.next();
                if (sWDownloadFile.getStatus() != n) continue;
                ++n2;
            }
        }
        return n2;
    }

    public SWDownloadFile getDownloadFile(int n) {
        if (n < 0 || n >= this.downloadList.size()) {
            return null;
        }
        return (SWDownloadFile)this.downloadList.get(n);
    }

    public SWDownloadFile[] getDownloadFiles(long l, URN uRN) {
        SWDownloadFile[] sWDownloadFileArray;
        ArrayList<SWDownloadFile> arrayList = new ArrayList<SWDownloadFile>(2);
        ArrayList arrayList2 = this.downloadList;
        synchronized (arrayList2) {
            sWDownloadFileArray = ((AbstractList)this.downloadList).iterator();
            while (sWDownloadFileArray.hasNext()) {
                SWDownloadFile sWDownloadFile = (SWDownloadFile)sWDownloadFileArray.next();
                if (sWDownloadFile.getTotalDataSize() != l) continue;
                URN uRN2 = sWDownloadFile.getResearchSetting().getSearchURN();
                if (uRN != null && uRN2 != null && !uRN.equals(uRN2)) continue;
                arrayList.add(sWDownloadFile);
            }
        }
        sWDownloadFileArray = new SWDownloadFile[arrayList.size()];
        arrayList.toArray(sWDownloadFileArray);
        return sWDownloadFileArray;
    }

    public synchronized SWDownloadSet allocateDownloadSet(SWDownloadWorker sWDownloadWorker) {
        do {
            ArrayList arrayList = this.downloadList;
            synchronized (arrayList) {
                SWDownloadFile sWDownloadFile = null;
                SWDownloadCandidate sWDownloadCandidate = null;
                SWDownloadSegment sWDownloadSegment = null;
                Iterator iterator = ((AbstractList)this.downloadList).iterator();
                while (iterator.hasNext()) {
                    SWDownloadSet sWDownloadSet;
                    sWDownloadFile = (SWDownloadFile)iterator.next();
                    if (!sWDownloadFile.isAbleToBeAllocated()) {
                        Logger.logMessage(Logger.FINEST, (short)2, "Download file not able to be allocated: " + sWDownloadFile);
                        continue;
                    }
                    sWDownloadCandidate = sWDownloadFile.allocateDownloadCandidate(sWDownloadWorker);
                    if (sWDownloadCandidate == null) {
                        Logger.logMessage(Logger.FINEST, (short)2, "Allocating DownloadSet - No download candidate. " + sWDownloadWorker.toString());
                        continue;
                    }
                    sWDownloadSegment = sWDownloadFile.allocateDownloadSegment(sWDownloadWorker);
                    if (sWDownloadSegment == null) {
                        Logger.logMessage(Logger.FINER, (short)2, "Allocating DownloadSet - No download segment. " + sWDownloadWorker.toString());
                        sWDownloadFile.releaseDownloadCandidate(sWDownloadCandidate);
                        continue;
                    }
                    sWDownloadFile.incrementWorkerCount();
                    SWDownloadSet sWDownloadSet2 = sWDownloadSet = new SWDownloadSet(sWDownloadFile, sWDownloadCandidate, sWDownloadSegment);
                    return sWDownloadSet2;
                }
            }
            try {
                this.wait(10000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (!this.checkToStopWorker(sWDownloadWorker));
        return null;
    }

    public void releaseDownloadSet(SWDownloadSet sWDownloadSet) {
        SWDownloadFile sWDownloadFile = sWDownloadSet.getDownloadFile();
        SWDownloadCandidate sWDownloadCandidate = sWDownloadSet.getDownloadCandidate();
        sWDownloadFile.releaseDownloadSegment(sWDownloadSet.getDownloadSegment());
        sWDownloadCandidate.releaseDownloadSegment();
        sWDownloadFile.releaseDownloadCandidate(sWDownloadCandidate);
        sWDownloadFile.decrementWorkerCount();
    }

    public boolean isNewLocalFilenameUsed(SWDownloadFile sWDownloadFile, File file) {
        int n = this.downloadList.size();
        int n2 = 0;
        while (n2 < n) {
            SWDownloadFile sWDownloadFile2 = (SWDownloadFile)this.downloadList.get(n2);
            if ((sWDownloadFile == null || sWDownloadFile2 != sWDownloadFile) && sWDownloadFile2.getDestinationFile().compareTo(file) == 0) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void loadDownloadList() {
        String string = ServiceManager.getXMLDownloadSaveFilename();
        if (string == null) {
            Logger.logMessage(Logger.FINE, (short)2, "Configuration file name not set.");
            return;
        }
        File file = new File(string);
        File file2 = new File(string + ".bak");
        if (!file.exists() && !file2.exists()) {
            Logger.logMessage(Logger.FINE, (short)2, "No download configuration file found.");
            return;
        }
        Logger.logMessage(Logger.FINE, (short)2, "Load download configuration file.");
        Document document = null;
        if (file.exists()) {
            Logger.logMessage(Logger.FINE, (short)2, "Load download configuration file: download file.");
            document = XMLBuilder.loadFromFile(file);
            if (document == null) {
                Logger.logMessage(Logger.SEVERE, (short)2, "Error while parsing download xml file.");
            }
        }
        if (document == null && file2.exists()) {
            Logger.logMessage(Logger.FINE, (short)2, "Load download configuration file: download file backup.");
            document = XMLBuilder.loadFromFile(file2);
            if (document == null) {
                Logger.logMessage(Logger.SEVERE, (short)2, "Error while parsing download xml file backup.");
            }
            return;
        }
        XMLPhex xMLPhex = XMLPhexXMLCodec.decodeXML(document.getDocumentElement());
        if (xMLPhex == null) {
            Logger.logMessage(Logger.SEVERE, (short)2, "Error creating xphex.");
            return;
        }
        XMLDownloadList xMLDownloadList = xMLPhex.getDownloadList();
        if (xMLDownloadList != null) {
            this.updateOldXMLDownloadList(xMLDownloadList);
        } else {
            XMLSWDownloadList xMLSWDownloadList = xMLPhex.getSwDownloadList();
            if (xMLSWDownloadList != null) {
                this.loadXMLSWDownloadList(xMLSWDownloadList);
            } else {
                Logger.logMessage(Logger.FINE, (short)2, "No SWDownloadList found.");
            }
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void saveDownloadList() {
        OutputStreamWriter outputStreamWriter = null;
        File file = new File(ServiceManager.getXMLDownloadSaveFilename());
        File file2 = new File(ServiceManager.getXMLDownloadSaveFilename() + ".bak");
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF8");
        XMLPhex xMLPhex = new XMLPhex();
        XMLSWDownloadList xMLSWDownloadList = this.createXMLSWDownloadList();
        xMLPhex.setSwDownloadList(xMLSWDownloadList);
        xMLPhex.setPhexVersion(Res.getStr("Program.Version"));
        XmlDocument xmlDocument = XMLPhexXMLCodec.encodeXML(xMLPhex);
        xmlDocument.write(outputStreamWriter, "UTF-8");
        FileUtils.copyFile(file2, file);
        file2.delete();
        Object var9_11 = null;
        if (outputStreamWriter == null) return;
        try {
            outputStreamWriter.close();
            return;
        }
        catch (IOException iOException) {}
        return;
        {
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Logger.logError(unsupportedEncodingException);
                Object var9_12 = null;
                if (outputStreamWriter == null) return;
                try {
                    outputStreamWriter.close();
                    return;
                }
                catch (IOException iOException) {}
                return;
            }
            catch (FileNotFoundException fileNotFoundException) {
                Logger.logError(fileNotFoundException);
                Object var9_13 = null;
                if (outputStreamWriter == null) return;
                try {
                    outputStreamWriter.close();
                    return;
                }
                catch (IOException iOException) {}
                return;
            }
            catch (IOException iOException) {
                Logger.logError(iOException);
                Object var9_14 = null;
                if (outputStreamWriter == null) return;
                try {
                    outputStreamWriter.close();
                    return;
                }
                catch (IOException iOException2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var9_15 = null;
            if (outputStreamWriter == null) throw throwable;
            try {
                outputStreamWriter.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public synchronized boolean checkToStopWorker(SWDownloadWorker sWDownloadWorker) {
        int n = Math.min(this.downloadList.size() * ServiceManager.sCfg.maxWorkerPerDownload, ServiceManager.sCfg.maxTotalDownloadWorker);
        if (this.workerCount > n) {
            if (sWDownloadWorker.isRunning()) {
                sWDownloadWorker.stopWorker();
                this.workerCount = (short)(this.workerCount - 1);
            }
            return true;
        }
        return false;
    }

    public void notifyWorkerShoutdown(SWDownloadWorker sWDownloadWorker) {
        sWDownloadWorker.stopWorker();
        this.workerCount = (short)(this.workerCount - 1);
    }

    private void updateOldXMLDownloadList(XMLDownloadList xMLDownloadList) {
        Logger.logMessage(Logger.FINE, (short)2, "Updating old download list.");
        XMLSWDownloadList xMLSWDownloadList = new XMLSWDownloadList();
        Iterator iterator = xMLDownloadList.createXMLDownloadFileIterator();
        while (iterator.hasNext()) {
            Object object;
            Object object2;
            XMLDownloadFile xMLDownloadFile = (XMLDownloadFile)iterator.next();
            XMLSWDownloadFile xMLSWDownloadFile = new XMLSWDownloadFile();
            xMLSWDownloadFile.setFilesize(xMLDownloadFile.getFilesize());
            xMLSWDownloadFile.setLocalFilename(xMLDownloadFile.getLocalFilename());
            xMLSWDownloadFile.setSearchterm(xMLDownloadFile.getSearchterm());
            xMLSWDownloadFile.setStatus((short)1);
            Iterator iterator2 = xMLDownloadFile.createXMLRemoteFileIterator();
            while (iterator2.hasNext()) {
                object2 = (XMLRemoteFile)iterator2.next();
                object = new XMLSWDownloadCandidate();
                ((XMLSWDownloadCandidate)object).setFileIndex(((XMLRemoteFile)object2).getFileIndex());
                ((XMLSWDownloadCandidate)object).setFileName(((XMLRemoteFile)object2).getFileName());
                ((XMLSWDownloadCandidate)object).setGuid(((XMLRemoteFile)object2).getGuid());
                ((XMLSWDownloadCandidate)object).setRemoteHost(((XMLRemoteFile)object2).getRemoteHost());
                xMLSWDownloadFile.addXMLSWDownloadCandidate((XMLSWDownloadCandidate)object);
            }
            object2 = ServiceManager.sCfg.incompleteDir + File.separator + FileUtils.convertToLocalSystemFilename(xMLDownloadFile.getLocalFilename()) + ".dl";
            object = new XMLSWDownloadSegment();
            ((XMLSWDownloadSegment)object).setIncompleteFileName(new File((String)object2).getAbsolutePath());
            ((XMLSWDownloadSegment)object).setLength(xMLDownloadFile.getFilesize());
            ((XMLSWDownloadSegment)object).setSegmentNumber(0);
            ((XMLSWDownloadSegment)object).setStartPosition(0L);
            xMLSWDownloadFile.addXMLSWDownloadSegment((XMLSWDownloadSegment)object);
            xMLSWDownloadList.addXMLSWDownloadFile(xMLSWDownloadFile);
        }
        this.loadXMLSWDownloadList(xMLSWDownloadList);
    }

    private void loadXMLSWDownloadList(XMLSWDownloadList xMLSWDownloadList) {
        ArrayList arrayList = this.downloadList;
        synchronized (arrayList) {
            this.downloadList.clear();
            Iterator iterator = xMLSWDownloadList.createXMLSWDownloadFileIterator();
            Logger.logMessage(Logger.FINER, (short)2, "Loading SWDownload xml");
            while (iterator.hasNext()) {
                XMLSWDownloadFile xMLSWDownloadFile = (XMLSWDownloadFile)iterator.next();
                SWDownloadFile sWDownloadFile = new SWDownloadFile(xMLSWDownloadFile);
                int n = this.downloadList.size();
                this.downloadList.add(n, sWDownloadFile);
                Logger.logMessage(Logger.FINER, (short)2, "Loaded SWDownloadFile: " + sWDownloadFile);
                this.fireDownloadFileAdded(n);
            }
            this.createRequiredWorkers();
        }
    }

    private XMLSWDownloadList createXMLSWDownloadList() {
        XMLSWDownloadList xMLSWDownloadList = new XMLSWDownloadList();
        ArrayList arrayList = this.downloadList;
        synchronized (arrayList) {
            Iterator iterator = ((AbstractList)this.downloadList).iterator();
            while (iterator.hasNext()) {
                SWDownloadFile sWDownloadFile = (SWDownloadFile)iterator.next();
                xMLSWDownloadList.addXMLSWDownloadFile(sWDownloadFile.createXMLSWDownloadFile());
            }
        }
        return xMLSWDownloadList;
    }

    private synchronized void createRequiredWorkers() {
        int n = Math.min(this.downloadList.size() * ServiceManager.sCfg.maxWorkerPerDownload, ServiceManager.sCfg.maxTotalDownloadWorker);
        int n2 = this.workerCount;
        while (n2 < n) {
            SWDownloadWorker sWDownloadWorker = new SWDownloadWorker();
            this.workerCount = (short)(this.workerCount + 1);
            ++n2;
        }
    }

    public void addDownloadFilesChangeListener(DownloadFilesChangeListener downloadFilesChangeListener) {
        this.listenerList.add(downloadFilesChangeListener);
    }

    public void removeDownloadFilesChangeListener(DownloadFilesChangeListener downloadFilesChangeListener) {
        ((AbstractCollection)this.listenerList).remove(downloadFilesChangeListener);
    }

    private void fireDownloadFileChanged(final int n) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                Object[] objectArray = SwarmingManager.this.listenerList.toArray();
                int n2 = objectArray.length - 1;
                while (n2 >= 0) {
                    DownloadFilesChangeListener downloadFilesChangeListener = (DownloadFilesChangeListener)objectArray[n2];
                    downloadFilesChangeListener.downloadFileChanged(n);
                    --n2;
                }
            }
        });
    }

    private void fireDownloadFileAdded(final int n) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                Object[] objectArray = SwarmingManager.this.listenerList.toArray();
                int n2 = objectArray.length - 1;
                while (n2 >= 0) {
                    DownloadFilesChangeListener downloadFilesChangeListener = (DownloadFilesChangeListener)objectArray[n2];
                    downloadFilesChangeListener.downloadFileAdded(n);
                    --n2;
                }
            }
        });
    }

    private void fireDownloadFileRemoved(final int n) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                Object[] objectArray = SwarmingManager.this.listenerList.toArray();
                int n2 = objectArray.length - 1;
                while (n2 >= 0) {
                    DownloadFilesChangeListener downloadFilesChangeListener = (DownloadFilesChangeListener)objectArray[n2];
                    downloadFilesChangeListener.downloadFileRemoved(n);
                    --n2;
                }
            }
        });
    }

    public void fireDownloadFileChanged(SWDownloadFile sWDownloadFile) {
        int n = this.downloadList.indexOf(sWDownloadFile);
        if (n >= 0) {
            this.fireDownloadFileChanged(n);
        }
    }
}

