/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.common;

import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import phex.gui.actions.CloseGUIAction;
import phex.gui.common.DesktopIndicatorListener;
import phex.utils.Localizer;

public class DesktopIndicator {
    private static boolean isNativeLibLoaded = true;
    private int image;
    private String tooltip;
    private ArrayList listeners = new ArrayList();
    private int handler = 0;

    public DesktopIndicator() throws UnsupportedOperationException {
        if (!isNativeLibLoaded) {
            throw new UnsupportedOperationException("Cant load Phex.dll");
        }
        this.image = DesktopIndicator.nativeLoadImageIDStrFromResource("Phex");
        this.tooltip = Localizer.getString("TTTSysTray");
        this.showIndicator();
        this.hideIndicator();
    }

    public static void freeImage(int n) {
        try {
            DesktopIndicator.nativeFreeImage(n);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            // empty catch block
        }
    }

    public static int loadImage(String string) {
        try {
            return DesktopIndicator.nativeLoadImage(string);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            return -1;
        }
    }

    public void showIndicator() {
        this.setNativeMenuText(Localizer.getString("OpenPhex"), Localizer.getString("ExitPhex"));
        this.nativeEnable(this.image, this.tooltip);
    }

    public void hideIndicator() {
        this.nativeHide();
    }

    public void removeIndicator() {
        this.nativeDisable();
    }

    public void update(int n, String string) {
        this.image = n;
        this.tooltip = string;
        try {
            this.nativeEnable(n, string);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            // empty catch block
        }
    }

    private synchronized native void setNativeMenuText(String var1, String var2) throws UnsatisfiedLinkError;

    private synchronized native void nativeEnable(int var1, String var2) throws UnsatisfiedLinkError;

    private synchronized native void nativeHide() throws UnsatisfiedLinkError;

    private synchronized native void nativeDisable() throws UnsatisfiedLinkError;

    private static synchronized native int nativeLoadImage(String var0) throws UnsatisfiedLinkError;

    private static synchronized native void nativeFreeImage(int var0) throws UnsatisfiedLinkError;

    private static synchronized native int nativeLoadImageIDFromResource(int var0) throws UnsatisfiedLinkError;

    private static synchronized native int nativeLoadImageIDStrFromResource(String var0) throws UnsatisfiedLinkError;

    public void addDesktopIndicatorListener(DesktopIndicatorListener desktopIndicatorListener) {
        this.listeners.add(desktopIndicatorListener);
    }

    public void removeDesktopIndicatorListener(DesktopIndicatorListener desktopIndicatorListener) {
        ((AbstractCollection)this.listeners).remove(desktopIndicatorListener);
    }

    public void fireClicked() {
        Iterator iterator = ((AbstractList)this.listeners).iterator();
        while (iterator.hasNext()) {
            DesktopIndicatorListener desktopIndicatorListener = (DesktopIndicatorListener)iterator.next();
            desktopIndicatorListener.onDesktopIndicatorClicked(this);
        }
    }

    public void exitApplication() {
        CloseGUIAction.shutdown();
    }

    static {
        try {
            System.loadLibrary("Phex");
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            isNativeLibLoaded = false;
        }
    }
}

