/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.common;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.event.MouseInputAdapter;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableModel;
import phex.gui.common.FWTableColumn;
import phex.gui.models.FWSortedTableModel;
import phex.gui.models.FWTableColumnModel;

public class FWTable
extends JTable {
    private boolean isColumnResizeToFitEnabled = false;
    private boolean isColumnSortingEnabled = false;
    private JPopupMenu headerPopup;

    public FWTable(TableModel tableModel, FWTableColumnModel fWTableColumnModel) {
        super(tableModel, fWTableColumnModel);
        this.tableHeader.addMouseListener(new MouseHandler());
    }

    public void activateAllHeaderActions() {
        this.activateHeaderPopupMenu();
        this.activateColumnResizeToFit();
        this.activateColumnSorting();
    }

    public void activateColumnSorting() {
        this.setColumnSelectionAllowed(false);
        this.isColumnSortingEnabled = true;
        this.tableHeader.setDefaultRenderer(new SortedTableHeaderRenderer());
    }

    public void activateColumnResizeToFit() {
        this.isColumnResizeToFitEnabled = true;
    }

    public void activateHeaderPopupMenu() {
        this.headerPopup = new JPopupMenu();
        PopupMenuActionHandler popupMenuActionHandler = new PopupMenuActionHandler();
        Iterator iterator = ((FWTableColumnModel)this.columnModel).createAllColumnsIterator();
        while (iterator.hasNext()) {
            FWTableColumn fWTableColumn = (FWTableColumn)iterator.next();
            ColumnCheckBoxMenuItem columnCheckBoxMenuItem = new ColumnCheckBoxMenuItem(fWTableColumn);
            columnCheckBoxMenuItem.setEnabled(fWTableColumn.isHideable());
            columnCheckBoxMenuItem.addActionListener(popupMenuActionHandler);
            this.headerPopup.add(columnCheckBoxMenuItem);
        }
    }

    public int convertRowIndexToModel(int n) {
        if (this.isColumnSortingEnabled) {
            return ((FWSortedTableModel)this.dataModel).convertRowIndexToModel(n);
        }
        return n;
    }

    public int[] convertRowIndicesToModel(int[] nArray) {
        if (this.isColumnSortingEnabled) {
            FWSortedTableModel fWSortedTableModel = (FWSortedTableModel)this.dataModel;
            int[] nArray2 = new int[nArray.length];
            int n = 0;
            while (n < nArray.length) {
                nArray2[n] = fWSortedTableModel.convertRowIndexToModel(nArray[n]);
                ++n;
            }
            return nArray2;
        }
        return nArray;
    }

    private FWTableColumn getResizingColumn(Point point) {
        int n;
        int n2 = this.tableHeader.columnAtPoint(point);
        if (n2 == -1) {
            return null;
        }
        Rectangle rectangle = this.tableHeader.getHeaderRect(n2);
        rectangle.grow(-3, 0);
        if (rectangle.contains(point)) {
            return null;
        }
        int n3 = rectangle.x + rectangle.width / 2;
        if (this.tableHeader.getComponentOrientation().isLeftToRight()) {
            n = point.x < n3 ? n2 - 1 : n2;
        } else {
            int n4 = n = point.x < n3 ? n2 : n2 - 1;
        }
        if (n == -1) {
            return null;
        }
        return (FWTableColumn)this.tableHeader.getColumnModel().getColumn(n);
    }

    private class DirectionIcon
    implements Icon {
        private boolean isAscending;

        public DirectionIcon(boolean bl) {
            this.isAscending = bl;
        }

        public int getIconHeight() {
            return 5;
        }

        public int getIconWidth() {
            return 9;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            if (this.isAscending) {
                graphics.setColor((Color)UIManager.getDefaults().get("infoText"));
                graphics.drawLine(n, n2 + 3, n + 3, n2);
                graphics.drawLine(n + 4, n2, n + 4, n2);
                graphics.setColor((Color)UIManager.getDefaults().get("controlDkShadow"));
                graphics.drawLine(n + 3, n2 + 1, n + 5, n2 + 1);
                graphics.drawLine(n + 2, n2 + 2, n + 6, n2 + 2);
                graphics.drawLine(n + 1, n2 + 3, n + 7, n2 + 3);
                graphics.setColor((Color)UIManager.getDefaults().get("controlLtHighlight"));
                graphics.drawLine(n + 1, n2 + 4, n + 8, n2 + 4);
            } else {
                graphics.setColor((Color)UIManager.getDefaults().get("infoText"));
                graphics.drawLine(n, n2, n + 7, n2);
                graphics.setColor((Color)UIManager.getDefaults().get("controlDkShadow"));
                graphics.drawLine(n + 1, n2 + 1, n + 6, n2 + 1);
                graphics.drawLine(n + 2, n2 + 2, n + 5, n2 + 2);
                graphics.drawLine(n + 3, n2 + 3, n + 4, n2 + 3);
                graphics.setColor((Color)UIManager.getDefaults().get("controlLtHighlight"));
                graphics.drawLine(n + 7, n2 + 1, n + 4, n2 + 4);
            }
        }
    }

    private class SortedTableHeaderRenderer
    extends DefaultTableCellRenderer {
        private Icon ascendingIcon;
        private Icon descendingIcon;

        public SortedTableHeaderRenderer() {
            this.ascendingIcon = new DirectionIcon(true);
            this.descendingIcon = new DirectionIcon(false);
            this.setHorizontalAlignment(0);
            this.setHorizontalTextPosition(10);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JTableHeader jTableHeader;
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (jTable != null && (jTableHeader = jTable.getTableHeader()) != null) {
                this.setForeground(jTableHeader.getForeground());
                this.setBackground(jTableHeader.getBackground());
                this.setFont(jTableHeader.getFont());
                FWSortedTableModel fWSortedTableModel = (FWSortedTableModel)jTable.getModel();
                int n3 = jTable.convertColumnIndexToView(fWSortedTableModel.getSortByColumn());
                if (n3 == n2) {
                    if (fWSortedTableModel.isSortedAscending()) {
                        this.setIcon(this.ascendingIcon);
                    } else {
                        this.setIcon(this.descendingIcon);
                    }
                } else {
                    this.setIcon(null);
                }
            }
            this.setText(object == null ? "" : object.toString());
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            return this;
        }
    }

    private class ColumnCheckBoxMenuItem
    extends JCheckBoxMenuItem {
        private FWTableColumn column;

        public ColumnCheckBoxMenuItem(FWTableColumn fWTableColumn) {
            super((String)fWTableColumn.getHeaderValue(), fWTableColumn.isVisible());
            this.column = fWTableColumn;
        }

        public FWTableColumn getTableColumn() {
            return this.column;
        }
    }

    private class PopupMenuActionHandler
    implements ActionListener {
        private PopupMenuActionHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ColumnCheckBoxMenuItem columnCheckBoxMenuItem = (ColumnCheckBoxMenuItem)actionEvent.getSource();
            FWTableColumn fWTableColumn = columnCheckBoxMenuItem.getTableColumn();
            if (columnCheckBoxMenuItem.getState()) {
                ((FWTableColumnModel)FWTable.this.columnModel).showColumn(fWTableColumn);
            } else {
                ((FWTableColumnModel)FWTable.this.columnModel).hideColumn(fWTableColumn);
            }
        }
    }

    private class MouseHandler
    extends MouseInputAdapter {
        private MouseHandler() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            FWTableColumn fWTableColumn = FWTable.this.getResizingColumn(mouseEvent.getPoint());
            int n = mouseEvent.getClickCount();
            if (fWTableColumn == null && n == 1) {
                this.handleColumnSorting(mouseEvent);
            } else if (n >= 2) {
                this.handleColumnResizeToFit(fWTableColumn);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.popupMenu((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.popupMenu((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
            }
        }

        private void handleColumnSorting(MouseEvent mouseEvent) {
            if (!FWTable.this.isColumnSortingEnabled) {
                return;
            }
            int n = FWTable.this.columnModel.getColumnIndexAtX(mouseEvent.getX());
            int n2 = FWTable.this.convertColumnIndexToModel(n);
            if (n2 == -1) {
                return;
            }
            FWTableColumn fWTableColumn = (FWTableColumn)FWTable.this.getColumnModel().getColumn(n);
            boolean bl = fWTableColumn.reverseSortingOrder();
            ((FWSortedTableModel)FWTable.this.dataModel).sortByColumn(n2, bl);
        }

        private void handleColumnResizeToFit(FWTableColumn fWTableColumn) {
            if (!FWTable.this.isColumnResizeToFitEnabled) {
                return;
            }
            if (fWTableColumn != null) {
                fWTableColumn.sizeWidthToFitData(FWTable.this, FWTable.this.dataModel);
            }
        }

        private void popupMenu(Component component, int n, int n2) {
            if (FWTable.this.headerPopup != null) {
                FWTable.this.headerPopup.show(component, n, n2);
            }
        }
    }
}

