/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.common;

import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.AbstractTableModel;
import phex.ServiceManager;
import phex.gui.common.GUIRegistry;
import phex.utils.Localizer;
import phex.xml.XMLGUISettings;
import phex.xml.XMLGUITable;

public final class GUIUtils {
    private GUIUtils() {
    }

    public static XMLGUITable getXMLGUITableByIdentifier(XMLGUISettings xMLGUISettings, String string) {
        if (xMLGUISettings == null) {
            return null;
        }
        Iterator iterator = xMLGUISettings.getTableList().createXMLGUITableIterator();
        while (iterator.hasNext()) {
            XMLGUITable xMLGUITable = (XMLGUITable)iterator.next();
            if (!xMLGUITable.getTableIdentifier().equals(string)) continue;
            return xMLGUITable;
        }
        return null;
    }

    public static void adjustTableProgresssBarHeight(JTable jTable) {
        Font font = (Font)UIManager.getDefaults().get("ProgressBar.font");
        FontMetrics fontMetrics = ((Component)jTable).getFontMetrics(font);
        int n = fontMetrics.getHeight() + fontMetrics.getDescent();
        jTable.setRowHeight(n);
    }

    public static void setToolTipText(JComponent jComponent, String string) {
        if (ServiceManager.sCfg.mUIDisplayTooltip) {
            jComponent.setToolTipText(string);
        }
    }

    public static void fireTableChanged(JTable jTable, AbstractTableModel abstractTableModel) {
        int n = jTable.getSelectedRowCount();
        int[] nArray = jTable.getSelectedRows();
        abstractTableModel.fireTableDataChanged();
        if (n > 0) {
            int n2 = 0;
            while (n2 < nArray.length) {
                if (nArray[n2] < jTable.getRowCount()) {
                    jTable.addRowSelectionInterval(nArray[n2], nArray[n2]);
                }
                ++n2;
            }
        }
    }

    public static void showErrorMessage(String string) {
        GUIUtils.showErrorMessage(GUIRegistry.getInstance().getMainFrame(), string);
    }

    public static void showErrorMessage(String string, String string2) {
        GUIUtils.showErrorMessage(null, string, string2);
    }

    public static void showErrorMessage(Component component, String string) {
        GUIUtils.showErrorMessage(component, string, Localizer.getString("Error"));
    }

    public static void showErrorMessage(Component component, String string, String string2) {
        if (component == null) {
            component = GUIRegistry.getInstance().getMainFrame();
        }
        JOptionPane.showMessageDialog(component, string, string2, 0);
    }
}

