/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.common;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.net.URL;
import java.util.Hashtable;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import phex.utils.Logger;

public class IconFactory {
    private static final ImageIcon MISSING_IMAGE = new ImageIcon((class$phex$gui$common$IconFactory == null ? (class$phex$gui$common$IconFactory = IconFactory.class$("phex.gui.common.IconFactory")) : class$phex$gui$common$IconFactory).getResource("/phex/gui/resources/image-failed.gif"));
    private Hashtable table = new Hashtable();
    private ResourceBundle resource;
    static /* synthetic */ Class class$phex$gui$common$IconFactory;

    public IconFactory(String string) {
        this.resource = ResourceBundle.getBundle(string);
    }

    public Icon getIcon(String string) {
        TKIcon tKIcon = (TKIcon)this.table.get(string);
        if (tKIcon == null) {
            tKIcon = new TKIcon(string);
            this.table.put(string, tKIcon);
        }
        return tKIcon;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class TKIcon
    extends ImageIcon {
        private String key;
        private boolean loaded;
        static /* synthetic */ Class class$phex$gui$common$IconFactory;

        TKIcon(String string) {
            this.key = string;
            this.loaded = false;
        }

        public Image getImage() {
            this.loadIcon();
            return super.getImage();
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            this.loadIcon();
            super.paintIcon(component, graphics, n, n2);
        }

        public int getIconWidth() {
            this.loadIcon();
            return super.getIconWidth();
        }

        public int getIconHeight() {
            this.loadIcon();
            return super.getIconHeight();
        }

        private void loadIcon() {
            if (this.loaded) {
                return;
            }
            try {
                if (this.key != null) {
                    String string = IconFactory.this.resource.getString(this.key);
                    URL uRL = null;
                    if (string != null) {
                        uRL = (class$phex$gui$common$IconFactory == null ? (class$phex$gui$common$IconFactory = TKIcon.class$("phex.gui.common.IconFactory")) : class$phex$gui$common$IconFactory).getResource(string);
                    }
                    Image image = null;
                    if (uRL != null) {
                        image = Toolkit.getDefaultToolkit().createImage(uRL);
                    }
                    if (image == null) {
                        Logger.logMessage(Logger.WARNING, (short)32, "Can't find image for key: " + this.key);
                        image = MISSING_IMAGE.getImage();
                    }
                    super.setImage(image);
                    this.loaded = true;
                }
            }
            catch (Exception exception) {
                Logger.logError(exception);
            }
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }
}

