/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.common;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.FocusEvent;
import java.awt.event.InputMethodEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import javax.swing.FocusManager;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class TextFieldFix
extends JTextField
implements KeyListener,
MouseListener {
    private boolean mSkipKey = false;
    private static TextFieldFix lastFocusedComponent = null;
    private static TextFieldFix nowFocusedComponent = null;
    private static boolean focusInTextField = false;
    private static boolean mUnix = true;

    public TextFieldFix() {
        this(null, 0);
    }

    public TextFieldFix(int n) {
        this(null, n);
    }

    public TextFieldFix(String string, int n) {
        super(string, n);
        this.addKeyListener(this);
        this.addMouseListener(this);
    }

    public static void setUnix(boolean bl) {
        mUnix = bl;
    }

    public boolean isManagingFocus() {
        return mUnix;
    }

    private void removeEveryFocus(Component component) {
        if (component instanceof TextFieldFix) {
            ((TextFieldFix)component).getCaret().setVisible(false);
            ((TextFieldFix)component).getCaret().setSelectionVisible(false);
        }
        if (component instanceof Container) {
            int n = ((Container)component).getComponentCount();
            int n2 = 0;
            while (n2 < n) {
                this.removeEveryFocus(((Container)component).getComponent(n2));
                ++n2;
            }
        }
    }

    private void unfocus(JTextField jTextField) {
        JComponent jComponent;
        Component component;
        if (jTextField.hasFocus()) {
            this.processEvent(new FocusEvent(jTextField, 1005));
        }
        if ((component = SwingUtilities.findFocusOwner(this.getRootPane())) != null) {
            jComponent = new JTextField();
            this.getParent().add(jComponent);
            jComponent.grabFocus();
            this.getParent().remove(jComponent);
        }
        if ((component = SwingUtilities.findFocusOwner(this.getRootPane())) != null) {
            jComponent = this.getRootPane();
            this.removeEveryFocus(jComponent);
        }
    }

    private void focus(JTextField jTextField) {
        jTextField.grabFocus();
        this.processFocusEvent(new FocusEvent(jTextField, 1004));
        focusInTextField = true;
        jTextField.getCaret().setVisible(true);
        jTextField.getCaret().setSelectionVisible(true);
    }

    private void refocus(JTextField jTextField) {
        this.unfocus(jTextField);
        this.focus(jTextField);
    }

    public void keyTyped(KeyEvent keyEvent) {
        boolean bl;
        boolean bl2 = keyEvent.getKeyCode() == 18 || this.mSkipKey;
        boolean bl3 = bl = keyEvent.getKeyCode() == 9 || keyEvent.getKeyChar() == '\t';
        if (!(!mUnix || bl2 || focusInTextField && (Component)keyEvent.getSource() == nowFocusedComponent)) {
            JTextField jTextField = (JTextField)keyEvent.getSource();
            if (bl) {
                this.unfocus(jTextField);
            }
            this.focus(jTextField);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        boolean bl;
        this.mSkipKey = keyEvent.isAltDown() && keyEvent.getKeyCode() != 18;
        boolean bl2 = bl = keyEvent.getKeyCode() == 9 || keyEvent.getKeyChar() == '\t';
        if (mUnix && bl) {
            if ((keyEvent.getModifiers() & 1) == 1) {
                FocusManager.getCurrentManager().focusPreviousComponent(this);
            } else {
                FocusManager.getCurrentManager().focusNextComponent(this);
            }
            keyEvent.consume();
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mUnix) {
            JTextField jTextField = (JTextField)mouseEvent.getSource();
            Component component = SwingUtilities.findFocusOwner(this.getRootPane());
            this.refocus(jTextField);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    protected void processInputMethodEvent(InputMethodEvent inputMethodEvent) {
        if (!this.mSkipKey) {
            super.processInputMethodEvent(inputMethodEvent);
        }
    }

    protected void processEvent(AWTEvent aWTEvent) {
        super.processEvent(aWTEvent);
        if (mUnix && aWTEvent.getID() == 1005) {
            if (aWTEvent.getSource() instanceof TextFieldFix) {
                lastFocusedComponent = (TextFieldFix)aWTEvent.getSource();
            }
            focusInTextField = false;
            this.getCaret().setVisible(false);
            this.getCaret().setSelectionVisible(false);
        }
        if (mUnix) {
            Serializable serializable;
            if (aWTEvent.getID() == 1004) {
                serializable = SwingUtilities.findFocusOwner(this.getRootPane());
                if (serializable != null && serializable != this) {
                    this.unfocus(this);
                }
                serializable = SwingUtilities.findFocusOwner(this.getRootPane());
                if (aWTEvent.getSource() instanceof TextFieldFix) {
                    nowFocusedComponent = (TextFieldFix)aWTEvent.getSource();
                }
                focusInTextField = true;
                this.getCaret().setVisible(true);
                this.getCaret().setSelectionVisible(true);
            }
            if (aWTEvent instanceof KeyEvent) {
                boolean bl;
                serializable = (KeyEvent)aWTEvent;
                boolean bl2 = bl = ((KeyEvent)serializable).getKeyCode() == 18 || this.mSkipKey;
                if (bl) {
                    if (this.hasFocus()) {
                        this.processEvent(new FocusEvent(this, 1005));
                    }
                    if (nowFocusedComponent != null && nowFocusedComponent.hasFocus()) {
                        this.processEvent(new FocusEvent(nowFocusedComponent, 1005));
                    }
                }
            }
        }
    }

    static {
        String string = System.getProperty("os.name");
        mUnix = "Mac OS".equals(string) ? false : !string.startsWith("Windows");
    }
}

