/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.dialogs;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import phex.gui.common.GUIRegistry;
import phex.update.UpdateChecker;
import phex.utils.Localizer;

public class UpdateNotificationDialog
extends JDialog {
    private UpdateChecker updateChecker;
    private JCheckBox dontDisplayAgainChkBox;

    public UpdateNotificationDialog(UpdateChecker updateChecker) {
        super(GUIRegistry.getInstance().getMainFrame(), Localizer.getString("PhexUpdateNotification"), true);
        this.updateChecker = updateChecker;
        this.prepareComponent();
    }

    private void prepareComponent() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                UpdateNotificationDialog.this.closeDialog();
            }
        });
        Container container = this.getContentPane();
        container.setLayout(new GridBagLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(20, 10, 0, 10);
        gridBagConstraints.anchor = 10;
        container.add((Component)jPanel, gridBagConstraints);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Localizer.getString("NewPhexVersionFront"));
        stringBuffer.append(' ');
        stringBuffer.append(this.updateChecker.getUpdateVersion());
        stringBuffer.append(' ');
        stringBuffer.append(Localizer.getString("NewPhexVersionEnd"));
        JLabel jLabel = new JLabel(stringBuffer.toString());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 20, 0);
        gridBagConstraints.anchor = 10;
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.dontDisplayAgainChkBox = new JCheckBox(Localizer.getString("DontShowUpdateNotification"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        gridBagConstraints.anchor = 10;
        jPanel.add((Component)this.dontDisplayAgainChkBox, gridBagConstraints);
        JSeparator jSeparator = new JSeparator();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        container.add((Component)jSeparator, gridBagConstraints);
        jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        gridBagConstraints.anchor = 10;
        container.add((Component)jPanel, gridBagConstraints);
        JButton jButton = new JButton(Localizer.getString("OK"));
        jButton.setDefaultCapable(true);
        jButton.setRequestFocusEnabled(true);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                UpdateNotificationDialog.this.saveUpdateNotificationState();
                UpdateNotificationDialog.this.closeDialog();
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 10;
        jPanel.add((Component)jButton, gridBagConstraints);
        this.setDefaultCloseOperation(2);
        this.getRootPane().setDefaultButton(jButton);
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private void closeDialog() {
        ((Component)this).setVisible(false);
        this.dispose();
    }

    private void saveUpdateNotificationState() {
        boolean bl = this.dontDisplayAgainChkBox.isSelected();
        this.updateChecker.setShowUpdateNotification(!bl);
    }
}

