/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.dialogs.options;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import phex.ServiceManager;
import phex.gui.dialogs.options.OptionsSettingsPane;
import phex.utils.Localizer;
import phex.utils.StrUtil;

public class BandwidthPane
extends OptionsSettingsPane {
    private int UNLIMITED_VALUE = 101;
    private SpeedDefinition[] speedDefinitions = new SpeedDefinition[]{new SpeedDefinition("Modem", 56), new SpeedDefinition("ISDN", 64), new SpeedDefinition("DualISDN", 128), new SpeedDefinition("DSLCable1", 256), new SpeedDefinition("DSLCable2", 512), new SpeedDefinition("DSLCable3", 768), new SpeedDefinition("T1", 1544), new SpeedDefinition("10LAN", 10000), new SpeedDefinition("T3", 44736), new SpeedDefinition("100LAN", 100000)};
    private Dictionary sliderLabels = new Hashtable(5);
    private JComboBox connectionSpeedCbx;
    private JLabel totalBandwidthLabel;
    private JSlider totalBandwidthSldr;
    private JLabel netBandwidthLabel;
    private JSlider netBandwidthSldr;
    private JLabel downloadBandwidthLabel;
    private JSlider downloadBandwidthSldr;
    private JLabel uploadBandwidthLabel;
    private JSlider uploadBandwidthSldr;
    private double maxConnectionBandwidth;
    private double currentTotalBandwidth;
    private double currentNetBandwidth;
    private double currentDownloadBandwidth;
    private double currentUploadBandwidth;

    public BandwidthPane() {
        super("Bandwidth");
        this.sliderLabels.put(new Integer(0), new JLabel("0%", 0));
        this.sliderLabels.put(new Integer(25), new JLabel("25%", 0));
        this.sliderLabels.put(new Integer(50), new JLabel("50%", 0));
        this.sliderLabels.put(new Integer(75), new JLabel("75%", 0));
        this.sliderLabels.put(new Integer(100), new JLabel("100%", 0));
    }

    protected void prepareComponent() {
        this.setLayout(new GridBagLayout());
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Localizer.getString("NetworkSpeedSettings")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)jPanel, gridBagConstraints);
        JLabel jLabel = new JLabel(Localizer.getString("SelectConnection") + ": ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.connectionSpeedCbx = new JComboBox<SpeedDefinition>(this.speedDefinitions);
        this.connectionSpeedCbx.addItemListener(new SpeedItemListener());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 12;
        jPanel.add((Component)this.connectionSpeedCbx, gridBagConstraints);
        jLabel = new JLabel(Localizer.getString("PhexBandwidth") + ": ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.totalBandwidthLabel = new JLabel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this.totalBandwidthLabel, gridBagConstraints);
        this.totalBandwidthSldr = new JSlider(0, 0, 101, 0);
        this.totalBandwidthSldr.addChangeListener(new SliderChangeListener());
        this.totalBandwidthSldr.setLabelTable(this.sliderLabels);
        this.totalBandwidthSldr.setPaintLabels(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this.totalBandwidthSldr, gridBagConstraints);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Localizer.getString("PhexBandwidthSettings")));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)jPanel2, gridBagConstraints);
        jLabel = new JLabel(Localizer.getString("MaxNetworkBandwidth") + ": ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        jPanel2.add((Component)jLabel, gridBagConstraints);
        this.netBandwidthLabel = new JLabel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.weightx = 1.0;
        jPanel2.add((Component)this.netBandwidthLabel, gridBagConstraints);
        this.netBandwidthSldr = new JSlider(0, 0, 101, 0);
        this.netBandwidthSldr.addChangeListener(new SliderChangeListener());
        this.netBandwidthSldr.setLabelTable(this.sliderLabels);
        this.netBandwidthSldr.setPaintLabels(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        jPanel2.add((Component)this.netBandwidthSldr, gridBagConstraints);
        jLabel = new JLabel(Localizer.getString("MaxDownloadBandwidth") + ": ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        jPanel2.add((Component)jLabel, gridBagConstraints);
        this.downloadBandwidthLabel = new JLabel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.weightx = 1.0;
        jPanel2.add((Component)this.downloadBandwidthLabel, gridBagConstraints);
        this.downloadBandwidthSldr = new JSlider(0, 0, 101, 0);
        this.downloadBandwidthSldr.addChangeListener(new SliderChangeListener());
        this.downloadBandwidthSldr.setPaintLabels(true);
        this.downloadBandwidthSldr.setLabelTable(this.sliderLabels);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        jPanel2.add((Component)this.downloadBandwidthSldr, gridBagConstraints);
        jLabel = new JLabel(Localizer.getString("MaxUploadBandwidth") + ": ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 18;
        jPanel2.add((Component)jLabel, gridBagConstraints);
        this.uploadBandwidthLabel = new JLabel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.weightx = 1.0;
        jPanel2.add((Component)this.uploadBandwidthLabel, gridBagConstraints);
        this.uploadBandwidthSldr = new JSlider(0, 0, 101, 0);
        this.uploadBandwidthSldr.addChangeListener(new SliderChangeListener());
        this.uploadBandwidthSldr.setPaintLabels(true);
        this.uploadBandwidthSldr.setLabelTable(this.sliderLabels);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel2.add((Component)this.uploadBandwidthSldr, gridBagConstraints);
        this.initConfigValues();
    }

    public void checkInput(HashMap hashMap) {
    }

    public void displayErrorMessage(HashMap hashMap) {
    }

    public void saveAndApplyChanges(HashMap hashMap) {
        SpeedDefinition speedDefinition = (SpeedDefinition)this.connectionSpeedCbx.getSelectedItem();
        int n = speedDefinition.getSpeedInKbps();
        if (ServiceManager.sCfg.networkSpeedKbps != n) {
            ServiceManager.sCfg.networkSpeedKbps = n;
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
        if (ServiceManager.sCfg.maxTotalBandwidth != (n = this.totalBandwidthSldr.getValue() == this.UNLIMITED_VALUE ? Integer.MAX_VALUE : (int)Math.round(this.currentTotalBandwidth))) {
            ServiceManager.setPhexTotalBandwidth(n);
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
        if (ServiceManager.sCfg.mNetMaxRate != (n = this.netBandwidthSldr.getValue() == this.UNLIMITED_VALUE ? Integer.MAX_VALUE : (int)Math.round(this.currentNetBandwidth))) {
            ServiceManager.setNetworkBandwidth(n);
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
        if (ServiceManager.sCfg.mDownloadMaxBandwidth != (n = this.downloadBandwidthSldr.getValue() == this.UNLIMITED_VALUE ? Integer.MAX_VALUE : (int)Math.round(this.currentDownloadBandwidth))) {
            ServiceManager.setDownloadBandwidth(n);
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
        if (ServiceManager.sCfg.mUploadMaxBandwidth != (n = this.uploadBandwidthSldr.getValue() == this.UNLIMITED_VALUE ? Integer.MAX_VALUE : (int)Math.round(this.currentUploadBandwidth))) {
            ServiceManager.setUploadBandwidth(n);
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
    }

    private void initConfigValues() {
        int n = ServiceManager.sCfg.networkSpeedKbps;
        int n2 = 0;
        while (n2 < this.speedDefinitions.length) {
            SpeedDefinition speedDefinition = this.speedDefinitions[n2];
            int n3 = speedDefinition.getSpeedInKbps() - n;
            if (n3 >= 0) {
                this.connectionSpeedCbx.setSelectedIndex(n2);
                if (n2 != 0) break;
                this.updateMaxConnectionBandwidth(speedDefinition);
                break;
            }
            ++n2;
        }
        double d = ServiceManager.sCfg.maxTotalBandwidth;
        int n4 = (int)Math.round(d / this.maxConnectionBandwidth * 100.0);
        this.totalBandwidthSldr.setValue(n4);
        d = ServiceManager.sCfg.mNetMaxRate;
        n4 = (int)Math.round(d / this.currentTotalBandwidth * 100.0);
        this.netBandwidthSldr.setValue(n4);
        d = ServiceManager.sCfg.mDownloadMaxBandwidth;
        n4 = (int)Math.round(d / this.currentTotalBandwidth * 100.0);
        this.downloadBandwidthSldr.setValue(n4);
        d = ServiceManager.sCfg.mUploadMaxBandwidth;
        n4 = (int)Math.round(d / this.currentTotalBandwidth * 100.0);
        this.uploadBandwidthSldr.setValue(n4);
    }

    private void calculateBandwidth() {
        double d;
        String string;
        int n = this.totalBandwidthSldr.getValue();
        if (n == this.UNLIMITED_VALUE) {
            string = Localizer.getString("Unlimited");
            this.currentTotalBandwidth = this.maxConnectionBandwidth;
        } else {
            d = (double)n / 100.0;
            this.currentTotalBandwidth = this.maxConnectionBandwidth * d;
            string = StrUtil.formatSizeBytes(this.currentTotalBandwidth) + Localizer.getString("PerSec");
        }
        this.totalBandwidthLabel.setText(string);
        n = this.netBandwidthSldr.getValue();
        if (n == this.UNLIMITED_VALUE) {
            string = Localizer.getString("Unlimited");
            this.currentNetBandwidth = this.maxConnectionBandwidth;
        } else {
            d = (double)n / 100.0;
            this.currentNetBandwidth = this.currentTotalBandwidth * d;
            string = StrUtil.formatSizeBytes(this.currentNetBandwidth) + Localizer.getString("PerSec");
        }
        this.netBandwidthLabel.setText(string);
        n = this.downloadBandwidthSldr.getValue();
        if (n == this.UNLIMITED_VALUE) {
            string = Localizer.getString("Unlimited");
            this.currentDownloadBandwidth = this.maxConnectionBandwidth;
        } else {
            d = (double)n / 100.0;
            this.currentDownloadBandwidth = this.currentTotalBandwidth * d;
            string = StrUtil.formatSizeBytes(this.currentDownloadBandwidth) + Localizer.getString("PerSec");
        }
        this.downloadBandwidthLabel.setText(string);
        n = this.uploadBandwidthSldr.getValue();
        if (n == this.UNLIMITED_VALUE) {
            string = Localizer.getString("Unlimited");
            this.currentUploadBandwidth = this.maxConnectionBandwidth;
        } else {
            d = (double)n / 100.0;
            this.currentUploadBandwidth = this.currentTotalBandwidth * d;
            string = StrUtil.formatSizeBytes(this.currentUploadBandwidth) + Localizer.getString("PerSec");
        }
        this.uploadBandwidthLabel.setText(string);
    }

    private void updateMaxConnectionBandwidth(SpeedDefinition speedDefinition) {
        this.maxConnectionBandwidth = speedDefinition.getSpeedInKB() * 1024.0;
        this.calculateBandwidth();
    }

    private static class SpeedDefinition {
        private String representation;
        private int speedInKbps;

        public SpeedDefinition(String string, int n) {
            this.representation = Localizer.getString(string);
            this.speedInKbps = n;
        }

        public double getSpeedInKB() {
            return this.speedInKbps / 8;
        }

        public int getSpeedInKbps() {
            return this.speedInKbps;
        }

        public String toString() {
            return this.representation;
        }
    }

    private class SpeedItemListener
    implements ItemListener {
        private SpeedItemListener() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                SpeedDefinition speedDefinition = (SpeedDefinition)itemEvent.getItem();
                BandwidthPane.this.updateMaxConnectionBandwidth(speedDefinition);
            }
        }
    }

    private class SliderChangeListener
    implements ChangeListener {
        private SliderChangeListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            BandwidthPane.this.calculateBandwidth();
        }
    }
}

