/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.dialogs.options;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import phex.ServiceManager;
import phex.gui.common.GUIRegistry;
import phex.gui.common.GUIUtils;
import phex.gui.common.IntegerTextField;
import phex.gui.common.MultiLinePanel;
import phex.gui.dialogs.options.OptionsSettingsPane;
import phex.host.HostAddress;
import phex.utils.IPUtils;
import phex.utils.Localizer;

public class ProxyPane
extends OptionsSettingsPane {
    private static final String EXPORT_IP_KEY = "ExportIP";
    private static final String SOCKS5_PROXY_PORT_KEY = "SOCKS5ProxyPort";
    private static final String HTTP_PROXY_PORT_KEY = "HTTPProxyPort";
    private static final String EXPORT_IP_ERROR_KEY = "ExportIPError";
    private static final String WRONG_EXPORT_IP_FORMAT = "WrongExportIPFormat";
    private JCheckBox behindFirewallCkbx;
    private JLabel exportIPLabel;
    private JTextField exportIPTF;
    private JCheckBox socks5ProxyCkbx;
    private JLabel socks5HostLabel;
    private JTextField socks5ProxyHostTF;
    private JLabel socks5PortLabel;
    private IntegerTextField socks5ProxyPortTF;
    private JCheckBox socks5AuthenticationCkbx;
    private JLabel socks5UserLabel;
    private JTextField socks5UserNameTF;
    private JLabel socks5PasswordLabel;
    private JPasswordField socks5PasswordTF;
    private JCheckBox httpProxyCkbx;
    private MultiLinePanel infoLabel;
    private JLabel httpHostLabel;
    private JTextField httpProxyHostTF;
    private JLabel httpPortLabel;
    private IntegerTextField httpProxyPortTF;

    public ProxyPane() {
        super("FirewallProxy");
    }

    protected void prepareComponent() {
        this.setLayout(new GridBagLayout());
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Localizer.getString("FirewallSOCKSSettings")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)jPanel, gridBagConstraints);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        this.exportIPLabel = new JLabel(Localizer.getString("ExportIPAs") + ": ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        jPanel2.add((Component)this.exportIPLabel, gridBagConstraints);
        this.exportIPTF = new JTextField(ServiceManager.sCfg.mMyIP, 15);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        jPanel2.add((Component)this.exportIPTF, gridBagConstraints);
        this.behindFirewallCkbx = new JCheckBox(Localizer.getString("BehindFirewall"), ServiceManager.sCfg.isBehindFirewall);
        this.behindFirewallCkbx.addActionListener(new CheckboxActionListener());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this.behindFirewallCkbx, gridBagConstraints);
        jPanel2 = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        this.socks5ProxyCkbx = new JCheckBox(Localizer.getString("UseSocks5Proxy"), ServiceManager.sCfg.mProxyUse);
        this.socks5ProxyCkbx.addActionListener(new CheckboxActionListener());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        jPanel2.add((Component)this.socks5ProxyCkbx, gridBagConstraints);
        this.socks5HostLabel = new JLabel(Localizer.getString("ProxyHostIP") + ": ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 15, 2, 5);
        jPanel2.add((Component)this.socks5HostLabel, gridBagConstraints);
        this.socks5ProxyHostTF = new JTextField(ServiceManager.sCfg.mProxyHost, 15);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        jPanel2.add((Component)this.socks5ProxyHostTF, gridBagConstraints);
        this.socks5PortLabel = new JLabel(Localizer.getString("Port") + ": ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 5, 2, 5);
        jPanel2.add((Component)this.socks5PortLabel, gridBagConstraints);
        this.socks5ProxyPortTF = new IntegerTextField(String.valueOf(ServiceManager.sCfg.mProxyPort), 5, 5);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        jPanel2.add((Component)this.socks5ProxyPortTF, gridBagConstraints);
        this.socks5AuthenticationCkbx = new JCheckBox(Localizer.getString("Authentication"), ServiceManager.sCfg.useProxyAuthentication);
        this.socks5AuthenticationCkbx.addActionListener(new CheckboxActionListener());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 15, 2, 0);
        jPanel.add((Component)this.socks5AuthenticationCkbx, gridBagConstraints);
        jPanel2 = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 15, 2, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        this.socks5UserLabel = new JLabel(Localizer.getString("Username") + ": ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        jPanel2.add((Component)this.socks5UserLabel, gridBagConstraints);
        this.socks5UserNameTF = new JTextField(ServiceManager.sCfg.mProxyUserName, 10);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        jPanel2.add((Component)this.socks5UserNameTF, gridBagConstraints);
        this.socks5PasswordLabel = new JLabel(Localizer.getString("Password") + ": ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        jPanel2.add((Component)this.socks5PasswordLabel, gridBagConstraints);
        this.socks5PasswordTF = new JPasswordField(ServiceManager.sCfg.mProxyPassword, 10);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel2.add((Component)this.socks5PasswordTF, gridBagConstraints);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Localizer.getString("HTTPProxySettings")));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)jPanel3, gridBagConstraints);
        jPanel2 = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel3.add((Component)jPanel2, gridBagConstraints);
        this.infoLabel = new MultiLinePanel(Localizer.getString("HttpProxyInfoText"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        jPanel2.add((Component)this.infoLabel, gridBagConstraints);
        this.httpProxyCkbx = new JCheckBox(Localizer.getString("UseHTTPProxy"), ServiceManager.sCfg.isHttpProxyUsed);
        this.httpProxyCkbx.addActionListener(new CheckboxActionListener());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        jPanel2.add((Component)this.httpProxyCkbx, gridBagConstraints);
        this.httpHostLabel = new JLabel(Localizer.getString("ProxyHostIP") + ": ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 15, 2, 5);
        jPanel2.add((Component)this.httpHostLabel, gridBagConstraints);
        this.httpProxyHostTF = new JTextField(ServiceManager.sCfg.httpProxyHost, 15);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        jPanel2.add((Component)this.httpProxyHostTF, gridBagConstraints);
        this.httpPortLabel = new JLabel(Localizer.getString("Port") + ": ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 5, 2, 5);
        jPanel2.add((Component)this.httpPortLabel, gridBagConstraints);
        this.httpProxyPortTF = new IntegerTextField(String.valueOf(ServiceManager.sCfg.httpProxyPort), 5, 5);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        jPanel2.add((Component)this.httpProxyPortTF, gridBagConstraints);
        this.refreshEnableState();
    }

    public void checkInput(HashMap hashMap) {
        Integer n;
        Object object;
        String string = this.exportIPTF.getText().trim();
        if (string.length() > 0) {
            object = HostAddress.parseIP(string);
            if (object != null) {
                hashMap.put(EXPORT_IP_KEY, object);
            } else {
                hashMap.put(EXPORT_IP_ERROR_KEY, WRONG_EXPORT_IP_FORMAT);
                this.setInputValid(hashMap, false);
                return;
            }
        }
        try {
            object = this.socks5ProxyPortTF.getText();
            n = new Integer((String)object);
            hashMap.put(SOCKS5_PROXY_PORT_KEY, n);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            object = this.httpProxyPortTF.getText();
            n = new Integer((String)object);
            hashMap.put(HTTP_PROXY_PORT_KEY, n);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.setInputValid(hashMap, true);
    }

    public void displayErrorMessage(HashMap hashMap) {
        if (hashMap.containsKey("NumberFormatError")) {
            this.displayNumberFormatError(hashMap);
        }
        if (hashMap.containsKey(EXPORT_IP_ERROR_KEY)) {
            this.exportIPTF.requestFocus();
            this.exportIPTF.selectAll();
            GUIUtils.showErrorMessage(Localizer.getString(WRONG_EXPORT_IP_FORMAT), Localizer.getString("IPFormatError"));
        }
    }

    public void saveAndApplyChanges(HashMap hashMap) {
        String string;
        String string2;
        String string3;
        boolean bl;
        String string4;
        boolean bl2;
        boolean bl3;
        byte[] byArray = (byte[])hashMap.get(EXPORT_IP_KEY);
        String string5 = "";
        if (byArray != null) {
            string5 = IPUtils.ip2string(byArray);
        }
        if (!ServiceManager.sCfg.mMyIP.equals(string5)) {
            ServiceManager.getListener().setForcedHostIP(byArray);
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
        if (ServiceManager.sCfg.isBehindFirewall != (bl3 = this.behindFirewallCkbx.isSelected())) {
            ServiceManager.sCfg.isBehindFirewall = bl3;
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
        if (ServiceManager.sCfg.mProxyUse != (bl2 = this.socks5ProxyCkbx.isSelected())) {
            ServiceManager.sCfg.mProxyUse = bl2;
            OptionsSettingsPane.triggerConfigSave(hashMap);
            GUIRegistry.getInstance().getMainFrame().setTitle();
        }
        if (!ServiceManager.sCfg.mProxyHost.equals(string4 = this.socks5ProxyHostTF.getText())) {
            ServiceManager.sCfg.mProxyHost = string4;
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
        Integer n = (Integer)hashMap.get(SOCKS5_PROXY_PORT_KEY);
        int n2 = 1080;
        if (n != null) {
            n2 = n;
        }
        if (ServiceManager.sCfg.mProxyPort != n2) {
            ServiceManager.sCfg.mProxyPort = n2;
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
        if (ServiceManager.sCfg.useProxyAuthentication != (bl = this.socks5AuthenticationCkbx.isSelected())) {
            ServiceManager.sCfg.useProxyAuthentication = bl;
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
        if (!ServiceManager.sCfg.mProxyUserName.equals(string3 = this.socks5UserNameTF.getText())) {
            ServiceManager.sCfg.mProxyUserName = string3;
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
        if (!ServiceManager.sCfg.mProxyPassword.equals(string2 = new String(this.socks5PasswordTF.getPassword()))) {
            ServiceManager.sCfg.mProxyPassword = string2;
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
        boolean bl4 = false;
        boolean bl5 = this.httpProxyCkbx.isSelected();
        if (ServiceManager.sCfg.isHttpProxyUsed != bl5) {
            ServiceManager.sCfg.isHttpProxyUsed = bl5;
            OptionsSettingsPane.triggerConfigSave(hashMap);
            bl4 = true;
        }
        if (!ServiceManager.sCfg.httpProxyHost.equals(string = this.httpProxyHostTF.getText())) {
            ServiceManager.sCfg.httpProxyHost = string;
            OptionsSettingsPane.triggerConfigSave(hashMap);
            bl4 = true;
        }
        Integer n3 = (Integer)hashMap.get(HTTP_PROXY_PORT_KEY);
        int n4 = 80;
        if (n3 != null) {
            n4 = n3;
        }
        if (ServiceManager.sCfg.httpProxyPort != n4) {
            ServiceManager.sCfg.httpProxyPort = n4;
            OptionsSettingsPane.triggerConfigSave(hashMap);
            bl4 = true;
        }
        if (bl4) {
            ServiceManager.sCfg.updateHTTPProxySettings();
        }
    }

    private void refreshEnableState() {
        this.socks5ProxyCkbx.setEnabled(this.behindFirewallCkbx.isSelected());
        this.socks5HostLabel.setEnabled(this.behindFirewallCkbx.isSelected() && this.socks5ProxyCkbx.isSelected());
        this.socks5ProxyHostTF.setEnabled(this.behindFirewallCkbx.isSelected() && this.socks5ProxyCkbx.isSelected());
        this.socks5PortLabel.setEnabled(this.behindFirewallCkbx.isSelected() && this.socks5ProxyCkbx.isSelected());
        this.socks5ProxyPortTF.setEnabled(this.behindFirewallCkbx.isSelected() && this.socks5ProxyCkbx.isSelected());
        this.socks5AuthenticationCkbx.setEnabled(this.behindFirewallCkbx.isSelected() && this.socks5ProxyCkbx.isSelected());
        this.socks5UserLabel.setEnabled(this.behindFirewallCkbx.isSelected() && this.socks5ProxyCkbx.isSelected() && this.socks5AuthenticationCkbx.isSelected());
        this.socks5UserNameTF.setEnabled(this.behindFirewallCkbx.isSelected() && this.socks5ProxyCkbx.isSelected() && this.socks5AuthenticationCkbx.isSelected());
        this.socks5PasswordLabel.setEnabled(this.behindFirewallCkbx.isSelected() && this.socks5ProxyCkbx.isSelected() && this.socks5AuthenticationCkbx.isSelected());
        this.socks5PasswordTF.setEnabled(this.behindFirewallCkbx.isSelected() && this.socks5ProxyCkbx.isSelected() && this.socks5AuthenticationCkbx.isSelected());
        this.httpHostLabel.setEnabled(this.httpProxyCkbx.isSelected());
        this.httpProxyHostTF.setEnabled(this.httpProxyCkbx.isSelected());
        this.httpPortLabel.setEnabled(this.httpProxyCkbx.isSelected());
        this.httpProxyPortTF.setEnabled(this.httpProxyCkbx.isSelected());
    }

    class CheckboxActionListener
    implements ActionListener {
        CheckboxActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ProxyPane.this.refreshEnableState();
        }
    }
}

