/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.dialogs.options;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import phex.ServiceManager;
import phex.gui.common.IntegerTextField;
import phex.gui.dialogs.options.OptionsSettingsPane;
import phex.utils.Localizer;

public class SharingPane
extends OptionsSettingsPane {
    private static final String SIMULTANEOUS_UPLOADS_KEY = "SimultaneousUploads";
    private static final String UPLOADS_PER_HOST_KEY = "UploadsPerHost";
    private static final String RETURNED_SEARCH_LIMIT_KEY = "ReturnedSearchLimit";
    private IntegerTextField simultaneousUploadsTF;
    private IntegerTextField uploadsPerHostTF;
    private IntegerTextField returnedSearchLimitTF;
    private JCheckBox removeCompletedUploadsChkbx;
    private JCheckBox allowBrowsingChkbx;

    public SharingPane() {
        super("Sharing");
    }

    protected void prepareComponent() {
        this.setLayout(new GridBagLayout());
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Localizer.getString("GeneralUploadSettings")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)jPanel, gridBagConstraints);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(3, 0, 5, 0);
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        JLabel jLabel = new JLabel(Localizer.getString(SIMULTANEOUS_UPLOADS_KEY) + ": ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        jPanel2.add((Component)jLabel, gridBagConstraints);
        this.simultaneousUploadsTF = new IntegerTextField(String.valueOf(ServiceManager.sCfg.mMaxUpload), 3, 3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        jPanel2.add((Component)this.simultaneousUploadsTF, gridBagConstraints);
        jPanel2 = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        jLabel = new JLabel(Localizer.getString(UPLOADS_PER_HOST_KEY) + ": ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        jPanel2.add((Component)jLabel, gridBagConstraints);
        this.uploadsPerHostTF = new IntegerTextField(String.valueOf(ServiceManager.sCfg.mMaxUploadPerIP), 3, 3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        jPanel2.add((Component)this.uploadsPerHostTF, gridBagConstraints);
        jPanel2 = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        jLabel = new JLabel(Localizer.getString(RETURNED_SEARCH_LIMIT_KEY) + ": ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        jPanel2.add((Component)jLabel, gridBagConstraints);
        this.returnedSearchLimitTF = new IntegerTextField(String.valueOf(ServiceManager.sCfg.mUploadMaxSearch), 4, 4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        jPanel2.add((Component)this.returnedSearchLimitTF, gridBagConstraints);
        this.removeCompletedUploadsChkbx = new JCheckBox(Localizer.getString("AutoRemoveCompletedUploads"), ServiceManager.sCfg.mUploadAutoRemoveCompleted);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this.removeCompletedUploadsChkbx, gridBagConstraints);
        this.allowBrowsingChkbx = new JCheckBox(Localizer.getString("AllowBrowsingDirectories"), ServiceManager.sCfg.mShareBrowseDir);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)this.allowBrowsingChkbx, gridBagConstraints);
    }

    public void checkInput(HashMap hashMap) {
        Integer n;
        String string;
        try {
            string = this.simultaneousUploadsTF.getText();
            n = new Integer(string);
            hashMap.put(SIMULTANEOUS_UPLOADS_KEY, n);
        }
        catch (NumberFormatException numberFormatException) {
            hashMap.put("NumberFormatError", this.simultaneousUploadsTF);
            this.setInputValid(hashMap, false);
            return;
        }
        try {
            string = this.uploadsPerHostTF.getText();
            n = new Integer(string);
            hashMap.put(UPLOADS_PER_HOST_KEY, n);
        }
        catch (NumberFormatException numberFormatException) {
            hashMap.put("NumberFormatError", this.uploadsPerHostTF);
            this.setInputValid(hashMap, false);
            return;
        }
        try {
            string = this.returnedSearchLimitTF.getText();
            n = new Integer(string);
            hashMap.put(RETURNED_SEARCH_LIMIT_KEY, n);
        }
        catch (NumberFormatException numberFormatException) {
            hashMap.put("NumberFormatError", this.returnedSearchLimitTF);
            this.setInputValid(hashMap, false);
            return;
        }
        this.setInputValid(hashMap, true);
    }

    public void displayErrorMessage(HashMap hashMap) {
        if (hashMap.containsKey("NumberFormatError")) {
            this.displayNumberFormatError(hashMap);
        }
    }

    public void saveAndApplyChanges(HashMap hashMap) {
        boolean bl;
        boolean bl2;
        Integer n;
        int n2;
        Integer n3;
        int n4;
        Integer n5 = (Integer)hashMap.get(SIMULTANEOUS_UPLOADS_KEY);
        int n6 = n5;
        if (ServiceManager.sCfg.mMaxUpload != n6) {
            ServiceManager.sCfg.mMaxUpload = n6;
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
        if (ServiceManager.sCfg.mMaxUploadPerIP != (n4 = (n3 = (Integer)hashMap.get(UPLOADS_PER_HOST_KEY)).intValue())) {
            ServiceManager.sCfg.mMaxUploadPerIP = n4;
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
        if (ServiceManager.sCfg.mUploadMaxSearch != (n2 = (n = (Integer)hashMap.get(RETURNED_SEARCH_LIMIT_KEY)).intValue())) {
            ServiceManager.sCfg.mUploadMaxSearch = n2;
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
        if (ServiceManager.sCfg.mUploadAutoRemoveCompleted != (bl2 = this.removeCompletedUploadsChkbx.isSelected())) {
            ServiceManager.sCfg.mUploadAutoRemoveCompleted = bl2;
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
        if (ServiceManager.sCfg.mShareBrowseDir != (bl = this.allowBrowsingChkbx.isSelected())) {
            ServiceManager.sCfg.mShareBrowseDir = bl;
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
    }
}

