/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.models;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import phex.gui.common.FWTableColumn;
import phex.gui.models.FWTableModel;
import phex.utils.Logger;
import phex.xml.XMLGUITableColumn;
import phex.xml.XMLGUITableColumnList;

public class FWTableColumnModel
extends DefaultTableColumnModel {
    private ArrayList allTableColumns = new ArrayList();

    public FWTableColumnModel(FWTableModel fWTableModel, int[] nArray) {
        this(fWTableModel, nArray, null);
    }

    public FWTableColumnModel(FWTableModel fWTableModel, int[] nArray, XMLGUITableColumnList xMLGUITableColumnList) {
        this.buildColumnsFromColumnIDs(nArray, fWTableModel, xMLGUITableColumnList);
    }

    public void addColumn(FWTableColumn fWTableColumn) {
        if (fWTableColumn.isVisible()) {
            super.addColumn(fWTableColumn);
        }
        this.allTableColumns.add(fWTableColumn);
    }

    public void showColumn(FWTableColumn fWTableColumn) {
        if (!fWTableColumn.isVisible()) {
            fWTableColumn.setVisible(true);
            super.addColumn(fWTableColumn);
            int n = this.getColumnCount() - 1;
            int n2 = fWTableColumn.getModelIndex();
            if (n == 0) {
                return;
            }
            TableColumn tableColumn = this.getColumn(n - 1);
            int n3 = tableColumn.getModelIndex();
            while (n3 > n2) {
                if (--n == 0) break;
                tableColumn = this.getColumn(n - 1);
                n3 = tableColumn.getModelIndex();
            }
            if (n < this.getColumnCount() - 1) {
                this.moveColumn(this.getColumnCount() - 1, n);
            }
        }
    }

    public void hideColumn(FWTableColumn fWTableColumn) {
        if (fWTableColumn.isHideable() && fWTableColumn.isVisible()) {
            this.removeColumn(fWTableColumn);
            fWTableColumn.setVisible(false);
        }
    }

    public FWTableColumn getColumn(Object object) {
        Iterator iterator = ((AbstractList)this.allTableColumns).iterator();
        while (iterator.hasNext()) {
            FWTableColumn fWTableColumn = (FWTableColumn)iterator.next();
            if (!object.equals(fWTableColumn.getIdentifier())) continue;
            return fWTableColumn;
        }
        return null;
    }

    public Iterator createAllColumnsIterator() {
        return ((AbstractList)this.allTableColumns).iterator();
    }

    public XMLGUITableColumnList createXMLGUITableColumnList() {
        XMLGUITableColumnList xMLGUITableColumnList = new XMLGUITableColumnList();
        Collections.sort(this.allTableColumns, new VisibleTableColumnComparator());
        Iterator iterator = ((AbstractList)this.allTableColumns).iterator();
        while (iterator.hasNext()) {
            FWTableColumn fWTableColumn = (FWTableColumn)iterator.next();
            XMLGUITableColumn xMLGUITableColumn = fWTableColumn.createXMLGUITableColumn();
            if (fWTableColumn.isVisible()) {
                xMLGUITableColumn.setVisibleIndex(this.getColumnIndex(fWTableColumn.getIdentifier()));
            }
            xMLGUITableColumnList.addXMLGUITableColumn(xMLGUITableColumn);
        }
        return xMLGUITableColumnList;
    }

    protected void buildColumnsFromColumnIDs(int[] nArray, FWTableModel fWTableModel, XMLGUITableColumnList xMLGUITableColumnList) {
        ArrayList<FWTableColumn> arrayList = new ArrayList<FWTableColumn>(nArray.length);
        int n = 0;
        while (n < nArray.length) {
            FWTableColumn fWTableColumn = null;
            if (xMLGUITableColumnList != null) {
                fWTableColumn = this.buildColumnFromXML(nArray[n], fWTableModel, xMLGUITableColumnList);
            }
            if (fWTableColumn == null) {
                fWTableColumn = this.buildDefaultColumn(nArray[n], fWTableModel);
                arrayList.add(fWTableColumn);
            }
            ++n;
        }
        this.arrangeColumns(xMLGUITableColumnList, arrayList, fWTableModel);
    }

    protected FWTableColumn buildColumnFromXML(int n, FWTableModel fWTableModel, XMLGUITableColumnList xMLGUITableColumnList) {
        if (xMLGUITableColumnList == null) {
            return null;
        }
        try {
            FWTableColumn fWTableColumn = null;
            Iterator iterator = xMLGUITableColumnList.createXMLGUITableColumnIterator();
            while (iterator.hasNext()) {
                XMLGUITableColumn xMLGUITableColumn = (XMLGUITableColumn)iterator.next();
                if (n != xMLGUITableColumn.getColumnID()) continue;
                int n2 = fWTableModel.mapColumnIDToModelIndex(n);
                fWTableColumn = new FWTableColumn(n2, fWTableModel.getColumnName(n2), new Integer(n));
                fWTableColumn.setHideable(fWTableModel.isColumnHideable(n));
                fWTableColumn.setVisible(xMLGUITableColumn.getIsVisible());
                fWTableColumn.setPreferredWidth(xMLGUITableColumn.getWidth());
                this.addColumn(fWTableColumn);
                return fWTableColumn;
            }
            return null;
        }
        catch (Exception exception) {
            Logger.logError(exception);
            return null;
        }
    }

    protected FWTableColumn buildDefaultColumn(int n, FWTableModel fWTableModel) {
        int n2 = fWTableModel.mapColumnIDToModelIndex(n);
        FWTableColumn fWTableColumn = new FWTableColumn(n2, fWTableModel.getColumnName(n2), new Integer(n));
        fWTableColumn.setHideable(fWTableModel.isColumnHideable(n));
        this.addColumn(fWTableColumn);
        return fWTableColumn;
    }

    protected void arrangeColumns(XMLGUITableColumnList xMLGUITableColumnList, ArrayList arrayList, FWTableModel fWTableModel) {
        int n;
        int n2;
        Object object;
        Object object2;
        if (xMLGUITableColumnList != null) {
            object2 = xMLGUITableColumnList.createXMLGUITableColumnIterator();
            while (object2.hasNext()) {
                try {
                    object = (XMLGUITableColumn)object2.next();
                    n2 = ((XMLGUITableColumn)object).getColumnID();
                    if (!((XMLGUITableColumn)object).getIsVisible()) continue;
                    n = this.getColumnIndex(new Integer(n2));
                    int n3 = ((XMLGUITableColumn)object).getVisibleIndex();
                    this.moveColumn(n, n3);
                }
                catch (Exception exception) {
                    Logger.logError(exception);
                }
            }
        }
        object = ((AbstractList)arrayList).iterator();
        while (object.hasNext()) {
            object2 = (FWTableColumn)object.next();
            n2 = this.getColumnIndex(((TableColumn)object2).getIdentifier());
            n = Math.min(fWTableModel.mapColumnIDToModelIndex((Integer)((TableColumn)object2).getIdentifier()), this.getColumnCount() - 1);
            this.moveColumn(n2, n);
        }
    }

    private class VisibleTableColumnComparator
    implements Comparator {
        private VisibleTableColumnComparator() {
        }

        public int compare(Object object, Object object2) {
            FWTableColumn fWTableColumn = (FWTableColumn)object;
            FWTableColumn fWTableColumn2 = (FWTableColumn)object2;
            if (!fWTableColumn.isVisible()) {
                return -1;
            }
            if (!fWTableColumn2.isVisible()) {
                return 1;
            }
            int n = FWTableColumnModel.this.getColumnIndex(fWTableColumn.getIdentifier());
            int n2 = FWTableColumnModel.this.getColumnIndex(fWTableColumn2.getIdentifier());
            return n - n2;
        }
    }
}

