/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.models;

import phex.ServiceManager;
import phex.event.NetworkHostsChangeListener;
import phex.gui.models.FWTableModel;
import phex.host.Host;
import phex.host.HostManager;
import phex.utils.Localizer;
import phex.utils.StrUtil;

public class NetworkTableModel
extends FWTableModel {
    public static final int HOST_COLUMN_ID = 1001;
    public static final int VENDOR_COLUMN_ID = 1002;
    public static final int TYPE_COLUMN_ID = 1003;
    public static final int RECEIVED_DROPPED_COLUMN_ID = 1004;
    public static final int SENT_QUEUED_COLUMN_ID = 1005;
    public static final int PING_COLUMN_ID = 1006;
    public static final int SHARED_COLUMN_ID = 1007;
    public static final int UPTIME_COLUMN_ID = 1008;
    public static final int STATUS_COLUMN_ID = 1009;
    public static final int HOST_MODEL_INDEX = 0;
    public static final int VENDOR_MODEL_INDEX = 1;
    public static final int TYPE_MODEL_INDEX = 2;
    public static final int RECEIVED_DROPPED_MODEL_INDEX = 3;
    public static final int SENT_QUEUED_MODEL_INDEX = 4;
    public static final int PING_MODEL_INDEX = 5;
    public static final int SHARED_MODEL_INDEX = 6;
    public static final int UPTIME_MODEL_INDEX = 7;
    public static final int STATUS_MODEL_INDEX = 8;
    private static String[] tableColumns = new String[]{Localizer.getString("RemoteHost"), Localizer.getString("Vendor"), Localizer.getString("Type"), Localizer.getString("ReceivedDropped"), Localizer.getString("SentQueued"), Localizer.getString("PingLatency"), Localizer.getString("Shared"), Localizer.getString("Uptime"), Localizer.getString("Status")};
    private static Class[] tableClasses = new Class[]{class$java$lang$String == null ? (class$java$lang$String = NetworkTableModel.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = NetworkTableModel.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = NetworkTableModel.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = NetworkTableModel.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = NetworkTableModel.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = NetworkTableModel.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = NetworkTableModel.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = NetworkTableModel.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = NetworkTableModel.class$("java.lang.String")) : class$java$lang$String};
    private HostManager hostMgr = ServiceManager.getHostManager();
    static /* synthetic */ Class class$java$lang$String;

    public NetworkTableModel() {
        super(tableColumns, tableClasses);
        this.hostMgr.addNetworkHostsChangeListener(new NetworkHostsListener());
    }

    public int getRowCount() {
        return this.hostMgr.getNetworkHostCount();
    }

    public Object getValueAt(int n, int n2) {
        Host host = this.hostMgr.getNetworkHostAt(n);
        if (host == null) {
            this.fireTableRowsDeleted(n, n);
            return "";
        }
        switch (n2) {
            case 0: {
                return host.getHostAddress().getFullHostName();
            }
            case 1: {
                return host.getVendor();
            }
            case 2: {
                return host.getTypeName();
            }
            case 3: {
                return String.valueOf(host.getReceivedCount() + " (" + String.valueOf(host.getDropCount()) + ")");
            }
            case 4: {
                return String.valueOf(host.getSentCount()) + " (" + String.valueOf(host.getSendQueueLength()) + ")";
            }
            case 5: {
                if (host.getLatency() == 99999) {
                    return Localizer.getString("Timeout");
                }
                return String.valueOf(host.getLatency());
            }
            case 6: {
                if (host.getFileCount() == 0) {
                    return "";
                }
                return host.getFileCount() + "/" + StrUtil.formatSizeBytes((long)host.getTotalSize() * 1024L);
            }
            case 7: {
                long l = host.getConnectionUpTime(System.currentTimeMillis()) / 1000L;
                return StrUtil.formatSignificantElapsedTime(l);
            }
            case 8: {
                return host.getStatusName();
            }
        }
        return "";
    }

    public int mapColumnIDToModelIndex(int n) {
        switch (n) {
            case 1001: {
                return 0;
            }
            case 1002: {
                return 1;
            }
            case 1003: {
                return 2;
            }
            case 1004: {
                return 3;
            }
            case 1005: {
                return 4;
            }
            case 1006: {
                return 5;
            }
            case 1007: {
                return 6;
            }
            case 1008: {
                return 7;
            }
            case 1009: {
                return 8;
            }
        }
        return -1;
    }

    public boolean isColumnHideable(int n) {
        return n != 1001;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class NetworkHostsListener
    implements NetworkHostsChangeListener {
        private NetworkHostsListener() {
        }

        public void networkHostChanged(int n) {
            NetworkTableModel.this.fireTableRowsUpdated(n, n);
        }

        public void networkHostAdded(int n) {
            NetworkTableModel.this.fireTableRowsInserted(n, n);
        }

        public void networkHostRemoved(int n) {
            NetworkTableModel.this.fireTableRowsDeleted(n, n);
        }
    }
}

