/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.models;

import javax.swing.event.TableModelEvent;
import phex.ServiceManager;
import phex.event.SharedFilesChangeListener;
import phex.gui.common.GUIRegistry;
import phex.gui.common.LazyEventQueue;
import phex.gui.models.FWTableModel;
import phex.share.FileAdministration;
import phex.share.ShareFile;
import phex.utils.Localizer;

public class SharedFilesTableModel
extends FWTableModel {
    public static final int FILE_COLUMN_ID = 1001;
    public static final int DIRECTORY_COLUMN_ID = 1002;
    public static final int SIZE_COLUMN_ID = 1003;
    public static final int SEARCH_COUNT_COLUMN_ID = 1004;
    public static final int UPLOAD_COUNT_COLUMN_ID = 1005;
    public static final int SHA1_COLUMN_ID = 1006;
    public static final int FILE_MODEL_INDEX = 0;
    public static final int DIRECTORY_MODEL_INDEX = 1;
    public static final int SIZE_MODEL_INDEX = 2;
    public static final int SEARCH_COUNT_MODEL_INDEX = 3;
    public static final int UPLOAD_COUNT_MODEL_INDEX = 4;
    public static final int SHA1_MODEL_INDEX = 5;
    private static String[] tableColumns = new String[]{Localizer.getString("File"), Localizer.getString("Directory"), Localizer.getString("Size"), Localizer.getString("SearchCount"), Localizer.getString("UploadCount"), Localizer.getString("SHA1")};
    private static Class[] tableClasses = new Class[]{class$java$lang$String == null ? (class$java$lang$String = SharedFilesTableModel.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = SharedFilesTableModel.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Long == null ? (class$java$lang$Long = SharedFilesTableModel.class$("java.lang.Long")) : class$java$lang$Long, class$java$lang$Integer == null ? (class$java$lang$Integer = SharedFilesTableModel.class$("java.lang.Integer")) : class$java$lang$Integer, class$java$lang$Integer == null ? (class$java$lang$Integer = SharedFilesTableModel.class$("java.lang.Integer")) : class$java$lang$Integer, class$java$lang$String == null ? (class$java$lang$String = SharedFilesTableModel.class$("java.lang.String")) : class$java$lang$String};
    private FileAdministration sharedFileAdmin = ServiceManager.getShareManager().getFileAdministration();
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Integer;

    public SharedFilesTableModel() {
        super(tableColumns, tableClasses);
        this.sharedFileAdmin.addSharedFilesChangeListener(new SharedFilesListener());
    }

    public int getRowCount() {
        return this.sharedFileAdmin.getFileCount();
    }

    public Object getValueAt(int n, int n2) {
        ShareFile shareFile = this.sharedFileAdmin.getFileAt(n);
        if (shareFile == null) {
            this.fireTableRowsDeleted(n, n);
            return "";
        }
        switch (n2) {
            case 0: {
                return shareFile.getEffectiveName();
            }
            case 1: {
                return shareFile.getFile().getParent();
            }
            case 2: {
                return shareFile.getFileSizeObject();
            }
            case 3: {
                return new Integer(shareFile.getSearchCount());
            }
            case 4: {
                return new Integer(shareFile.getUploadCount());
            }
            case 5: {
                return shareFile.getSHA1();
            }
        }
        return "";
    }

    public int mapColumnIDToModelIndex(int n) {
        switch (n) {
            case 1001: {
                return 0;
            }
            case 1002: {
                return 1;
            }
            case 1003: {
                return 2;
            }
            case 1004: {
                return 3;
            }
            case 1005: {
                return 4;
            }
            case 1006: {
                return 5;
            }
        }
        return -1;
    }

    public boolean isColumnHideable(int n) {
        return n != 1001;
    }

    public static int[] getColumnIdArray() {
        int[] nArray = new int[]{1001, 1002, 1003, 1004, 1005, 1006};
        return nArray;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class SharedFilesListener
    implements SharedFilesChangeListener {
        private LazyEventQueue lazyEventQueue = GUIRegistry.getInstance().getLazyEventQueue();

        public void sharedFileChanged(int n) {
            SharedFilesTableModel.this.fireTableCellUpdated(n, n);
        }

        public void sharedFileAdded(int n) {
            this.lazyEventQueue.addTableModelEvent(new TableModelEvent(SharedFilesTableModel.this, n, n, -1, 1));
        }

        public void sharedFileRemoved(int n) {
            this.lazyEventQueue.addTableModelEvent(new TableModelEvent(SharedFilesTableModel.this, n, n, -1, -1));
        }

        public void allSharedFilesChanged() {
            SharedFilesTableModel.this.fireTableDataChanged();
        }
    }
}

