/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.tabs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.net.URLEncoder;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import phex.MainFrame;
import phex.ServiceManager;
import phex.download.RemoteFile;
import phex.event.QueryHistoryChangeListener;
import phex.gui.common.FWTable;
import phex.gui.common.GUIUtils;
import phex.gui.common.IntegerTextField;
import phex.gui.models.FWSortedTableModel;
import phex.gui.models.FWTableColumnModel;
import phex.gui.models.PassiveSearchTableModel;
import phex.gui.models.QueryHistoryMonitorTableModel;
import phex.interfaces.IMonitorSearch;
import phex.msg.MsgManager;
import phex.query.QueryHistoryMonitor;
import phex.utils.IPUtils;
import phex.utils.Localizer;
import phex.utils.StrUtil;
import phex.xml.XMLGUISettings;
import phex.xml.XMLGUITable;
import phex.xml.XMLGUITableColumnList;

public class MonitorTab
extends JPanel
implements IMonitorSearch {
    private static final String PASSIVE_SEARCH_TABLE_IDENTIFIER = "PassiveSearchTable";
    private MainFrame mainFrame;
    private MsgManager mMsgManager;
    private QueryHistoryMonitor queryHistory;
    private JTable mMonitorTable;
    private QueryHistoryMonitorTableModel queryHistoryModel;
    private FWTable passiveSearchTable;
    private PassiveSearchTableModel passiveSearchModel;
    private FWTableColumnModel passiveSearchColumnModel;
    private JTextField mPassiveSearch;
    private JButton mPassiveButton;
    private JLabel mPassiveStatus;
    private JPopupMenu mSearchResultPopupMenu;
    private JCheckBox enableMonitorCheckbox;
    private JTextField numberOfMonitorRows;

    public MonitorTab(MainFrame mainFrame) {
        this.mainFrame = mainFrame;
        this.mMsgManager = ServiceManager.getMsgManager();
        this.queryHistory = ServiceManager.getQueryManager().getQueryHistoryMonitor();
        this.mMsgManager.setMonitorSearchListener(this);
        this.mSearchResultPopupMenu = new JPopupMenu();
        this.mainFrame.populatePopupMenu(this.mSearchResultPopupMenu, "SearchResultTable.PopupMenu");
    }

    public void initComponent(XMLGUISettings xMLGUISettings) {
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.enableMonitorCheckbox = new JCheckBox("enable");
        this.enableMonitorCheckbox.setSelected(this.queryHistory.isHistoryMonitored());
        this.enableMonitorCheckbox.addChangeListener(new EnableMonitorChangeListener());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 12;
        jPanel.add((Component)this.enableMonitorCheckbox, gridBagConstraints);
        this.queryHistoryModel = new QueryHistoryMonitorTableModel();
        this.mMonitorTable = new JTable(this.queryHistoryModel);
        ServiceManager.getQueryManager().getQueryHistoryMonitor().setQueryHistoryChangeListener(new QueryHistoryChangeListener(){

            public void queryHistoryChanged() {
                GUIUtils.fireTableChanged(MonitorTab.this.mMonitorTable, MonitorTab.this.queryHistoryModel);
            }
        });
        this.mMonitorTable.getSelectionModel().addListSelectionListener(new SelectionHandler());
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        JLabel jLabel = new JLabel("Show ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 14;
        jPanel2.add((Component)jLabel, gridBagConstraints);
        this.numberOfMonitorRows = new IntegerTextField(String.valueOf(this.queryHistory.getMaxHistorySize()), 3, 3);
        this.numberOfMonitorRows.getDocument().addDocumentListener(new MonitorRowsDocumentListener());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 14;
        jPanel2.add((Component)this.numberOfMonitorRows, gridBagConstraints);
        jLabel = new JLabel(" Rows");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 14;
        jPanel2.add((Component)jLabel, gridBagConstraints);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add("North", jPanel);
        jPanel3.add("Center", new JScrollPane(this.mMonitorTable));
        jPanel3.add("South", jPanel2);
        jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(this.getBackground().darker()), Localizer.getString("SearchMonitor")));
        JPanel jPanel4 = new JPanel(new BorderLayout());
        this.passiveSearchModel = new PassiveSearchTableModel();
        XMLGUITable xMLGUITable = GUIUtils.getXMLGUITableByIdentifier(xMLGUISettings, PASSIVE_SEARCH_TABLE_IDENTIFIER);
        this.buildPassiveSearchTableColumnModel(xMLGUITable);
        this.passiveSearchTable = new FWTable((TableModel)new FWSortedTableModel(this.passiveSearchModel), this.passiveSearchColumnModel);
        this.passiveSearchTable.activateAllHeaderActions();
        this.passiveSearchTable.setAutoResizeMode(0);
        this.passiveSearchTable.getSelectionModel().addListSelectionListener(new SelectionHandler());
        this.passiveSearchTable.addMouseListener(new MouseHandler());
        JPanel jPanel5 = new JPanel(new BorderLayout());
        jPanel5.setBorder(BorderFactory.createEmptyBorder(8, 0, 0, 0));
        this.mPassiveSearch = new JTextField("", 20);
        GUIUtils.setToolTipText(this.mPassiveSearch, "Specify keywords to match, separated by space.");
        this.mPassiveButton = new JButton("Start Passive Search");
        GUIUtils.setToolTipText(this.mPassiveButton, "Passive search monitors the search results routed through here.  This might take a while.");
        this.mPassiveStatus = new JLabel("Passive Search Result");
        this.mPassiveButton.addActionListener(new PassiveSearchHandler());
        jPanel5.add("West", new JLabel("Monitor Filter:"));
        jPanel5.add("Center", this.mPassiveSearch);
        jPanel5.add("East", this.mPassiveButton);
        jPanel5.add("South", this.mPassiveStatus);
        JPanel jPanel6 = new JPanel(new FlowLayout());
        JButton jButton = new JButton("Download");
        JButton jButton2 = new JButton("Clear");
        jButton.addActionListener(new PassiveDownloadHandler());
        this.mainFrame.addRefreshComponent("ActionTransferDownload", jButton);
        jButton2.addActionListener(new PassiveClearHandler());
        jPanel6.add(jButton);
        jPanel6.add(jButton2);
        jPanel4.add("North", jPanel5);
        jPanel4.add("Center", new JScrollPane(this.passiveSearchTable));
        jPanel4.add("South", jPanel6);
        jPanel4.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(this.getBackground().darker()), Localizer.getString("PassiveSearch")));
        jPanel3.setPreferredSize(new Dimension(780, 200));
        jPanel4.setPreferredSize(new Dimension(780, 230));
        JSplitPane jSplitPane = new JSplitPane(0);
        jSplitPane.setBorder(BorderFactory.createEmptyBorder(4, 4, 2, 4));
        jSplitPane.setDividerSize(6);
        jSplitPane.setOneTouchExpandable(true);
        jSplitPane.setTopComponent(jPanel3);
        jSplitPane.setBottomComponent(jPanel4);
        this.add("Center", jSplitPane);
    }

    public RemoteFile getSelectedRemoteFile() {
        int n = this.passiveSearchTable.getSelectedRow();
        if (n < 0) {
            return null;
        }
        int n2 = this.passiveSearchTable.convertRowIndexToModel(n);
        Vector vector = this.mMsgManager.getPassiveResults();
        RemoteFile remoteFile = (RemoteFile)vector.elementAt(n2);
        return remoteFile;
    }

    public void passiveSearch() {
        if (this.mMsgManager.getPassiveSearching() == null) {
            String string = this.mPassiveSearch.getText().trim();
            this.mMsgManager.setPassiveSearching(string);
            this.mPassiveButton.setText("Stop Passive Search");
            this.mPassiveStatus.setText("Passive Search Result (Monitoring...)");
        } else {
            this.mMsgManager.setPassiveSearching(null);
            this.mPassiveButton.setText("Start Passive Search");
            this.mPassiveStatus.setText("Passive Search Result");
        }
        this.mainFrame.refreshAllActions();
    }

    public void passiveDownload() {
        int[] nArray = this.passiveSearchTable.getSelectedRows();
        if (nArray.length == 0) {
            return;
        }
        int[] nArray2 = this.passiveSearchTable.convertRowIndicesToModel(nArray);
        Vector vector = this.mMsgManager.getPassiveResults();
        int n = 0;
        while (n < nArray2.length) {
            int n2 = nArray2[n];
            RemoteFile remoteFile = (RemoteFile)vector.elementAt(n2);
            RemoteFile remoteFile2 = new RemoteFile(remoteFile);
            String string = StrUtil.createNaturalSearchTerm(remoteFile2.getFilename());
            ServiceManager.getSwarmingManager().addFileToDownload(remoteFile2, ServiceManager.sCfg.mDownloadDir + File.separator + remoteFile2.getFilename(), string);
            ++n;
        }
        this.mainFrame.setSelectedTab(3);
        this.mainFrame.refreshAllActions();
    }

    public void passiveCopyURL() {
        RemoteFile remoteFile = this.getSelectedRemoteFile();
        String string = URLEncoder.encode(remoteFile.getURL());
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(string), null);
    }

    public void filterPassiveDownloadHost() {
        int[] nArray = this.passiveSearchTable.getSelectedRows();
        if (nArray.length == 0) {
            return;
        }
        int[] nArray2 = this.passiveSearchTable.convertRowIndicesToModel(nArray);
        Vector vector = this.mMsgManager.getPassiveResults();
        int n = 0;
        while (n < nArray2.length) {
            int n2 = nArray2[n];
            RemoteFile remoteFile = (RemoteFile)vector.elementAt(n2);
            ServiceManager.sCfg.mFilteredSearchHosts.addElement(IPUtils.splitIP2Parts(remoteFile.getHostAddress().getHostName()));
            ++n;
        }
        ServiceManager.sCfg.save();
    }

    public boolean isPassiveResultSelected() {
        return this.passiveSearchTable.getSelectedRowCount() > 0;
    }

    private void passiveClearResult() {
        this.mMsgManager.resetPassiveResults();
        this.mainFrame.refreshAllActions();
    }

    public void passiveResultArrived() {
        GUIUtils.fireTableChanged(this.passiveSearchTable, this.passiveSearchModel);
    }

    private void buildPassiveSearchTableColumnModel(XMLGUITable xMLGUITable) {
        int[] nArray = PassiveSearchTableModel.getColumnIdArray();
        XMLGUITableColumnList xMLGUITableColumnList = null;
        if (xMLGUITable != null) {
            xMLGUITableColumnList = xMLGUITable.getTableColumnList();
        }
        this.passiveSearchColumnModel = new FWTableColumnModel(this.passiveSearchModel, nArray, xMLGUITableColumnList);
    }

    public void appendXMLGUISettings(XMLGUISettings xMLGUISettings) {
        XMLGUITableColumnList xMLGUITableColumnList = this.passiveSearchColumnModel.createXMLGUITableColumnList();
        XMLGUITable xMLGUITable = new XMLGUITable();
        xMLGUITable.setTableColumnList(xMLGUITableColumnList);
        xMLGUITable.setTableIdentifier(PASSIVE_SEARCH_TABLE_IDENTIFIER);
        xMLGUISettings.getTableList().addXMLGUITable(xMLGUITable);
    }

    private class MonitorRowsDocumentListener
    implements DocumentListener {
        private MonitorRowsDocumentListener() {
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.updateMonitorRows();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.updateMonitorRows();
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }

        private void updateMonitorRows() {
            String string = MonitorTab.this.numberOfMonitorRows.getText();
            try {
                int n = Integer.parseInt(string);
                MonitorTab.this.queryHistory.setMaxHistroySize(n);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private class EnableMonitorChangeListener
    implements ChangeListener {
        private EnableMonitorChangeListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            MonitorTab.this.queryHistory.setHistoryMonitored(MonitorTab.this.enableMonitorCheckbox.isSelected());
        }
    }

    private class SelectionHandler
    implements ListSelectionListener {
        private SelectionHandler() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            MonitorTab.this.mainFrame.refreshAllActions();
        }
    }

    private class PassiveSearchHandler
    implements ActionListener {
        private PassiveSearchHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MonitorTab.this.passiveSearch();
        }
    }

    private class MouseHandler
    extends MouseAdapter
    implements MouseListener {
        private MouseHandler() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2 && mouseEvent.getSource() == MonitorTab.this.passiveSearchTable) {
                MonitorTab.this.passiveDownload();
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.popupMenu((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.popupMenu((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
            }
        }

        private void popupMenu(Component component, int n, int n2) {
            if (component == MonitorTab.this.passiveSearchTable) {
                MonitorTab.this.mSearchResultPopupMenu.show(component, n, n2);
            }
        }
    }

    private class PassiveDownloadHandler
    implements ActionListener {
        private PassiveDownloadHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MonitorTab.this.passiveDownload();
        }
    }

    private class PassiveClearHandler
    implements ActionListener {
        private PassiveClearHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MonitorTab.this.passiveClearResult();
        }
    }
}

