/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.tabs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.AbstractList;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import phex.MainFrame;
import phex.ServiceManager;
import phex.download.swarming.SWDownloadCandidate;
import phex.download.swarming.SWDownloadFile;
import phex.download.swarming.SwarmingManager;
import phex.event.DownloadFilesChangeListener;
import phex.gui.actions.FWAction;
import phex.gui.common.FWTable;
import phex.gui.common.FWToolBar;
import phex.gui.common.GUIRegistry;
import phex.gui.common.GUIUtils;
import phex.gui.dialogs.DownloadConfigDialog;
import phex.gui.models.FWSortedTableModel;
import phex.gui.models.FWTableColumnModel;
import phex.gui.models.SWCandidateTableModel;
import phex.gui.models.SWDownloadTableModel;
import phex.gui.models.SWSegmentTableModel;
import phex.gui.renderer.DefaultPhexCellRenderers;
import phex.gui.tabs.FWTab;
import phex.utils.Localizer;
import phex.utils.StrUtil;
import phex.xml.XMLGUISettings;
import phex.xml.XMLGUITable;
import phex.xml.XMLGUITableColumnList;

public class SWDownloadTab
extends FWTab {
    private static final String DOWNLOAD_TABLE_IDENTIFIER = "DownloadTable";
    private static final String SEGMENT_TABLE_IDENTIFIER = "SegmentTable";
    private static final String CANDIDATE_TABLE_IDENTIFIER = "CandidateTable";
    private SwarmingManager swarmingMgr = ServiceManager.getSwarmingManager();
    private FWTable downloadTable;
    private FWTableColumnModel downloadColumnModel;
    private SWDownloadTableModel downloadModel;
    private JTabbedPane downloadDetails;
    private TitledBorder candidateTitleBorder;
    private FWTable candidateTable;
    private FWTableColumnModel candidateColumnModel;
    private SWCandidateTableModel candidateModel;
    private FWTable segmentTable;
    private FWTableColumnModel segmentColumnModel;
    private SWSegmentTableModel segmentModel;
    private MainFrame mainFrame;

    public SWDownloadTab(MainFrame mainFrame) {
        this.swarmingMgr.addDownloadFilesChangeListener(new DownloadFilesChangeHandler());
        this.mainFrame = mainFrame;
    }

    public void initComponent(XMLGUISettings xMLGUISettings) {
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(this.getBackground().darker()), Localizer.getString("DownloadFiles")));
        this.downloadModel = new SWDownloadTableModel();
        XMLGUITable xMLGUITable = GUIUtils.getXMLGUITableByIdentifier(xMLGUISettings, DOWNLOAD_TABLE_IDENTIFIER);
        this.buildDownloadTableColumnModel(xMLGUITable);
        this.downloadTable = new FWTable((TableModel)new FWSortedTableModel(this.downloadModel), this.downloadColumnModel);
        this.downloadTable.activateAllHeaderActions();
        this.downloadTable.setAutoResizeMode(0);
        this.downloadTable.getSelectionModel().addListSelectionListener(new DownloadSelectionHandler());
        GUIRegistry.getInstance().getTableUpdateService().registerTable(this.downloadTable);
        jPanel.add("Center", new JScrollPane(this.downloadTable));
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 4, 0, 4), BorderFactory.createEtchedBorder()));
        FWToolBar fWToolBar = new FWToolBar(0);
        fWToolBar.setBorderPainted(false);
        fWToolBar.setFloatable(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.anchor = 18;
        jPanel2.add((Component)fWToolBar, gridBagConstraints);
        FWAction fWAction = new StartStopDownloadAction();
        this.addTabAction(fWAction);
        fWToolBar.add(fWAction);
        fWToolBar.addSeparator();
        fWAction = new ConfigureDownloadAction();
        this.addTabAction(fWAction);
        fWToolBar.add(fWAction);
        fWAction = new SearchCandidatesAction();
        this.addTabAction(fWAction);
        fWToolBar.add(fWAction);
        fWToolBar.addSeparator();
        fWAction = new RemoveDownloadAction();
        this.addTabAction(fWAction);
        fWToolBar.add(fWAction);
        jPanel.add("South", jPanel2);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        this.candidateTitleBorder = BorderFactory.createTitledBorder(BorderFactory.createLineBorder(this.getBackground().darker()), Localizer.getString("DownloadCandidates"));
        jPanel3.setBorder(this.candidateTitleBorder);
        this.candidateModel = new SWCandidateTableModel(this.downloadTable);
        xMLGUITable = GUIUtils.getXMLGUITableByIdentifier(xMLGUISettings, CANDIDATE_TABLE_IDENTIFIER);
        this.buildCandidateTableColumnModel(xMLGUITable);
        this.candidateTable = new FWTable((TableModel)new FWSortedTableModel(this.candidateModel), this.candidateColumnModel);
        this.candidateTable.activateAllHeaderActions();
        this.candidateTable.setSelectionMode(0);
        this.candidateTable.getSelectionModel().addListSelectionListener(new DownloadSelectionHandler());
        this.candidateTable.setAutoResizeMode(0);
        GUIRegistry.getInstance().getTableUpdateService().registerTable(this.candidateTable);
        jPanel3.add("Center", new JScrollPane(this.candidateTable));
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        jPanel4.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 4, 0, 4), BorderFactory.createEtchedBorder()));
        FWToolBar fWToolBar2 = new FWToolBar(0);
        fWToolBar2.setBorderPainted(false);
        fWToolBar2.setFloatable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.anchor = 18;
        jPanel4.add((Component)fWToolBar2, gridBagConstraints);
        fWAction = new RetryCandidateAction();
        this.addTabAction(fWAction);
        fWToolBar2.add(fWAction);
        fWToolBar2.addSeparator();
        fWAction = new RemoveCandidateAction();
        this.addTabAction(fWAction);
        fWToolBar2.add(fWAction);
        fWToolBar2.addSeparator();
        jPanel3.add("South", jPanel4);
        JPanel jPanel5 = new JPanel(new BorderLayout());
        jPanel5.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(this.getBackground().darker()), Localizer.getString("DownloadSegments")));
        this.segmentModel = new SWSegmentTableModel(this.downloadTable);
        xMLGUITable = GUIUtils.getXMLGUITableByIdentifier(xMLGUISettings, SEGMENT_TABLE_IDENTIFIER);
        this.buildSegmentTableColumnModel(xMLGUITable);
        this.segmentTable = new FWTable((TableModel)new FWSortedTableModel(this.segmentModel), this.segmentColumnModel);
        this.segmentTable.activateAllHeaderActions();
        this.segmentTable.setSelectionMode(0);
        this.segmentTable.setAutoResizeMode(0);
        GUIRegistry.getInstance().getTableUpdateService().registerTable(this.segmentTable);
        jPanel5.add("Center", new JScrollPane(this.segmentTable));
        this.downloadDetails = new JTabbedPane(3);
        this.downloadDetails.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
        this.downloadDetails.addTab(Localizer.getString("Candidates"), jPanel3);
        this.downloadDetails.addTab(Localizer.getString("Segments"), jPanel5);
        Dimension dimension = new Dimension(400, 200);
        jPanel.setPreferredSize(dimension);
        this.downloadDetails.setPreferredSize(dimension);
        JSplitPane jSplitPane = new JSplitPane(0, jPanel, this.downloadDetails);
        jSplitPane.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        jSplitPane.setDividerSize(4);
        jSplitPane.setOneTouchExpandable(false);
        jSplitPane.setDividerLocation(0.5);
        jSplitPane.setResizeWeight(0.5);
        this.add("Center", jSplitPane);
        DefaultPhexCellRenderers.setDefaultPhexCellRenderers(this.downloadTable);
        DefaultPhexCellRenderers.setDefaultPhexCellRenderers(this.candidateTable);
        DefaultPhexCellRenderers.setDefaultPhexCellRenderers(this.segmentTable);
        GUIUtils.adjustTableProgresssBarHeight(this.downloadTable);
        GUIUtils.adjustTableProgresssBarHeight(this.candidateTable);
        GUIUtils.adjustTableProgresssBarHeight(this.segmentTable);
    }

    public void updateUI() {
        super.updateUI();
        if (this.downloadTable != null) {
            GUIUtils.adjustTableProgresssBarHeight(this.downloadTable);
        }
    }

    private void updateInformation(int n) {
        int n2 = this.downloadTable.convertRowIndexToModel(this.downloadTable.getSelectedRow());
        if (n2 == n) {
            this.refreshTabActions();
            SWDownloadFile sWDownloadFile = this.swarmingMgr.getDownloadFile(n2);
            if (sWDownloadFile != null) {
                if (sWDownloadFile.getResearchSetting().isSearchRunning()) {
                    Object[] objectArray = new Object[]{new Integer(sWDownloadFile.getResearchSetting().getSearchHitCount())};
                    StringBuffer stringBuffer = new StringBuffer(Localizer.getString("DownloadCandidates"));
                    stringBuffer.append(' ');
                    stringBuffer.append(Localizer.getFormatedString("CandidatesSearchingExt", objectArray));
                    this.candidateTitleBorder.setTitle(stringBuffer.toString());
                } else {
                    this.candidateTitleBorder.setTitle(Localizer.getString("DownloadCandidates"));
                }
                this.downloadDetails.repaint();
            }
        }
    }

    public SWDownloadFile[] getSelectedDownloadFiles() {
        if (this.downloadTable.getSelectedRowCount() == 0) {
            return new SWDownloadFile[0];
        }
        int[] nArray = this.downloadTable.getSelectedRows();
        int[] nArray2 = this.downloadTable.convertRowIndicesToModel(nArray);
        SWDownloadFile[] sWDownloadFileArray = new SWDownloadFile[nArray2.length];
        int n = 0;
        while (n < sWDownloadFileArray.length) {
            sWDownloadFileArray[n] = this.swarmingMgr.getDownloadFile(nArray2[n]);
            ++n;
        }
        return sWDownloadFileArray;
    }

    private void buildDownloadTableColumnModel(XMLGUITable xMLGUITable) {
        int[] nArray = SWDownloadTableModel.getColumnIdArray();
        XMLGUITableColumnList xMLGUITableColumnList = null;
        if (xMLGUITable != null) {
            xMLGUITableColumnList = xMLGUITable.getTableColumnList();
        }
        this.downloadColumnModel = new FWTableColumnModel(this.downloadModel, nArray, xMLGUITableColumnList);
    }

    private void buildSegmentTableColumnModel(XMLGUITable xMLGUITable) {
        int[] nArray = new int[]{1001, 1002, 1003, 1004};
        XMLGUITableColumnList xMLGUITableColumnList = null;
        if (xMLGUITable != null) {
            xMLGUITableColumnList = xMLGUITable.getTableColumnList();
        }
        this.segmentColumnModel = new FWTableColumnModel(this.segmentModel, nArray, xMLGUITableColumnList);
    }

    private void buildCandidateTableColumnModel(XMLGUITable xMLGUITable) {
        int[] nArray = new int[]{1001, 1002, 1003, 1004, 1005, 1006};
        XMLGUITableColumnList xMLGUITableColumnList = null;
        if (xMLGUITable != null) {
            xMLGUITableColumnList = xMLGUITable.getTableColumnList();
        }
        this.candidateColumnModel = new FWTableColumnModel(this.candidateModel, nArray, xMLGUITableColumnList);
    }

    public void appendXMLGUISettings(XMLGUISettings xMLGUISettings) {
        XMLGUITableColumnList xMLGUITableColumnList = this.downloadColumnModel.createXMLGUITableColumnList();
        XMLGUITable xMLGUITable = new XMLGUITable();
        xMLGUITable.setTableColumnList(xMLGUITableColumnList);
        xMLGUITable.setTableIdentifier(DOWNLOAD_TABLE_IDENTIFIER);
        xMLGUISettings.getTableList().addXMLGUITable(xMLGUITable);
        xMLGUITableColumnList = this.segmentColumnModel.createXMLGUITableColumnList();
        xMLGUITable = new XMLGUITable();
        xMLGUITable.setTableColumnList(xMLGUITableColumnList);
        xMLGUITable.setTableIdentifier(SEGMENT_TABLE_IDENTIFIER);
        xMLGUISettings.getTableList().addXMLGUITable(xMLGUITable);
        xMLGUITableColumnList = this.candidateColumnModel.createXMLGUITableColumnList();
        xMLGUITable = new XMLGUITable();
        xMLGUITable.setTableColumnList(xMLGUITableColumnList);
        xMLGUITable.setTableIdentifier(CANDIDATE_TABLE_IDENTIFIER);
        xMLGUISettings.getTableList().addXMLGUITable(xMLGUITable);
    }

    private class SearchCandidatesAction
    extends FWAction {
        public SearchCandidatesAction() {
            super(Localizer.getString("Search"), null, Localizer.getString("TTTSearchCandidates"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = SWDownloadTab.this.downloadTable.getSelectedRow();
            int n2 = SWDownloadTab.this.downloadTable.convertRowIndexToModel(n);
            SWDownloadFile sWDownloadFile = SWDownloadTab.this.swarmingMgr.getDownloadFile(n2);
            sWDownloadFile.startSearchForCandidates();
        }

        public void refreshActionState() {
            int n = SWDownloadTab.this.downloadTable.getSelectedRow();
            int n2 = SWDownloadTab.this.downloadTable.convertRowIndexToModel(n);
            SWDownloadFile sWDownloadFile = SWDownloadTab.this.swarmingMgr.getDownloadFile(n2);
            if (sWDownloadFile == null) {
                this.setEnabled(false);
            } else if (sWDownloadFile.getResearchSetting().isSearchRunning()) {
                this.setEnabled(false);
            } else {
                this.setEnabled(true);
            }
        }
    }

    class RetryCandidateAction
    extends FWAction {
        RetryCandidateAction() {
            super(Localizer.getString("RetryCandidate"), null, Localizer.getString("TTTRetryCandidate"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = SWDownloadTab.this.downloadTable.getSelectedRow();
            int n2 = SWDownloadTab.this.downloadTable.convertRowIndexToModel(n);
            SWDownloadFile sWDownloadFile = SWDownloadTab.this.swarmingMgr.getDownloadFile(n2);
            n = SWDownloadTab.this.candidateTable.getSelectedRow();
            n2 = SWDownloadTab.this.candidateTable.convertRowIndexToModel(n);
            SWDownloadCandidate sWDownloadCandidate = sWDownloadFile.getCandidate(n2);
            sWDownloadCandidate.manualConnectionRetry();
        }

        public void refreshActionState() {
            int n = SWDownloadTab.this.downloadTable.getSelectedRow();
            int n2 = SWDownloadTab.this.candidateTable.getSelectedRow();
            if (n < 0 || n2 < 0) {
                this.setEnabled(false);
            } else {
                this.setEnabled(true);
            }
        }
    }

    class RemoveCandidateAction
    extends FWAction {
        RemoveCandidateAction() {
            super(Localizer.getString("RemoveCandidate"), null, Localizer.getString("TTTRemoveCandidate"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = SWDownloadTab.this.downloadTable.getSelectedRow();
            int n2 = SWDownloadTab.this.downloadTable.convertRowIndexToModel(n);
            SWDownloadFile sWDownloadFile = SWDownloadTab.this.swarmingMgr.getDownloadFile(n2);
            n = SWDownloadTab.this.candidateTable.getSelectedRow();
            n2 = SWDownloadTab.this.candidateTable.convertRowIndexToModel(n);
            SWDownloadCandidate sWDownloadCandidate = sWDownloadFile.getCandidate(n2);
            sWDownloadFile.removeDownloadCandidate(sWDownloadCandidate);
        }

        public void refreshActionState() {
            int n = SWDownloadTab.this.downloadTable.getSelectedRow();
            int n2 = SWDownloadTab.this.candidateTable.getSelectedRow();
            if (n < 0 || n2 < 0) {
                this.setEnabled(false);
            } else {
                this.setEnabled(true);
            }
        }
    }

    class RemoveDownloadAction
    extends FWAction {
        RemoveDownloadAction() {
            super(Localizer.getString("RemoveDownload"), null, Localizer.getString("TTTRemoveDownload"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SWDownloadFile[] sWDownloadFileArray;
            SWDownloadFile[] sWDownloadFileArray2 = SWDownloadTab.this.getSelectedDownloadFiles();
            ArrayList<SWDownloadFile> arrayList = new ArrayList<SWDownloadFile>(sWDownloadFileArray2.length);
            ArrayList<Object> arrayList2 = new ArrayList<Object>(sWDownloadFileArray2.length);
            int n = 0;
            while (n < sWDownloadFileArray2.length) {
                if (sWDownloadFileArray2[n].isDownloadCompleted()) {
                    arrayList2.add(sWDownloadFileArray2[n]);
                } else if (sWDownloadFileArray2[n].getTransferredDataSize() == 0L) {
                    arrayList2.add(sWDownloadFileArray2[n]);
                } else {
                    arrayList.add(sWDownloadFileArray2[n]);
                }
                ++n;
            }
            Integer n2 = new Integer(arrayList.size());
            int n3 = 0;
            while (n3 < n2) {
                sWDownloadFileArray = (SWDownloadFile[])arrayList.get(n3);
                sWDownloadFileArray.forceCollectionOfTransferData();
                Object[] objectArray = new Object[]{sWDownloadFileArray.getDestinationFile().getName(), StrUtil.formatSizeBytes(sWDownloadFileArray.getTransferredDataSize()), StrUtil.formatSizeBytes(sWDownloadFileArray.getTransferDataSize())};
                Object[] objectArray2 = new Object[]{new Integer(n3 + 1), n2};
                Object[] objectArray3 = n2 - n3 > 1 ? new Object[]{Localizer.getString("Yes"), Localizer.getString("No"), Localizer.getString("YesToAll"), Localizer.getString("NoToAll")} : new Object[]{Localizer.getString("Yes"), Localizer.getString("No")};
                int n4 = JOptionPane.showOptionDialog(SWDownloadTab.this.mainFrame, Localizer.getFormatedString("RemoveDownloadWarning", objectArray), Localizer.getFormatedString("RemoveDownloadTitle", objectArray2), 0, 2, null, objectArray3, Localizer.getString("Yes"));
                System.out.println(n4);
                if (n4 == 0) {
                    arrayList2.add(sWDownloadFileArray);
                } else {
                    if (n4 == 2) {
                        arrayList2.addAll(((AbstractList)arrayList).subList(n3, arrayList.size()));
                        break;
                    }
                    if (n4 == 3) break;
                }
                ++n3;
            }
            if (arrayList2.size() > 0) {
                sWDownloadFileArray = new SWDownloadFile[arrayList2.size()];
                arrayList2.toArray(sWDownloadFileArray);
                SWDownloadTab.this.swarmingMgr.removeDownloadFiles(sWDownloadFileArray);
                SWDownloadTab.this.downloadTable.getSelectionModel().clearSelection();
            }
        }

        public void refreshActionState() {
            int n = SWDownloadTab.this.downloadTable.getSelectedRow();
            if (n < 0) {
                this.setEnabled(false);
            } else {
                this.setEnabled(true);
            }
        }
    }

    class ConfigureDownloadAction
    extends FWAction {
        ConfigureDownloadAction() {
            super(Localizer.getString("ConfigureDownload"), null, Localizer.getString("TTTConfigureDownload"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = SWDownloadTab.this.downloadTable.getSelectedRow();
            int n2 = SWDownloadTab.this.downloadTable.convertRowIndexToModel(n);
            SWDownloadFile sWDownloadFile = SWDownloadTab.this.swarmingMgr.getDownloadFile(n2);
            if (sWDownloadFile != null) {
                if (sWDownloadFile.isDownloadInProgress()) {
                    JOptionPane.showMessageDialog(SWDownloadTab.this, Localizer.getString("NoConfigDownloadInProgress"), Localizer.getString("DownloadInProgress"), 2);
                    return;
                }
                short s = sWDownloadFile.getStatus();
                sWDownloadFile.stopDownload();
                DownloadConfigDialog downloadConfigDialog = new DownloadConfigDialog(sWDownloadFile);
                downloadConfigDialog.show();
                sWDownloadFile.setStatus(s);
            }
        }

        public void refreshActionState() {
            int n = SWDownloadTab.this.downloadTable.getSelectedRow();
            if (n < 0) {
                this.setEnabled(false);
            } else {
                this.setEnabled(true);
            }
        }
    }

    class StartStopDownloadAction
    extends FWAction {
        private boolean isStartAction;

        StartStopDownloadAction() {
            super(Localizer.getString("StopDownload"), null, Localizer.getString("TTTStopDownload"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = SWDownloadTab.this.downloadTable.getSelectedRow();
            int n2 = SWDownloadTab.this.downloadTable.convertRowIndexToModel(n);
            SWDownloadFile sWDownloadFile = SWDownloadTab.this.swarmingMgr.getDownloadFile(n2);
            if (!this.isStartAction) {
                sWDownloadFile.stopDownload();
            } else {
                sWDownloadFile.startDownload();
            }
            this.refreshActionState();
        }

        public void refreshActionState() {
            int n = SWDownloadTab.this.downloadTable.getSelectedRow();
            int n2 = SWDownloadTab.this.downloadTable.convertRowIndexToModel(n);
            SWDownloadFile sWDownloadFile = SWDownloadTab.this.swarmingMgr.getDownloadFile(n2);
            if (sWDownloadFile == null || sWDownloadFile.isDownloadCompleted()) {
                this.setEnabled(false);
            } else if (sWDownloadFile.isDownloadStopped()) {
                this.setEnabled(true);
                this.putValue("Name", Localizer.getString("StartDownload"));
                this.putValue("ToolTipText", Localizer.getString("TTTStartDownload"));
                this.isStartAction = true;
            } else {
                this.setEnabled(true);
                this.putValue("Name", Localizer.getString("StopDownload"));
                this.putValue("ToolTipText", Localizer.getString("TTTStopDownload"));
                this.isStartAction = false;
            }
        }
    }

    private class DownloadFilesChangeHandler
    implements DownloadFilesChangeListener {
        private DownloadFilesChangeHandler() {
        }

        public void downloadFileChanged(int n) {
            SWDownloadTab.this.updateInformation(n);
        }

        public void downloadFileAdded(int n) {
        }

        public void downloadFileRemoved(int n) {
        }
    }

    class DownloadSelectionHandler
    implements ListSelectionListener {
        DownloadSelectionHandler() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                SWDownloadTab.this.refreshTabActions();
            }
        }
    }
}

