/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.tabs;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.net.URLEncoder;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import phex.MainFrame;
import phex.ServiceManager;
import phex.common.MediaType;
import phex.config.Cfg;
import phex.dialogues.DlgAddAsCandidate;
import phex.download.RemoteFile;
import phex.download.swarming.SWDownloadFile;
import phex.gui.actions.FWAction;
import phex.gui.common.FWTable;
import phex.gui.common.FWToolBar;
import phex.gui.common.GUIRegistry;
import phex.gui.common.GUIUtils;
import phex.gui.common.IntegerTextField;
import phex.gui.dialogs.DownloadConfigDialog;
import phex.gui.models.FWSortedTableModel;
import phex.gui.models.FWTableColumnModel;
import phex.gui.models.SearchComboBoxModel;
import phex.gui.models.SearchTableModel;
import phex.gui.renderer.DefaultPhexCellRenderers;
import phex.gui.renderer.MediaTypeListRenderer;
import phex.gui.renderer.SearchListRenderer;
import phex.gui.tabs.FWTab;
import phex.interfaces.IFind;
import phex.query.Search;
import phex.query.SearchContainer;
import phex.utils.IPUtils;
import phex.utils.Localizer;
import phex.utils.StrUtil;
import phex.xml.XMLGUISettings;
import phex.xml.XMLGUITable;
import phex.xml.XMLGUITableColumnList;

public class SearchTab
extends FWTab
implements IFind {
    private static final Dimension NO_SIZE_DIMENSION = new Dimension(0, 0);
    private static final String SEARCH_TABLE_IDENTIFIER = "SearchTable";
    private SizeDefinition[] sizeDefinitions = new SizeDefinition[]{new SizeDefinition("BytesToken", 1L), new SizeDefinition("KBToken", 1024L), new SizeDefinition("MBToken", 0x100000L), new SizeDefinition("GBToken", 0x40000000L)};
    private JPanel topPanel;
    private JPanel searchConfigPanel;
    private JTextField searchTextTF;
    private JButton submitSearchBtn;
    private JPanel filterConfigPanel;
    private JTextField filterTextTF;
    private JComboBox mediaTypeComboBox;
    private JCheckBox filterHostsCkbx;
    private JTextField maxSearchResultsTF;
    private JComboBox minFileSizeUnitComboBox;
    private JTextField minFileSizeTF;
    private JTextField minHostSpeed;
    private JComboBox minHostRatingComboBox;
    private JButton saveFilterButton;
    private JButton applyFilterButton;
    private JButton resetFilterButton;
    private SearchContainer searchContainer;
    private MainFrame mainFrame;
    private JLabel mSearchResultLabel;
    private JTextField mMaximumSizeFilterText;
    private JComboBox searchResultCombo;
    private SearchComboBoxModel searchResultModel;
    private JButton searchStopButton;
    private JButton removeSearchBtn;
    private JComboBox filterComboBox;
    private JButton removeFilterBtn;
    private FWTable searchTable;
    private FWTableColumnModel searchColumnModel;
    private SearchTableModel searchModel;
    private JPopupMenu mSearchResultPopupMenu;
    private static String QUICK_DOWNLOAD_ACTION_KEY = "SWQuickDownloadAction";
    private static String CONFIG_DOWNLOAD_ACTION_KEY = "SWConfigDownloadAction";
    private static String ADD_AS_CANDIDATE_ACTION_KEY = "AddAsCandidateAction";

    public SearchTab(MainFrame mainFrame) {
        this.mainFrame = mainFrame;
        this.searchContainer = ServiceManager.getQueryManager().getSearchContainer();
        this.mSearchResultPopupMenu = new JPopupMenu();
        this.mainFrame.populatePopupMenu(this.mSearchResultPopupMenu, "SearchResultTable.PopupMenu");
    }

    public void initComponent(XMLGUISettings xMLGUISettings) {
        Insets insets = new Insets(0, 0, 0, 0);
        Insets insets2 = new Insets(0, 2, 0, 2);
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(4, 4, 2, 4));
        this.topPanel = new JPanel(new GridBagLayout());
        this.topPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(this.getBackground().darker()), Localizer.getString("SearchConditions")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        this.add((Component)this.topPanel, gridBagConstraints);
        this.searchConfigPanel = new JPanel(new GridBagLayout());
        this.searchConfigPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 4));
        JLabel jLabel = new JLabel(Localizer.getString("SearchTerm") + ": ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 0, 2);
        this.searchConfigPanel.add((Component)jLabel, gridBagConstraints);
        SubmitSearchAction submitSearchAction = new SubmitSearchAction();
        this.searchTextTF = new JTextField(ServiceManager.sCfg.mSearchLastSearch, 25);
        this.searchTextTF.registerKeyboardAction(submitSearchAction, KeyStroke.getKeyStroke(10, 0), 0);
        GUIUtils.setToolTipText(this.searchTextTF, Localizer.getString("TTTSearchText"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.searchConfigPanel.add((Component)this.searchTextTF, gridBagConstraints);
        this.submitSearchBtn = new JButton(Localizer.getString("Search"), GUIRegistry.getInstance().getIconFactory().getIcon("Search"));
        Insets insets3 = this.submitSearchBtn.getMargin();
        this.submitSearchBtn.setMargin(new Insets(insets3.top - 1, insets3.left, insets3.bottom - 1, insets3.right));
        this.submitSearchBtn.addActionListener(submitSearchAction);
        GUIUtils.setToolTipText(this.submitSearchBtn, Localizer.getString("TTTSearch"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.searchConfigPanel.add((Component)this.submitSearchBtn, gridBagConstraints);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 4));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        this.topPanel.add((Component)jPanel, gridBagConstraints);
        this.searchResultModel = new SearchComboBoxModel();
        this.searchResultModel.addListDataListener(new SearchUpdateChangeListener());
        this.searchResultCombo = new JComboBox(this.searchResultModel);
        this.searchResultCombo.setRenderer(new SearchListRenderer());
        this.searchResultCombo.setEditable(false);
        this.searchResultCombo.addActionListener(new SearchComboActionHandler());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.9;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)this.searchResultCombo, gridBagConstraints);
        this.searchStopButton = new JButton("Stop");
        this.searchStopButton.setMargin(insets);
        GUIUtils.setToolTipText(this.searchStopButton, "Stop the selected search.");
        this.searchStopButton.setEnabled(false);
        this.searchStopButton.addActionListener(new SearchButtonHandler());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 2);
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)this.searchStopButton, gridBagConstraints);
        this.removeSearchBtn = new JButton(Localizer.getString("Remove"));
        this.removeSearchBtn.setMargin(insets);
        GUIUtils.setToolTipText(this.removeSearchBtn, Localizer.getString("TTTRemoveSearch"));
        this.removeSearchBtn.setEnabled(true);
        this.removeSearchBtn.addActionListener(new SearchButtonHandler());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 2);
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)this.removeSearchBtn, gridBagConstraints);
        this.filterConfigPanel = new JPanel(new GridBagLayout());
        this.filterConfigPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 4));
        jLabel = new JLabel(Localizer.getString("RefineSearch") + ": ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 2, 2);
        this.filterConfigPanel.add((Component)jLabel, gridBagConstraints);
        this.filterTextTF = new JTextField(ServiceManager.sCfg.mSearchFilter, 20);
        GUIUtils.setToolTipText(this.filterTextTF, Localizer.getString("TTTResultFilter"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 2, 5);
        this.filterConfigPanel.add((Component)this.filterTextTF, gridBagConstraints);
        this.mediaTypeComboBox = new JComboBox<MediaType>(MediaType.getAllMediaTypes());
        this.mediaTypeComboBox.setRenderer(new MediaTypeListRenderer());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 2, 5);
        this.filterConfigPanel.add((Component)this.mediaTypeComboBox, gridBagConstraints);
        this.filterHostsCkbx = new JCheckBox(Localizer.getString("HideFilteredHosts"), ServiceManager.sCfg.mApplyFilterdHosts);
        GUIUtils.setToolTipText(this.filterHostsCkbx, Localizer.getString("TTTHideFilteredHosts"));
        this.filterHostsCkbx.addActionListener(new ApplyFilterHandler());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 2, 5);
        this.filterConfigPanel.add((Component)this.filterHostsCkbx, gridBagConstraints);
        jLabel = new JLabel(Localizer.getString("MaxSearchResults") + ": ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 2, 2);
        this.filterConfigPanel.add((Component)jLabel, gridBagConstraints);
        String string = String.valueOf(ServiceManager.sCfg.mSearchMaxSearch);
        this.maxSearchResultsTF = new IntegerTextField(string, 4, 5);
        GUIUtils.setToolTipText(this.maxSearchResultsTF, Localizer.getString("TTTMaxSearchResults"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 2, 5);
        this.filterConfigPanel.add((Component)this.maxSearchResultsTF, gridBagConstraints);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 2, 5);
        this.filterConfigPanel.add((Component)jPanel2, gridBagConstraints);
        jLabel = new JLabel(Localizer.getString("MinFileSize"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 0, 2);
        jPanel2.add((Component)jLabel, gridBagConstraints);
        this.minFileSizeUnitComboBox = new JComboBox<SizeDefinition>(this.sizeDefinitions);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 1);
        jPanel2.add((Component)this.minFileSizeUnitComboBox, gridBagConstraints);
        jLabel = new JLabel(Localizer.getChar("ColonSign") + " ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel2.add((Component)jLabel, gridBagConstraints);
        String string2 = String.valueOf(ServiceManager.sCfg.mMinimumFileSize);
        this.minFileSizeTF = new IntegerTextField(string2, 10, 12);
        GUIUtils.setToolTipText(this.minFileSizeTF, Localizer.getString("TTTMinFileSize"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.filterConfigPanel.add((Component)this.minFileSizeTF, gridBagConstraints);
        this.applyFilterButton = new JButton(Localizer.getString("ApplyFilter"));
        this.applyFilterButton.setMargin(insets2);
        GUIUtils.setToolTipText(this.applyFilterButton, Localizer.getString("TTTApplyFilter"));
        this.applyFilterButton.addActionListener(new SearchButtonHandler());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 2, 2);
        gridBagConstraints.anchor = 17;
        this.filterConfigPanel.add((Component)this.applyFilterButton, gridBagConstraints);
        jLabel = new JLabel(Localizer.getString("MinSpeed") + ": ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 2, 2);
        this.filterConfigPanel.add((Component)jLabel, gridBagConstraints);
        String string3 = String.valueOf(ServiceManager.sCfg.mSearchMinSpeed);
        this.minHostSpeed = new IntegerTextField(string3, 6, 9);
        GUIUtils.setToolTipText(this.minHostSpeed, Localizer.getString("TTTMinSpeed"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 2, 5);
        this.filterConfigPanel.add((Component)this.minHostSpeed, gridBagConstraints);
        jPanel2 = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        this.filterConfigPanel.add((Component)jPanel2, gridBagConstraints);
        jLabel = new JLabel(Localizer.getString("MinRating") + ": ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(0, 0, 2, 2);
        jPanel2.add((Component)jLabel, gridBagConstraints);
        Object[] objectArray = new Object[]{new Integer(0), new Integer(1), new Integer(2), new Integer(3), new Integer(4), new Integer(5), new Integer(6), new Integer(7), new Integer(8)};
        this.minHostRatingComboBox = new JComboBox<Object>(objectArray);
        GUIUtils.setToolTipText(this.minHostRatingComboBox, Localizer.getString("TTTMinRating"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 2, 5);
        jPanel2.add((Component)this.minHostRatingComboBox, gridBagConstraints);
        final JButton jButton = new JButton(Localizer.getString("Filter"));
        jButton.setMargin(insets);
        jButton.setActionCommand("OpenFilter");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                if (string.equals("OpenFilter")) {
                    jButton.setActionCommand("CloseFilter");
                    SearchTab.this.filterConfigPanel.setVisible(true);
                } else {
                    jButton.setActionCommand("OpenFilter");
                    SearchTab.this.filterConfigPanel.setVisible(false);
                }
                SearchTab.this.topPanel.setMinimumSize(SearchTab.this.topPanel.getPreferredSize());
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)jButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        this.topPanel.add((Component)this.searchConfigPanel, gridBagConstraints);
        this.filterConfigPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(this.getBackground().darker()), Localizer.getString("ResultFilter")));
        this.topPanel.setMinimumSize(this.topPanel.getPreferredSize());
        this.filterConfigPanel.setMinimumSize(this.filterConfigPanel.getPreferredSize());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        this.topPanel.add((Component)this.filterConfigPanel, gridBagConstraints);
        this.filterConfigPanel.setVisible(false);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        this.add((Component)jPanel3, gridBagConstraints);
        this.mSearchResultLabel = new JLabel(Localizer.getString("NoSearchSelected"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        jPanel3.add((Component)this.mSearchResultLabel, gridBagConstraints);
        this.searchModel = new SearchTableModel(this);
        XMLGUITable xMLGUITable = GUIUtils.getXMLGUITableByIdentifier(xMLGUISettings, SEARCH_TABLE_IDENTIFIER);
        this.buildSearchTableColumnModel(xMLGUITable);
        this.searchTable = new FWTable((TableModel)new FWSortedTableModel(this.searchModel), this.searchColumnModel);
        this.searchTable.activateAllHeaderActions();
        this.searchTable.setAutoResizeMode(0);
        this.searchTable.getSelectionModel().addListSelectionListener(new SelectionHandler());
        DefaultPhexCellRenderers.setDefaultPhexCellRenderers(this.searchTable);
        GUIUtils.setToolTipText(this.searchTable, "Search results.  Perform sorting by clicking on the column.");
        this.searchTable.addMouseListener(new MouseHandler());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        jPanel3.add((Component)new JScrollPane(this.searchTable), gridBagConstraints);
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        jPanel4.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 4, 0, 4), BorderFactory.createEtchedBorder()));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        jPanel3.add((Component)jPanel4, gridBagConstraints);
        FWToolBar fWToolBar = new FWToolBar(0);
        fWToolBar.setBorderPainted(false);
        fWToolBar.setFloatable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.anchor = 18;
        jPanel4.add((Component)fWToolBar, gridBagConstraints);
        FWAction fWAction = new SWQuickDownloadAction();
        this.addTabAction(QUICK_DOWNLOAD_ACTION_KEY, fWAction);
        fWToolBar.addAction(fWAction);
        fWAction = new SWConfigDownloadAction();
        this.addTabAction(CONFIG_DOWNLOAD_ACTION_KEY, fWAction);
        fWToolBar.addAction(fWAction);
        fWAction = new AddAsCandidateAction();
        this.addTabAction(ADD_AS_CANDIDATE_ACTION_KEY, fWAction);
        fWToolBar.addAction(fWAction);
        this.initConfigValues();
    }

    public void updateUI() {
        int n;
        FontMetrics fontMetrics;
        Font font;
        Dimension dimension;
        super.updateUI();
        if (this.searchResultCombo != null) {
            dimension = this.searchResultCombo.getUI().getPreferredSize(this.searchResultCombo);
            font = (Font)UIManager.getDefaults().get("ComboBox.font");
            fontMetrics = ((Component)this.searchResultCombo).getFontMetrics(font);
            n = fontMetrics.getHeight() + fontMetrics.getDescent() + 2;
            this.searchResultCombo.setPreferredSize(new Dimension(dimension.width + 4, n));
        }
        if (this.filterComboBox != null) {
            dimension = this.filterComboBox.getUI().getPreferredSize(this.filterComboBox);
            font = (Font)UIManager.getDefaults().get("ComboBox.font");
            fontMetrics = ((Component)this.filterComboBox).getFontMetrics(font);
            n = fontMetrics.getHeight() + fontMetrics.getDescent() + 2;
            this.filterComboBox.setPreferredSize(new Dimension(dimension.width + 4, n));
        }
        if (this.mediaTypeComboBox != null) {
            dimension = this.mediaTypeComboBox.getUI().getPreferredSize(this.mediaTypeComboBox);
            font = (Font)UIManager.getDefaults().get("ComboBox.font");
            fontMetrics = ((Component)this.mediaTypeComboBox).getFontMetrics(font);
            n = fontMetrics.getHeight() + fontMetrics.getDescent();
            this.mediaTypeComboBox.setPreferredSize(new Dimension(dimension.width + 4, n));
        }
        if (this.minFileSizeUnitComboBox != null) {
            dimension = this.minFileSizeUnitComboBox.getUI().getPreferredSize(this.minFileSizeUnitComboBox);
            font = (Font)UIManager.getDefaults().get("ComboBox.font");
            fontMetrics = ((Component)this.minFileSizeUnitComboBox).getFontMetrics(font);
            n = fontMetrics.getHeight() + fontMetrics.getDescent();
            this.minFileSizeUnitComboBox.setPreferredSize(new Dimension(dimension.width + 4, n));
        }
        if (this.minHostRatingComboBox != null) {
            dimension = this.minHostRatingComboBox.getUI().getPreferredSize(this.minHostRatingComboBox);
            font = (Font)UIManager.getDefaults().get("ComboBox.font");
            fontMetrics = ((Component)this.minHostRatingComboBox).getFontMetrics(font);
            n = fontMetrics.getHeight() + fontMetrics.getDescent();
            this.minHostRatingComboBox.setPreferredSize(new Dimension(dimension.width + 4, n));
        }
    }

    public void appendXMLGUISettings(XMLGUISettings xMLGUISettings) {
        XMLGUITableColumnList xMLGUITableColumnList = this.searchColumnModel.createXMLGUITableColumnList();
        XMLGUITable xMLGUITable = new XMLGUITable();
        xMLGUITable.setTableColumnList(xMLGUITableColumnList);
        xMLGUITable.setTableIdentifier(SEARCH_TABLE_IDENTIFIER);
        xMLGUISettings.getTableList().addXMLGUITable(xMLGUITable);
    }

    public Search getSelectedSearchResult() {
        int n = this.searchResultCombo.getSelectedIndex();
        if (n >= 0 && n < this.searchContainer.getSearchCount()) {
            return this.searchContainer.getSearchAt(n);
        }
        return null;
    }

    public void stopSearch() {
        Search search = this.getSelectedSearchResult();
        if (search != null) {
            search.stopSearching();
        }
    }

    public void findInResult(boolean bl, boolean bl2, String string) {
        int n = this.searchTable.getSelectedRow();
        n = bl2 ? ++n : --n;
        if (!bl) {
            string = string.toLowerCase();
        }
        int n2 = n;
        int n3 = this.searchTable.getRowCount();
        int n4 = this.searchTable.getColumnCount();
        while (!(bl2 ? n2 >= n3 : n2 < 0)) {
            int n5 = 0;
            while (n5 < n4) {
                int n6;
                Object object = this.searchTable.getValueAt(n2, n5);
                if (object != null && (n6 = bl ? object.toString().indexOf(string) : object.toString().toLowerCase().indexOf(string)) != -1) {
                    this.searchTable.clearSelection();
                    this.searchTable.addRowSelectionInterval(n2, n2);
                    this.searchTable.scrollRectToVisible(this.searchTable.getCellRect(n2, 0, true));
                    return;
                }
                ++n5;
            }
            if (bl2) {
                ++n2;
                continue;
            }
            --n2;
        }
        JOptionPane.showMessageDialog(this, "No more result found.", "Find", 0);
    }

    private void initConfigValues() {
        long l = ServiceManager.sCfg.minimumFileSizeMultiplier;
        int n = 0;
        while (n < this.sizeDefinitions.length) {
            SizeDefinition sizeDefinition = this.sizeDefinitions[n];
            long l2 = sizeDefinition.getMultiplier() - l;
            if (l2 >= 0L) break;
            ++n;
        }
    }

    private void applyFilterSettings() {
        int n;
        MediaType mediaType = (MediaType)this.mediaTypeComboBox.getSelectedItem();
        String string = this.maxSearchResultsTF.getText().trim();
        String string2 = this.minHostSpeed.getText().trim();
        String string3 = this.minFileSizeTF.getText().trim();
        String string4 = this.filterTextTF.getText().trim();
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(this, "Maximum search results should be an integer.", "Invalid Maximum Results", 0);
            return;
        }
        int n2 = 0;
        try {
            if (string2.length() > 0) {
                n2 = Integer.parseInt(string2);
            }
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(this, "Minimum speed should be an integer.", "Invalid Minimum Speed", 0);
            return;
        }
        long l = 0L;
        try {
            if (string3.length() > 0) {
                l = Integer.parseInt(string3);
            }
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(this, "Minimum size should be an integer.", "Invalid Minimum Size", 0);
            return;
        }
        SizeDefinition sizeDefinition = (SizeDefinition)this.minFileSizeUnitComboBox.getSelectedItem();
        long l2 = sizeDefinition.getMultiplier();
        long l3 = l2 * l;
        Search search = this.getSelectedSearchResult();
        if (search != null) {
            search.updateSearchFilterConstraints(string4, n2, mediaType, n, l3);
        }
    }

    private void removeSearch() {
        Search search = this.getSelectedSearchResult();
        if (search != null) {
            this.searchContainer.removeSearch(search);
        }
    }

    public RemoteFile getSelectedRemoteFile() {
        Search search = this.getSelectedSearchResult();
        if (search == null) {
            return null;
        }
        int n = this.searchTable.getSelectedRow();
        if (n < 0) {
            return null;
        }
        int n2 = this.searchTable.convertRowIndexToModel(n);
        RemoteFile remoteFile = search.getQueryHit(n2);
        return remoteFile;
    }

    public void filterDownloadHost() {
        Search search = this.getSelectedSearchResult();
        if (search == null) {
            return;
        }
        int[] nArray = this.searchTable.getSelectedRows();
        if (nArray.length == 0) {
            return;
        }
        int[] nArray2 = this.searchTable.convertRowIndicesToModel(nArray);
        boolean bl = false;
        int n = 0;
        while (n < nArray2.length) {
            int n2 = nArray2[n];
            RemoteFile remoteFile = search.getQueryHit(n2);
            ServiceManager.sCfg.mFilteredSearchHosts.addElement(IPUtils.splitIP2Parts(remoteFile.getHostAddress().getHostName()));
            ++n;
        }
        ServiceManager.sCfg.save();
    }

    public int getResultSelectedCount() {
        return this.searchTable.getSelectedRowCount();
    }

    public void copyURL() {
        RemoteFile remoteFile = this.getSelectedRemoteFile();
        if (remoteFile == null) {
            return;
        }
        String string = URLEncoder.encode(remoteFile.getURL());
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(string), null);
    }

    public void quickDownload() {
        this.getTabAction(QUICK_DOWNLOAD_ACTION_KEY).actionPerformed(null);
    }

    private void updateSearchResultLabel() {
        Search search = this.getSelectedSearchResult();
        if (search != null) {
            this.updateSearchResultLabel(search);
            return;
        }
        this.searchStopButton.setEnabled(false);
        this.mainFrame.refreshAllActions();
        this.mSearchResultLabel.setText(Localizer.getString("NoSearchSelected"));
    }

    private void updateSearchResultLabel(Search search) {
        final Search search2 = search;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Integer n = search2.isSearching() ? new Integer(1) : new Integer(0);
                Object[] objectArray = new Object[]{new Integer(search2.getQueryHitCount()), new Integer(search2.getLocallyFilteredCount()), n};
                SearchTab.this.searchStopButton.setEnabled(search2.isSearching());
                SearchTab.this.mainFrame.refreshAllActions();
                SearchTab.this.mSearchResultLabel.setText(Localizer.getFormatedString("SearchStatus", objectArray));
            }
        });
    }

    private void buildSearchTableColumnModel(XMLGUITable xMLGUITable) {
        int[] nArray = SearchTableModel.getColumnIdArray();
        XMLGUITableColumnList xMLGUITableColumnList = null;
        if (xMLGUITable != null) {
            xMLGUITableColumnList = xMLGUITable.getTableColumnList();
        }
        this.searchColumnModel = new FWTableColumnModel(this.searchModel, nArray, xMLGUITableColumnList);
    }

    private class SizeDefinition {
        private String representation;
        private long multiplier;

        public SizeDefinition(String string, long l) {
            this.representation = Localizer.getString(string);
            this.multiplier = l;
        }

        public long getMultiplier() {
            return this.multiplier;
        }

        public String toString() {
            return this.representation;
        }
    }

    private class MouseHandler
    extends MouseAdapter
    implements MouseListener {
        private MouseHandler() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2 && mouseEvent.getSource() == SearchTab.this.searchTable) {
                SearchTab.this.quickDownload();
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.popupMenu((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.popupMenu((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
            }
        }

        private void popupMenu(Component component, int n, int n2) {
            if (component == SearchTab.this.searchTable) {
                SearchTab.this.mSearchResultPopupMenu.show(component, n, n2);
            }
        }
    }

    private class SelectionHandler
    implements ListSelectionListener {
        private SelectionHandler() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            SearchTab.this.mainFrame.refreshAllActions();
            SearchTab.this.refreshTabActions();
        }
    }

    private class SearchButtonHandler
    implements ActionListener {
        private SearchButtonHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == SearchTab.this.searchStopButton) {
                SearchTab.this.stopSearch();
            } else if (object == SearchTab.this.removeSearchBtn) {
                SearchTab.this.removeSearch();
            } else if (object == SearchTab.this.applyFilterButton) {
                SearchTab.this.applyFilterSettings();
            }
        }
    }

    private class SubmitSearchAction
    extends FWAction {
        private Search lastSearch;

        public SubmitSearchAction() {
            super(Localizer.getString("Search"), null, Localizer.getString("TTTSearch"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = SearchTab.this.searchTextTF.getText().trim();
            if (string.length() == 0) {
                return;
            }
            Search search = SearchTab.this.searchContainer.getRunningSearch(string);
            if (search != null) {
                SearchTab.this.searchResultCombo.setSelectedItem(search);
                return;
            }
            if (string.length() < Cfg.MIN_SEARCH_TERM_LENGTH) {
                Object[] objectArray = new Object[]{new Integer(Cfg.MIN_SEARCH_TERM_LENGTH)};
                GUIUtils.showErrorMessage(Localizer.getFormatedString("MinSearchTerm", objectArray));
                SearchTab.this.searchTextTF.requestFocus();
                return;
            }
            this.lastSearch = SearchTab.this.searchContainer.createSearch(string);
        }

        public void refreshActionState() {
        }
    }

    private class AddAsCandidateAction
    extends FWAction {
        public AddAsCandidateAction() {
            super(Localizer.getString("AddAsCandidate"), GUIRegistry.getInstance().getIconFactory().getIcon("AddCandidate"), Localizer.getString("TTTAddAsCandidate"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            RemoteFile remoteFile = SearchTab.this.getSelectedRemoteFile();
            if (remoteFile == null) {
                return;
            }
            SWDownloadFile[] sWDownloadFileArray = ServiceManager.getSwarmingManager().getDownloadFiles(remoteFile.getFileSize(), remoteFile.getURN());
            if (sWDownloadFileArray.length == 0) {
                return;
            }
            if (sWDownloadFileArray.length == 1) {
                Object[] objectArray = new Object[]{remoteFile.getFilename(), remoteFile.getHostAddress().getFullHostName(), sWDownloadFileArray[0].getDestinationFileName()};
                int n = JOptionPane.showOptionDialog(SearchTab.this.mainFrame, Localizer.getFormatedString("AddSingleCandidate", objectArray), Localizer.getString("AddCandidate"), 0, 3, null, null, null);
                if (n == 0) {
                    RemoteFile remoteFile2 = new RemoteFile(remoteFile);
                    sWDownloadFileArray[0].addDownloadCandidate(remoteFile2);
                    remoteFile.setInDownloadQueue(true);
                }
            } else {
                RemoteFile remoteFile3 = new RemoteFile(remoteFile);
                DlgAddAsCandidate dlgAddAsCandidate = new DlgAddAsCandidate(SearchTab.this.mainFrame, remoteFile3, sWDownloadFileArray);
                ((Component)dlgAddAsCandidate).setVisible(true);
                if (dlgAddAsCandidate.getCancel()) {
                    return;
                }
                SWDownloadFile sWDownloadFile = dlgAddAsCandidate.getDownloadFile();
                if (sWDownloadFile == null) {
                    return;
                }
                sWDownloadFile.addDownloadCandidate(remoteFile3);
                remoteFile.setInDownloadQueue(true);
            }
        }

        public void refreshActionState() {
            if (SearchTab.this.searchTable.getSelectedRow() < 0) {
                this.setEnabled(false);
            } else {
                this.setEnabled(true);
            }
        }
    }

    private class SWConfigDownloadAction
    extends FWAction {
        public SWConfigDownloadAction() {
            super(Localizer.getString("Download"), GUIRegistry.getInstance().getIconFactory().getIcon("ConfigDownload"), Localizer.getString("TTTDownload"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            RemoteFile remoteFile = SearchTab.this.getSelectedRemoteFile();
            if (remoteFile == null) {
                return;
            }
            RemoteFile remoteFile2 = new RemoteFile(remoteFile);
            DownloadConfigDialog downloadConfigDialog = new DownloadConfigDialog(remoteFile2);
            downloadConfigDialog.show();
            if (remoteFile2.isInDownloadQueue()) {
                remoteFile.setInDownloadQueue(true);
                GUIUtils.fireTableChanged(SearchTab.this.searchTable, SearchTab.this.searchModel);
            }
        }

        public void refreshActionState() {
            if (SearchTab.this.searchTable.getSelectedRow() < 0) {
                this.setEnabled(false);
            } else {
                this.setEnabled(true);
            }
        }
    }

    private class SWQuickDownloadAction
    extends FWAction {
        public SWQuickDownloadAction() {
            super(Localizer.getString("QuickDownload"), GUIRegistry.getInstance().getIconFactory().getIcon("Download"), Localizer.getString("TTTQuickDownload"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            RemoteFile remoteFile = SearchTab.this.getSelectedRemoteFile();
            if (remoteFile == null) {
                return;
            }
            remoteFile.setInDownloadQueue(true);
            GUIUtils.fireTableChanged(SearchTab.this.searchTable, SearchTab.this.searchModel);
            RemoteFile remoteFile2 = new RemoteFile(remoteFile);
            String string = StrUtil.createNaturalSearchTerm(remoteFile2.getFilename());
            ServiceManager.getSwarmingManager().addFileToDownload(remoteFile2, ServiceManager.sCfg.mDownloadDir + File.separator + remoteFile2.getFilename(), string);
        }

        public void refreshActionState() {
            if (SearchTab.this.searchTable.getSelectedRow() < 0) {
                this.setEnabled(false);
            } else {
                this.setEnabled(true);
            }
        }
    }

    private class SearchComboActionHandler
    implements ActionListener {
        private SearchComboActionHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SearchTab.this.updateSearchResultLabel();
            GUIUtils.fireTableChanged(SearchTab.this.searchTable, SearchTab.this.searchModel);
        }
    }

    private class ApplyFilterHandler
    implements ActionListener {
        private ApplyFilterHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ServiceManager.sCfg.mApplyFilterdHosts = SearchTab.this.filterHostsCkbx.isSelected();
            ServiceManager.sCfg.save();
        }
    }

    private class SearchUpdateChangeListener
    implements ListDataListener {
        private SearchUpdateChangeListener() {
        }

        public void contentsChanged(ListDataEvent listDataEvent) {
            if (listDataEvent.getType() == 0) {
                Search search = SearchTab.this.getSelectedSearchResult();
                if (search == null) {
                    return;
                }
                SearchTab.this.updateSearchResultLabel(search);
                GUIUtils.fireTableChanged(SearchTab.this.searchTable, SearchTab.this.searchModel);
            } else {
                SearchTab.this.updateSearchResultLabel();
            }
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
        }

        public void intervalAdded(ListDataEvent listDataEvent) {
        }
    }
}

