/*
 * Decompiled with CFR 0.152.
 */
package phex.host;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.NoSuchElementException;
import phex.ReadWorker;
import phex.SendManager;
import phex.ServiceManager;
import phex.host.HostAddress;
import phex.host.HostManager;
import phex.host.HostMsg;
import phex.msg.MsgInit;
import phex.msg.MsgInitResponse;
import phex.utils.CircularQueue;
import phex.utils.Logger;

public class Host {
    private static final int STABLE_CONNECTION_TIME = 75000;
    public static final int STATUS_HOST_NOT_CONNECTED = 0;
    public static final int sStatusError = 1;
    public static final int sStatusConnecting = 2;
    public static final int sStatusAccepting = 3;
    public static final int sStatusConnected = 4;
    public static final int STATUS_HOST_DISCONNECTED = 5;
    public static final int sTypeOutgoing = 1;
    public static final int sTypeIncoming = 2;
    public static final int sTypeDownload = 3;
    public static final int sTypePush = 4;
    public static final int sLatencyTimeout = 99999;
    private HostManager mManager = ServiceManager.getHostManager();
    private SendManager mSendManager = ServiceManager.getSendManager();
    private HostAddress hostAddress;
    private Socket mSock = null;
    private InputStream mIs = null;
    private OutputStream mOs = null;
    private int mStatus = 0;
    private String mLastStatusMsg = "";
    private long mStatusTime = 0L;
    private int mType = 1;
    private boolean mHasWorker = false;
    private boolean mSending = false;
    private int mReceivedCount;
    private int mSentCount;
    private int mDropCount;
    private MsgInit mPingMsg = null;
    private long mPingStartTime = 0L;
    private long mPingNextStartTime = -1L;
    private int mPingLatency = 0;
    private long mLatencyTimeOutStartTime = 0L;
    private int mFileCount = 0;
    private int mTotalSize = 0;
    private String vendor;
    private CircularQueue messageQueue;
    private boolean isConnectionStable = false;

    public Host() {
    }

    public Host(HostAddress hostAddress) {
        this();
        this.hostAddress = hostAddress;
    }

    public HostAddress getHostAddress() {
        return this.hostAddress;
    }

    public Socket getSock() {
        return this.mSock;
    }

    public void setSock(Socket socket) {
        this.mSock = socket;
        this.mReceivedCount = 0;
        this.mSentCount = 0;
        this.mDropCount = 0;
    }

    public InputStream getIs() {
        return this.mIs;
    }

    public void setIs(InputStream inputStream) {
        this.mIs = inputStream;
    }

    public OutputStream getOs() {
        return this.mOs;
    }

    public void setOs(OutputStream outputStream) {
        this.mOs = outputStream;
    }

    public void setVendor(String string) {
        this.vendor = string;
    }

    public String getVendor() {
        return this.vendor;
    }

    public int getStatus() {
        return this.mStatus;
    }

    public String getStatusName() {
        switch (this.mStatus) {
            case 0: {
                return "(Not connected)";
            }
            case 1: {
                return "Error.  " + this.mLastStatusMsg;
            }
            case 2: {
                return "Connecting...  " + this.mLastStatusMsg;
            }
            case 3: {
                return "Accepting...  " + this.mLastStatusMsg;
            }
            case 4: {
                if (this.sendQueueInRed() || this.latencyInRed()) {
                    return "Connected (deprecated, no broadcast forwarded)";
                }
                return "Connected";
            }
            case 5: {
                return "Disconnect";
            }
        }
        return "Unknown";
    }

    public void setStatus(int n) {
        this.setStatus(n, null, System.currentTimeMillis());
    }

    public void setStatus(int n, long l) {
        this.setStatus(n, null, l);
    }

    public void setStatus(int n, String string) {
        this.setStatus(n, string, System.currentTimeMillis());
    }

    public void setStatus(int n, String string, long l) {
        if (this.mStatus == n) {
            return;
        }
        this.mStatus = n;
        this.mLastStatusMsg = string;
        this.mStatusTime = l;
        this.mManager.fireNetworkHostChanged(this);
    }

    public void checkForStableConnection(long l) {
        if (this.isConnectionStable) {
            return;
        }
        if (this.mStatus == 4 && this.getConnectionUpTime(l) > 75000L) {
            this.isConnectionStable = true;
            this.mManager.fireNetworkHostChanged(this);
        }
    }

    public boolean isConnectionStable() {
        return this.isConnectionStable;
    }

    public long getConnectionUpTime(long l) {
        if (this.mStatus == 4) {
            return l - this.mStatusTime;
        }
        return 0L;
    }

    public boolean isErrorStatusExpired(long l) {
        return (this.mStatus == 1 || this.mStatus == 5) && l - this.mStatusTime > 5000L;
    }

    public int getType() {
        return this.mType;
    }

    public String getTypeName() {
        switch (this.mType) {
            case 1: {
                return "Outgoing";
            }
            case 2: {
                return "Incoming";
            }
            case 3: {
                return "Download";
            }
            case 4: {
                return "Push";
            }
        }
        return "Unknown";
    }

    public void setType(int n) {
        this.mType = n;
    }

    public void incReceivedCount() {
        ++this.mReceivedCount;
    }

    public int getReceivedCount() {
        return this.mReceivedCount;
    }

    public void incSentCount() {
        ++this.mSentCount;
    }

    public int getSentCount() {
        return this.mSentCount;
    }

    public void incDropCount() {
        ++this.mDropCount;
    }

    public int getDropCount() {
        return this.mDropCount;
    }

    public int getFileCount() {
        return this.mFileCount;
    }

    public int getTotalSize() {
        return this.mTotalSize;
    }

    public boolean tooManyDropPackets() {
        if (this.mReceivedCount < 50 && this.getConnectionUpTime(System.currentTimeMillis()) < 60000L) {
            return false;
        }
        return this.mDropCount * 100 / (this.mReceivedCount + 1) > ServiceManager.sCfg.mDisconnectDropRatio;
    }

    public boolean dropPacketsInRed() {
        return this.mDropCount * 100 / (this.mReceivedCount + 1) > ServiceManager.sCfg.mDisconnectDropRatio * 3 / 4;
    }

    public void connectForReading() {
        if (this.getType() != 1) {
            return;
        }
        if (this.mSock != null) {
            return;
        }
        new ReadWorker(this);
    }

    public boolean isConnected() {
        return this.mSock != null;
    }

    public void disconnect() {
        if (this.mSock != null && this.mStatus != 1) {
            this.setStatus(5);
        }
        if (this.mIs != null) {
            try {
                this.mIs.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.mIs = null;
        }
        if (this.mOs != null) {
            try {
                this.mOs.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.mOs = null;
        }
        if (this.mSock != null) {
            try {
                this.mSock.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.mSock = null;
        }
    }

    public synchronized boolean acquireByWorker() {
        if (this.mHasWorker) {
            return false;
        }
        this.mHasWorker = true;
        return true;
    }

    public synchronized void releaseFromWorker() {
        this.mHasWorker = false;
    }

    public synchronized boolean acquireSendLockOrQueueMsg(HostMsg hostMsg) {
        if (this.mSending) {
            this.initWaitingQueue();
            if (hostMsg.getUrgent()) {
                this.messageQueue.addToHead(hostMsg);
            } else {
                this.messageQueue.addToTail(hostMsg);
            }
            return false;
        }
        this.mSending = true;
        return true;
    }

    public synchronized void releaseSendLock() {
        this.initWaitingQueue();
        if (!this.messageQueue.isEmpty()) {
            try {
                HostMsg hostMsg = (HostMsg)this.messageQueue.removeFromHead();
                this.mSendManager.queueMsgToSend(hostMsg);
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        }
        this.mSending = false;
    }

    public int getSendQueueLength() {
        if (this.messageQueue == null) {
            return 0;
        }
        return this.messageQueue.getSize();
    }

    public boolean sendQueueTooLong() {
        if (this.messageQueue == null) {
            return false;
        }
        return this.messageQueue.getSize() >= ServiceManager.sCfg.mNetMaxSendQueue - 1;
    }

    public boolean sendQueueInRed() {
        if (this.messageQueue == null) {
            return false;
        }
        return this.messageQueue.getSize() >= ServiceManager.sCfg.mNetMaxSendQueue * 3 / 4;
    }

    public void pingHost() {
        if (this.mStatus != 4) {
            return;
        }
        long l = System.currentTimeMillis();
        if (this.mPingMsg != null) {
            if (l - this.mPingStartTime > (long)ServiceManager.sCfg.mPingTimeout) {
                this.mPingLatency = 99999;
                this.mPingMsg = null;
                this.mLatencyTimeOutStartTime = System.currentTimeMillis();
            }
            return;
        }
        if (l < this.mPingNextStartTime) {
            return;
        }
        this.mPingStartTime = l;
        this.mPingNextStartTime = l + (long)ServiceManager.sCfg.mPingFrequency;
        this.mPingMsg = new MsgInit();
        this.mPingMsg.getHeader().setTTL(1);
        this.mSendManager.queueMsgToSend(this, this.mPingMsg, true);
    }

    public boolean checkPingResponse(MsgInitResponse msgInitResponse) {
        if (this.mPingMsg != null && msgInitResponse.getHeader().getMsgID().equals(this.mPingMsg.getHeader().getMsgID())) {
            this.mPingMsg = null;
            this.mPingLatency = (int)(System.currentTimeMillis() - this.mPingStartTime);
            this.mFileCount = msgInitResponse.getFileCount();
            this.mTotalSize = msgInitResponse.getTotalSize();
            return true;
        }
        return false;
    }

    public int getLatency() {
        return this.mPingLatency;
    }

    public boolean tooMuchLatency(long l) {
        return this.mPingLatency == 99999 && l - this.mLatencyTimeOutStartTime > (long)ServiceManager.sCfg.mDisconnectLatency;
    }

    public boolean latencyInRed() {
        return this.mPingLatency == 99999;
    }

    public void log(Logger.LogLevel logLevel, String string) {
        Logger.logMessage(logLevel, (short)16, "Host " + this.hostAddress.getHostName() + ":" + this.hostAddress.getPort() + " Vendor: " + this.vendor + " Message: " + string);
    }

    public String toString() {
        return '[' + this.hostAddress.getHostName() + ":" + this.hostAddress.getPort() + "; status:" + this.mStatus + ']';
    }

    private void initWaitingQueue() {
        if (this.messageQueue != null) {
            return;
        }
        this.messageQueue = new CircularQueue(ServiceManager.sCfg.mNetMaxSendQueue);
    }
}

